// Copyright 2005 T-MAPY spol. s r. o. All rights reserved.
//$Id: tmapobj.js,v 1.22 2007/08/02 11:47:19 tokr Exp $ $Name:  $ 

function tMapBBOX(x1,y1,x2,y2) {this.minx=x1;this.miny=y1;this.maxx=x2;this.maxy=y2;}

function tMapObj(p) {
  //Private
  this._lastReq='';
  this._win=p.win;
  this._src=p.src?p.src:'.';
  this._name=p.name?p.name:'tMap';
  this._cbname=p.cbname?p.cbname:'';
  this._panSize=p.pansize?p.pansize:0.51;
  this._mouse={scroll:0};
  this._evScrollOn=_scrollProcOn;
  this._evScrollOff=_scrollProcOff;
  this._timeouts=new Array();
  this._debug=false;
  this._overviewtype='default';
  this._stoponreq=true;
 
  this._brow=getBrowser();
  if (p.win==top) {
    this._winFrm=p.win;
  } else {
    this._winFrm=((this._brow.ie && this._brow.ver < 5.5)||(this._brow.op))?this._win.parent.document.getElementById(this._win.name):this._win.frameElement;
  }
  this._winDce=(this._brow.ie && this._brow.ver < 6)?this._win.document.body:this._win.document.documentElement;
  this._tool='zoom';
  this._eventReg={};
  this._zoomLvls={};
  this._zoomLvlsCount=0;
  this._layers={};
  this._overviews={len:0,ovs:{},prop:{nam:'x-x'}};
  this._eventHandler=_eventHandlerReg;
  this._commFrm=null;
  this._init=_init;
  this._init2=_init2;
  this._map={id:0,px:0,bbox:{}};
  this._divLayers=null;
  this._divZoom=null;

  //Methods - internal
  this._initMap=_initMap;
  this._initMapEnd=_initMapEnd;
  this._prepareRequest=_prepareRequest;
  this._preparePrintStyle=_preparePrintStyle;
  this._processRequest=_processRequest;
  this._refreshMapContent=_refreshMapContent;
  this._refreshOverviews=_refreshOverviews;
  this._getWinPos=_getWinPos;
  this._getBBOXPixelSize=_getBBOXPixelSize;
  this._getOwnerDocument=_getOwnerDocument;
  this._switchScrollEvent=_switchScrollEvent;

  this._mozillaScroll=_mozillaScroll;
  this._draggingMapCheck=_draggingMapCheck;
  this._mozillaScTop=-1;
  
  //Event handlers - internal
  this._mouseDownProc=_mouseDownProc;
  this._mouseUpProc=_mouseUpProc;
  this._mouseMoveProc=_mouseMoveProc;
  this._mouseWheelProc=_mouseWheelProc;
  this._mouseOutProc=_mouseOutProc;
  
  this._keyDownProc=_keyDownProc;
  this._dblClickProc=_dblClickProc;
  this._scrollProcOn=_scrollProcOn;
  this._scrollProcOff=_scrollProcOff;
  this._ovMouseDownProc=_ovMouseDownProc;
  this._ovMouseMoveProc=_ovMouseMoveProc;
  this._ovMouseUpProc=_ovMouseUpProc;
  
  //Methods - public
  this.getBrowEvent=getBrowEvent;
  this.getOverview=getOverview;
  this.setOverviewType=setOverviewType;
  this.getBBOX=getBBOX;
  this.formatBBOX=formatBBOX;
  this.resizeBBOX=resizeBBOX;
  this.pointInBBOX=pointInBBOX;
  this.setBBOXCenter=setBBOXCenter;
  this.getBBOXCenter=getBBOXCenter;
  this.getBrowser=getBrowser;
  this.setTool=setTool;
  this.getTool=getTool;
  this.getPixelSize=getPixelSize;
  this.getFrame=getFrame;
  this.resizeFrame=resizeFrame;
  this.resizeViewport=resizeViewport;
  this.getWindow=getWindow;
  this.registerEvent=registerEvent;
  this.registerOverview=registerOverview;
  this.registerStyle=registerStyle;
  this.createLayer=createLayer;
  this.setStopOnRequest=setStopOnRequest;
  this.getStopOnRequest=getStopOnRequest;

  this.pan=pan;
  this.scrollBy=scrollBy;
  this.scrollByAnim=scrollByAnim;
  this.scrollToPoint=scrollToPoint;
  this.setPanSize=setPanSize;
  this.getPanSize=getPanSize;

  this.getZoomLevels=getZoomLevels;
  this.getActiveZoomLevel=getActiveZoomLevel;
  this.getMaxZoomLevel=getMaxZoomLevel;
  this.zoomToLevel=zoomToLevel;
  this.zoomToBBOX=zoomToBBOX;

  this.convertCoord=convertCoord;
  this.updateMap=updateMap;

  this.s42towgs84=s42towgs84;


  function _init() {

    this._switchScrollEvent(0);
  
    var doc=this._win.document;
    this._win._tmap=this;
    var body=doc.getElementsByTagName("body").item(0);
    body.style.padding='0px';
    body.style.margin='0px';

    doc.oncontextmenu=function(){return false};
    doc.onmousedown=this._mouseDownProc;
    doc.onmousemove=this._mouseMoveProc;
    doc.onmouseup=this._mouseUpProc;
    doc.onmouseout=this._mouseOutProc;
    doc.ondblclick=this._dblClickProc;
    doc.onkeydown=this._keyDownProc;
    
    if (this._brow.ie) {
      this._win.onbeforeprint=function() {this.frameElement.setAttribute('scrolling','no');};
      this._win.onafterprint=function() {this.frameElement.setAttribute('scrolling','auto')};
    }
    if (!this._brow.ns) {
      if (this._brow.ver>5.5) doc.onmousewheel=this._mouseWheelProc;
    } else {
      doc.addEventListener('DOMMouseScroll', this._mouseWheelProc, false);
      if (this._win.parent) {
        this._win.parent.document.addEventListener('keydown', this._keyDownProc, false);
        this._win.parent._tmap=this;
      }
    }
    this._switchScrollEvent(1);
    if (this._brow.ns) {
      this._mozillaScSkip=1;
	    this._win.setInterval('window._tmap._mozillaScroll()',100);
    }
    
    var e;
    e=doc.createElement("div");
    e.setAttribute('id',this._name+'_lrs');
    e.className='lrs';
    e.style.position='absolute';
    var pos=this._getWinPos()
    e.style.width=(pos.wvis+100000)+'px';
    e.style.height=(pos.hvis+100000)+'px';
    body.appendChild(e);
    this._divLayers=e;

    e=doc.createElement("div");
    e.setAttribute('id',this._name+'_zoom');
    e.style.position='absolute';
    e.style.border='2px red solid';
    e.style.visibility='hidden';
    e.overflow='hidden';
    e.style.left='0px';
    e.style.top='0px';
    e.style.zIndex=5000;
//    e.style.backgroundColor='yellow';
    e.style.fontSize='0px';
    body.appendChild(e);
    this._divZoom=e;

    e=doc.createElement("iframe");
    e.name=this._name+'_commfrm';
    e.style.position='absolute';
    if (this._brow.op)
      e.style.visibility='hidden';
    else
      e.style.display='none';
    e.style.padding='0px';
    e.style.zIndex=500;
    e.style.border='solid 2px red';
//    e.style.overflow='scroll';
    e.width='300px';
    e.height='300px';
    
    body.appendChild(e);
    this._commFrm=e;

    //For opera and getBrowser
    this._win.setTimeout('window._tmap._init2();',1);
        
  }

  function _init2() {
    this._brow=this.getBrowser();

		var c=true;
    if (this._win.parent) {
      eval('if (this._win.parent.tMapInit'+this._cbname+') c=this._win.parent.tMapInit'+this._cbname+"(this);");
    }
		if (c!=false) this._commFrm.src=(this._src=='.'?'':this._src+'/ifrmmap.php')+'?'+this._prepareRequest({c:'map',init:1,pan:1},'',{nobbox:1});
//    window.prompt("Message", this._commFrm.src);
  }
  
  function _initMap(p) {
    var bp=p.bbox; var bl=this._map.bbox; 
    var fp=p.fext; var fl=this._map.fext;
    if (fl) p.fext.changed=(fl.minx!=fp.minx || fl.maxx!=fp.maxx || fl.miny!=fp.miny || fl.maxy!=fp.maxy);
    if (bp && !p.nobboxch) 
      p.bbox.changed=(bl.minx!=bp.minx || bl.maxx!=bp.maxx || bl.miny!=bp.miny || bl.maxy!=bp.maxy);
    else 
      p.bbox=bl;
    p.center=this._map.center?this._map.center:this.getBBOXCenter(p.bbox);
    if (p.ov) {
      this._overviews.prop=p.ov;
      this._map.ov=null;
    }
    if (this._brow.ns) this._mozillaScSkip=1;
    this._map=p;
    this._divLayers.style.width=p.w+'px';
    this._divLayers.style.height=p.h+'px';
    if (!p.noov) this._refreshOverviews();
  }

  function _initMapEnd(p) {
    if (this._map.bbox.changed) {
      this._eventHandler('onBBOXChanged',{});
      this._draggingMapCheck();
      this._map.bbox.changed=0;
    }
    this._preparePrintStyle();
  }
  
  function _preparePrintStyle() {
    if (!this._brow.op) { 
      var pos=this._getWinPos();
      if (_tMapStyle) {
        _tMapStyle.left=(-1*pos.l)+'px';
        _tMapStyle.top=(-1*pos.t)+'px';
      }
    }  
  }
  
  function _refreshMapContent(p,i) {
    var lr; var e; var nam; var d; var i;
    var doc=this._win.document;
    var par=p.parent?p.parent:this._divLayers;
    var pos=this._getWinPos();
    var frst=!p.parent;

    if (frst) {
      this._switchScrollEvent(0);
      for(nam in i) {
        lr = this._layers['lr_'+i[nam]];
        if (lr) {
          lr.vis=0;
          lr.clear();
        }
      }
    }
    i=0;
    while(p[i]!=undefined) {
      e=p[i];
      nam='lr_'+e.pro.nam;
      lr=this._layers[nam];
      if (lr && lr.pro.typ!=e.pro.typ) {
        lr.clear();
        this._layers[nam]=null;
        lr=false;
      }
      if (!lr) lr=this.createLayer(e.pro,par);
      if (lr) {
        if (e.vis) {
          lr.vis=1;
          if (this._map.fext && this._map.fext.changed) lr.clear();
          lr.draw(e);
        } else {
          lr.vis=0;
          lr.clear();
        }
      }
      if (e.lrs) {
        if (lr) e.lrs.parent=lr._div;
        this._refreshMapContent(e.lrs,{});
      }
      i++; 
    }
    
    if (frst) {
      for (nam in this._layers) {
        lr=this._layers[nam];
        if (lr.pro && lr.pro.persist) {
          lr.refresh();
        }
      }
  
      this._switchScrollEvent(1);
    }
  }

  function _getBBOXPixelSize(b,w) {
    if (!w) w=this._getWinPos();               
    var x=(b.maxx-b.minx)/w.wvis;
    var y=(b.maxy-b.miny)/w.hvis;
    if (x>y) return x; else return y;
  }
  
  function _getWinPos() {
    var p={};
    if (this._map) {
    	p.w=this._map.w;
    	p.h=this._map.h;
    } else if (this._brow.ns) {
    	p.w=this._win.document.documentElement.scrollWidth;
    	p.h=this._win.document.documentElement.scrollHeight;
    } else {
    	p.w=this._win.document.body.scrollWidth;
    	p.h=this._win.document.body.scrollHeight;
    }
    if (this._brow.ns) {
      if (this._brow.ff && !this._brow.ff10) {
      	p.wvis = this._winDce.clientWidth || this._winDce.scrollWidth;
      	p.hvis = this._winDce.clientHeight || this._winDce.scrollHeight;
      } else {
      	p.wvis = this._win.document.body.clientWidth || this._winFrm.width;
      	p.hvis = this._win.document.body.clientHeight || this._winFrm.height;
      }
    } else {
    	p.wvis = this._win.document.body.clientWidth || this._win.document.documentElement.clientWidth || this._winFrm.width;
    	p.hvis = this._win.document.body.clientHeight || this._win.document.documentElement.clientHeight || this._winFrm.height;
    }
    if (this._win.pageYOffset) {
    	p.l = this._win.pageXOffset;
    	p.t = this._win.pageYOffset;
    } else {
    	p.l = this._win.document.body.scrollLeft || this._win.document.documentElement.scrollLeft;
    	p.t = this._win.document.body.scrollTop || this._win.document.documentElement.scrollTop;
    }
    return p;  
  }

  function _processRequest(p,par,p2) {
    var id;
//    window.prompt('a',this._src+'/ifrmmap.php?'+this._prepareRequest(p,'',par));
    if (this._commFrm) {
      var req=(this._src=='.'?'':this._src+'/ifrmmap.php')+'?'+this._prepareRequest(p,'',par);
      if (this._lastReq!=req) {

        if (this._stoponreq) {
          if (this._brow.ie) this._win.document.execCommand('Stop');
          else if (this._brow.ns) this._win.stop();
        }
        
        for (id in this._timeouts) this._win.clearTimeout(this._timeouts[id]);
        this._timeouts=new Array();
          
        this._lastReq=req;
        if (p2) {
          for (key in p2) {
            req+=(req?'&':'')+key+'='+(escape(p2[key]).replace(/\+/g,'%2B').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F')); 
          }
        }
        this._commFrm.src=req;
//        this._commFrm.contentWindow.document.location.href=req;
        var d=this._win.parent.document.getElementById('debug');
        if (d) {
          d.c=!d.c?1:d.c+1;
          d.innerHTML=d.c+'. <a href="'+req+'">'+req+'</a><br>'+d.innerHTML;
        }
      }
    }
  }

  function _prepareRequest(p,req,par) {
    var pos=this._getWinPos();
//    alert(pos.w);
    if (!req) var req='';
		if (!p.bbox && (!par || !par.nobbox)) {
		  var bbox=this.getBBOX();
      if (bbox.minx!=undefined) p.bbox=bbox.minx+','+bbox.miny+','+bbox.maxx+','+bbox.maxy;
		}
		if (this._overviews.len) {
      p.ov=this._overviews.prop.nam;
      p.ovt=this._overviewtype;
    }
    p.n=this._name;
    p.wh=pos.wvis+':'+pos.hvis;
    for (key in p) {
      req+=(req?'&':'')+key+'='+p[key]; 
    }
    return req;
  }
  

  /****************** PUBLIC ***************************/
    
  function getBBOX() {
    var p=this._getWinPos();
    var b={};
    if (this._map.bbox && this._map.bbox.changed) {
      b=this._map.bbox;
    } else if (this._map.fext) {
      b.minx=this._map.fext.minx+(p.l*this._map.px); 
      b.dx=(p.wvis*this._map.px);
      b.maxx=b.minx+b.dx; 
      b.maxy=this._map.fext.maxy-(p.t*this._map.px); 
      b.dy=(p.hvis*this._map.px); 
      b.miny=b.maxy-b.dy;
    }
    return b; 
  }
  
  function formatBBOX(p) {
    return (p.minx+','+p.miny+','+p.maxx+','+p.maxy);
  }

  
  function getPixelSize() {
    return this._map.px;
  }
    
  function convertCoord(pt,fr,to) {
    var pos=this._getWinPos();
    var p_pg={};
    var p_res={};
    switch (fr) {
      case 'win':
        p_pg=pt;
      break;
      case 'winvis':
        p_pg.x=pt.x+pos.l;
        p_pg.y=pt.y+pos.t;
      break;
      case 'map':
        if (this._map && this._map.fext) {
          var dx=this._map.fext.maxx-this._map.fext.minx; 
          var px=dx/pos.w; 
          p_pg.x=Math.floor((pt.x-this._map.fext.minx)/px);
          p_pg.y=Math.floor((this._map.fext.maxy-pt.y)/px);
        } else {
          p_pg.x=0;
          p_pg.y=0;
        }
      break;
    }
    switch (to) {
      case 'win':
        p_res=p_pg;
      break;
      case 'winvis':
        p_res.x=p_pg.x-pos.l;
        p_res.y=p_pg.y-pos.t;
      break;
      case 'map':
        if (this._map && this._map.fext) {
          var dx=this._map.fext.maxx-this._map.fext.minx;
          var px=dx/pos.w;
          p_res.x=this._map.fext.minx+(p_pg.x*px);
          p_res.y=this._map.fext.maxy-(p_pg.y*px);
        } else {
          p_pg.x=0;
          p_pg.y=0;
        }
      break;
    }
    return p_res;
  }

  function scrollToPoint(p) {
    var pos=this._getWinPos();
    var c=this.convertCoord(p,'map','win');
    this._switchScrollEvent(0);
    var dx=Math.round(c.x-(pos.l+pos.wvis/2));
    var dy=Math.round(c.y-(pos.t+pos.hvis/2));
    this._win.scrollBy(dx,dy);
    this._map.center=p; 
    this._switchScrollEvent(1);
  }

  function panToBBOX(p) {
    var b=this.getBBOX();
    var cx=(p.maxx+p.minx)/2;
    var cy=(p.maxy+p.miny)/2;
    var bx=(b.maxx+b.minx)/2;
    var by=(b.maxy+b.miny)/2;
    var x=Math.round((cx-bx)/this._map.px);
    var y=Math.round((by-cy)/this._map.px);
    this._switchScrollEvent(0);
    this._win.scrollBy(x,y)
    this._map.center=p; 
    this._switchScrollEvent(1);
  }

  function getZoomLevels() {
    return {levels:this._zoomLvls,count:this._zoomLvlsCount};
  }

  function getActiveZoomLevel() {
    var l=null; var lm=0; var d=0; var ds=0; var dm=null;
    for (key in this._zoomLvls) {
      l=this._zoomLvls[key];
      ds=l.p-this._map.px;
      d=Math.abs(ds);
      if (d==0 || ds<0) {
        return Math.round(key);
      } else if (!dm || dm>d){
        dm=d;
        lm=Math.round(key);
      }
    }
    return lm;
  }

  function getMaxZoomLevel() {
    return this._map.lstLvl;
  }
  
  function pointInBBOX(b, p) {
    return !(b.minx>p.x || b.maxx<p.x || b.miny>p.y || b.maxy<p.y); 
  }

  function setBBOXCenter(b,c) {
    var dx=c.x-((b.maxx+b.minx)/2); 
    var dy=c.y-((b.maxy+b.miny)/2); 
    return new tMapBBOX(b.minx+dx,b.miny+dy,b.maxx+dx,b.maxy+dy);
  }
  

  function getBBOXCenter(p) {
    return {x:(p.maxx+p.minx)/2,y:(p.maxy+p.miny)/2};
  }
  
  function zoomToLevel(p,c) {
    var b;
    if (p=='n') {
      p=this.getActiveZoomLevel()+1;
      if (p==this._zoomLvlsCount) p-=1;
    } else if (p=='p') {
      p=this.getActiveZoomLevel()-1;
      if (p<0) p=0;
    }
    if (this._zoomLvls[p] && this._zoomLvls[p].p) {
      b=this.getBBOX();
      if (this._zoomLvls[p].e) {
        if (!c && this._map.center) c=this._map.center;
        this.zoomToBBOX(this._zoomLvls[p].e);
        if (c) this._map.center=c;
      } else {
        if (b.minx==undefined) {
          var pos=this._getWinPos();
          b={minx:0,miny:0,maxx:pos.wvis,maxy:pos.hvis};
          b=this.resizeBBOX(b,this._zoomLvls[p].p);
        } else {
          b=this.resizeBBOX(b,this._zoomLvls[p].p/this._map.px);
        }
        if (!c && this._map.center) c=this._map.center;
        if (c.x) b=this.setBBOXCenter(b,c);
        this._timeouts[this._timeouts.length]=this._win.setTimeout('window._tmap.zoomToBBOX({minx:'+b.minx+',miny:'+b.miny+',maxx:'+b.maxx+',maxy:'+b.maxy+'})',100);
        //this.zoomToBBOX(b);
      }
    }
  }

  function zoomToBBOX(p) {
		this._refreshOverviews({bbox:p});
		this._map.center=this.getBBOXCenter(p);
		this._processRequest({c:'map',bbox:this.formatBBOX(p)},{},{pan:1});
  }
  
  function resizeBBOX(b,s) {
    var dx=b.maxx-b.minx; var dy=b.maxy-b.miny; 
    var dxs=dx*s; var dys=dy*s;
    var r={};
    r.minx=b.minx+((dx-dxs)/2);   
    r.maxx=r.minx+dxs;   
    r.miny=b.miny+((dy-dys)/2);   
    r.maxy=r.miny+dys;
    return r;   
  }
  
  function setPanSize(s) {this._panSize=s};
  function getPanSize(s) {return this._panSize};
  
  function pan(p) {
    var pos=this._getWinPos();
    var x=0; var y=0;
    var sz=p.size?p.size:this._panSize;
    var dx=Math.round(pos.wvis*sz);
    var dy=Math.round(pos.hvis*sz);
    switch (p.dir) {
      case 'l': x-=dx; break;
      case 'r': x+=dx; break;
      case 'u': y-=dy; break;
      case 'd': y+=dy; break;
      case 'ul': x-=dx; y-=dy; break;
      case 'ur': x+=dx; y-=dy; break;
      case 'dl': x-=dx; y+=dy; break;
      case 'dr': x+=dx; y+=dy; break;
    }
    var pmin=this.convertCoord({x:x,y:(pos.hvis+y)},'winvis','map');
    var pmax=this.convertCoord({x:(pos.wvis+x),y:y},'winvis','map');
    if (p.anim) {
      this._processRequest({c:'map',nobboxch:1,bbox:this.formatBBOX(new tMapBBOX(pmin.x,pmin.y,pmax.x,pmax.y))},{},{pan:0,noov:1});
      this.scrollByAnim(x,y,'window._tmap.zoomToBBOX(new tMapBBOX('+pmin.x+','+pmin.y+','+pmax.x+','+pmax.y+'))');
    } else {
      this._switchScrollEvent(0);
      this._win.scrollBy(x,y);
      this.zoomToBBOX(new tMapBBOX(pmin.x,pmin.y,pmax.x,pmax.y));
      this._switchScrollEvent(1);
    }
  }

  function scrollByAnim(x,y,c) {
    this._switchScrollEvent(0);
    var dx=0; var dy=0;
    if (x) {
      if (Math.abs(x)>9) dx=x>0?10:-10; else dx=x; 
      x-=dx;
    }
    if (y) {
      if (Math.abs(y)>9) {
			  if (x+dx) dy=Math.round(Math.abs(y/(x+dx)*10)); else dy=10;
			  dy=y>0?dy:-dy;
		  } else dy=y;
      y-=dy;
    }
    this._win.scrollBy(dx,dy);
    if (!x && !y) {
      eval(c);
      this.updateMap();
      this._switchScrollEvent(1);
    } else {
      this._timeouts[this._timeouts.length]=this._win.setTimeout('window._tmap.scrollByAnim('+x+','+y+",'"+c+"')",10);
      this._refreshOverviews({bbox:this.getBBOX()});
      this._switchScrollEvent(1);
    }
  }
  
  function scrollBy(x,y) {
    this._switchScrollEvent(0);
    this._win.scrollBy(x,y);
    this._switchScrollEvent(1);
    this._map.center=this.getBBOXCenter(this.getBBOX()); 
    if (x || y) this.updateMap();
  }   
  
  //p is internal, non-required parameter 
  function updateMap(p) {
    if (p && p.scrollLast && p.scrollLast!=this._mouse.scrolllast) return false;
    if (this._mouse.scroll) {
      this._mouse.scroll=0;
      this._mouse.rect=0;
    }
    this._processRequest({c:'map'});
  }
  
  function registerStyle(s) {
    var doc=this._win.document;
    var body=doc.getElementsByTagName("body").item(0);
    var e=doc.createElement("link");
    e.type='text/css';
    e.rel='stylesheet';
    e.href=s;
    body.appendChild(e);
    return true;
  }
    
  function registerEvent(en,f) {this._eventReg[en]=f;return true;}
  function setTool(t) {this._tool=t;}
  function getTool() {return this._tool;}
  function getWindow() {return this._win;}
  function getFrame() {return this._winFrm;}
  
  function resizeFrame(w,h) {
    var dw=Math.round((this._winFrm.width-w)/2);
    var dh=Math.round((this._winFrm.height-h)/2);
    this._switchScrollEvent(0);
    this._winFrm.width=w;
    this._winFrm.height=h;
    this.scrollBy(dw,dh);
    this._switchScrollEvent(1);
    if (dw || dh) this.updateMap();
  }
  
  function resizeViewport(w,h) {
    this.resizeFrame(w+this._brow.scbsz,h+this._brow.scbsz);
  }

  function getBrowser() {
    var b={}; 
    b.sup=1;
    b.ie=0; b.ns=0;
    b.op=window.opera?1:0;
    if (b.op) {
      b.ver=parseFloat(navigator.appVersion);
      b.sup=b.ver>6;
      if (this._divLayers) {
        b.scbsz = window.innerWidth - document.body.clientWidth;
      }
    } else {
      b.ie=document.all?1:0;
      if (b.ie) {
        b.ver=!document.fireEvent?(document.getElementById?5.0:4.0):(document.createComment?6:5.5);
        b.sup=b.ver>5.0;
        if (this._divLayers) {
          b.scbsz = document.body.offsetWidth - document.body.clientWidth;
        }
      } else {
        b.ns=1;
        b.ver=document.getElementById?6:4;
        b.sup=b.ver>4;
        if (navigator.userAgent.indexOf('Firefox') > 1) {
          b.ff = 1;
        } else {
          b.ff = 0;
        }
        if (this._divLayers) {
          if (b.ff) {
            if (navigator.userAgent.indexOf('1.0.') > 1) {
              b.ff10 = true;
              b.scbsz = window.innerWidth - document.body.clientWidth;
            } else {
              b.ff10 = false;
              b.scbsz = window.innerWidth - document.documentElement.clientWidth;
            }
          } else {
            b.scbsz = window.innerWidth - document.body.clientWidth;
          }
        }
      }
    }
    return b;
  }

  /****************** OVERVIEW ***************************/
  
  function _refreshOverviews(p) {
		if (this._overviews.len) {
      var ov,px,ext,w;
    	var b=(p && p.bbox)?p.bbox:this._map.bbox; 
      for (key in this._overviews.ovs) {
        ov=this._overviews.ovs[key];
        ext=ov.p.ext?ov.p.ext:this._overviews.prop.ext;
        if (ext) {
    			ov.z.style.visibility='hidden';
    			if (!ov.p.ext) {
    			  if (ov.i.src!=this._overviews.prop.img) {
    				  ov.i.src=this._overviews.prop.img;
    					ov.i.style.visibility='visible';
    			  }
    			}
          w= ov.d.clientWidth || ov.d.scrollWidth;
  				px=(ext['maxx']-ext['minx'])/w;
          if (this._overviews.prop.maxp >= this._map.px) {
      			ov.z.style.left=Math.round((b['minx']-ext['minx'])/px)+'px';
      			ov.z.style.width=Math.round((b['maxx']-b['minx'])/px)+'px';
      			ov.z.style.top=Math.round((ext['maxy']-b['maxy'])/px)+'px';
      			ov.z.style.height=Math.round((b['maxy']-b['miny'])/px)+'px';
            ov.z.style.visibility='visible';
          }
        } 
      }
		}
  }
  
  function getOverview() {
    return this._overviews.prop;
  }

  function setOverviewType(p) {
    this._overviewtype=p;
  }

  function setStopOnRequest(p) {
    this._stoponreq=p;
  }
  
  function getStopOnRequest() {
    return this._stoponreq;
  } 
  
  function _getOwnerDocument(d) {
    var o;
    if (!d) return false;
    if (this._brow.ie && this._brow.ver < 6) {
      var doc=d;
      while (doc.parentElement) doc=doc.parentElement;
      o=doc.document;
    } else {
      o=d.ownerDocument;
    }
    return o;
  }
  
  function registerOverview(d,p) {
    p.ownD=this._getOwnerDocument(d);
    if (!p.ownD) return false;
    var ds=p.ownD.createElement("div");
    ds.style.position='relative';
    ds.style.left='0px';
    ds.style.top='0px';
    if (p.ext) {
  		ds.style.width='0px';
    	ds.style.height='0px';
    } else {
  		ds.style.width=(d.clientWidth || d.scrollWidth)+'px';
    	ds.style.height=(d.clientHeight || d.scrollHeight)+'px';
  		ds.style.overflow='hidden';
    }
    var f=d.firstChild;
    if (f) {
      d.insertBefore(ds,f);
    } else
      d.appendChild(ds);
    
    if (!p.ext) {
      var i=p.ownD.createElement("img");
      i.style.position='absolute';
  		i.style.left='0px';
  		i.style.top='0px';
  		i.style.width=(d.clientWidth || d.scrollWidth)+'px';
  		i.style.height=(d.clientHeight || d.scrollHeight)+'px';
  		i.style.visibility='hidden';
      ds.appendChild(i);
    }
		
    z=p.ownD.createElement("div");
    z.style.position='absolute';
//		z.style.visibility='hidden';
    z.style.border=p.zs?p.zs:'2px red solid';
    z.style.left='-1000px';
    z.style.top='-1000px';
		z.style.width='0px';
		z.style.height='0px';
    z.style.fontSize='0px';
    ds.appendChild(z);

    var e=p.ownD.createElement("div");
    e.style.position='absolute';
		e.style.left='0px';
		e.style.top='0px';
		e.style.backgroundImage='url(#)';
		e.style.width=(d.clientWidth || d.scrollWidth)+'px';
		e.style.height=(d.clientHeight || d.scrollHeight)+'px';
    e.onmousedown=this._ovMouseDownProc;
    e.onmousemove=this._ovMouseMoveProc;
    e.onmouseup=this._ovMouseUpProc;
    e._map=this;
    e._zoom=z;
    e._ovid=this._overviews.len;
    ds.appendChild(e);
		
    this._overviews.ovs[this._overviews.len]={d:d,p:p,i:i,z:z};
    this._overviews.len++;
    return true;
  }
  

  /****************** LAYERS ***************************/
  function createLayer(p,pr) {
    var d; var l;
    var par=pr?pr:this._divLayers;
    var doc=this._win.document;
    var nam='lr_'+p.nam;
    d=doc.getElementById(nam);
    if (!d) {
      d=doc.createElement('div');
      d.setAttribute('id',nam);
      d.style.position='absolute'; 
      d.style.left='0px';
      d.style.top='0px';
      if (p.zindex) d.style.zIndex=p.zindex;
      par.appendChild(d);
    }
    l=this._layers[nam];
    if (!l) {
      switch (p.typ) {
        case 'div':
          l=new tMapLayerdivObj({nam:nam,div:d,pro:p,map:this});
        break;
        case 'imgmx':
          l=new tMapLayerimgmxObj({nam:nam,div:d,pro:p,map:this});
        break;
        case 'points':
          l=new tMapLayerpointsObj({nam:nam,div:d,pro:p,map:this});
        break;
      }
      if (l) this._layers[nam]=l;
    }
    return l;
  }
  
  /****************** EVENTS ***************************/

  function getBrowEvent(e,win) {
    if (!win) win=this._win; 
    if (!e) e=win.event;
    var b=this._brow;
    if (b.ie) {
      e.target=e.srcElement;
      switch (e.button) {
        case 1: e.buttonAll=0; break;
        case 2: e.buttonAll=2; break;
        case 4: e.buttonAll=1; break;
        default: e.buttonAll=e.button;
      }
      e.keyNum=e.keyCode;
      switch (e.keyNum) {
        case 107: e.keyNum=43; break;
        case 109: e.keyNum=45; break;
      }
      e.layerX=e.offsetX;
      e.layerY=e.offsetY;
      e.wheelDeltaAll=-1*e.wheelDelta;
    } else if (b.op){
      e.buttonAll=e.button;
      e.keyNum=e.which;
      switch (e.keyNum) {
        case 37:
        case 38:
        case 39:
        case 40:
          e.keyNum=0;
        break;
      }
      if (b.ver<8 && e.button) e.buttonAll=e.button-1;
      e.layerX=e.offsetX;
      e.layerY=e.offsetY;
      e.wheelDeltaAll=e.wheelDelta;
    } else {
      e.keyNum=e.which;
      switch (e.keyNum) {
        case 107: e.keyNum=43; break;
        case 109: e.keyNum=45; break;
      }
      e.buttonAll=e.button;
      e.wheelDeltaAll=e.detail;
    }
    return e;
  }
  
  function _switchScrollEvent(on) {
    this._mouse.scrollon=on;
    if (on && this._win._tmap) this._timeouts[this._timeouts.length]=this._win.setTimeout('window._tmap._win.onscroll=window._tmap._evScrollOn',this._brow.ie?1:100); else this._win.onscroll=this._evScrollOff;
  }

  function _scrollProcOff(ev) {return false;}
  
  function _scrollProcOn(ev) {
    var win=this.defaultView?this.defaultView:this;
    var tmap=win._tmap?win._tmap:this;
    if (!tmap._mouse.scrollon) return false;
    tmap._mouse.scroll=1;
    tmap._mouse.scrolllast=(new Date).getTime();
  	tmap._refreshOverviews({bbox:tmap.getBBOX()});
  	tmap._map.center=tmap.getBBOXCenter(tmap.getBBOX()); 
    tmap._timeouts[tmap._timeouts.length]=tmap._win.setTimeout('window._tmap.updateMap({scrollLast:'+tmap._mouse.scrolllast+'})',350);
    return false;
  }
  
  function _mouseWheelProc(ev) {
    var win=this.parentWindow || this.defaultView;
    var tmap=win._tmap;
    var e=tmap.getBrowEvent(ev,win);
    if (tmap._eventHandler('onMouseWheel',{ev:e,win:win})) {
      switch (tmap._tool) {
        case 'zoom':
          if (e.altKey && e.wheelDeltaAll) {
        	  if (tmap._brow.ie) { 
              win.scrollBy(e.wheelDeltaAll,0);
              return false;
            } else 
              win.scrollBy(-30*e.wheelDeltaAll,-20*e.wheelDeltaAll);
          }
        break;
        case 'zoom2':
          if (e.wheelDeltaAll > 0) 
            tmap.zoomToLevel('p');
          else
            tmap.zoomToLevel('n');
          return false;
        break;
      }
    }
  }

  function _ovMouseDownProc(ev) {
    var tmap=this._map;
    var d=tmap._getOwnerDocument(this);
    if (!d) return false;
    var win=d.parentWindow;
    var e=tmap.getBrowEvent(ev,win);
    if (this._map) {
      switch (e.buttonAll) {
      case 0:
        tmap._mouse.type='ov';
        tmap._mouse.target=e.target;
        tmap._mouse.rect=1;
        tmap._mouse.startX=e.layerX;
        tmap._mouse.startY=e.layerY;
        tmap._mouse.left=tmap._mouse.startX;
        tmap._mouse.right=tmap._mouse.startX;
        tmap._mouse.top=tmap._mouse.startY;
        tmap._mouse.bottom=tmap._mouse.startY;
        return false;
      break;
      }
    }
  }
  
  function _ovMouseMoveProc(ev) {
    var tmap=this._map;
    var d=tmap._getOwnerDocument(this);
    if (!d) return false;
    var win=d.parentWindow;
    var e=tmap.getBrowEvent(ev,win);
    if (tmap._mouse.rect && tmap._mouse.target==e.target) {
      var div=this._zoom;
      div.style.visibility='visible';
      var x=e.layerX;
      var y=e.layerY;
      if (x>tmap._mouse.startX) {
        tmap._mouse.left=tmap._mouse.startX;
        tmap._mouse.right=x;
        div.style.left=(tmap._mouse.startX-2)+'px';
        div.style.width=(x-tmap._mouse.startX)+'px';
      } else { 
        tmap._mouse.left=x;
        tmap._mouse.right=tmap._mouse.startX;
        div.style.left=(x-2)+'px';
        div.style.width=(tmap._mouse.startX-x)+'px';
      }
      if (y>tmap._mouse.startY && y>10) {
        tmap._mouse.top=tmap._mouse.startY;
        tmap._mouse.bottom=y;
        div.style.top=(tmap._mouse.startY-2)+'px';
        div.style.height=(y-tmap._mouse.startY)+'px';
        window.status=this.clientLeft;
      } else {
        tmap._mouse.top=y;
        tmap._mouse.bottom=tmap._mouse.startY;
        div.style.top=(y-2)+'px';
        div.style.height=(tmap._mouse.startY-y)+'px';
      }
    }
  }
  function _ovMouseUpProc(ev) {
    var tmap=this._map;
    var d=tmap._getOwnerDocument(this);
    if (!d) return false;
    var win=d.parentWindow;
    var e=tmap.getBrowEvent(ev,win);
    if (tmap._mouse.rect && tmap._mouse.target==e.target) {
      tmap._mouse.rect=0;
      var ov=tmap._overviews.ovs[this._ovid]
      var ext=ov.p.ext?ov.p.ext:tmap._overviews.prop.ext;
      if (!ext) return false;
      var w=this.clientWidth || this.scrollWidth;
      var h=this.clientWidth || this.scrollWidth;
      var px=(ext.maxx-ext.minx)/w;
      var bbox=new tMapBBOX(
        ext.minx+((tmap._mouse.left-2)*px),
        ext.maxy-((tmap._mouse.bottom-2)*px),
        ext.minx+((tmap._mouse.right-2)*px),
        ext.maxy-((tmap._mouse.top-2)*px)
      );
      if ((tmap._mouse.right-tmap._mouse.left)<3) {
        var pt={x:(bbox.minx+bbox.maxx)/2,y:(bbox.miny+bbox.maxy)/2};
        var bbox=tmap.setBBOXCenter(tmap.getBBOX(),pt);
      }
      tmap._mouse.target=null;
      tmap.zoomToBBOX(bbox);
      return false;
    }
  }

  function _mouseDownProc(ev) {
    var win=this.parentWindow || this.defaultView;
    var tmap=win._tmap;
    var e=tmap.getBrowEvent(ev,win);
    var pt=tmap.convertCoord({x:e.clientX,y:e.clientY},'winvis','map');
    tmap.s42towgs84(pt.x, pt.y);
    if (tmap._eventHandler('onMouseDown',{pt:pt,ev:e,win:win})) {
      var div=tmap._divZoom;
      var pos=tmap._getWinPos();
      if (e.clientX <= pos.wvis && e.clientY <= pos.hvis) {
        switch (tmap._tool) {
          case 'zoom':
          case 'zoom2':
            switch (e.buttonAll) {
            case 0:
              tmap._mouse.scroll=0;
              tmap._mouse.down=1;
              tmap._mouse.type='map';
              tmap._mouse.rect=1;
              tmap._mouse.ctrl=e.ctrlKey; 
              tmap._mouse.startX=e.clientX;
              tmap._mouse.startY=e.clientY;
              tmap._mouse.left=e.clientX;
              tmap._mouse.right=e.clientX;
              tmap._mouse.top=e.clientY;
              tmap._mouse.bottom=e.clientY;
              return false;
            break;
            case 2:
              tmap.zoomToLevel('p');
              return false;
            break;
            }
          break;
        }
      }
    }
  }

  function _mouseMoveProc(ev) {
    var win=this.parentWindow || this.defaultView;
    var tmap=win._tmap;
    var e=tmap.getBrowEvent(ev,win);
    var pt=tmap.convertCoord({x:e.clientX,y:e.clientY},'winvis','map');
    if (tmap._eventHandler('onMouseMove',{pt:pt,ev:e,win:win})) {
      if (tmap._mouse.rect && !tmap._mouse.scroll && tmap._mouse.type=='map') {
        var pos=tmap._getWinPos();
        var div=tmap._divZoom;
        if (tmap._tool=='zoom' || (tmap._tool=='zoom2' && tmap._mouse.ctrl)) {
          if (e.clientX>tmap._mouse.startX) {
            tmap._mouse.left=tmap._mouse.startX;
            tmap._mouse.right=e.clientX;
            div.style.left=(pos.l+tmap._mouse.startX-2)+'px';
            div.style.width=(e.clientX-tmap._mouse.startX)+'px';
          } else { 
            tmap._mouse.left=e.clientX;
            tmap._mouse.right=tmap._mouse.startX;
            div.style.left=(pos.l+e.clientX-2)+'px';
            div.style.width=(tmap._mouse.startX-e.clientX)+'px';
          }
          if (e.clientY>tmap._mouse.startY) {
            tmap._mouse.top=tmap._mouse.startY;
            tmap._mouse.bottom=e.clientY;
            div.style.top=(pos.t+tmap._mouse.startY-2)+'px';
            div.style.height=(e.clientY-tmap._mouse.startY)+'px';
          } else {
            tmap._mouse.top=e.clientY;
            tmap._mouse.bottom=tmap._mouse.startY;
            div.style.top=(pos.t+e.clientY-2)+'px';
            div.style.height=(tmap._mouse.startY-e.clientY)+'px';
          }
        } else if (tmap._mouse.down) {
          tmap._switchScrollEvent(0);
          tmap._win.scrollBy(tmap._mouse.left-e.clientX,tmap._mouse.top-e.clientY);
          tmap._map.center=tmap.getBBOXCenter(tmap.getBBOX()); 
          tmap._draggingMapCheck();
          tmap._mouse.left=e.clientX;
          tmap._mouse.top=e.clientY;
          tmap._switchScrollEvent(1);
        }
        div.style.visibility='visible';
        return false;
      }
    }
  }
  

  function _dblClickProc(ev) {
    var win=this.parentWindow || this.defaultView;
    var tmap=win._tmap;
    var e=tmap.getBrowEvent(ev,win);
    var pt=tmap.convertCoord({x:e.clientX,y:e.clientY},'winvis','map');
    if (tmap._eventHandler('onDblClick',{pt:pt,ev:e,win:win}) && e.buttonAll==0) {
      tmap.zoomToLevel('n',pt);
    }
    return false;
  }

  function _mouseUpProc(ev,win) {
    if (!win) var win=this.parentWindow || this.defaultView;
    var tmap=win._tmap;
    var e=tmap.getBrowEvent(ev,win);
    var pt=tmap.convertCoord({x:e.clientX,y:e.clientY},'winvis','map');
    if (tmap._eventHandler('onMouseUp',{pt:pt,ev:e,win:win})) {
      tmap._mouse.down=0;
      if (tmap._tool=='zoom2' && !tmap._mouse.ctrl && e.buttonAll==0) {
        tmap._mouse.ctrl=false;
        tmap._mouse.rect=0;
        tmap.updateMap();
        return false;
      } 
      if (tmap._mouse.rect && !tmap._mouse.scroll && e.buttonAll==0) {
        var div=tmap._divZoom;
        tmap._mouse.rect=0;
        div.style.visibility='hidden';
        div.style.left=0;
        div.style.top=0;
        div.style.width='0px';div.style.height='0px';
        var pmin=tmap.convertCoord({x:tmap._mouse.left,y:tmap._mouse.bottom},'winvis','map');
        var pmax=tmap.convertCoord({x:tmap._mouse.right,y:tmap._mouse.top},'winvis','map');
        if (tmap._tool=='zoom' || (tmap._tool=='zoom2')) {
          if ((tmap._mouse.right-tmap._mouse.left)>3) {
            var b=new tMapBBOX(pmin.x,pmin.y,pmax.x,pmax.y);
            var p=tmap.getActiveZoomLevel()+1;
            if (p<tmap._zoomLvlsCount) {
              var px=tmap._getBBOXPixelSize(b);
              if (tmap._zoomLvls[p].p < px) {
                b=tmap.resizeBBOX(b,tmap._zoomLvls[p].p/px);
              }
            }
            tmap.zoomToBBOX(b);
          } else {
            tmap.zoomToLevel('n',{x:(pmin.x+pmax.x)/2,y:(pmin.y+pmax.y)/2});
          }
        }
        tmap._mouse.scroll=0;
        return false;
      }
    }
  }

  function _mouseOutProc(ev) {
    var win=this.parentWindow || this.defaultView;
    var tmap=win._tmap;
    var e=tmap.getBrowEvent(ev,win);
    var pt=tmap.convertCoord({x:e.clientX,y:e.clientY},'winvis','map');
    if (tmap._eventHandler('onMouseOut',{pt:pt,ev:e,win:win})) {
      var pos=tmap._getWinPos();
      if (tmap._mouse.down && (e.clientX>pos.wvis || e.clientX<0 || e.clientY>pos.hvis || e.clientY<0)) {
        tmap._mouseUpProc(ev, win);
      }
    }
  }

  function _keyDownProc(ev) {
    var win=this.parentWindow || this.defaultView;
    var tmap=win._tmap;
    var e=tmap.getBrowEvent(ev,win);
    if (tmap._eventHandler('onKeyDown',{ev:e,win:win})) {
      var sz=false;
      if (e.ctrlKey) sz=1/100;
      switch (e.keyNum) {
        case 37: tmap.pan({dir:'l',size:sz}); break;
        case 38: tmap.pan({dir:'u',size:sz}); break;
        case 39: tmap.pan({dir:'r',size:sz}); break;
        case 40: tmap.pan({dir:'d',size:sz}); break;
        case 43: tmap.zoomToLevel('n'); break;
        case 45: tmap.zoomToLevel('p'); break;
      }
    }
  }

  function _eventHandlerReg(en,p) { 
    var r; 
    p.obj=this; 
    p.nam=en;
    var m=this._eventReg[en];
    if (m) {
      if (this._brow.ie && this._brow.ver<5) 
        r=m(p);
      else 
        try {r=m(p)} catch(e) {if (this._debug) alert(this._name+": error in the event handler: "+m)};
    }
    return (r==undefined)?true:r;
  }
  
  function _mozillaScroll() {
    if (this._win.document.documentElement.scrollTop!=this._mozillaScTop && !this._mouse.down) {
      this._mozillaScTop=this._win.document.documentElement.scrollTop;
      if (!this._mozillaScSkip) {
        this._scrollProcOn();
      } else {
        this._mozillaScSkip=0;
      }
    }
  }
  
  function _draggingMapCheck() {
    var p=this._getWinPos();
    var bad=p.l<2||(p.w-p.l-p.wvis)<2||p.t<2||(p.h-p.t-p.hvis)<2;
    this._eventHandler('onDraggingMap',{ok:!bad});
    return !bad;
  }
  
  /****************** CONVERT ***************************/
  
  function s42towgs84(y,x,f) {
    function formatwgs84(p) {
      p+=1/7200;  // add 1 second for rounding
      var deg=Math.floor(p);
      var min=Math.floor((p-deg)*60);
      var sec=Math.round((p-deg-min/60)*3600*100)/100+0.001;
      //if (deg<100) deg='0'+deg; if (deg<10) deg='0'+deg;
      if (min<10) min='0'+min;
      if (sec<10) sec='0'+sec; sec=String(sec); sec=sec.substr(0,5);
      return deg+'\u00B0'+min+'\u2032'+sec+'\u2033';
    }
    if (!y || !x) return false;
    if (y<3260000 || x<5360000 || y>3820000 || x>5680000) return false;
    //x = 3528545; y=5514561;
    var ro=57.295779513082321; var a=6378245; var c=6356863.019; var e2=0.673852541468/100; var ee=0.669342162297/100;
    var pas=3;
    var lnula=pas*6-3;
    var b=x/111134.861084;
    y=y-pas*1000000-500000;
    var br=b/ro; 
    var db=16036.480269*Math.sin(2*br);
    db=db-16.828067*Math.sin(4*br);
    db=db+0.021975*Math.sin(6*br);
    db=db-0.000031*Math.sin(8*br);
    var t=Math.sin(br)/Math.cos(br);
    var eta2=e2*Math.cos(br)*Math.cos(br);
    var n=a*a/(c*Math.sqrt(eta2+1));
    b=b+db*ro*(1+eta2)/n;
    b=b-(3*ro*t*db*db*eta2)*(1+eta2)/(2*n*n);
    b=b-(ro*db*db*db*eta2)*(1-t*t+2*eta2-6*t*t*eta2)/(2*n*n*n);
    br=b/ro;
    t=Math.sin(br)/Math.cos(br);
    eta2=e2 *Math.cos(br)*Math.cos(br);
    n=a*a/(c*Math.sqrt(eta2+1));
    l=lnula;
    l1=(ro*y)/(n*Math.cos(br));
    l+=l1;
    l2=-(ro*y*y*y)*(1+2*t*t+eta2)/(6*n*n*n*Math.cos(br));
    l+=l2;
    l3=(ro*y*y*y*y*y)*(5+28*t*t+24*t*t*t*t+6*eta2+8*t*t*eta2)/(120*n*n*n*n*n*Math.cos(br));
    l+=l3;
    b=b-(ro*t*y*y)*(1+eta2)/(2*n*n);
    b=b+(ro*t*y*y*y*y)*(5+3*t*t+6*eta2-6*t*t*eta2-3*eta2*eta2-9*t*t*eta2*eta2)/(24*n*n*n*n);
    l=l/ro; b=b/ro;
    var f84=b-1.4/3600/ro;
    var l84=l-6.2/3600/ro;
    if (l>(18/ro)) {
      f84=b-1.2/3600/ro;
      l84=l-6.1/3600/ro;
    }
    f84=f84*180/Math.PI;  
    l84=l84*180/Math.PI;
    if (!f) {
      f84=formatwgs84(f84);
      l84=formatwgs84(l84);
    }  
    return {fi:f84,lambda:l84};   
  }
  

}

function tMapSubLayer(p) {
  this.pro=p.pro;
  this.par=p.par;
  
  this.getProperties=getProperties;
  this.getParent=getParent;
  this.setVisible=setVisible;
  
  function getProperties() {return this.pro;}  
  function getParent() {return this.par;}
  function setVisible(v) {this.pro.vis=(v?1:0)}  
}

function tMapLayerObj(p) {
  this._mapO=p.map; 
  this._div=p.div; 

  this.name=p.nam; 
  this.pro=p.pro; 
  this.subLrs={lrs:{},len:0};

  this.getDiv=getDiv;
  this.refresh=refresh;
  this.draw=draw;
  this.clear=clear;
  
  this.getSubLayers=getSubLayers;
  this.registerSubLayers=registerSubLayers;
  
  if (this.pro.lrs) this.registerSubLayers(this.pro.lrs);

  function getDiv() {return this._div;}
  function refresh(){}
  function draw(dt){}
  function clear(){
    this._div.style.width='0px';
    this._div.style.height='0px';
  }
  
  function registerSubLayers(l) {
    var k,lr;
    if (l) {
      for (k in l) {
        lr=l[k];
        lr.par=this;
        this.subLrs['lrs'][lr.name]=new tMapSubLayer(lr);
        this.subLrs['len']++;
      }
    }
  }
  
  function getSubLayers() {
    return this.subLrs;
  }
}

function tMapLayerdivObj(p) {
  this.inh=tMapLayerObj;this.inh(p);
}

function tMapLayerpointsObj(p) {
  this.inh=tMapLayerObj;this.inh(p);
  this._dat={dt:{},len:0};
  this._mat={};
  
  this._checkMatCol=_checkMatCol;
  this._writeMatPos=_writeMatPos;
  this._getMatRectPad=_getMatRectPad;
  this._procesRenderer=_procesRenderer;
  this._getPointRect=_getPointRect;
  this._getCopyRect=_getCopyRect;
  this._findMatPos=_findMatPos;
  this._findMatPosFreeXYProc=_findMatPosFreeXYProc;
  this.appendData=appendData;
  this.refresh=refresh;
  this.draw=draw;
  this.clear=clear;
  
  this.getDataCount=getDataCount;
  this.getData=getData;

  function getDataCount() {
    return this._dat.len;
  }

  function getData(i) {
    return this._dat.dt[i];
  }
  
  function clear(){
    var d; var i; var p;
    for (i in this._dat.dt) {
      d=this._dat.dt[i];
      if(d.el) this._div.removeChild(d.el);
      d.el = null;
    }
    this._dat={dt:{},len:0};
    this._div.style.width='0px';
    this._div.style.height='0px';
  }
  
  function _checkMatCol(r) {
    var l,t;
    var m=this._mat;
    for(l=r.l+1;l<r.r;l++) {
      for(t=r.t+1;t<r.b;t++) {
        if (m[l] && m[l][t]) return m[l][t];
      }
    }
    return false;
  }

  function _writeMatPos(r) {
    var l,t;
    var m=this._mat;
    for(l=r.l;l<=r.r;l++) {
      for(t=r.t;t<=r.b;t++) {
        if (!m[l]) m[l]={};
        m[l][t]=r;
      }
    }
  }

  function _findMatPosFreeXYProc(r,x,y) {
    r.dx=0; r.dy=0;
    r.lo=r.l; r.to=r.t; r.bo=r.b; r.ro=r.r;
    while (this._checkMatCol(r)) {
      r.dx+=x; r.dy+=y;
      r.l=Math.round(r.lo+r.dx); r.r=Math.round(r.ro+r.dx); 
      r.t=Math.round(r.to+r.dy); r.b=Math.round(r.bo+r.dy); ;
    }
    r.dist=(r.dx*r.dx+r.dy*r.dy);
    return r;
  }

  function _findMatPos(r) {
    var p=new Array();
    var rc=this._checkMatCol(r);
    var dl=r.l-rc.l;
    var dt=r.t-rc.t;
    var dh=r.h/r.w;
    p[0]=this._findMatPosFreeXYProc(this._getCopyRect(r),1,0);
    p[1]=this._findMatPosFreeXYProc(this._getCopyRect(r),-1,0);
    p[2]=this._findMatPosFreeXYProc(this._getCopyRect(r),0,dh);
    p[3]=this._findMatPosFreeXYProc(this._getCopyRect(r),0,-dh);
    p[4]=this._findMatPosFreeXYProc(this._getCopyRect(r),1,-dh);
    p[5]=this._findMatPosFreeXYProc(this._getCopyRect(r),1,dh);
    p[6]=this._findMatPosFreeXYProc(this._getCopyRect(r),-1,dh);
    p[7]=this._findMatPosFreeXYProc(this._getCopyRect(r),-1,-dh);
    if (dl || dt) {
      if (dl!=0) {dt=dt/Math.abs(dl);dl=dl/Math.abs(dl);} else {dl=dl/Math.abs(dt);dt=dt/Math.abs(dt)}
      p[8]=this._findMatPosFreeXYProc(this._getCopyRect(r),dl,dt);
      p[8].dist-=p[8].dist*0.50;
    }
    var i;
    var d=10000;
    for (i in p) {
      if (p[i].dist < d) {
        r=p[i];
        d=p[i].dist;
      }
    }
    
    
    return r;
  }
  
  function _getMatRectPad(r,v) {
    var c;
    if (v) {
      var p=v.p;
      if (!isNaN(p)) {
        p={l:p,r:p,t:p,b:p};
      }
      switch (v.t) {
        case 'pc':
          var w=r.r-r.l;
          var h=r.b-r.t;
          if (p.l) r.l-=Math.round(w*p.l/100);
          if (p.r) r.r+=Math.round(w*p.r/100);
          if (p.t) r.t-=Math.round(h*p.t/100);
          if (p.b) r.b+=Math.round(h*p.b/100);
        break;
        case 'px':
        default:
          if (p.l) r.l-=p.l;
          if (p.r) r.r+=p.r;
          if (p.t) r.t-=p.t;
          if (p.b) r.b+=p.b;
        break;
      }
      if (r.l>r.r) {c=r.l;r.l=r.r;r.r=c;} 
      if (r.t>r.b) {c=r.b;r.b=r.t;r.t=c;} 
      r.w=r.r-r.l;
      r.h=r.b-r.t;
    }
    return r;
  }
  
  function _getCopyRect(r) {
    return {l:r.l,r:r.r,t:r.t,b:r.b,w:r.w,h:r.h};
  }
  
  function _procesRenderer(e,p,d) {
    if (p.c) e.innerHTML=p.c;
    if (p.s) for (s in p.s) e.style[s]=p.s[s];
    if (p.a) for (s in p.a) e.setAttribute(s,p.a[s]);
    for (s in p.e) { 
      if (this._mapO._brow.ie) 
        e.attachEvent('on'+s,p.e[s]); 
      else 
        e.addEventListener(s,p.e[s],false);
    }
    if (p.ct) d.ct=p.ct;
    if (p.rp) d.rp=p.rp;
    if (p.po) d.po=p.po;
  }

  function appendData(dt,st,pro){
    var i,d,e,p,t,te,w;
    for (i in dt) {
      d=dt[i];
      if (!d.co) continue;
      if (pro && pro.pos) {
        d.co.x+=pro.pos.x;
        d.co.y+=pro.pos.y;
      }
      t=d.re.t?d.re.t:st.re.t;
      switch (t) {
        case 'el':
          p=(d.re && d.re.s)?d.re.s:{};
          te=p.t?p.t:st.re.s.t;
          e=this._mapO._win.document.createElement(te);
          e.style.position='absolute';
          e.style.left='-1000px';
          e.setAttribute('id',this.name+'_'+i);
          if (st && st.re && st.re.s) this._procesRenderer(e,st.re.s,d);
          this._procesRenderer(e,p,d);
          d.id=d.id?d.id:i;
          e.tData=d;
          this._div.appendChild(e);
          w=e.clientWidth || e.scrollWidth;
          if (w && !e.style.width) e.style.width=w+'px';
          d.el=e;
        break;
      }
//      e.outerHTML=d.e;
      this._dat.dt[this._dat.len]=d;
      this._dat.len++;
    }
  }
  
  function _getPointRect(d) {
    var p=this._mapO.convertCoord(d.co,'map','win');
    var x=p.x;
    var y=p.y;
    if (!d.rp) d.rp={};
    var v=d.el.style.display=='none';
    if (v) d.el.style.display='inline';
    switch (d.rp.ver) {
      case 't': y-=0; break;
      case 'b': y-=d.el.offsetHeight; break;
      case 'm': default: y-=Math.floor(d.el.offsetHeight / 2); break;
    }
    switch (d.rp.hor) {
      case 'l': x-=0; break;
      case 'r': x-=d.el.offsetWidth; break;
      case 'c': default: x-=Math.floor(d.el.offsetWidth / 2); break;
    }
    if (d.rp.left) x-=d.rp.left;
    if (d.rp.top) y-=d.rp.top;
    d.el.style.left=x+'px';
    d.el.style.top=y+'px';
    var r={l:x,r:x+d.el.offsetWidth-1,t:y,b:y+d.el.offsetHeight-1};
    r.w=r.r-r.l;
    r.h=r.b-r.t;
    if (v) d.el.style.display='none';
    return r;
  }
  
  function refresh(){
    var d,i,p,x,y,r,rd,dl,dt,rc;
    var m=this._mapO;
    var b=m._map.bbox;
    var pts=new Array();
    var pts2=new Array();
    this._mat={};
    for (i in this._dat.dt) {
      d=this._dat.dt[i];
      if (d.co) {
        if (m.pointInBBOX(b,d.co)) {
          rd=this._getPointRect(d);
          if (this.pro.allowcollision || this.pro.allowcollission) {
            d.el.style.left=rd.l+'px';
            d.el.style.top=rd.t+'px';
            d.el.style.display='inline';
          } else {
            r=this._getMatRectPad(this._getCopyRect(rd),d.po);
            if (!this._checkMatCol(r)) {
              this._writeMatPos(r);
              d.el.style.left=rd.l+'px';
              d.el.style.top=rd.t+'px';
              d.el.style.display='inline';
            } else {
              pts[pts.length]={d:d,r:r,rd:rd};
            }
          }
        } else {
          d.el.style.display='none';
        }
      }
    }
    for (i in pts) {
      d=pts[i].d;
      rd=pts[i].rd;
      r=this._findMatPos(this._getCopyRect(pts[i].r));
      if (r) {
        this._writeMatPos(r);
        rd.l = rd.l+(r.l-pts[i].r.l);
        rd.t = rd.t+(r.t-pts[i].r.t);
        d.el.style.left=rd.l+'px';
        d.el.style.top=rd.t+'px';
        d.el.style.display='inline';
      } else {
        d.el.style.display='none';
      }
    } 
  }
  
  function draw(d){
    if (d && d.dat) {
      if (!this.pro.persist) this.clear();
      this.appendData(d.dat.dat, d.dat.st, d.dat.pro);
    }
    this.refresh();
  }
  
}

function tMapLayerimgmxObj(p) {
  this.inh=tMapLayerObj;this.inh(p);
  this._cache={};
  this._createImg=_createImg;
  this._removeImg=_removeImg;
  //Public
  this.draw=draw;
  this.clear=clear;

  function clear() {
    var d=this._div; 
    var l=d.childNodes.length;
    for (i=0;i<l;i++) d.removeChild(d.childNodes[0]);

    this._cache={};
    this._div.style.width='0px';
    this._div.style.height='0px';
  }

  function _removeImg(p) {
    if (p) {
      p.onload=null;
      p.ondragstart=null;
      this._div.removeChild(p);
    }
  }

  function _createImg(p) {

    function _imgonload() {this.data=1;}
    function _imgondragstart() {return false}

    var i=this._mapO._win.document.createElement("img");
    i.src=p.u+p.n;
    i.style.left=p.l+'px';
    i.style.top=p.t+'px';
    i.style.width=p.w+'px';
    i.style.height=p.h+'px';
    i.style.position='absolute';
    i.data=0;
    i.onload=_imgonload;
    i.ondragstart=_imgondragstart;
    this._div.appendChild(i);
    return i;
  }
  
  function draw(dt) {
    var k=0; var img=null;
    if (dt.dat && dt.pro.pos) {
      var pt=this._mapO.convertCoord({x:dt.pro.pos.x,y:dt.pro.pos.y},'map','win');
      var t=pt.y;
      var l=0;
      var cre=false;
      var url;
      for (var i=0;i<dt.pro.cat.r;i++) {
        l=pt.x;
        for (var j=0;j<dt.pro.cat.c;j++) {
          if (this._cache[l] && this._cache[l][t]) {
            if (!this._cache[l][t].data) {
              this._removeImg(this._cache[l][t]);
              this._cache[l][t]=null;
              cre=true;
            } else {
              cre=false;
            }
          } else {
            cre=true;
          } 
          if (cre && dt.dat[k]!='-') {
            if (dt.pro.cat.u2) {
              if (Math.round(l/dt.pro.pos.w)%2)
                if (Math.round(t/dt.pro.pos.h)%2)
                  url = dt.pro.cat.u;
                else
                  url = dt.pro.cat.u2;
              else
                if (Math.round(t/dt.pro.pos.h)%2)
                  url = dt.pro.cat.u2;
                else
                  url = dt.pro.cat.u;
            } else {
              url = dt.pro.cat.u;
            }
            img=this._createImg({
              u:url,
              n:dt.dat[k],
              l:l,
              t:t,
              w:dt.pro.pos.w,
              h:dt.pro.pos.h
            });
            if (!this._cache[l]) this._cache[l]={};
            this._cache[l][t]=img;
            img=null;
          }
          k++;
          l+=dt.pro.pos.w;
        }
        t+=dt.pro.pos.h;
      }
    }
    //Clear cache
    var rem; 
    this._cache[0]={};
    for (var l in this._cache) {
      rem=false;
      l = l*1;
      if (pt && ((l < (pt.x-3*dt.pro.pos.w)) || (l > (pt.x+(3+dt.pro.cat.c)*dt.pro.pos.w)))) rem=true;
      for (var t in this._cache[l]) {
        t=t*1;
        if (rem || (pt && (t < (pt.y-3*dt.pro.pos.h)) || (t > (pt.y+(3+dt.pro.cat.r)*dt.pro.pos.h)))) {
          this._removeImg(this._cache[l][t]);
          this._cache[l][t] = null;
          this._cache[l][t] = undefined;
        }
      }
      if (rem) this._cache[l]=undefined;
    }

  }  
}


