// Copyright 2000 T-Mapy spol. s r. o. All rights reserved.
//$Id: ZoomBaseFunc.js,v 1.5 2006/01/17 10:28:55 jiva Exp $ $Name:  $

function FullExtent() {
	var c=map.cur; c.minx=map.minx; c.miny=map.miny; c.maxx=map.maxx; c.maxy=map.maxy;
	Scale();
	Refresh();
}

function ZoomOutCenter() {
	var r=map.rect;
	Transf_XY();
	ZoomOutCenterXY(r.x1,r.y2);
}

function ZoomOutCenterXY(x,y) {
	var c=map.cur;
	if (map.scale < map.maxScale) {
		w=(c.maxx-c.minx);
		h=(c.maxy-c.miny);
		dx=x-(c.minx+w/2);
		dy=y-(c.miny+h/2);
		c.minx=c.minx+dx-(w/2);
		c.maxx=c.maxx+dx+(w/2);
		c.miny=c.miny+dy-(h/2);
		c.maxy=c.maxy+dy+(h/2);
		Scale();
		if (map.scale > map.maxScale) {
			ChangeScale(map.maxScale);
		}
		Refresh();
	}
	else PanCenterXY(x,y);
}

function ZoomOutRect() {
	var r=map.rect; var c=map.cur;
	Transf_XY();
	if (map.scale < map.maxScale) {
		wx=(c.maxx-c.minx)*(c.maxx-c.minx)/(r.x2-r.x1);
		wy=(c.maxy-c.miny)*(c.maxy-c.miny)/(r.y2-r.y1);
		pan_x=(r.x1-c.minx)*wx/(c.maxx-c.minx);
		pan_y=(r.y1-c.miny)*wy/(c.maxy-c.miny);
		c.minx=c.minx-pan_x;
		c.miny=c.miny-pan_y;
		c.maxx=c.minx+wx;
		c.maxy=c.miny+wy;
		ChangeRatio(c);
		Scale();
		if (map.scale>map.maxScale) {
			ChangeScale(map.maxScale);
		}
		Refresh();
	}
	else PanCenterXY(Math.round(r.x1+(r.x2-r.x1)/2), Math.round(r.y1+(r.y2-r.y1)/2));
}


function ZoomInRect() {
	var r=map.rect; var c=map.cur;
	Transf_XY();
	if (map.scale > map.minScale) {
		c.minx=r.x1;
		c.miny=r.y1;
		c.maxx=r.x2;
		c.maxy=r.y2;
		ChangeRatio(c);
		Scale();
		if (map.scale < map.minScale) {
			ChangeScale(map.minScale);
		}
		Refresh();
	}
	else PanCenterXY(r.x1+((r.x2-r.x1)/2), r.y1+((r.y2-r.y1)/2));
}

function ZoomInCenterXY(x,y) {
	var c=map.cur;
	if (map.scale > map.minScale) {
		w=(c.maxx-c.minx);
		h=(c.maxy-c.miny);
		dx=x-(c.minx+w/2);
		dy=y-(c.miny+h/2);
		c.minx=c.minx+dx+(w/4);
		c.maxx=c.maxx+dx-(w/4);
		c.miny=c.miny+dy+(h/4);
		c.maxy=c.maxy+dy-(h/4);
		Scale();
		if (map.scale < map.minScale) {
			ChangeScale(map.minScale);
		}
		Refresh();
	}
	else PanCenterXY(x, y);
}

function ZoomInCenter() {
	var r=map.rect;
	Transf_XY();
	ZoomInCenterXY(r.x1,r.y2);
}

function ZoomOut() {
	ZoomOutCenterXY(map.cur.minx+(map.cur.maxx-map.cur.minx)/2,map.cur.miny+(map.cur.maxy-map.cur.miny)/2);
}

function ZoomIn() {
	ZoomInCenterXY(map.cur.minx+(map.cur.maxx-map.cur.minx)/2,map.cur.miny+(map.cur.maxy-map.cur.miny)/2);
}

function ChangeScale(num) {
	var c=map.cur;
	if (num<map.minScale) num=map.minScale;
	if (num>map.maxScale) num=map.maxScale;
	map.scale=num;
	if (map.units==1000) num = num/111300;
	var w=num*map.meterWidth;
	var dx=w-(c.maxx-c.minx);
	c.minx=c.minx-dx/2;
	c.maxx=w+c.minx;
	c.miny=c.miny+(c.maxy-c.miny)/2 -1/map.units; 
	c.maxy=c.miny+2/map.units; 
	ChangeRatio(c);
}

function ChangeScaleByPixel(num) {
	var c=map.cur;
	var w = map.window.width*num;
	var dx = ((c.maxx-c.minx)-w)/2;
	c.minx = c.minx+dx;
	c.maxx = c.minx+w;
	c.miny=c.miny+(c.maxy-c.miny)/2 -1/map.units; 
	c.maxy=c.miny+2/map.units; 
	ChangeRatio(c);
	Scale();
}
function ZoomBarOnMouseDown(el) {
 if (!mobj['zoombar']) mobjprop[mobjprop.length] = 'zoombar';
 mobj['zoombar'] = 1;
}

function Back() {window.history.go(-1);}
function Forward() {window.history.go(1);}
