function Refresh(action, target) {
  if (map.last_click_x && map.last_click_y) {
    ChangeMapVarsObj('X', map.last_click_x);
    ChangeMapVarsObj('Y', map.last_click_y);
  }
  RefreshByForm(action, target);
}

function RefreshByForm(action, target) {

	switch(mobj['cl']) {
    case "print":
    case "legend":
      SetPageLayerVisible(window, "MapWait", false);
      break;
    default: SetPageLayerVisible(window, "MapWait", true);
  }

  var frm = document.frm_refresh;
  if (action) frm.action = action;
  if (target) frm.target = target;
  var e=map.cur;
  frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="BBOX" value="'+Math.round(e.minx)+","+Math.round(e.miny)+","+Math.round(e.maxx)+","+Math.round(e.maxy)+'">');
  if(map.lang) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="client_lang" value="'+map.lang+'">');
  if(subproject) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="subproject" value="'+subproject+'">');
  if(map.name) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="MAP" value="'+map.name+'">');

  if(mobj.cl || map.cl_type) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="client_type" value="'+(mobj.cl?mobj.cl:map.cl_type)+'">');

  if(map.select) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="SELECT" value="'+map.select+'">');
  if(map.window.width) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="WIDTH" value="'+map.window.width+'">');
  if(map.window.height) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="HEIGHT" value="'+map.window.height+'">');
  if(map.geolocation) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="geolocation" value="'+map.geolocation+'">');
  frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="m_next_time" value="1">');
  for (i=0; i < mobjprop.length; i++) {
    if(mobj[mobjprop[i]]) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="m_'+mobjprop[i]+'" value="'+mobj[mobjprop[i]]+'">');
  }
  if (mobj.layers)
    if (mobj.layers) frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="layers" value="'+mobj.layers+'">');
  frm.submit();
  if (target) frm.target='_self';
  if (action) frm.action='';
}

function ChangeMapVarsObj(key, val, last) {
  if (!mobj[key]) mobjprop[mobjprop.length] = key;
  if (last) {
    mobj[key+'_last'] = mobj[key];
    mobjprop[mobjprop.length] = key+'_last';
  }
  mobj[key] = val;
}

function ChangeMapVarsObjR(key, val, last) {
  ChangeMapVarsObj(key, val, last);
  Refresh();
}

function is_numeric(num) {
   if ((isNaN(num)) || (num.length == 0)) return false;
   else return true;
}

function SetHTMLLayerVisible(key, val, last) {
  if (is_numeric(key)) key = "__"+key;
  ChangeMapVarsObj(key, val, last);
  if(val) ChangeMapVarsObj("last_layer",key,false);
  else ChangeMapVarsObj("last_layer_unvisible",key,true);
  Refresh();
}

function Navi(from, type, tclass) {
  tbl = from.parentNode.parentNode;
  for (i=0; i<tbl.rows.length; i++) {
    tr = tbl.rows[i];
    for (j=0; j<tr.cells.length; j++) {
      td = tr.cells[j];
      if (td.id) {
        if ((type == 1) && (td.id == from.id)) {
//          alert(td.id+"|"+from.id+"|"+td.axis);
          if(navi.css) td.className = td.axis+"_a";
          else td.style.background = navi.select;
          imgappend = "_b";
        } else {
          if(navi.css) td.className = td.axis;
          else td.style.background = navi.background;
          imgappend = "";
        }
      }
    }
  }
}

if(typeof HTMLElement!="undefined" && !HTMLElement.prototype.insertAdjacentElement){
	HTMLElement.prototype.insertAdjacentElement = function(where,parsedNode)
	{
		switch (where){
		case 'beforeBegin':
			this.parentNode.insertBefore(parsedNode,this)
			break;
		case 'afterBegin':
			this.insertBefore(parsedNode,this.firstChild);
			break;
		case 'beforeEnd':
			this.appendChild(parsedNode);
			break;
		case 'afterEnd':
			if (this.nextSibling) this.parentNode.insertBefore(parsedNode,this.nextSibling);
			else this.parentNode.appendChild(parsedNode);
			break;
		}
	}

	HTMLElement.prototype.insertAdjacentHTML = function(where,htmlStr)
	{
		var r = this.ownerDocument.createRange();
		r.setStartBefore(this);
		var parsedHTML = r.createContextualFragment(htmlStr);
		this.insertAdjacentElement(where,parsedHTML)
	}


	HTMLElement.prototype.insertAdjacentText = function(where,txtStr)
	{
		var parsedText = document.createTextNode(txtStr)
		this.insertAdjacentElement(where,parsedText)
	}
}

function InitHeader() {
  switch(map.cl_type) {
    case "print":
    case "legend":
      Init();
      window.panel.state="none";
    break;
    default:
      if(document.getElementById('search_box')) $h_minus = 116;
      else $h_minus = 0;
      if(document.getElementById('info_box')) document.getElementById('info_box').style.height = map.window.height+25-$h_minus;
      if(document.getElementById('legend_box')) document.getElementById('legend_box').style.height = map.window.height+25-$h_minus;

      Init();
      InitTabs();
      BlinkArrow();
  }
  ChangeCursor();
	document.onkeydown = ClientKeyDown;
  window.page_loaded = true;
//jednorazove info
  ChangeMapVarsObj('X', '');
  ChangeMapVarsObj('Y', '');
}

function PrintMap() {
  ChangeMapVarsObj ('cl', 'print');
  ChangeMapVarsObj ('map_cl_type', map.cl_type);
  ChangeMapVarsObj ('cl_lang', map.lang);
  ChangeMapVarsObj ('cl_print_map_scale', map.scale);
  win = window.open('', 'tms_print', 'height=500,width=700,status=yes,toolbar=yes,resizable=yes,menubar=yes,scrollbars=yes,location=no');
  win.focus();
  Refresh(false, 'tms_print');
  ChangeMapVarsObj ('cl', '');
  ChangeMapVarsObj ('map_cl_type', '');
  ChangeMapVarsObj ('cl_lang', '');
  ChangeMapVarsObj ('cl_print_map_scale', '');
}
function MapLegend(target) {
  if(target=="newwindow") { //open legend in new window
    ChangeMapVarsObj ('cl', 'legend');
    ChangeMapVarsObj ('map_cl_type', map.cl_type);
    ChangeMapVarsObj ('cl_lang', map.lang);
    win = window.open('', 'tms_legend', 'height=350,width=300,status=no,toolbar=no,resizable=yes,menubar=no,scrollbars=yes,location=no');
    win.focus();
    Refresh(false, 'tms_legend');
    ChangeMapVarsObj ('cl', '');
    ChangeMapVarsObj ('map_cl_type', '');
    ChangeMapVarsObj ('cl_lang', '');
  } else { //open legend in client DIV
    legend = window.document.getElementById('legend_box');
    info = window.document.getElementById('info_box');
    if(legend && info) {
      if (legend.style.visibility == 'hidden') {
        legend.style.visibility = 'visible';
        info.style.visibility = 'hidden';
      } else {
        legend.style.visibility = 'hidden';
        info.style.visibility = 'visible';
      }
    }
  }
}

function Search() {
  var db=map.window.db;
  var script='db.php?client_lang='+map.lang+'&client_type='+map.cl_type+'&fce_type=search';
  map_db=window.open(script, 'map_db','toolbar,width=700,height=350,left=0,top=0,resizable');
//  map_db=window.open(script, 'map_db','toolbar,width='+db.width+',height='+db.height+',left='+db.left+',top='+db.top+',resizable');
  map_db.focus();
}


function SubmitFindObject(type, code) {
  ChangeMapVarsObj ('sparpg', 0);
  ChangeMapVarsObj ('sadrpg', 0);
  ChangeMapVarsObj ('stype', type);
  ChangeMapVarsObjR('scode', code);
  return false;
}

function ChangeMapClientSize(width, height, type) {
  map.window.width = width;
  map.window.height = height;
  ChangeMapVarsObj ('map_size', type);
  Refresh(false, false);
}
function ChangeMode(mode) {
  old_mode = window.panel.state;
  window.panel.state=mode;
  ChangeCursor();
  ChangeMapVarsObj ('panel_state', mode);
  if(window.document[old_mode]) window.document[old_mode].src = ImgOff(old_mode);
  if(window.document[mode]) window.document[mode].src = ImgOn(mode);
}
function GetUrl(l) {
	var a=l.pathname.split('/');
	a.length--;
	return l.protocol+'//'+l.host+a.join('/');
}

function Help(file) {
  var db=map.window.db;
  var script=GetUrl(location)+'/../help/'+file;
  map_db=window.open(script, 'help','');
  map_db.focus();
}
function GetClientVariables(excluded) {
  excluded = excluded.split(",");
  var variables = "";
  if(mobjprop && mobj) {
    for(var i=0;i<mobjprop.length;i++) {
      var set=true;
      for(var j=0;j<excluded.length;j++) if(excluded[j] == mobjprop[i]) set=false;
      if(set) variables += "&m_"+mobjprop[i]+"="+mobj[mobjprop[i]];
    }
  }
  return variables;
}
function SearchBox(type) {
  var db=map.window.db;
  if(window.array_search_box) {
    var field = window.array_search_box['field_'+type];
    var value = escape(window.document.getElementById(field).value).replace(/\+/g,'%2B').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
    var script = window.array_search_box['href_'+type]+"&"+window.array_search_box['field_'+type+'_name']+"="+value+"&client_lang="+window.map.lang+"&client_type="+window.map.cl_type;
  } else {
    var value = window.document.getElementById("search_box_value").value;
  	h=window.document.getElementById("search_box_type");
    var path = escape(h.options[h.selectedIndex].value).replace(/\+/g,'%2B').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
    var search_box_type = escape(h.selectedIndex).replace(/\+/g,'%2B').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
    var search_box_value = value;
    var script = path+value+"&strange_opener=1&client_type="+window.map.cl_type+"&subproject="+subproject+"&map_size="+mobj.map_size+"&search_box_type="+search_box_type+"&search_box_value="+search_box_value;
  }
  map_db=window.open(script, 'map_db','toolbar,scrollbars,width=700,height=350,left=0,top=0,resizable');
  map_db.focus();
}
function ClientKeyDown(e) {
	if (env.isN) {
    if (window.event == null) window.event = new Object();
    window.event.keyCode = e.which;
  }
}
function InitWaitLayer() {
  SetPageLayerVisible(window, "MapWait", false);
}
