// Copyright 2000 T-Mapy spol. s r. o. All rights reserved.
//$Id: PanFunc.js,v 1.3 2006/10/02 06:58:32 lube Exp $ $Name:  $

function PanCenterXY(x,y) {
	var c=map.cur;
	dx=(c.maxx-c.minx)/2;
	dy=(c.maxy-c.miny)/2;
	c.minx=x-dx;
	c.maxx=x+dx;
	c.miny=y-dy;
	c.maxy=y+dy;
	Refresh();
}

function PanCenter() {
	var x=Math.round(TransformX(map.point.left));
	var y=Math.round(TransformY(map.point.top));
	PanCenterXY(x,y);
}

function PanH(l) {
	var c=map.cur;
	var w=map.pansize*(c.maxx-c.minx);
	if (l) w=-w;
	c.minx=c.minx+w;
	c.maxx=c.maxx+w;
	Refresh();
}

function PanV(d) {
	var c=map.cur;
	var h=map.pansize*(c.maxy-c.miny);
	if (d) h=-h;
	c.miny=c.miny-h;
	c.maxy=c.maxy-h;
	Refresh();
}

function PanLeft() {PanH(true);}
function PanRight() {PanH(false);}
function PanDown() {PanV(false);}
function PanUp() {PanV(true);}
function PanLeftUp() {PanH(true);PanV(true);}
function PanRightUp() {PanH(false);PanV(true);}
function PanLeftDown() {PanH(true);PanV(false);}
function PanRightDown() {PanH(false);PanV(false);}

function PanPoint() {
	var c=map.cur;var p=map.point;
	var x1=Round(TransformX(p.left));
	var y2=Round(TransformY(p.top));
	var x2=Round(TransformX(p.right));
	var y1=Round(TransformY(p.bottom));
	c.minx=c.minx-(x2-x1);
	c.maxx=c.maxx-(x2-x1);
	c.miny=c.miny+(y2-y1);
	c.maxy=c.maxy+(y2-y1);
	Refresh();
}