// Copyright 2000 T-Mapy spol. s r. o. All rights reserved.
//$Id: PageLayerFunc.js,v 1.6 2005/12/06 16:28:12 tokr Exp $ $Name:  $

function GetPageLayerObject(w,name) {
	if (env.isN) {
		if (env.version == 4) {
			if (w.document.layers[name]) return(w.document.layers[name]);
			else {
				if (w.document.layers["MapLayers"].layers[name]) return(w.document.layers["MapLayers"].layers[name]);
				else return(null);
			}
		}
		else if (env.version >= 5) {
        el = w.document.getElementById(name);
				if (el) return(el);
				else return(null);
		} 
		else return(null);
	}
	else if (env.isIE || env.isOP) {
		if (w.document[name]) return(w.document[name]);
		else {
			if (w.document.all[name]) return(w.document.all[name]);
			else return(null);
		}
	}
	else return(null);
}

function GetPageLayer(w,name) {
	if (env.isN) {
		if (env.version == 4) {
			if (w.document.layers[name]) return(w.document.layers[name]);
			else {
				if (w.document.layers["MapLayers"].layers[name]) return(w.document.layers["MapLayers"].layers[name]);
				else return(null);
			}
		}
		else if (env.version == 5) {
				if (w.document.getElementById(name)) return(w.document.getElementById(name).style);
				else return(null);
		} 
		else return(null);
	}
	else if (env.isIE || env.isOP) {
		if (w.document[name]) return(w.document[name].style);
		else {
			if (w.document.all[name]) return(w.document.all[name].style);
			else return(null);
		}
	}
	else return(null);
}

function SetPageLayerVisible(win, name, visible) {
	var layer = GetPageLayer(win, name); 
	if (layer != null) {
		if (visible) {
			if (env.isN && (env.version == 4)) layer.visibility = "show";
			else layer.visibility = "visible";
		}
		else {
			if (env.isN && (env.version == 4)) layer.visibility = "hide";
			else layer.visibility = "hidden";
		}
	}
}

function ChangePageLayerVisible(win,name) {
	var layer = GetPageLayer(win, name); 
	if (layer != null) {
		if (layer.visibility == "hide" || layer.visibility == "hidden") {
			if (env.isN && (env.version == 4)) layer.visibility = "show";
			else layer.visibility = "visible";
		}
		else {
			if (env.isN && (env.version == 4)) layer.visibility = "hide";
			else layer.visibility = "hidden";
		}
	}
}
		
function SetPageLayerClip(win, name, left, top, right, bottom) {
	var layer = GetPageLayer(win, name);
	if (layer != null) {
		if (env.isN && (env.version == 4)) {
			layer.clip.left=left;
			layer.clip.top=top;
			layer.clip.right=right;
			layer.clip.bottom=bottom;
		}
		else layer.clip = 'rect('+top+' '+right+' '+bottom+' '+left+')';
	}
}

function SetRectVisible(w, n, vis) {
//alert(w.name+','+vis);
	SetPageLayerVisible(w,n+"RectTop",vis);
	SetPageLayerVisible(w,n+"RectLeft",vis);
	SetPageLayerVisible(w,n+"RectRight",vis);
	SetPageLayerVisible(w,n+"RectBottom",vis);
}


function MoveRect(w,n,r) {
	if (r.x1>r.x2) {r.right=r.x1; r.left=r.x2;} 
	else {r.left=r.x1; r.right=r.x2;}
	if (r.y1>r.y2) {r.bottom=r.y1; r.top=r.y2;} 
	else {r.top=r.y1; r.bottom=r.y2;}
	if ((r.x1!=r.x2) &&(r.y1!=r.y2)) ClipRect(w,n,r);
}

function ClipRect(w,n,r) {
//alert(r.left+","+r.top+","+r.right+","+(r.top+r.size));
	SetPageLayerClip(w,n+"RectTop",r.left,r.top,r.right,r.top+r.size);
	SetPageLayerClip(w,n+"RectLeft",r.left,r.top,r.left+r.size,r.bottom);
	SetPageLayerClip(w,n+"RectRight",r.right-r.size,r.top,r.right,r.bottom);
	SetPageLayerClip(w,n+"RectBottom",r.left,r.bottom-r.size,r.right,r.bottom);
}


function StartRect(w,n,r,e) {
	if (r.active) EndRect(w,n,r,e);
	else {
		r.x1=map.mouseX;
		r.y1=map.mouseY;
		r.left=map.mouseX;
		r.top=map.mouseY;
		r.right=r.left+1;
		r.bottom=r.top+1;
		ClipRect(w,n,r);
		r.active=true;
		SetRectVisible(w,n,true)
	}
	return false;
}

function StartRectOV(w,n,r,e) {
	if (r.active) EndRect(w,n,r,e);
	else {
		r.x1=map.ov.mouseX; //-map.ov.left
		r.y1=map.ov.mouseY; //-map.ov.top
		r.left=map.ov.mouseX;  //-map.ov.left
		r.top=map.ov.mouseY;  //-map.ov.top

		r.right=r.left+1;
		r.bottom=r.top+1;
		ClipRect(w,n,r);
		r.active=true;
		SetRectVisible(w,n,true)
	}
	return false;
}

function EndRect(w,n,r,e) {
	r.active=false;
	SetRectVisible(w,n,false)
	return true;
}

function StartPoint(p, e) {
	if (p.active) EndPoint(p);
	else {
		p.left=map.mouseX;
		p.top=map.mouseY;
		p.right=p.left+1;
		p.bottom=p.top+1;
		p.active=true;
	}
}

function EndPoint(p) {p.active=false;}
