// Copyright 2000 T-Mapy spol. s r. o. All rights reserved.
//$Id: MouseEventFunc.js,v 1.15 2008/02/05 08:01:42 tono Exp $ $Name:  $
var ExternalEvents = {};

function Cancel(e) {
	GetWindowEvent(e);
  map.last_click_x = null; map.last_click_y = null;
  ChangeCursor(false);
	return(window.event.keyCode==27);
}

/* Detection of the mouse button
    		  L M R
IE,KON		1 4 2  event.button
NS,OP8,FF	0 1 2  e.button
OP7 		  1 3 2  e.button
NS,OP8,FF	1 2 3  e.which
*/
function Button(e,w) {
	if (env.isN || env.isOP) {
    switch (e.button) {
      case 0: b=1; break;
      case 1: b=4; break;
      case 2: b=2; break;
    }
  } else {
	  var b=w.event.button;
  }
  return(b);
}

function GetElementPosition(el) {
	var x=0; var y=0;
	obj = el;
	while (obj.tagName != 'BODY') {
		x += obj.offsetLeft;
		y += obj.offsetTop;
		obj = obj.offsetParent;
	}
	if (env.isIE) {
		x += obj.clientLeft;
		y += obj.clientTop;
	}
  x -= obj.scrollLeft;
	y -= obj.scrollTop;

	ar = new Array(x,y);
	return ar;
}

function GetWindowEvent(e) {
	if (env.isN) {
		if (window.event == null) window.event = new Object();
		window.event.button = e.which;
		window.event.keyCode = e.which;
		window.event.clientX = e.clientX;
		window.event.clientY = e.clientY;
		window.event.srcElement = e.target;
  	if (!env.isIE) window.event.wheelDelta=-1*e.detail;
		else window.event.wheelDelta = e.wheelDelta;
	}
}

function GetMapMouse(e) {
	GetWindowEvent(e);
	pos = GetElementPosition(map.layer);
	map.mouseX = window.event.clientX-pos[0];
	map.mouseY = window.event.clientY-pos[1];
  map.wheelDelta = window.event.wheelDelta;
}

function GetCtrlKey(e,w) {
	if (env.isIE) {
		var e=w.event;
    return e.ctrlKey;
  } else {
    return e.ctrlKey;
	}
}

function CtrlKey(mode) {
  if(mode) {
    if(window.panel.default_ctrl) {
      window.panel.old_state = window.panel.state;
      window.panel.state=window.panel.default_ctrl;
    }
  } else {
    if(window.panel.old_state) window.panel.state=window.panel.old_state;
  }
  ChangeCursor(false);
}

function RegisterExternalEvent(type,func) {
  if (ExternalEvents[type]) {
    ExternalEvents[type] = ExternalEvents[type].concat(func);
  } else {
    ExternalEvents[type] = new Array(func);
  }
}

function MapMouseDown(e) {
  //CTRL KEY ZMENA STATE PODPORA - leftButton
  if (env.isN) {if(e.ctrlKey) CtrlKey(true);}
  else {if(event.ctrlKey) CtrlKey(true);}

  GetMapMouse(e);
  ChangeCursor(false);

  if (ExternalEvents['mapmousedown']) {
    for (key in ExternalEvents['mapmousedown']) {
      if (!ExternalEvents['mapmousedown'][key](e)) return false;
    }
  }
  var mx=map.mouseX; var my=map.mouseY; var w=map.window;
  panel.panning=false;
  panel.zoomingIn=false;
  panel.zoomingOut=false;

//  if(Button(e,window)==env.rightButton) alert('right');
//  if(Button(e,window)==env.middleButton) alert('middle');

  if (Button(e,window)==env.middleButton && window.panel.support_middleButton) {
		if ((mx<=w.width) && (my<=w.height) && (mx>=w.left) && (my>=w.top)) {
      if (!env.isIE) e.stopPropagation();
      else event.cancelBubble=true;
		  if (GetCtrlKey(e,window)) {
		    StartRect(window, "Map", map.rect, e);
   			panel.zoomingIn=true;
		  } else {
		    StartPoint(map.point, e);
		    panel.panning=true;
      }
    }
  }
  else if (Button(e,window)==env.rightButton && window.panel.support_rightButton) {
    if (!env.isIE) e.stopPropagation();
    else event.cancelBubble=true;
    StartRect(window, "Map", map.rect, e);
   	panel.zoomingOut=true;
    document.oncontextmenu=new Function("return false");
  }
  else if(Button(e,window)==env.leftButton) {
		switch(panel.state) {
			case "zoomIn":
			case "zoomOut":
			case "zoomInIndex":
      case "selection":
				StartRect(window, "Map", map.rect, e);
			break;
			case "pan":
			case "info":
			case "info_once":
			case "hotlink":
			case "edit":
			case "xycreator":
			case "gd_xy":
  		case "hotlink1":
  		case "hotlink2":
  		case "hotlink3":
  		case "hotlink4":
  		case "hotlink5":
      case "neighbours":
      case "xy2agend":
				StartPoint(map.point, e);
			break;
		}
		return false;
	}
	return true;
}

function MapMouseUp(e) {
  ChangeCursor(true);
	var r=map.rect;
	var p=map.point;

  if (ExternalEvents['mapmouseup']) {
    for (key in ExternalEvents['mapmouseup']) {
      if (!ExternalEvents['mapmouseup'][key](e)) return false;
    }
  }

	if (r.active) {
		GetMapMouse(e);
		r.x2=map.mouseX;
		r.y2=map.mouseY;
		MoveRect(window, "Map", r);
		EndRect(window, "Map", r, e);
		if ((r.right < r.left+7) && (r.bottom < r.top+7)) {
      map.last_click_x = TransformX(map.mouseX);
      map.last_click_y = TransformY(map.mouseY);
      map.last_click_imgx = map.mouseX;
      map.last_click_imgy = map.mouseY;      
			if (map.onClick!="pan" && !panel.zoomingIn) {

        switch(map.onClick) {
          case "hotlink1":
          case "hotlink2":
          case "hotlink3":
          case "hotlink4":
          case "hotlink5":
            var state_old = window.panel.state;
            window.panel.state = map.onClick;
            HotlinkOnce(map.mouseX, map.mouseY);
            window.panel.state = state_old;
          break;
        }

        if (panel.zoomingOut) ZoomOutCenter();
				if (panel.state=="zoomIn") ZoomInCenter();
				if (panel.state=="zoomOut") ZoomOutCenter();
				if (panel.state=="zoomInIndex") ZoomInIndexCenter();
			}
			else if ((panel.state=="zoomIn")||(panel.state=="zoomOut")||(panel.state=="zoomInIndex")||panel.zoomingIn||panel.zoomingOut) {
				p.left=r.left;p.top=r.top;
				if (edit.state==2) {EditCenter(p.left,p.top);edit.state=0;}
				else PanCenter();
			}
		}
		else {
      if (panel.zoomingOut) ZoomOutRect();
			if (panel.state=="zoomIn") ZoomInRect();
			if (panel.state=="zoomOut") ZoomOutRect();
      if (panel.state=="selection") Selection(GetCtrlKey(e,window));
			if (panel.state=="zoomInIndex") ZoomInIndexRect();
		}
	}
	if (p.active) {
		GetMapMouse(e);
		p.right=map.mouseX;
		p.bottom=map.mouseY;
		EndPoint(p);

		if ((map.mouseX < p.left+1) && (map.mouseY < p.top+1) && (map.mouseX > p.left-1) && (map.mouseY > p.top-1) && ((panel.state == "pan") ||  panel.panning)) {
      map.last_click_x = TransformX(map.mouseX);
      map.last_click_y = TransformY(map.mouseY);

			PanCenter();
		}
		else if ((map.mouseX < p.left+4) && (map.mouseY < p.top+4) && (map.mouseX > p.left-4) && (map.mouseY > p.top-4)) {
      map.last_click_x = TransformX(map.mouseX);
      map.last_click_y = TransformY(map.mouseY);
      map.last_click_imgx = map.mouseX;
      map.last_click_imgy = map.mouseY;

			if (panel.state == "pan" || panel.panning) PanCenter();
			if (panel.state == "info") InfoCenter(p.left, p.top);
			if (panel.state == "hotlink1") HotlinkOnce(p.left, p.top);
			if (panel.state == "hotlink2") HotlinkOnce(p.left, p.top);
			if (panel.state == "hotlink3") HotlinkOnce(p.left, p.top);
			if (panel.state == "hotlink4") HotlinkOnce(p.left, p.top);
			if (panel.state == "hotlink5") HotlinkOnce(p.left, p.top);
			if (panel.state == "info_once") InfoCenter(p.left, p.top,1);
			if (panel.state == "hotlink") HotlinkCenter(p.left, p.top);
			if (panel.state == "edit") EditCenter(p.left, p.top);
			if (panel.state == "xycreator") CreateXYLink(p.left, p.top);
			if (panel.state == "gd_xy") gd_xy(p.left, p.top);
      if (panel.state == "neighbours") Neighbours(p.left, p.top);
			if (panel.state == "xy2agend") SendXY2Agend(p.left, p.top);
		}
		else {
			if (panel.state == "pan" || panel.panning) PanPoint();
		}
    //CTRL KEY ZMENA STATE PODPORA - leftButton
    CtrlKey(false);
		return false;
	}
  //CTRL KEY ZMENA STATE PODPORA - leftButton
  CtrlKey(false);

	panel.zoomingIn = false;
	panel.zoomingOut = false;
	panel.panning = false;
	return true;
}

function MapMouseMove(e) {
	GetMapMouse(e);

  if (ExternalEvents['mapmousemove']) {
    for (key in ExternalEvents['mapmousemove']) {
      if (!ExternalEvents['mapmousemove'][key](e)) return false;
    }
  }

	var mx=map.mouseX; var my=map.mouseY;
	var p=map.point; var r=map.rect;
	if (r.active) {
		r.x2=mx;
		r.y2=my;
		MoveRect(window, "Map", r);
	}
	if (p.active) {
		p.right=mx;
		p.bottom=my;
		if (panel.state=="pan" || panel.panning) {
//      alert(map.name);
      var m_l = window.document.getElementById("MapLayers");
      if(m_l) {
  			m_l.style.left = p.right - p.left;
  			m_l.style.top = p.bottom - p.top;
      }
		}
	}
	if (map.status) {
		MouseXY(mx,my);
	}
	return !env.isIE;
}

function MapMouseWheel(e) {
  if (!env.isIE) e.stopPropagation();
  else event.cancelBubble=true;

  GetMapMouse(e);

  if (ExternalEvents['mapmousewheel']) {
    for (key in ExternalEvents['mapmousewheel']) {
      if (!ExternalEvents['mapmousewheel'][key](e)) return false;
    }
  }

  var c=map.cur;
  var x=Round(c.minx+(c.maxx-c.minx)/2);
  var y=Round(c.miny+(c.maxy-c.miny)/2);
  if (map.wheelDelta > 0)
    ZoomInCenterXY(x,y);
  else
    ZoomOutCenterXY(x,y);
  return false;
}

function MapOVKeyPress(e) {
  if (ExternalEvents['mapkeypress']) {
    for (key in ExternalEvents['mapkeypress']) {
      if (!ExternalEvents['mapkeypress'][key](e)) return false;
    }
  }
	if (Cancel(e)) {
		if (map.point.active) {
      var m_l = window.document.getElementById("MapLayers");
      if(m_l) {
  			m_l.style.left = 0;
  			m_l.style.top = 0;
      }
			EndPoint(map.point);
		}
		if (map.rect.active) {
			EndRect(window, "Map", map.rect, e);
		}
		if (map.ov.rect.active) {
			EndRect(window, "OV", map.ov.rect, e);
			RefreshOV();
		}
	}
}

function GetOVMouse(e) {
	GetWindowEvent(e);
	pos = GetElementPosition(map.ov.layer);
	map.ov.mouseX = window.event.clientX-pos[0];
	map.ov.mouseY = window.event.clientY-pos[1];
}

function OVMouseMove(e) {
	GetOVMouse(e);

  if (ExternalEvents['ovmouseup']) {
    for (key in ExternalEvents['ovmouseup']) {
      if (!ExternalEvents['ovmouseup'][key](e)) return false;
    }
  }

  var mx=map.ov.mouseX; var my=map.ov.mouseY;
	var o=map.ov; var r=map.ov.rect;
	if (r.active) {
		r.x2=map.ov.mouseX;
		r.y2=map.ov.mouseY;
		MoveRect(window, "OV", r);
	}
	return false;
}

function OVMouseUp(e) {
	GetOVMouse(e);

  if (ExternalEvents['ovmouseup']) {
    for (key in ExternalEvents['ovmouseup']) {
      if (!ExternalEvents['ovmouseup'][key](e)) return false;
    }
  }

  var r=map.ov.rect; var c=map.cur; var w=map.window;
	if (r.active) {
		r.x2=map.ov.mouseX;
		r.y2=map.ov.mouseY;
		MoveRect(window, "OV", r);
		EndRect(window, "OV", r, e);
	 with (Math) {
		if (max(abs(r.right-r.left), abs(r.top - r.bottom)) > 2) {
//changed by jiva
			c.minx = round(TransformOVX(r.left*w.width/map.ov.width)*1000)/1000;
			c.maxx = round(TransformOVX(r.right*w.width/map.ov.width)*1000)/1000;
			c.maxy = round(TransformOVY(r.top*w.height/map.ov.height)*1000)/1000;
			c.miny = round(TransformOVY(r.bottom*w.height/map.ov.height)*1000)/1000;
			ChangeRatio(c);
			Scale();
			if (map.scale < map.minScale) ChangeScale(map.minScale);
			if (map.scale > map.maxScale) ChangeScale(map.maxScale);
			Refresh();
		}
		else {
			var x = round(TransformOVX(r.left*w.width/map.ov.width)*1000)/1000;
			var y = round(TransformOVY(r.top*w.height/map.ov.height)*1000)/1000;
			PanCenterXY(x,y);
		}
	 }
	}
	return false;
}

function OVMouseDown(e) {
	GetOVMouse(e);

  if (ExternalEvents['ovmouseup']) {
    for (key in ExternalEvents['ovmouseup']) {
      if (!ExternalEvents['ovmouseup'][key](e)) return false;
    }
  }

	if (window.event.button==env.leftButton) {
		StartRectOV(window, "OV", map.ov.rect, e);
	}
	return false;
}

function ChangeCursor(def) {
  version=0
  if (navigator.appVersion.indexOf("MSIE")!=-1){
  temp=navigator.appVersion.split("MSIE")
  version=parseFloat(temp[1])
  }
  if(version>5.5  || version==0) {
    var m_l = window.document.getElementById("MapLayers");
    if(m_l) {
      if(def) m_l.style.cursor = "default";
      else m_l.style.cursor = "url('../images/cursor/"+panel.state+".cur'), default";
    }
  }
}
