// Copyright 2000 T-Mapy spol. s r. o. All rights reserved.
//$Id: BaseFunc.js,v 1.11 2006/12/07 08:21:40 lube Exp $ $Name:  $

function GetEnv() {
	env.isN=false;
	env.isIE=false;
	env.Win=false;
	env.version=0;
  if (navigator.appName=="Netscape") {
		env.isN=true;
		if (navigator.appVersion[0]=='4') 
			env.version = 4;
		else
			env.version = 5;
	} else if (window.opera) {
    env.isOP=true;
  }	else env.isIE = true;
	if (navigator.userAgent.indexOf("Win")!=-1) env.Win=true;
}

function ImgOn(n){return img[n+'_on'].src;}
function ImgOff(n){return img[n+'_off'].src;}

function SetImg(n,src1,src2) {
  img[n+'_on']=new Image();
  img[n+'_on'].src=src1;
  img[n+'_off']=new Image();
  img[n+'_off'].src=src2;
}

function LinkIt(script,name) {
  if (name=='') name = 'Link';
  var w = window.open('',name,'');
  w.location.href = script;
  w.focus();
}

function RefreshMap() {Refresh(true);}
function StatusMap() {Status(map.cur.minx,map.cur.miny);}
function MouseXY(x,y) {Status(TransformX(x),TransformY(y))};
//function MouseXY(x,y) {Status(x,y)};
function TransformX(x) {return map.cur.minx+x/map.window.width*(map.cur.maxx-map.cur.minx);}
function TransformY(y) {return map.cur.maxy-y/map.window.height*(map.cur.maxy-map.cur.miny);}
function TransformOVX(x) {return map.minx+x/map.window.width*(map.maxx-map.minx);}
function TransformOVY(y) {return map.maxy-y/map.window.height*(map.maxy-map.miny);}

function Transf_XY() {
	var r=map.rect;
	var c=map.units;
	r.x1=Math.round(TransformX(r.left)*c)/c;
	r.y1=Math.round(TransformY(r.bottom)*c)/c;
	r.x2=Math.round(TransformX(r.right)*c)/c;
	r.y2=Math.round(TransformY(r.top)*c)/c;
}

function Status(x,y) {
	if (map.status) {
		if (map.units==1000) window.status="X: "+ConvertCoord(x)+", Y: "+ConvertCoord(y);
		else window.status=resource.scale+" 1:"+ map.scale +", X: "+Math.round(x)+", Y: "+Math.round(y);
	}
}

function ConvertCoord(x,type) {
	if (x[0]=="-") {x = -1*x; sign = "-";}
	else {sign = "";}
	xd = Math.floor(x);
	x = (x-xd)*60;
	xm = Math.floor(x);
	if (xm < 10) xm = "0" + xm	
	x = (x-xm)*60;
	xs = Math.floor(x);
	if (xs < 10) xs = "0" + xs
	if (type==1) return sign + xd+" "+xm+"'"+xs + '"';
	else return sign + xd+''+xm+"'"+xs + '"';
}


function Scale() {
	map.scale=(map.cur.maxx-map.cur.minx)/map.meterWidth;
	if (map.units==1000) map.scale = map.scale*111300;
	map.scale=Math.round(map.scale);
}

function ChangeState(state,w_name) {
	if (w_name == null) {
		if (panel.state != state) {
			document[panel.state].src=ImgOn(panel.state);
			panel.state=state;
			document[state].src=ImgOff(state);
		}
	}	
	else { 
		if (panel.state != state) {
			if (env.isN && env.version==4) {
				parent[w_name].document[panel.state].document[panel.state].src=ImgOn(panel.state);
				panel.state=state;
				parent[w_name].document[state].document[state].src=ImgOff(state);
				
			}
			else {
				parent[w_name].document[panel.state].src=ImgOn(panel.state);
				panel.state=state;
				parent[w_name].document[state].src=ImgOff(state);
			}
		}
	}
}

function ChangeRatio(e) {
	if (map.window.ratio < ((e.maxy-e.miny)/(e.maxx-e.minx)) ) {
		x =1/map.window.ratio*(e.maxy-e.miny);
		dx=(x-(e.maxx-e.minx))/2;
		e.maxx=e.maxx+dx;
		e.minx=e.minx-dx;
	}
	else {
		y =map.window.ratio*(e.maxx-e.minx);
		dy=(y-(e.maxy-e.miny))/2;
		e.maxy=e.maxy+dy;
		e.miny=e.miny-dy;
	}
}

function InitScale() {
	w=30.3;//cm
	map.meterWidth=map.window.width * (w/window.screen.width) / 100;
}

function Init(ref, i) {
	GetEnv();
	InitScale();
	ChangeRatio(map);
	ChangeRatio(map.cur);
	Scale();
  if (zoom) InitZoomIndex();
	panel_loaded=true;
	if (map.ov.refresh) RefreshOV();
	SetPageLayerVisible(window, "MapWait", false);
  if(!window.panel) {
    window.panel=new Object();
    window.panel.state="zoomIn";
  }  
  map.layer = GetPageLayerObject(window,'MapLayers_Envelope');
  if (!map.layer) map.layer = GetPageLayerObject(window,'MapLayers');
  if (map.layer) {
    map.layer.onmousemove = MapMouseMove;
    map.layer.onmousedown = MapMouseDown;
    map.layer.onmouseup = MapMouseUp;
    map.layer.onkeypress = MapOVKeyPress;
    map.layer.onmousewheel=MapMouseWheel;
    if (window.env.isN) {
      document.onkeydown = MapOVKeyPress;
      map.layer.addEventListener('DOMMouseScroll', MapMouseWheel, false);
    }
  }
  map.ov.layer = GetPageLayerObject(window,'OVLayers_Envelope');
  if (!map.ov.layer) map.ov.layer = GetPageLayerObject(window,'OVLayers');
  if (map.ov.layer) {
    map.ov.layer.onmousemove = OVMouseMove;
    map.ov.layer.onmousedown = OVMouseDown;
    map.ov.layer.onmouseup = OVMouseUp;
    map.ov.layer.onkeypress = MapOVKeyPress;
  }
}
//window.onload = Init;

function RefreshOV() {
	var r=map.ov.rect;
	var c=map.cur;		 
	var o=map.ov;

	map.minx=o.minx;
	map.miny=o.miny;
	map.maxx=o.maxx;
	map.maxy=o.maxy;
	
	var ax=o.width/(map.maxx-map.minx);
	var ay=o.height/(map.maxy-map.miny);
	r.left=Math.round((c.minx-map.minx)*ax);
	r.right=Math.round((c.maxx-map.minx)*ax);
	r.bottom=Math.round(o.height-((c.miny-map.miny)*ay));
	r.top=Math.round(o.height-((c.maxy-map.miny)*ay));
	
	if (r.right-r.left < o.min_size) {
	r.left=r.left-Math.round(o.min_size/2);
	r.right=r.left+o.min_size;
	}
	if (r.bottom-r.top<o.min_size) {
	r.top=r.top-Math.round(o.min_size/2);
	r.bottom=r.top+o.min_size;
	}
	ClipRect(this, "OV", r);
	SetRectVisible(this, "OV", true)
}

function Refresh() {
	var e=map.cur;
	var box=escape(Math.round(e.minx)+","+Math.round(e.miny)+","+Math.round(e.maxx)+","+Math.round(e.maxy)).replace(/\+/g,'%2B').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
	window.location.href=window.location.pathname+"?BBOX="+box;
}

function Round(p) {return Math.round(p*map.units*1000)/(1000*map.units);}
