// Copyright 2000 T-Mapy spol. s r. o. All rights reserved.
//$Id: MouseEvent.js,v 1.13 2007/03/30 09:14:03 tokr Exp $ $Name:  $

var ExternalEvents = {};

function GetMouse(e,w) {
	if (!env.isIE) {
		map.mouseX=e.pageX;
		map.mouseY=e.pageY;
		map.wheelDelta=-1*e.detail;
	} else {
		var e=w.event;
		map.mouseX=e.clientX;
		map.mouseY=e.clientY;
		map.wheelDelta=e.wheelDelta;
    e.target=e.srcElement;
	}
}	

function GetCtrlKey(e,w) {
	if (env.isIE) {
		var e=w.event;
    return e.ctrlKey;
  } else {
    return e.ctrlKey;
	}
}	

function GetShiftKey(e,w) {
	if (env.isIE) {
		var e=w.event;
    return e.shiftKey;
  } else {
    return e.shiftKey;
	}
}	

function GetMouseXY(e) {GetMouse(e,f_map);}
function GetOVMouseXY(e) {GetMouse(e,f_ov);}

function RegisterExternalEvent(type,func) {
  if (ExternalEvents[type]) {
    ExternalEvents[type] = ExternalEvents[type].concat(func);
  } else {
    ExternalEvents[type] = new Array(func);
  }
}


function MapMouseMove(e) {
  if (!GetMouseXY) return false;
  GetMouseXY(e);

  if (ExternalEvents['mapmousemove']) {
    for (key in ExternalEvents['mapmousemove']) {
      if (!ExternalEvents['mapmousemove'][key](e)) return false;
    } 
  }

	var mx=map.mouseX; var my=map.mouseY;
	var w=map.window; var p=map.point; var r=map.rect;
  
	if ((mx<=w.width) && (my<=w.height) && (mx>=w.left) && (my>=w.top)) {
		if (r.active) {
			r.x2=map.mouseX;
			r.y2=map.mouseY;
			MoveRect(f_map, "Map", r);
		}
		if (p.active) {
			p.right=mx;
			p.bottom=my;
			if (panel.state=="pan" || panel.panning) {
				var layer = GetPageLayer(f_map, "MapLayers");
				layer.left = p.right - p.left;
				layer.top = p.bottom - p.top;
 			}
		}
		if (map.status) {
			MouseXY(mx,my);
		}
	}
	return false;
}

function OVMouseMove(e) { 
	GetOVMouseXY(e);

  if (ExternalEvents['ovmousemove']) {
    for (key in ExternalEvents['ovmousemove']) {
      if (!ExternalEvents['ovmousemove'][key](e)) return false;
    } 
  }

	var o=map.ov;
	if ((map.mouseX<=o.width)&&(map.mouseY<=o.height)&&(map.mouseX>=o.left)&&(map.mouseY>=o.top)) {
		if (o.rect.active) {
			o.rect.x2=map.mouseX;
			o.rect.y2=map.mouseY;
			MoveRect(f_ov, "Map", o.rect);
		}
	}
	return false;
}

function Button(e,w) {
	if (env.isN || env.isOP) {
    switch (e.button) {
      case 0: b=1; break;
      case 1: b=4; break;
      case 2: b=2; break;
    }
  } else {
	  var b=w.event.button;
  }
  return(b);
}

function MapMouseDown(e) {
  GetMouseXY(e);
  
  if (ExternalEvents['mapmousedown']) {
    for (key in ExternalEvents['mapmousedown']) {
      if (!ExternalEvents['mapmousedown'][key](e)) return false;
    } 
  }
  
  var mx=map.mouseX; var my=map.mouseY; var w=map.window;
  panel.panning=false;
  panel.zooming=false;
  if (!env.isOP && Button(e,f_map)==env.middleButton) {
		if ((mx<=w.width) && (my<=w.height) && (mx>=w.left) && (my>=w.top)) {
      if (!env.isIE) e.stopPropagation();
		  if (GetCtrlKey(e,f_map)) {
		    StartRect(f_map, "Map", map.rect, e);
			panel.zooming=true;
		  } else {
		    StartPoint(map.point, e);
		    panel.panning=true;
      }
    }
  } else if (Button(e,f_map)==env.leftButton) {
		if ((mx<=w.width) && (my<=w.height) && (mx>=w.left) && (my>=w.top)) {
			switch(panel.state) {
				case "zoomIn":
				case "zoomOut":
        case "selection":
        case "selection_maponly":
					StartRect(f_map, "Map", map.rect, e);
				break;
				case "pan":
				case "info":
				case "edit":
				case "xycreator":
        case "xy2agend":
        case "data2agend":
        case "neighbours":
        case "neighbours_maponly":
  				StartPoint(map.point, e);
				break;
				case "hotlink":
				case "hotlink1":
				case "hotlink2":
				case "hotlink3":
				case "hotlink4":
				case "hotlink5":
          if (link.select_type==2) {StartRect(f_map, "Map", map.rect, e);}
          else {StartPoint(map.point, e);}
				break;
				default:
				  
				break;
			}
		}
	}
	return false;
}

function OVMouseDown(e) {
  GetOVMouseXY(e);
  
  if (ExternalEvents['ovmousedown']) {
    for (key in ExternalEvents['ovmousedown']) {
      if (!ExternalEvents['ovmousedown'][key](e)) return false;
    } 
  }

	if (Button(e,f_ov)==env.leftButton) {
		var o=map.ov;
		if ((map.mouseX<=o.width)&&(map.mouseY<=o.height)&&(map.mouseX>=o.left)&&(map.mouseY>=o.top)) {
			StartRect(f_ov, "Map", o.rect, e);
		}
	}
	return false;
}

function MapMouseUp(e) {
	var r=map.rect;
	var p=map.point;
	if (r.active) {
		GetMouseXY(e);
		r.x2=map.mouseX;
		r.y2=map.mouseY;
	}

  if (ExternalEvents['mapmouseup']) {
    for (key in ExternalEvents['mapmouseup']) {
      if (!ExternalEvents['mapmouseup'][key](e)) return false;
    } 
  }
 
	if (r.active) {
		MoveRect(f_map, "Map", r);
		EndRect(f_map, "Map", r, e);
		if ((r.right < r.left+7) && (r.bottom < r.top+7)) {
			if (map.onClick!="pan" && !panel.zooming) {
				if (panel.state=="zoomIn") ZoomInCenter();
				if (panel.state=="zoomOut") ZoomOutCenter();
  			if (panel.state=="hotlink") HotlinkCenter(r.left, r.top);
  			if (panel.state=="hotlink1") HotlinkOnce(r.left, r.top, 'center');
  			if (panel.state=="hotlink2") HotlinkOnce(r.left, r.top, 'center');
  			if (panel.state=="hotlink3") HotlinkOnce(r.left, r.top, 'center');
  			if (panel.state=="hotlink4") HotlinkOnce(r.left, r.top, 'center');
  			if (panel.state=="hotlink5") HotlinkOnce(r.left, r.top, 'center');
			}
			else if ((panel.state=="zoomIn")||(panel.state=="zoomOut")||panel.zooming) {
				p.left=r.left;p.top=r.top;
				if (window.EditCenter && edit.state==2) {EditCenter(p.left,p.top);edit.state=0;}
				else PanCenter();
			}
		} 
		else {
			if (panel.state=="zoomIn" || panel.zooming) ZoomInRect();
			if (panel.state=="zoomOut") ZoomOutRect();
  		if (panel.state=="selection") Selection(GetCtrlKey(e,f_map));
  		if (panel.state=="selection_maponly") SelectionMapOnly(GetCtrlKey(e,f_map));
			if (panel.state=="hotlink") HotlinkRect();
			if (panel.state=="hotlink1") HotlinkOnce('', '', 'rect');
			if (panel.state=="hotlink2") HotlinkOnce('', '', 'rect');
			if (panel.state=="hotlink3") HotlinkOnce('', '', 'rect');
			if (panel.state=="hotlink4") HotlinkOnce('', '', 'rect');
			if (panel.state=="hotlink5") HotlinkOnce('', '', 'rect');
		}
	}
	if (p.active) {
		GetMouseXY(e);
		p.right=map.mouseX;
		p.bottom=map.mouseY;
		EndPoint(p);
		if ((map.mouseX < p.left+1) && (map.mouseY < p.top+1) && (map.mouseX > p.left-1) && (map.mouseY > p.top-1) && ((panel.state == "pan") ||  panel.panning)) 
			PanCenter();
		else if ((map.mouseX < p.left+4) && (map.mouseY < p.top+4) && (map.mouseX > p.left-4) && (map.mouseY > p.top-4)) {
			if (panel.state == "pan" || panel.panning) PanPoint();
			if (panel.state == "info") InfoCenter(p.left, p.top);
			if (panel.state == "hotlink") HotlinkCenter(p.left, p.top);
			if (panel.state == "hotlink1") HotlinkOnce(p.left, p.top, 'center');
			if (panel.state == "hotlink2") HotlinkOnce(p.left, p.top, 'center');
			if (panel.state == "hotlink3") HotlinkOnce(p.left, p.top, 'center');
			if (panel.state == "hotlink4") HotlinkOnce(p.left, p.top, 'center');
			if (panel.state == "hotlink5") HotlinkOnce(p.left, p.top, 'center');
			if (panel.state == "edit") EditCenter(p.left, p.top);
			if (panel.state == "xycreator") CreateXYLink(p.left, p.top);
			if (panel.state == "xy2agend") SendXY2Agend(p.left, p.top);
			if (panel.state == "data2agend") SendData2Agend(p.left, p.top);            
  		if (panel.state == "neighbours") Neighbours(p.left, p.top);      
  		if (panel.state == "neighbours_maponly") NeighboursMapOnly(p.left, p.top);
		}
		else {
			if (panel.state == "pan" || panel.panning) PanPoint();
		}
	}
	panel.zooming = false;
	panel.panning = false;
	return false;
}

function MapMouseWheel(e) {
  GetMouseXY(e);
  
  if (ExternalEvents['mapmousewheel']) {
    for (key in ExternalEvents['mapmousewheel']) {
      if (!ExternalEvents['mapmousewheel'][key](e)) return false;
    } 
  }
  
  var c=map.cur;
  var x=Round(c.minx+(c.maxx-c.minx)/2);
  var y=Round(c.miny+(c.maxy-c.miny)/2);
  if (map.wheelDelta > 0)
    ZoomInCenterXY(x,y);
  else 
    ZoomOutCenterXY(x,y);
    
  return false;
}

function OVMouseUp(e) { 
	var r=map.ov.rect; var c=map.cur; var w=map.window;
	if (r.active) {
		GetOVMouseXY(e);
		r.x2=map.mouseX;
		r.y2=map.mouseY;
	}
	
  if (ExternalEvents['ovmouseup']) {
    for (key in ExternalEvents['ovmouseup']) {
      if (!ExternalEvents['ovmouseup'][key](e)) return false;
    } 
  }
	
	if (r.active) {
		MoveRect(f_ov, "Map", r);
		EndRect(f_ov, "Map", r, e);
	 with (Math) {
		if (max(abs(r.right-r.left), abs(r.top - r.bottom)) > 2) {
			c.minx = TransformOVX(r.left);
			c.maxx = TransformOVX(r.right);
			c.maxy = TransformOVY(r.top);
			c.miny = TransformOVY(r.bottom);
			ChangeRatio(c);
			Scale();
			if (map.scale < map.minScale) ChangeScale(map.minScale);
			if (map.scale > map.maxScale) ChangeScale(map.maxScale);
			Refresh();
		}
		else {
			var x = TransformOVX(r.left);
			var y = TransformOVY(r.top);
			PanCenterXY(x,y); 
		}
	 }
	}
	return false;
}

function Cancel(e,w) {
	if (env.isN) {
	  if (env.version == 4) {
      if (e.which==32) return(true);
    } else {
      if (e.keyCode==27) return(true);
    }
  }
	else {if (w.event.keyCode==27) return(true);}
	return(false);
}

function MapKeyPress(e) {
  if (ExternalEvents['mapkeypress']) {
    for (key in ExternalEvents['mapkeypress']) {
      if (!ExternalEvents['mapkeypress'][key](e)) return false;
    } 
  }

	if (Cancel(e,f_map)) {
		if (map.point.active) {
			var layer = GetPageLayer(f_map, "MapLayers");
			layer.left = 0;
			layer.top = 0;
			EndPoint(map.point);
		}
		if (map.rect.active) {
			EndRect(f_map, "Map", map.rect, e);
		}
	}
}

function OVKeyPress(e) {
  if (ExternalEvents['ovkeypress']) {
    for (key in ExternalEvents['ovkeypress']) {
      if (!ExternalEvents['ovkeypress'][key](e)) return false;
    } 
  }

	if (Cancel(e,f_ov)) {
		if (map.ov.rect.active) {
			EndRect(f_ov, "Map", map.ov.rect, e);
			RefreshOV();
		}
	}
}
