// Copyright 2000 T-Mapy spol. s r. o. All rights reserved.
//$Id: MapFunc_simple.js,v 1.8 2007/02/07 08:51:10 tono Exp $ $Name:  $

function GetUrl(l) {
	var a=l.pathname.split('/');
	a.length--;
	return l.protocol+'//'+l.host+a.join('/');
}

function IsInScale(l) {
	if(l.minScale!='') if(!(l.minScale<map.scale)) return false;
	if(l.maxScale!='') if(!(l.maxScale>map.scale)) return false;
	return true;
}

function LayerRequest(ov,req,lays,name) {
	req.lay=req.lay+name+'(';
	req.sty=req.sty+'(';
	var first=true;
	for(var i in lays) {
		l=lays[i];
		if ((ov && l.ov) || (!ov &&l.visible&& IsInScale(l))) {
			if (first) first=false;
			else {req.lay=req.lay+','; req.sty=req.sty+',';}
			req.lay=req.lay+l.name;
			req.sty=req.sty+l.style;
			if(l.condition) {
				if(req.cond!='') req.cond=req.cond+',';
				else req.cond='CONDITIONS=';
				//req.cond=req.cond+name+'.'+l.name+'('+l.condition+')';
				req.cond=req.cond+(escape(name+'.'+l.name+'('+l.condition+')').replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F'));
			}
			if(l.select) {
				if(req.sel!='')req.sel=req.sel+',';
				else req.sel='SELECT=';
				//req.sel=req.sel+name+'.'+l.name+'('+l.select+')';
				req.sel=req.sel+(escape(name+'.'+l.name+'('+l.select+')').replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F'));
			}
		}
	}
	req.lay=req.lay+'),';
	req.sty=req.sty+'),';
	for(var i in lays) {
		l=lays[i];
		if ((ov && l.ov) || (!ov &&l.visible&& IsInScale(l))) {
			if (l.layers) LayerRequest(ov,req,l.layers,name+'.'+l.name);
		}
	}
}

function GetFromLayers(ov) {
	var req=new Object();
  /*
	req.lay='LAYERS=';
	req.sty='STYLES=';
	req.cond='';
	req.sel='';
	LayerRequest(ov,req,layer,map.name);
	return(req.lay.substring(0,req.lay.length-1)+'&'+req.sty.substring(0,req.sty.length-1)+(req.cond!=''?'&'+req.cond:'')+(req.sel!=''?'&'+req.sel:''));
  */
  //tono - URL RFC 1738
	req.lay='';
	req.sty='';
	req.cond='';
	req.sel='';
	LayerRequest(ov,req,layer,map.name);
	var layers_val_encoded = escape(req.lay.substring(0,req.lay.length-1)).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
  var styles_val_encoded = escape(req.sty.substring(0,req.sty.length-1)).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F'); 
  req.lay='LAYERS='+req.lay;
  req.sty='STYLES='+req.sty;
	var layers_encoded='LAYERS='+layers_val_encoded;
	var styles_encoded='STYLES='+styles_val_encoded;
	return(layers_encoded+'&'+styles_encoded+(req.cond!=''?'&'+req.cond:'')+(req.sel!=''?'&'+req.sel:''));  
}
/*
function Refresh(reload) {
	if (Refresh.arguments.length==0) reload=false;
	StatusMap();
	var e=map.cur;
	var w=map.window;
	var box='BBOX='+Math.round(e.minx*1000)/1000+','+Math.round(e.miny*1000)/1000+','+Math.round(e.maxx*1000)/1000+','+Math.round(e.maxy*1000)/1000;
	var m_scale='';
	if (w.mapscale) m_scale='MAPSCALE=1';
	var request='MAP='+map.name+'&'+box+'&HEIGHT='+w.height+'&WIDTH='+w.width+'&SCALE='+map.scale+'&'+ GetFromLayers(false) +'&'+ m_scale+'&VERSION='+map.version+'&FORMAT=HTML'+'&BGCOLOR='+map.window.bgColor+'&client_lang='+map.lang+'&client_type='+map.cl_type;
	if (reload) request=request+'&cacheID=' +(new Date).getTime():'');
	if (map.charset) request=request+'&charset='+map.charset;
  //alert(request);
	if (map.replace) {
		map.replace=false;
		f_map.location.replace('map.php?'+request);
	}
	else f_map.location.href='map.php?'+request;
	if (map.ov.refresh) RefreshOV();
}

function RefreshOV() {
	var r=map.ov.rect; var c=map.cur; var o=map.ov;
	if (win_ready.ov) {
	//alert('LUBE - refreshOV');
		var ax=o.width/(map.maxx-map.minx);
		var ay=o.height/(map.maxy-map.miny);
		r.left=Math.round((c.minx-map.minx)*ax);
		r.right=Math.round((c.maxx-map.minx)*ax);
		r.bottom=Math.round(o.height-((c.miny-map.miny)*ay));
		r.top=Math.round(o.height-((c.maxy-map.miny)*ay));
		if (r.right-r.left < o.min_size) {
			r.left=r.left-Math.round(o.min_size/2);
			r.right=r.left+o.min_size;
		}
		if (r.bottom-r.top<o.min_size) {
			r.top=r.top-Math.round(o.min_size/2);
			r.bottom=r.top+o.min_size;
		}
		ClipRect(f_ov, 'Map', r);
		SetRectVisible(f_ov, 'Map', true)
	}
	else window.setTimeout(RefreshOV, 500);
}
*/
function InitOV() {
	var e=map;
	var boxEncodedValue = escape(Math.round(e.minx*1000)/1000+','+Math.round(e.miny*1000)/1000+','+Math.round(e.maxx*1000)/1000+','+Math.round(e.maxy*1000)/1000).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
	var box='BBOX='+boxEncodedValue;
// changed by jiva
//	var box='BBOX='+Math.round(map.minx)+','+Math.round(map.miny)+','+Math.round(map.maxx)+','+Math.round(map.maxy);
  var version_encoded = escape(map.version).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
	var request='MAP='+map.name+'&'+box+'&HEIGHT='+map.ov.height+'&WIDTH='+map.ov.width+'&'+GetFromLayers(true)+'&OVERVIEW=1&cacheID='+(new Date).getTime()+'&VERSION='+version_encoded+'&FORMAT=HTML'+'&BGCOLOR='+(escape(map.window.bgColor).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F'));
	f_ov.location.href='map.php?'+request ;
}

function Transf_XY() {
	var r=map.rect;
	var c=map.units;
	r.x1=Math.round(TransformX(r.left)*c)/c;
	r.y1=Math.round(TransformY(r.bottom)*c)/c;
	r.x2=Math.round(TransformX(r.right)*c)/c;
	r.y2=Math.round(TransformY(r.top)*c)/c;
}

function ZoomOutRect() {
	var r=map.rect; var c=map.cur;
	Transf_XY();
	if (map.scale < map.maxScale) {
		wx=(c.maxx-c.minx)*(c.maxx-c.minx)/(r.x2-r.x1);
		wy=(c.maxy-c.miny)*(c.maxy-c.miny)/(r.y2-r.y1);
		pan_x=(r.x1-c.minx)*wx/(c.maxx-c.minx);
		pan_y=(r.y1-c.miny)*wy/(c.maxy-c.miny);
		c.minx=c.minx-pan_x;
		c.miny=c.miny-pan_y;
		c.maxx=c.minx+wx;
		c.maxy=c.miny+wy;
		ChangeRatio(c);
		Scale();
		if (map.scale>map.maxScale) {
			ChangeScale(map.maxScale);
		}
		Refresh();
	}
	else PanCenterXY(Math.round(r.x1+(r.x2-r.x1)/2), Math.round(r.y1+(r.y2-r.y1)/2));
}

function ZoomOutCenter() {
	var r=map.rect;
	Transf_XY();
	ZoomOutCenterXY(r.x1,r.y2);
}

function ZoomOutCenterXY(x,y) {
	var c=map.cur;
	if (map.scale < map.maxScale) {
		w=(c.maxx-c.minx);
		h=(c.maxy-c.miny);
		dx=x-(c.minx+w/2);
		dy=y-(c.miny+h/2);
		c.minx=c.minx+dx-(w/2);
		c.maxx=c.maxx+dx+(w/2);
		c.miny=c.miny+dy-(h/2);
		c.maxy=c.maxy+dy+(h/2);
		Scale();
		if (map.scale > map.maxScale) {
			ChangeScale(map.maxScale);
		}
		Refresh();
	}
	else PanCenterXY(x,y);
}

function ZoomInRect() {
	var r=map.rect; var c=map.cur;
	Transf_XY();
	if (map.scale > map.minScale) {
		c.minx=r.x1;
		c.miny=r.y1;
		c.maxx=r.x2;
		c.maxy=r.y2;
		ChangeRatio(c);
		Scale();
		if (map.scale < map.minScale) {
			ChangeScale(map.minScale);
		}
		Refresh();
	}
	else PanCenterXY(r.x1+((r.x2-r.x1)/2), r.y1+((r.y2-r.y1)/2));
}

function ZoomInCenterXY(x,y) {
	var c=map.cur;
	if (map.scale > map.minScale) {
		w=(c.maxx-c.minx);
		h=(c.maxy-c.miny);
		dx=x-(c.minx+w/2);
		dy=y-(c.miny+h/2);
		c.minx=c.minx+dx+(w/4);
		c.maxx=c.maxx+dx-(w/4);
		c.miny=c.miny+dy+(h/4);
		c.maxy=c.maxy+dy-(h/4);
		Scale();
		if (map.scale < map.minScale) {
			ChangeScale(map.minScale);
		}
		Refresh();
	}
	else PanCenterXY(x, y);
}

function ZoomInCenter() {
	var r=map.rect;
	Transf_XY();
	ZoomInCenterXY(r.x1,r.y2);
}

function PanCenterXY(x,y) {
	var c=map.cur;
	dx=(c.maxx-c.minx)/2;
	dy=(c.maxy-c.miny)/2;
	c.minx=x-dx;
	c.maxx=x+dx;
	c.miny=y-dy;
	c.maxy=y+dy;
	Refresh();
}

function PanCenter() {
	var x=Math.round(TransformX(map.point.left));
	var y=Math.round(TransformY(map.point.top));
	PanCenterXY(x,y);
}
function SendCoords() {
	var x=TransformX(map.point.left);
	var y=TransformY(map.point.top);
	var c=map.cur;
	dx=(c.maxx-c.minx)/2;
	dy=(c.maxy-c.miny)/2;
	c.minx=x-dx;
	c.maxx=x+dx;
	c.miny=y-dy;
	c.maxy=y+dy;
	var e=map.cur;
	var box='BBOX='+Math.round(e.minx*1000)/1000+','+Math.round(e.miny*1000)/1000+','+Math.round(e.maxx*1000)/1000+','+Math.round(e.maxy*1000)/1000;
	var request=box+'&X='+x+'&Y='+y;
  window.location.replace('index.php?'+request);
}

function PanPoint() {
	var c=map.cur;var p=map.point;
	var x1=Math.round(TransformX(p.left));
	var y2=Math.round(TransformY(p.top));
	var x2=Math.round(TransformX(p.right));
	var y1=Math.round(TransformY(p.bottom));
	c.minx=c.minx-(x2-x1);
	c.maxx=c.maxx-(x2-x1);
	c.miny=c.miny+(y2-y1);
	c.maxy=c.maxy+(y2-y1);
	Refresh();
}

function MapScale() {
	var w=map.window; var im=document.mapscale;
	if (w.mapscale) {w.mapscale=false; im.src=ImgOff('check_w');}
	else {w.mapscale=true; im.src=ImgOn('check_w');}
	if (GetPageLayer(f_map,'MapScaleBar') != null) {
		SetPageLayerVisible(f_map,'MapScaleBar',w.mapscale);
	}
	else Refresh();
}

function FullExtent() {
	var c=map.cur; c.minx=map.minx; c.miny=map.miny; c.maxx=map.maxx; c.maxy=map.maxy;
	Scale();
	Refresh();
}

function RefreshMap() {Refresh(true);}
function Back() {f_map.history.go(-1);}
function Forward() {f_map.history.go(1);}
function StatusMap() {Status(map.cur.minx,map.cur.miny);}
function MouseXY(x,y) {Status(TransformX(x),TransformY(y))};
function TransformX(x) {return map.cur.minx+x/map.window.width*(map.cur.maxx-map.cur.minx);}
function TransformY(y) {return map.cur.maxy-y/map.window.height*(map.cur.maxy-map.cur.miny);}
function TransformOVX(x) {return map.minx+x/map.window.width*(map.maxx-map.minx);}
function TransformOVY(y) {return map.maxy-y/map.window.height*(map.maxy-map.miny);}

function Status(x,y) {
	if (map.status) {
		if (map.units==1000) window.status="X: "+ConvertCoord(x)+", Y: "+ConvertCoord(y);
		else window.status=resource.scale+" 1:"+ map.scale +", X: "+Math.round(x)+", Y: "+Math.round(y);
	}
}

function ConvertCoord(x,type) {
	if (x[0]=="-") {x = -1*x; sign = "-";}
	else {sign = "";}
	xd = Math.floor(x);
	x = (x-xd)*60;
	xm = Math.floor(x);
	if (xm < 10) xm = "0" + xm
	x = (x-xm)*60;
	xs = Math.floor(x);
	if (xs < 10) xs = "0" + xs
	if (type==1) return sign + xd+" "+xm+"'"+xs + '"';
	else return sign + xd+''+xm+"'"+xs + '"';
}

function Scale() {
	map.scale=(map.cur.maxx-map.cur.minx)/map.meterWidth;
	if (map.units==1000) map.scale = map.scale*111300;
	map.scale=Math.round(map.scale);
}


function ChangeState(state,w_name) {
	if (w_name == null) {
		if (panel.state != state) {
			document[panel.state].src=ImgOn(panel.state);
			panel.state=state;
			document[state].src=ImgOff(state);
		}
	}
	else {
		if (panel.state != state) {
			if (env.isN) {
				parent[w_name].document[panel.state].document[panel.state].src=ImgOn(panel.state);
				panel.state=state;
				parent[w_name].document[state].document[state].src=ImgOff(state);

			}
			else {
				parent[w_name].document[panel.state].src=ImgOn(panel.state);
				panel.state=state;
				parent[w_name].document[state].src=ImgOff(state);
			}
		}
	}
}



function ChangeRatio(e) {
	if (map.window.ratio < ((e.maxy-e.miny)/(e.maxx-e.minx)) ) {
		x =1/map.window.ratio*(e.maxy-e.miny);
		dx=(x-(e.maxx-e.minx))/2;
		e.maxx=e.maxx+dx;
		e.minx=e.minx-dx;
	}
	else {
		y =map.window.ratio*(e.maxx-e.minx);
		dy=(y-(e.maxy-e.miny))/2;
		e.maxy=e.maxy+dy;
		e.miny=e.miny-dy;
	}
}

function ChangeScale(num) {
	var c=map.cur;
	if (num<map.minScale) num=map.minScale;
	if (num>map.maxScale) num=map.maxScale;
	map.scale=num;
	if (map.units==1000) num = num/111300;
	var w=num*map.meterWidth;
	var dx=w-(c.maxx-c.minx);
	c.minx=c.minx-dx/2;
	c.maxx=w+c.minx;
	c.miny=c.miny+(c.maxy-c.miny)/2 -1/map.units;
	c.maxy=c.miny+2/map.units;
	ChangeRatio(c);
}

function ChangeExtentPercent(perc,minSc,maxSc) {
	var c=map.cur;
	var rat=perc/100;
	var dx=((c.maxx-c.minx)*rat-(c.maxx-c.minx))/2;
	var dy=((c.maxy-c.miny)*rat-(c.maxy-c.miny))/2;
	c.minx=c.minx-dx;
	c.maxx=c.maxx+dx;
	c.miny=c.miny-dy;
	c.maxy=c.maxy+dy;
	Scale();
	if (minSc!=0 && map.scale<minSc) ChangeScale(minSc);
	if (maxSc!=0 && map.scale>maxSc) ChangeScale(maxSc);
}

function ScaleDialog() {
	var num=parseInt(prompt(resource.scale_prompt,map.scale));
	if (!isNaN(num)) {
		ChangeScale(num);
		Refresh();
	}
}

function InitScale() {
	w=30.3;//cm
	map.meterWidth=map.window.width * (w/window.screen.width) / 100;
}

function Help(s) {
	var exist=false;
	if (window.f_help) if (!f_help.closed) exist=true;
	if (exist) f_help.focus();
	else {
		var h=map.window.help;
		f_help=window.open(s,'map_help','width='+h.width+',height='+h.height+',left='+h.left+',top='+h.top+',resizable,scrollbars');
		f_help.focus();
	}
}

function Print() {
	var p=map.window.print;
	f_print=window.open(f_map.location.href+'&SCRIPT=0&WAIT=0&PRINT=1','map_print','width='+p.width+',height='+p.height+',left='+p.left+',top='+p.top);
	f_print.focus();
}

function PrintPage(s) {
	var exist=false;
	if (window.f_print) if (!f_print.closed) exist=true;
	if (exist) f_print.focus();
	else {
		var h=map.window.print;
		f_print=window.open(s+f_map.location.search,'map_print','width='+p.width+',height='+p.height+',left='+p.left+',top='+p.top+',resizable,scrollbars');
		f_print.focus();
	}
}

function MapExtent(x1,y1,x2,y2) {
	var c=map.cur;
	c.minx=x1; c.miny=y1; c.maxx=x2; c.maxy=y2;
	var scale=Math.round((c.maxx-c.minx)/map.meterWidth);
	if (map.units!=1000) if (Math.abs(map.scale-scale)>1) map.scale=scale;
	StatusMap();
	RefreshOV();
	if (zoom) ChangeZoomIndex();
	if (window.testMS==true) TestCircle();
}

function Search() {
	var exist=false;
	if (top.window.opener!=null) {if (!top.window.opener.closed) {if (top.window.opener.name == 'table'||top.window.opener.name == 'main') {
		exist=true;
		map_db=top.window.opener.top;
		f_db=map_db[top.window.opener.name];
	}}}
	if (map_db != null) {if (!map_db.closed) exist=true;}
	if (exist) map_db.focus();
	else {
		var db=map.window.db;
		var script='db.php?client_lang='+map.lang+'&client_type='+map.cl_type;
		map_db=window.open(script, 'map_db','toolbar,width='+db.width+',height='+db.height+',left='+db.left+',top='+db.top+',resizable');
		map_db.focus();
	}
}

function Legend() {
	var script='legend.php?MAP='+map.name+'&client_lang='+map.lang;
	var exist=false;
	if (f_legend != null) {if (!f_legend.closed) exist=true;}
	if (exist) {f_legend.location.href=script;f_legend.focus();}
	else {
		var i=(map.window.legend?map.window.legend:map.window.info);
		f_legend=window.open(script, i.name,'width='+i.width+',height='+i.height+',left='+i.left+',top='+i.top+',resizable,scrollbars');
		f_legend.focus();
	}
}

function ChangeOV(name) {
  var mex_minx=parent.map_panel.map.minx;
	var mex_miny=parent.map_panel.map.miny;
	var mex_maxx=parent.map_panel.map.maxx;
	var mex_maxy=parent.map_panel.map.maxy;

  if (parent.map_panel.map.ov.id != name) {
     var script = 'map_ov.php?MAP='+map.name+'&OV_NAME='+(escape(name).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F'))+'&client_lang='+map.lang;
		 f_ov.location.href=script;
 //    alert('panel-'+parent.map_panel.panel_loaded);
  	 if (!parent.map_panel.panel_loaded) window.setTimeout(RefreshOV, 500);
     else window.setTimeout(RefreshOV, 200);
	}
}

function Init(ref, i) {
	GetEnv();
	InitScale();
	ChangeRatio(map);
	ChangeRatio(map.cur);
	Scale();
	panel_loaded=true;
	if (map.toc) ShowToc();
	if (ref) {map.replace=true; Refresh();}
//	if (map.ov.refresh) InitOV();
  if (map.ov.refresh) RefreshOV();
  if (zoom) InitZoomIndex();
  if (document.all["MapWait"]) {
    document.all["MapWait"].style.visibility='hidden';
  }

}
