// Copyright 2000 T-Mapy spol. s r. o. All rights reserved.
//$Id: MapFunc.js,v 1.46 2008/02/07 13:43:35 tokr Exp $ $Name:  $
if (!state_functions) var state_functions=new Array();

function GetUrl(l) {
	var a=l.pathname.split('/');
	a.length--;
	return l.protocol+'//'+l.host+a.join('/');
}

function IsInScale(l) {
	if(l.minScale!='') if(!(l.minScale<=map.scale)) return false;
	if(l.maxScale!='') if(!(l.maxScale>=map.scale)) return false;
	return true;
}

function LayerRequest(ov,req,lays,name) {
	var l;
  req.lay=req.lay+name+'(';
	req.sty=req.sty+'(';
	var first=true;
	for(var i in lays) {
		l=lays[i];
		if ((ov && l.ov) || (!ov &&l.visible&& IsInScale(l))) {
			if (first) first=false;
			else {req.lay=req.lay+','; req.sty=req.sty+',';}
			req.lay=req.lay+l.name;
			req.sty=req.sty+l.style;
			if(l.condition) {
				if(req.cond!='') req.cond=req.cond+',';
				else req.cond='CONDITIONS=';
				//req.cond=req.cond+name+'.'+l.name+'('+l.condition+')';
			  req.cond=req.cond+name+'.'+l.name+'('+l.condition+')';
			}
			if(l.select) {
				if(req.sel!='')req.sel=req.sel+',';
				else req.sel='SELECT=';
				//req.sel=req.sel+name+'.'+l.name+'('+l.select+')';
			  req.sel=req.sel+name+'.'+l.name+'('+l.select+')';
			}
		}
	}
	req.lay=req.lay+'),';
	req.sty=req.sty+'),';
	for(var i in lays) {
		l=lays[i];
		if ((ov && l.ov) || (!ov &&l.visible&& IsInScale(l))) {
			if (l.layers) 
        LayerRequest(ov,req,l.layers,name+'.'+l.name);
		}
	}
}

function GetFromLayers(ov) {
	var req=new Object();
  /*
	req.lay='LAYERS=';
	req.sty='STYLES=';
	req.cond='';
	req.sel='';
	LayerRequest(ov,req,layer,map.name);
	return(req.lay.substring(0,req.lay.length-1)+'&'+req.sty.substring(0,req.sty.length-1)+(req.cond!=''?'&'+req.cond:'')+(req.sel!=''?'&'+req.sel:''));
  */
  //tono - URL RFC 1738
	req.lay='';
	req.sty='';
	req.cond='';
	req.sel='';
	LayerRequest(ov,req,layer,map.name);
  var layers_val_encoded = req.lay.substring(0,req.lay.length-1);
  var styles_val_encoded = req.sty.substring(0,req.sty.length-1);
  req.lay='LAYERS='+req.lay;
  req.sty='STYLES='+req.sty;
	var layers_encoded='LAYERS='+layers_val_encoded;
	var styles_encoded='STYLES='+styles_val_encoded;
	return(layers_encoded+'&'+styles_encoded+(req.cond!=''?'&'+req.cond:'')+(req.sel!=''?'&'+req.sel:''));
}

function Refresh(reload, target, replace) {

  if(map.refresh_button.blink) {
    parent.map_panel.document.panel_f.refresh.src = map.refresh_button.img_static;
  }

	if (Refresh.arguments.length==0) reload=false;
	if (map.window.fit) ResizeMapWindow();
	StatusMap();
	var e=map.cur;
	var w=map.window;
 	var box='BBOX='+Round(e.minx)+','+Round(e.miny)+','+Round(e.maxx)+','+Round(e.maxy);
	var m_scale='';
	if (w.mapscale) m_scale='&MAPSCALE=1';
	var m_measure='';
	if (w.measure) m_measure='&MEASURE=1';
	var m_edit_vector='';
	if (w.edit_vector) m_edit_vector='&EDIT_VECTOR=1';
	var m_selection_shape='';
	if (w.selection_shape) m_selection_shape='&SELECTION_SHAPE=1';
	var m_selection_shape_maponly='';
	if (w.selection_shape_maponly) m_selection_shape_maponly='&SELECTION_SHAPE_MAPONLY=1';
	var live_refresh = target=='ifrm_refresher'?'1':'0'; 
	var request='MAP='+map.name+'&'+box+'&HEIGHT='+w.height+'&WIDTH='+w.width+'&SCALE='+map.scale+'&'+ GetFromLayers(false) +m_scale+m_measure+m_selection_shape+m_selection_shape_maponly+m_edit_vector+(reload?'&cacheID=' +(new Date).getTime():'')+'&VERSION='+map.version+'&FORMAT=HTML'+'&BGCOLOR='+map.window.bgColor+'&client_lang='+map.lang+'&client_type='+map.cl_type+'&live_refresh='+live_refresh;
  if (map.charset) request=request+'&charset='+map.charset;
  if (map.window.fit) request=request+'&MAPWINFIT=1';
  if (map.session) request=request+'&SESSION=1';
  //alert(request);
  RefreshByForm(request,'map.php',(target?target:f_map.name),f_map,(replace?replace:map.replace));
  map.lastrequest = request;
 	if (map.replace) map.replace=false;
	if (map.ov.refresh) RefreshOV();
}

function RefreshByForm(request, action, target, frame, replace, frm) {
  if (!frm) frm = f_panel.document.frm_refresh;
  if (action) frm.action = action;
  if (target) frm.target = target;
  var param = '';
  var params = request.split('&');
  var url='';
  for(var i=0;i<params.length;i++) {
    param = params[i].split('=');
    url += (url?'&':'')+param[0]+'='+escape(param[1]).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');;
  }
  url = action+'?'+url;
  if ((map.refreshMethod == 'POST')||(env.isIE && url.length > 2000)) 
    frm.method = 'POST';
  else 
    frm.method = 'GET';

  if (frm.method == 'GET') {
    if (replace) {
      frame.location.replace(url);
    } else {
      frame.location.href = url;
    }
  } else {
    for(var i=0;i<params.length;i++) {
      param = params[i].split('=');
      if (frm.insertAdjacentHTML) 
        frm.insertAdjacentHTML("beforeEnd", '<input type="hidden" name="'+param[0]+'" value="'+param[1]+'">');
      else
        frm.insertAdjacentHTML2("beforeEnd", '<input type="hidden" name="'+param[0]+'" value="'+param[1]+'">');
    }
    frm.submit();
  }
  frm.innerHTML = '';
  if (target) frm.target='_self';
  if (action) frm.action='';
}

function RefreshOV() {
	var r=map.ov.rect; var c=map.cur; var o=map.ov;
	if (win_ready.ov) {
  	var r=map.ov.rect;
  	var c=map.cur;		 
  	var o=map.ov;
  
  	var ax=o.width/(o.maxx-o.minx);
  	var ay=o.height/(o.maxy-o.miny);
  	r.left=Math.round((c.minx-o.minx)*ax);
  	r.right=Math.round((c.maxx-o.minx)*ax);
  	r.bottom=Math.round(o.height-((c.miny-o.miny)*ay));
  	r.top=Math.round(o.height-((c.maxy-o.miny)*ay));
  	
  	if (r.right-r.left < o.min_size) {
  	r.left=r.left-Math.round(o.min_size/2);
  	r.right=r.left+o.min_size;
  	}
  	if (r.bottom-r.top<o.min_size) {
  	r.top=r.top-Math.round(o.min_size/2);
  	r.bottom=r.top+o.min_size;
  	}
  	ClipRect(f_ov, "Map", r);
  	SetRectVisible(f_ov, "Map", true)
	}
	else window.setTimeout(RefreshOV, 500);
}

function InitMapRequest(ov) {
	var e=(ov?map.ov:map.cur);
	var w=(ov?map.ov:map.window);
	var box=Round(e.minx)+','+Round(e.miny)+','+Round(e.maxx)+','+Round(e.maxy);
  var request='MAP='+map.name+'&BBOX='+box+'&HEIGHT='+w.height+'&WIDTH='+w.width+'&'+GetFromLayers(ov)+'&cacheID='+(new Date).getTime()+'&VERSION='+map.version+'&client_lang='+map.lang+'&FORMAT=HTML'+'&BGCOLOR='+map.window.bgColor;
  if (map.charset) request=request+'&charset='+map.charset;
  return request;
}

function InitOV() {
  if (map.ov.schema_init)
	  ChangeOV('');
  else
    RefreshByForm(InitMapRequest(true)+'&MODE=ov','map.php',f_ov.name,f_ov,true);
	  //f_ov.location.replace('map.php?'+InitMapRequest(true) + '&MODE=ov');
}

function Transf_XY() {
	var r=map.rect;
	r.x1=Round(TransformX(r.left));
	r.y1=Round(TransformY(r.bottom));
	r.x2=Round(TransformX(r.right));
	r.y2=Round(TransformY(r.top));
}

function ZoomOutRect() {
	var r=map.rect; var c=map.cur;
	Transf_XY();
	if (map.scale < map.maxScale) {
		wx=(c.maxx-c.minx)*(c.maxx-c.minx)/(r.x2-r.x1);
		wy=(c.maxy-c.miny)*(c.maxy-c.miny)/(r.y2-r.y1);
		pan_x=(r.x1-c.minx)*wx/(c.maxx-c.minx);
		pan_y=(r.y1-c.miny)*wy/(c.maxy-c.miny);
		c.minx=c.minx-pan_x;
		c.miny=c.miny-pan_y;
		c.maxx=c.minx+wx;
		c.maxy=c.miny+wy;
		ChangeRatio(c);
		Scale();
		if (map.scale>map.maxScale) {
			ChangeScale(map.maxScale);
		}
		Refresh();
	}
	else PanCenterXY(Round(r.x1+(r.x2-r.x1)/2), Round(r.y1+(r.y2-r.y1)/2));
}

function ZoomOutCenter() {
	var r=map.rect;
	Transf_XY();
	ZoomOutCenterXY(r.x1,r.y2);
}

function ZoomOutCenterXY(x,y) {
	var c=map.cur;
	if (map.scale < map.maxScale) {
		w=(c.maxx-c.minx);
		h=(c.maxy-c.miny);
		dx=x-(c.minx+w/2);
		dy=y-(c.miny+h/2);
		c.minx=c.minx+dx-(w/2);
		c.maxx=c.maxx+dx+(w/2);
		c.miny=c.miny+dy-(h/2);
		c.maxy=c.maxy+dy+(h/2);
		Scale();
		if (map.scale > map.maxScale) {
			ChangeScale(map.maxScale);
		}
		Refresh();
	}
	else PanCenterXY(x,y);
}

function ZoomInRect() {
	var r=map.rect; var c=map.cur;
	Transf_XY();
	if (map.scale > map.minScale) {
		c.minx=r.x1;
		c.miny=r.y1;
		c.maxx=r.x2;
		c.maxy=r.y2;
		ChangeRatio(c);
		Scale();
		if (map.scale < map.minScale) {
			ChangeScale(map.minScale);
		}
		Refresh();
	}
	else PanCenterXY(Round(r.x1+(r.x2-r.x1)/2), Round(r.y1+(r.y2-r.y1)/2));
}

function ZoomToBBOX(c,percent) {
  map.cur=c;
	ChangeRatio(c);
	if (percent) ChangeExtentPercent(percent,map.minScale,map.maxScale);
	Scale();
	if (map.scale < map.minScale) {
		ChangeScale(map.minScale);
	}
	Refresh();
}

function ZoomInCenterXY(x,y) {
	var c=map.cur;
	if (map.scale > map.minScale) {
		w=(c.maxx-c.minx);
		h=(c.maxy-c.miny);
		dx=x-(c.minx+w/2);
		dy=y-(c.miny+h/2);
		c.minx=c.minx+dx+(w/4);
		c.maxx=c.maxx+dx-(w/4);
		c.miny=c.miny+dy+(h/4);
		c.maxy=c.maxy+dy-(h/4);
		Scale();
		if (map.scale < map.minScale) {
			ChangeScale(map.minScale);
		}
		Refresh();
	}
	else PanCenterXY(x, y);
}

function ZoomInCenter() {
	var r=map.rect;
	Transf_XY();
	ZoomInCenterXY(r.x1,r.y2);
}

function PanCenterXY(x,y) {
	var c=map.cur;
	dx=(c.maxx-c.minx)/2;
	dy=(c.maxy-c.miny)/2;
	c.minx=x-dx;
	c.maxx=x+dx;
	c.miny=y-dy;
	c.maxy=y+dy;
	Refresh();
}

function PanCenter() {
	var x=Round(TransformX(map.point.left));
	var y=Round(TransformY(map.point.top));
	PanCenterXY(x,y);
}

function PanPoint() {
	var c=map.cur;var p=map.point;
	var x1=Round(TransformX(p.left));
	var y2=Round(TransformY(p.top));
	var x2=Round(TransformX(p.right));
	var y1=Round(TransformY(p.bottom));
	c.minx=c.minx-(x2-x1);
	c.maxx=c.maxx-(x2-x1);
	c.miny=c.miny+(y2-y1);
	c.maxy=c.maxy+(y2-y1);
	Refresh();
}

function MapScale() {
	var w=map.window; var im=document.mapscale;
	if (w.mapscale) {w.mapscale=false; im.src=ImgOff('check_w');}
	else {w.mapscale=true; im.src=ImgOn('check_w');}
	if (GetPageLayer(f_map,'MapScaleBar') != null) {
		SetPageLayerVisible(f_map,'MapScaleBar',w.mapscale);
	}
	else Refresh();
}

function FullExtent() {
	var c=map.cur; c.minx=map.minx; c.miny=map.miny; c.maxx=map.maxx; c.maxy=map.maxy;
  ChangeRatio(c);
	Scale();
	Refresh();
}

function Round(p) {return Math.round(p*map.units*1000)/(1000*map.units);}

function RefreshMap() {
  Refresh(true);
}

function Back() {f_map.history.go(-1);}
function Forward() {f_map.history.go(1);}
function StatusMap() {Status(map.cur.minx,map.cur.miny);}
function MouseXY(x,y) {Status(TransformX(x),TransformY(y))};
function TransformX(x) {return map.cur.minx+x/map.window.width*(map.cur.maxx-map.cur.minx);}
function TransformY(y) {return map.cur.maxy-y/map.window.height*(map.cur.maxy-map.cur.miny);}
function ReverseTransformX(x) {return Math.floor((x-map.cur.minx)/(map.cur.maxx-map.cur.minx)*map.window.width);}
function ReverseTransformY(y) {return Math.floor((map.cur.maxy-y)/(map.cur.maxy-map.cur.miny)*map.window.height);}
function TransformOVX(x) {return map.ov.minx+x/map.ov.width*(map.ov.maxx-map.ov.minx);}
function TransformOVY(y) {return map.ov.maxy-y/map.ov.height*(map.ov.maxy-map.ov.miny);}

function Status(x,y) {
	if (map.status) {
		if (map.units==1000) window.status="X: "+ConvertCoord(x)+", Y: "+ConvertCoord(y);
		else window.status=resource.scale+" 1:"+ map.scale +", X: "+Math.round(x)+", Y: "+Math.round(y);
	}
}

function ConvertCoord(x,type) {
	if (x[0]=="-") {x = -1*x; sign = "-";}
	else {sign = "";}
	xd = Math.floor(x);
	x = (x-xd)*60;
	xm = Math.floor(x);
	if (xm < 10) xm = "0" + xm;
	x = (x-xm)*60;
	xs = Math.floor(x);
	if (xs < 10) xs = "0" + xs;
	if (type==1) return sign + xd+" "+xm+"'"+xs + '"';
	else return sign + xd+''+xm+"'"+xs + '"';
}

function Scale() {
	map.scale=(map.cur.maxx-map.cur.minx)/map.meterWidth;
	if (map.units==1000) map.scale = map.scale*111300;
	map.scale=Math.round(map.scale);
}

function RegisterStateFunction(func) {
  state_functions = state_functions.concat(func);
}

function ChangeState(state,w_name) {
  var s=panel.state;
	if (w_name == null) {
		if (s != state) {
			panel.state=state;
			document[s].src=ImgOn(s);
			document[state].src=ImgOff(state);
		}
	}
	else {
		if (s != state) {
			panel.state=state;
			if (env.isN) {
				parent[w_name].document[s].document[s].src=ImgOn(s);
				parent[w_name].document[state].document[state].src=ImgOff(state);

			}
			else {
				parent[w_name].document[s].src=ImgOn(s);
				parent[w_name].document[state].src=ImgOff(state);
			}
		}
	}
  if (sel_el.active) {
    var el = sel_el.active;
    sel_el.active.style.visibility = 'hidden';
    el.style.position = 'absolute';
    sel_el.active = false;
  }

  for (key in state_functions) {
    state_functions[key]();
  }
  SetCursor();
}

function ChangeStateWithSelect(state,s_name,w_name) {
  ChangeState(state,w_name);
  if (w_name)
    var win = parent[w_name];
  else
    var win = window;

  if (env.isIE) {
    var el = false;
    var els = win.document.getElementsByName(s_name);
    for (i=0; i<els.length; i++) {
      if (els[i].id == s_name) {
        el = els[i];
        break;
      }
    }
  } else {
    var el = win.document.getElementById(s_name);
  }
  if (el && el.id == s_name) {
    el.style.visibility = 'visible';
    el.style.position = 'static';
    sel_el.active = el;
  }
}

function SetCursor() {
  f_panel = parent.map_panel;
  if (f_panel.panel.cursor[f_panel.panel.state]) parent.map.document.body.style.cursor = f_panel.panel.cursor[f_panel.panel.state];
  else parent.map.document.body.style.cursor = f_panel.panel.cursor['default'];
}


function ChangeRatio(e) {
	if (map.window.ratio < ((e.maxy-e.miny)/(e.maxx-e.minx)) ) {
		x =1/map.window.ratio*(e.maxy-e.miny);
		dx=(x-(e.maxx-e.minx))/2;
		e.maxx=e.maxx+dx;
		e.minx=e.minx-dx;
	}
	else {
		y =map.window.ratio*(e.maxx-e.minx);
		dy=(y-(e.maxy-e.miny))/2;
		e.maxy=e.maxy+dy;
		e.miny=e.miny-dy;
	}
}

function ChangeScale(num) {
	var c=map.cur;
	if (num<map.minScale) num=map.minScale;
	if (num>map.maxScale) num=map.maxScale;
	map.scale=num;
	if (map.units==1000) num = num/111300;
	var w=num*map.meterWidth;
	var dx=w-(c.maxx-c.minx);
	c.minx=c.minx-dx/2;
	c.maxx=w+c.minx;
	c.miny=c.miny+(c.maxy-c.miny)/2 -1/map.units;
	c.maxy=c.miny+2/map.units;
	ChangeRatio(c);
}

function ChangeExtentPercent(perc,minSc,maxSc) {
	var c=map.cur;
	var rat=perc/100;
	var dx=((c.maxx-c.minx)*rat-(c.maxx-c.minx))/2;
	var dy=((c.maxy-c.miny)*rat-(c.maxy-c.miny))/2;
	c.minx=c.minx-dx;
	c.maxx=c.maxx+dx;
	c.miny=c.miny-dy;
	c.maxy=c.maxy+dy;
	Scale();
	if (minSc!=0 && map.scale<minSc) ChangeScale(minSc);
	if (maxSc!=0 && map.scale>maxSc) ChangeScale(maxSc);
}

function ScaleDialog() {
	var num=parseInt(prompt(resource.scale_prompt,map.scale));
	if (!isNaN(num)) {
		ChangeScale(num);
		Refresh();
	}
}
function InitScale() {
  if(parent.map.window.document.body!=null) {
    if (env.isN) {
      map.window.height = parent.map.window.innerHeight;
      map.window.width = parent.map.window.innerWidth;
    } else {
      map.window.height = parent.map.window.document.body.clientHeight;
      map.window.width = parent.map.window.document.body.clientWidth;
    }
  } else window.setTimeout(InitScale, 200);

	var sw=map.window.width;
  map.meterWidth = sw / 96 * 2.54 /100; //m
}

function Help(s) {
	var exist=false;
	if (window.f_help) if ((typeof f_help.closed != "undefined") && !f_help.closed) exist=true;
	if (exist) f_help.focus();
	else {
		var h=map.window.help;
		f_help=window.open(s,'map_help','width='+h.width+',height='+h.height+',left='+h.left+',top='+h.top+',resizable,scrollbars');
		f_help.focus();
	}
}

function Print() {
	var p=map.window.print;
	var request = map.lastrequest+'&SCRIPT=0&WAIT=0&PRINT=1';
	f_print=window.open('empty.php','map_print','width='+p.width+',height='+p.height+',left='+p.left+',top='+p.top);
	RefreshByForm(request, 'map.php', 'map_print', f_print, true);
	f_print.focus();
}

function PrintPage(s) {
	var exist=false;
	if (window.f_print) if ((typeof f_print.closed != "undefined") && !f_print.closed) exist=true;
	if (!exist) {
		var p=map.window.print;
		f_print=window.open('empty.php', 'map_print','width='+p.width+',height='+p.height+',left='+p.left+',top='+p.top+',resizable,scrollbars');
	}
  var request = map.lastrequest+'&m_scale='+map.scale;
  RefreshByForm(request, s, 'map_print', f_print, true);
	f_print.focus();
}

function SaveImage(s) {
	var exist=false;
	if (window.f_print) if (!f_print.closed) exist=true;
	if (exist) f_print.focus();
	else {
		var h=map.window.print;
		f_print=window.open(s+f_map.location.search+'&mode=save_image&m_scale='+map.scale,'map_print','width='+p.width+',height='+p.height+',left='+p.left+',top='+p.top+',resizable,scrollbars');
		f_print.focus();
	}
}

function MapExtent(x1,y1,x2,y2) {
	var c=map.cur;
	c.minx=x1; c.miny=y1; c.maxx=x2; c.maxy=y2;
	var scale=Math.round((c.maxx-c.minx)/map.meterWidth);
	if (map.units!=1000) if (Math.abs(map.scale-scale)>1) map.scale=scale;
	StatusMap();
	RefreshOV();
	if (zoom) ChangeZoomIndex();
	if (window.testMS==true) TestCircle();
}

function Search() {
	var exist=false;
	if (top.window.opener!=null) {
    if(typeof(top.window.opener.document) == "object") {
      if (top.window.opener.name == 'table'||top.window.opener.name == 'main') {
    		exist=true;
    		map_db=top.window.opener.top;
    		f_db=map_db[top.window.opener.name];
	    }
    }
  }
	if (map_db != null) {if ((typeof map_db.closed != "undefined") && !map_db.closed) exist=true;}
	if (exist) map_db.focus();
	else {
		var db=map.window.db;
		var script='db.php?client_lang='+map.lang+'&client_type='+map.cl_type+'&fce_type=search';
		map_db=window.open(script, 'map_db','toolbar,width='+db.width+',height='+db.height+',left='+db.left+',top='+db.top+',resizable');
		map_db.focus();
	}
}

function Search2() {
  var db=map.window.db;
  var w=window.open('',db.name,'toolbar,width='+db.width+',height='+db.height+',left='+db.left+',top='+db.top+',resizable');
  w.location.href='db.php?client_lang='+map.lang+'&client_type='+map.cl_type+'&fce_type=search';
  w.focus();
}

function Legend() {
	var exist=false;
	if (f_legend != null) {if ((typeof f_legend.closed != "undefined") && !f_legend.closed) exist=true;}
	var i=(map.window.legend?map.window.legend:map.window.info);
	if (!i.name) i.name = 'info'; 
	if (!exist) {
		f_legend=window.open('empty.php', i.name,'width='+i.width+',height='+i.height+',left='+i.left+',top='+i.top+',resizable,scrollbars');
	}
  var request = InitMapRequest(false) + '&MODE=lg'+'&cacheID=' +(new Date).getTime();
  RefreshByForm(request, 'map.php', i.name, f_legend, true);
	f_legend.focus();
}

function ChangeOV(name) {
  if (parent.map_panel.map.ov.id != name) {
    var ov_w=parent.map_panel.map.ov.width;
    var ov_h=parent.map_panel.map.ov.height;
    f_ov.location.replace('map_ov.php?MAP='+map.name+'&OV_NAME='+name+'&client_lang='+map.lang+'&OV_HEIGHT='+ov_h+'&OV_WIDTH='+ov_w);
  }
}

function Init(ref, i) {
	GetEnv();
	if (env.isN) {
		h = f_map.innerHeight;
		w = f_map.innerWidth;
	} else {
		h = f_map.document.body.clientHeight;
		w = f_map.document.body.clientWidth;
	}
	map.window.height = h;
	map.window.width = w;
	map.window.ratio = h/w;
	InitScale();
	ChangeRatio(map);
	ChangeRatio(map.cur);
	Scale();
	panel_loaded=true;
	if (map.toc) ShowToc();
	if (ref) {map.replace=true; Refresh();}
	if (map.ov.refresh) InitOV();
	if (zoom) InitZoomIndex();
}

function ResizeMapWindow() {
  if (parent.map.document.body) {
    if (env.isN) {
      h = f_map.innerHeight;
      w = f_map.innerWidth;
    } else {
      h = f_map.document.body.clientHeight;
      w = f_map.document.body.clientWidth;
    }
    if (w != map.window.width || h != map.window.height) {
      map.window.height = h;
      map.window.width = w;
      map.window.ratio = h/w;
      InitScale();
      ChangeRatio(map);
      ChangeRatio(map.cur);
      ChangeScale(map.scale);
    }
  } else {
    window.setTimeout(ResizeMapWindow, 100);
  }
}

function ClearSelectAll() {
  ClearSelect(true);
  parent.map_interface.location.replace('db_interface.php?Theme=clear_sel&SESSION=1');
}

function SelectDialog(obj,typ) {
  var value = escape(obj.options[obj.selectedIndex].value).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
  switch(typ) {
    case "select_view":
      var extent = escape(map.cur.minx+":"+map.cur.miny+":"+map.cur.maxx+":"+map.cur.maxy).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
      ShowMapEx('Theme=select_view&Group='+value+'&Extent='+extent,'cz_win');
    break;
    case "select_scale":
    	if (value>0) {
        ChangeScale(value);
        Refresh();
      }
      else return false;
    break;
    default: return value;
  }
}

function ResetSelectDialog(obj) {
  obj.selectedIndex = 0;
  return false;
}

function Selection(ctrl) {
	var r=map.rect;
	var sour=new Object();
	Transf_XY();
	sour.minx=r.x1;
	sour.miny=r.y1;
	sour.maxx=r.x2;
	sour.maxy=r.y2;
	var s=document.panel_f.selection_select;
	var q_name = escape(s.options[s.selectedIndex].value).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
  if (q_name) {
    var addToSel='';
    if (ctrl) addToSel='&AddToSel=1';
  	var script=GetUrl(location)+'/selection.php?query_type=select&QUERY_LAYER='+q_name+addToSel+'&BBOX='+(escape(Math.round(sour.minx*1000)/1000+','+Math.round(sour.miny*1000)/1000+','+Math.round(sour.maxx*1000)/1000+','+Math.round(sour.maxy*1000)/1000).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F'))+'&client_type='+map.cl_type+'&client_lang='+map.lang;
  	var i=map.window.db;
  	selection_win=window.open(script, 'map_db','width='+i.width+',height='+i.height+',left='+i.left+',top='+i.top+',resizable,scrollbars');
  	selection_win.focus();
  } else alert(resource.hotlink_layer);
}

function SelectionMapOnly(ctrl) {
	var r=map.rect;
	var sour=new Object();
	Transf_XY();
	sour.minx=r.x1;
	sour.miny=r.y1;
	sour.maxx=r.x2;
	sour.maxy=r.y2;
	var s=document.panel_f.selection_select;
	var q_name = escape(s.options[s.selectedIndex].value).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F');
  if (q_name) {
    var addToSel='';
    if (ctrl) addToSel='&AddToSel=1';
    var script=GetUrl(location)+'/selection.php?mapOnly=1&query_type=select&QUERY_LAYER='+q_name+addToSel+'&BBOX='+(escape(Math.round(sour.minx*1000)/1000+','+Math.round(sour.miny*1000)/1000+','+Math.round(sour.maxx*1000)/1000+','+Math.round(sour.maxy*1000)/1000).replace(/\+/g,'%2B').replace(/\./g,'%2E').replace(/\"/g,'%22').replace(/\'/g, '%27').replace(/\//g,'%2F'))+'&client_type='+map.cl_type+'&client_lang='+map.lang;
  	var i=map.window.db;
    var int_win = window.parent.map_interface;
   	int_win.document.location.href = script;
   	
  } else alert(resource.hotlink_layer);
}

function Neighbours(x,y) {
	var x=Math.round(TransformX(x)*1000)/1000;
	var y=Math.round(TransformY(y)*1000)/1000;
	var s=document.panel_f.neighbours;
	var q_name = s.options[s.selectedIndex].value;
  if (q_name) {
  	//var script=GetUrl(location)+'/neighbours.php?QUERY_LAYER='+q_name+'&X='+x+'&Y='+y;
  	var script=GetUrl(location)+'/selection.php?type=neighbours&QUERY_LAYER='+q_name+'&X='+x+'&Y='+y+'&client_type='+map.cl_type+'&client_lang='+map.lang;
  	var i=map.window.db;
  	selection_win=window.open(script, 'map_db','width='+i.width+',height='+i.height+',left='+i.left+',top='+i.top+',resizable,scrollbars');
  	selection_win.focus();
  } else alert(resource.hotlink_layer);
}

function NeighboursMapOnly(x,y) {
	var x=Math.round(TransformX(x)*1000)/1000;
	var y=Math.round(TransformY(y)*1000)/1000;
	var s=document.panel_f.neighbours;
	var q_name = s.options[s.selectedIndex].value;
  if (q_name) {
  	var script=GetUrl(location)+'/selection.php?type=neighbours&mapOnly=1&QUERY_LAYER='+q_name+'&X='+x+'&Y='+y+'&client_type='+map.cl_type+'&client_lang='+map.lang;
  	var i=map.window.db;
    var int_win = window.parent.map_interface;
   	int_win.document.location.href = script;
  } else alert(resource.hotlink_layer);
}

function UpdateLayerOutput() {
  for(var i=0; i<refr_layers.length; i++) {
    if(document.getElementById(refr_layers[i])) var new_html = document.getElementById(refr_layers[i]).innerHTML;
    if(window.top.map.document.getElementById(refr_layers[i])) window.top.map.document.getElementById(refr_layers[i]).innerHTML = new_html;
  }
}