// Copyright 2000 T-Mapy spol. s r. o. All rights reserved.
//$Id: BaseFunc.js,v 1.10 2006/12/01 13:38:03 tokr Exp $ $Name:  $

function GetPageLayer(w,name) {
	if (env.isN) {
		if (env.version == 4) {
			if (w.document.layers[name]) return(w.document.layers[name]);
			else {
				if (w.document.layers["MapLayers"].layers[name]) return(w.document.layers["MapLayers"].layers[name]);
				else return(null);
			}
		}
		else if (env.version == 5) {
      var el = w.document.getElementById(name);
      if (el) return(el.style);
      else return(null);
    }
		else return(null);
	}
	else if (env.isIE || env.isOP) {
		if (w.document[name]) 
      return(w.document[name].style);
		else {
      var el = w.document.getElementById(name);
			if (el) {
        return(el.style);
			} else 
        return(null);
		}
	}
	else return(null);
}
		
function SetPageLayerVisible(win, name, visible) {
	var layer = GetPageLayer(win, name); 
	if (layer != null) {
		if (visible) {
			if (env.isN && (env.version == 4)) layer.visibility = "show";
			else layer.visibility = "visible";
		}
		else {
			if (env.isN && (env.version == 4)) layer.visibility = "hide";
			else layer.visibility = "hidden";
		}
	}
}
		
function SetPageLayerClip(win, name, left, top, right, bottom) {
	var layer = GetPageLayer(win, name);
	if(layer) {
  	if (env.isN && (env.version == 4)) {
  		layer.clip.left=left;
  		layer.clip.top=top;
  		layer.clip.right=right;
  		layer.clip.bottom=bottom;
  	}
  	else layer.clip = 'rect('+top+' '+right+' '+bottom+' '+left+')';
  }
}

function SetRectVisible(w, n, vis) {
//alert(w.name+','+vis);
	SetPageLayerVisible(w,n+"RectTop",vis);
	SetPageLayerVisible(w,n+"RectLeft",vis);
	SetPageLayerVisible(w,n+"RectRight",vis);
	SetPageLayerVisible(w,n+"RectBottom",vis);
}

function MoveRect(w,n,r) {
	if (r.x1>r.x2) {r.right=r.x1; r.left=r.x2;} 
	else {r.left=r.x1; r.right=r.x2;}
	if (r.y1>r.y2) {r.bottom=r.y1; r.top=r.y2;} 
	else {r.top=r.y1; r.bottom=r.y2;}
	if ((r.x1!=r.x2) &&(r.y1!=r.y2)) ClipRect(w,n,r);
}

function ClipRect(w,n,r) {
	SetPageLayerClip(w,n+"RectTop",r.left,r.top,r.right,r.top+r.size);
	SetPageLayerClip(w,n+"RectLeft",r.left,r.top,r.left+r.size,r.bottom);
	SetPageLayerClip(w,n+"RectRight",r.right-r.size,r.top,r.right,r.bottom);
	SetPageLayerClip(w,n+"RectBottom",r.left,r.bottom-r.size,r.right,r.bottom);
}


function StartRect(w,n,r,e) {
	if (r.active) EndRect(w,n,r,e);
	else {
		r.x1=map.mouseX;
		r.y1=map.mouseY;
		r.left=map.mouseX;
		r.top=map.mouseY;
		r.right=r.left+1;
		r.bottom=r.top+1;
		ClipRect(w,n,r);
		r.active=true;
		SetRectVisible(w,n,true)
	}
	return false;
}

function EndRect(w,n,r,e) {
	r.active=false;
	SetRectVisible(w,n,false)
	return true;
}

function StartPoint(p, e) {
	if (p.active) EndPoint(p);
	else {
		p.left=map.mouseX;
		p.top=map.mouseY;
		p.right=p.left+1;
		p.bottom=p.top+1;
		p.active=true;
	}
}

function EndPoint(p) {p.active=false;}

function GetEnv() {
	env.isN=false;
	env.isIE=false;
	env.Win=false;
	env.version=0;
  if (navigator.appName=="Netscape") {
		env.isN=true;
		if (navigator.appVersion[0]=='4') 
			env.version = 4;
		else
			env.version = 5;
	} else if (window.opera) {
    env.isOP=true;
  }	else env.isIE = true;
	if (navigator.userAgent.indexOf("Win")!=-1) env.Win=true;
}


function SetSelect(n,sel) {l=GetLayer(n);l.select=sel;}

function AddSelect(n,sel) {
  l=GetLayer(n);
  if (l.select!='') {l.select=l.select+','+sel;}
  else {l.select=sel;}
}

function SetLayer(n,visible,interface_without_refresh) {
  l=GetLayer(n);
  if (l.visible != visible) {
    ChangeLayerVisible(n,null,interface_without_refresh);
  }
}

function ClearCollSelect(coll) {
	for(var l in coll) {
		coll[l].select='';
		if (coll[l].layers) ClearCollSelect(coll[l].layers);
	}
}

function ClearSelect(norefresh) {
	if (ClearSelect.arguments.length==0) norefresh=false;
	var sel_l=GetPageLayer(f_map,"MapSelect");
	if (sel_l!=null) SetPageLayerVisible(f_map,"MapSelect",false);
	for(var l in layer) {
		layer[l].select='';
		if (layer[l].layers) ClearCollSelect(layer[l].layers);
	}
	if (!norefresh) Refresh();
}

function ImgOn(n){return img[n+'_on'].src;}
function ImgOff(n){return img[n+'_off'].src;}

function GetLayer(n) {
	var arr=n.split(".");
	if (arr.length==1) return layer[n];
	else {
		var l=layer[arr[0]];
		for(var i=1;i<arr.length;i++) {l=l.layers[arr[i]];}
		return l;
	}
}

function LinkIt(script,name) {
  if (name=='') name = 'Link';
  var w = window.open('',name,'');
  w.location.href = script;
  w.focus();
}
function UnsetAllLayersVisible(d,l,coll,level,interface_without_refresh) {
	if (coll!='') SetLayer(coll,false,interface_without_refresh);
	var arr=new Array();
	var i=0;
	for(var name in (coll!=''?l.layers:l)) {arr[i]=name; i++;}
	for(i=arr.length-1;i>=0;i--) {
		var sl=(coll!=''?l.layers[arr[i]]:l[arr[i]]);
		if (!(sl.title=='')) {
			if (sl.layers!=null) UnsetAllLayersVisible(d,sl,(coll!=''?coll+'.':'')+arr[i],level+1,interface_without_refresh);
			else {
        SetLayer(((coll!=''?coll+'.':'')+arr[i]),false,interface_without_refresh)
      }
		}
	}
	delete arr;
}
function SetInterfaceLayers(d,l,coll,level,s_layer) {
	if (coll!='') { var t_layer = SetInterfaceLayer(coll,s_layer);}
  if(!t_layer) {
  	var arr=new Array();
  	var i=0;
  	for(var name in (coll!=''?l.layers:l)) {arr[i]=name; i++;}
  	for(i=arr.length-1;i>=0;i--) {
  		var sl=(coll!=''?l.layers[arr[i]]:l[arr[i]]);
  		if (!(sl.title=='')) {
  			if (sl.layers!=null) {SetInterfaceLayers(d,sl,(coll!=''?coll+'.':'')+arr[i],level+1,s_layer);}
  			else {
          var layer = SetInterfaceLayer((coll!=''?coll+'.':'')+arr[i],s_layer);
          if (layer) {visible_layers.current = layer;return true;}
        }
  		}
  	}
  	delete arr;
  } else {
    visible_layers.current = t_layer;
    return true;
  }  
}

function SetInterfaceLayer(name,s_layer) {
  var layers_arr=name.split('.');
  if (s_layer == layers_arr[layers_arr.length-1]) return name;
  else return false;
}


if(typeof HTMLElement!="undefined" && !HTMLElement.prototype.insertAdjacentElement){
	HTMLElement.prototype.insertAdjacentElement2 = function(where,parsedNode)
	{
		switch (where){
		case 'beforeBegin':
			this.parentNode.insertBefore(parsedNode,this)
			break;
		case 'afterBegin':
			this.insertBefore(parsedNode,this.firstChild);
			break;
		case 'beforeEnd':
			this.appendChild(parsedNode);
			break;
		case 'afterEnd':
			if (this.nextSibling) this.parentNode.insertBefore(parsedNode,this.nextSibling);
			else this.parentNode.appendChild(parsedNode);
			break;
		}
	}

	HTMLElement.prototype.insertAdjacentHTML2 = function(where,htmlStr)
	{
		var r = this.ownerDocument.createRange();
		r.setStartBefore(this);
		var parsedHTML = r.createContextualFragment(htmlStr);
		this.insertAdjacentElement2(where,parsedHTML)
	}

	HTMLElement.prototype.insertAdjacentText2 = function(where,txtStr)
	{
		var parsedText = document.createTextNode(txtStr)
		this.insertAdjacentElement2(where,parsedText)
	}
}
