<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: route_soap_functions.inc,v 1.6 2006/11/29 10:20:19 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

function ProcessResult ($result) {
  if ($result['err']) {
    return new soap_fault($result['err'], '', $result['errmsg']);
  } else {
    return $result;
  }
}

function GetRouteObject() {
  static $r;
  if ($r) return $r;
  include_once(Fileup2(".admin/access_map_.inc"));
  require(FileUp2(".admin/route_schema.inc"));
  $MAP_ROUTE = MapAccessArray($MAP_ROUTE);
  require_once(FileUp2(".admin/route/main_route.inc"));
  $params['request'] = false;
  $params['properties'] = $MAP_ROUTE; 
  $r = new Route($params);
  return $r;
}

function Coord2Node($x, $y, $epsg) {
  $r = GetRouteObject();
  $r->SetRequest(array(
    'command'=>'Coord2Node',
    'x'=>$x,
    'y'=>$y,
    'epsg'=>$epsg
  ));
  $GLOBALS['RouteLogRequest'] = $r->request['command'];
  $result = $r->ProcessCommand();
  return ProcessResult($result);
}

function Coord2NodeM($coords, $epsg) {
  $r = GetRouteObject();
  $r->SetRequest(array(
    'command'=>'Coord2NodeM',
    'coords'=>$coords,
    'epsg'=>$epsg
  ));
  $GLOBALS['RouteLogRequest'] = $r->request['command'];
  $result = $r->ProcessCommand();
  return ProcessResult($result);
}

function RouteBasicInfo($nodes, $routetype, $epsg) {
  $r = GetRouteObject();
  $r->SetRequest(array(
    'command'=>'RouteBasicInfo',
    'nodes'=>$nodes,
    'routetype'=>$routetype,
    'epsg'=>$epsg
  ));
  $GLOBALS['RouteLogRequest'] = $r->request['command'];
  $result = $r->ProcessCommand();
  return ProcessResult($result);
}

function RouteItinerary($nodes, $routetype, $epsg) {
  $r = GetRouteObject();
  $r->SetRequest(array(
    'command'=>'RouteItinerary',
    'nodes'=>$nodes,
    'routetype'=>$routetype,
    'epsg'=>$epsg,
    'format'=>'ItineraryXML'
  ));
  $GLOBALS['RouteLogRequest'] = $r->request['command'];
  $r->ProcessCommand();
  $o = $r->GetOutputObject();
  $result = $o->ProcessItinerary();
  return ProcessResult($result['result']);
}

function RouteMap($nodes, $routetype, $epsg, $bbox, $width, $height, $imageformat) {
  $r = GetRouteObject();
  $r->SetRequest(array(
    'command'=>'RouteMap',
    'nodes'=>$nodes,
    'routetype'=>$routetype,
    'epsg'=>$epsg,
    'bbox'=>$bbox,
    'width'=>$width,
    'height'=>$height,
    'imageformat'=>$imageformat
  ));
  $GLOBALS['RouteLogRequest'] = $r->request['command'];
  $result = $r->ProcessCommand();
  return ProcessResult($result);
}

function RouteProfile($nodes, $routetype, $epsg, $width, $height, $imageformat, $labels) {
  $r = GetRouteObject();
  $r->SetRequest(array(
    'command'=>'RouteProfile',
    'nodes'=>$nodes,
    'routetype'=>$routetype,
    'epsg'=>$epsg,
    'width'=>$width,
    'height'=>$height,
    'imageformat'=>$imageformat,
    'labels'=>$labels
  ));
  $GLOBALS['RouteLogRequest'] = $r->request['command'];
  $result = $r->ProcessCommand();
  return ProcessResult($result);
}

function RouteErrorMsg($errcode) {
  $r = GetRouteObject();
  $r->SetRequest(array(
    'command'=>'RouteErrorMsg',
    'errcode'=>$errcode
  ));
  $GLOBALS['RouteLogRequest'] = $r->request['command'];
  $result = $r->ProcessCommand();
  return ProcessResult($result);
}



?>
