<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: route_soap.inc,v 1.6 2006/11/29 10:19:59 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

include_once(Fileup2(".admin/db/db_default.inc"));
include_once(Fileup2(".admin/access_.inc"));
if (!Access()) die();
require_once($GLOBALS["TMAPY_LIB"]."/lib/nusoap/lib/nusoap.php");
include_once(Fileup2(".admin/route/route_soap_functions.inc"));

$debug=false;
$server = new soap_server();
$server->configureWSDL('routewsdl', 'urn:routewsdl', $_SERVER["SCRIPT_URI"]);

/**** WSDL *******************************************/

//RouteNodeInfo structure
$server->wsdl->addComplexType(
  'NodeInfo','complexType','struct','all','',
  array(
    'node'=>array('name'=>'node','type'=>'xsd:integer'),
    'dist'=>array('name'=>'dist','type'=>'xsd:double'),
    'id'=>array('name'=>'id','type'=>'xsd:string')
  )
);
//RouteNodeInfoArray structure
$server->wsdl->addComplexType(
  'NodeInfoArray','complexType','array','','SOAP-ENC:Array',array(),
  array(
    array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:NodeInfo[]')
  ),
  'tns:NodeInfo'
);

//RouteExtentInfo structure
$server->wsdl->addComplexType(
  'ExtentInfo','complexType','struct','all','',
  array(
    'minx'=>array('name'=>'minx','type'=>'xsd:double'),
    'miny'=>array('name'=>'miny','type'=>'xsd:double'),
    'maxx'=>array('name'=>'maxx','type'=>'xsd:double'),
    'maxy'=>array('name'=>'maxy','type'=>'xsd:double'),
  )
);
//RouteBasicInfo structure
$server->wsdl->addComplexType(
  'RouteBasicInfo','complexType','struct','all','',
  array(
    'dist'=>array('name'=>'dist','type'=>'xsd:double'),
    'time'=>array('name'=>'time','type'=>'xsd:double')
  )
);
//RouteItineraryItem structure
$server->wsdl->addComplexType(
  'RouteItineraryItem','complexType','struct','all','',
  array(
    'node_id'=>array('name'=>'node_id','type'=>'xsd:int'),
    'x'=>array('name'=>'x','type'=>'xsd:double'),
    'y'=>array('name'=>'y','type'=>'xsd:double'),
    'desc'=>array('name'=>'desc','type'=>'xsd:string'),
    'drive'=>array('name'=>'drive','type'=>'xsd:string'),
    'road_number'=>array('name'=>'road_number','type'=>'xsd:string'),
    'road_type'=>array('name'=>'road_type','type'=>'xsd:int'),
    'time'=>array('name'=>'time','type'=>'xsd:double'),
    'totaltime'=>array('name'=>'totaltime','type'=>'xsd:double'),
    'dist'=>array('name'=>'dist','type'=>'xsd:double'),
    'totaldist'=>array('name'=>'totaldist','type'=>'xsd:double'),
    'fee'=>array('name'=>'fee','type'=>'xsd:boolean'),
  )
);
//RouteItineraryArray structure
$server->wsdl->addComplexType(
  'RouteItineraryArray','complexType','array','','SOAP-ENC:Array',array(),
  array(
    array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:RouteItineraryItem[]')
  ),
  'tns:RouteItineraryItem'
);
//RouteItineraryInfo structure
$server->wsdl->addComplexType(
  'RouteItineraryInfo','complexType','struct','all','',
  array(
    'extent'=>array('name'=>'extent', 'type'=>'tns:ExtentInfo'),
    'itinerary'=>array('name'=>'itinerary','type'=>'tns:RouteItineraryArray'),
  )
);

//RouteProfileInfo structure
$server->wsdl->addComplexType(
  'RouteProfileInfo','complexType','struct','all','',
  array(
    'min'=>array('name'=>'min','type'=>'xsd:double'),
    'max'=>array('name'=>'max','type'=>'xsd:double'),
    'up'=>array('name'=>'up','type'=>'xsd:double'),
    'down'=>array('name'=>'down','type'=>'xsd:double'),
    'url'=>array('name'=>'time','type'=>'xsd:string'),
  )
);
//RouteErrorInfo structure
$server->wsdl->addComplexType(
  'RouteErrorInfo','complexType','struct','all','',
  array(
    'errcode'=>array('name'=>'errcode','type'=>'xsd:string'),
    'errmsg'=>array('name'=>'errmsg','type'=>'xsd:string')
  )
);
//RouteMapInfo structure
$server->wsdl->addComplexType(
  'RouteMapInfo','complexType','struct','all','',
  array(
    'dist'=>array('name'=>'dist','type'=>'xsd:double'),
    'time'=>array('name'=>'time','type'=>'xsd:double'),
    'url'=>array('name'=>'time','type'=>'xsd:string'),
  )
);

/**** REGISTER *******************************************/

//Coordinate2Node
$server->register('Coord2Node',           // method name
  array(
    'x' => 'xsd:double',
    'y' => 'xsd:double',
    'epsg'  => 'xsd:int',
  ),                                  // input parameters
  array('return' => 'tns:NodeInfo'),   // output parameters
  'urn:routewsdl',                   // namespace
  'urn:routewsdl#Coord2Node',  // soapaction
  'rpc',                              // style
  'encoded',                          // use
  'Returns nearest node id from a point defined by coordinates. Parameters: x=[x-coord], y=[y-coord], epsg=[projection code (http://www.epsg.org)]. Returns node id and the distance to it.'            // documentation
);

//Coordinate2NodeM
$server->register('Coord2NodeM',           // method name
  array(
    'coords' => 'xsd:string',
    'epsg'  => 'xsd:int',
  ),                                  // input parameters
  array('return' => 'tns:NodeInfoArray'),   // output parameters
  'urn:routewsdl',                   // namespace
  'urn:routewsdl#Coord2NodeM',  // soapaction
  'rpc',                              // style
  'encoded',                          // use
  'Returns nearest node ids from points defined by coordinate pairs x:y(:id) delimited by |. Third parameter id is optional and will be return with node info. Parameters: coords=[x-coord]:[y-coord](:[id])|..., epsg=[projection code (http://www.epsg.org)]. Returns node ids and the distances to it. Max coord pair count is 25.'            // documentation
);

//RouteBasicInfo
$server->register('RouteBasicInfo',           // method name
  array(
    'nodes' => 'xsd:string',
    'routetype' => 'xsd:int',
//    'epsg'  => 'xsd:int',
  ),                                  // input parameters
  array('return' => 'tns:RouteBasicInfo'),   // output parameters
  'urn:routewsdl',                   // namespace
  'urn:routewsdl#RouteBasicInfo',  // soapaction
  'rpc',                              // style
  'encoded',                          // use
  'Returns basic informations about a route between nodes. Parameters: nodes=[node ids delimited by ,], routetype=[1-fastest, 2-shortest]. Returns the distance and the time.'            // documentation
);

//RouteItinerary
$server->register('RouteItinerary',           // method name
  array(
    'nodes' => 'xsd:string',
    'routetype' => 'xsd:int',
    'epsg'  => 'xsd:int',
  ),                                  // input parameters
  array('return' => 'tns:RouteItineraryInfo'),   // output parameters
  'urn:routewsdl',                   // namespace
  'urn:routewsdl#RouteItinerary',  // soapaction
  'rpc',                              // style
  'encoded',                          // use
  'Returns itinerary informations about a route between nodes. Parameters: nodes=[node ids delimited by ,], routetype=[1-fastest, 2-shortest], epsg=[projection code (http://www.epsg.org)]. Returns structured informations.'            // documentation
);

//RouteMap
$server->register('RouteMap',           // method name
  array(
    'nodes' => 'xsd:string',
    'routetype' => 'xsd:int',
    'epsg' => 'xsd:int',
    'bbox' => 'xsd:string',
    'width' => 'xsd:int',
    'height' => 'xsd:int',
    'imageformat' => 'xsd:string'
  ),                                  // input parameters
  array('return' => 'tns:RouteMapInfo'),   // output parameters
  'urn:routewsdl',                   // namespace
  'urn:routewsdl#RouteMap',  // soapaction
  'rpc',                              // style
  'encoded',                          // use
  'Returns url to an image with a route between nodes. Parameters: nodes=[node ids delimited by ,], routetype=[1-fastest, 2-shortest], epsg=[projection code (http://www.epsg.org)], bbox=[minx,miny,maxx,maxy], width=[width of the image], height=[height of the image], imageformat=[GIF|PNG|JPEG]. '
);

//RouteProfile
$server->register('RouteProfile',           // method name
  array(
    'nodes' => 'xsd:string',
    'routetype' => 'xsd:int',
//    'epsg' => 'xsd:int',
    'width' => 'xsd:int',
    'height' => 'xsd:int',
    'imageformat' => 'xsd:string',
    'labels' => 'xsd:int'
  ),                                  // input parameters
  array('return' => 'tns:RouteProfileInfo'),   // output parameters
  'urn:routewsdl',                   // namespace
  'urn:routewsdl#RouteProfile',  // soapaction
  'rpc',                              // style
  'encoded',                          // use
  'Returns url to an image of route profile and min, max elevation and superelevations. Parameters: nodes=[node ids delimited by ,], routetype=[1-fastest, 2-shortest], width=[width of the image], height=[height of the image], imageformat=[GIF|PNG|JPEG], labels=[0|1-axis|2-labels|3-axis+labels].'
);

//RouteErrorMsg
$server->register('RouteErrorMsg',           // method name
  array(
    'errcode' => 'xsd:string'
  ),                                        // input parameters
  array('return' => 'tns:RouteErrorInfo'),   // output parameters
  'urn:routewsdl',                          // namespace
  'urn:routewsdl#RouteErrorMsg',           // soapaction
  'rpc',                                    // style
  'encoded',                                // use
  'Returns an error message for the error code.'            // documentation
);

/**** SERVICE *******************************************/
$HTTP_RAW_POST_DATA = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : '';
@$server->service($HTTP_RAW_POST_DATA);

?>
