<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_route_engine.inc,v 1.16 2006/11/16 08:35:03 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class RouteEngine {
  var $properties;
  var $cache;

  function RouteEngine($properties, $cache) {
    $this->properties = $properties;
    if (!$this->properties['epsg']) $this->properties['epsg']=4326;
    $this->cache = $cache;
  }
  
  function RouteItinerary($nodes, $routetype, $epsg) {
    
    $r = $this->RouteInfo($nodes, $routetype, $epsg);
    
    if ($r['err']) {
      return $r;
    } else {
      $result = $this->_ProcessItinerary(&$r, $epsg);
      $result['err']=$r['err']; 
      return $this->_PrepareResult($result);
    }
  }
  
  function _PrepareResult($result) {
    if ($result['err']) {
      $result['err'] = 'RE'.abs($result['err']);
    } else {
      unset($result['err']);
    }
    return $result;
  }

  function _ProcessItinerary ($r, $epsg) {
    function ItinerarySetExtent($ext, $x, $y) {
      if (!isset($ext['minx']) || $ext['minx'] > $x) $ext['minx'] = $x;
      if (!isset($ext['maxx']) || $ext['maxx'] < $x) $ext['maxx'] = $x;
      if (!isset($ext['miny']) || $ext['miny'] > $y) $ext['miny'] = $y;
      if (!isset($ext['maxy']) || $ext['maxy'] < $y) $ext['maxy'] = $y;
    } 
    function ItineraryProjectExtent($obj, $ext, $epsg) {
      $pts = array();
      $pts[0] = $obj->_ConvertCoord($ext['minx'],$ext['miny'],(integer)$epsg,'from_network');
      $pts[1] = $obj->_ConvertCoord($ext['maxx'],$ext['maxy'],(integer)$epsg,'from_network');
      $pts[2] = $obj->_ConvertCoord($ext['minx'],$ext['maxy'],(integer)$epsg,'from_network');
      $pts[3] = $obj->_ConvertCoord($ext['maxx'],$ext['miny'],(integer)$epsg,'from_network');
      $ext2 = array();
      foreach($pts as $val) {
        ItinerarySetExtent(&$ext2, $val['x'], $val['y']);
      }
      $ext = $ext2;
    } 


    if (!$epsg) $epsg=4326;

    $gr = $this->properties['itinerary']['break_rules'];
    $gr_values = $this->properties['itinerary']['break_values'];
    $gr_cache = array();

    $result = array('extent'=>array(), 'itinerary'=>array());
    $glink = array();
    $last_key = Count($r['data']);
    $dir_to_cache = array();
    $ext = array();
    for ($key=0; $key<=$last_key; $key++) {
      if ($key == $last_key) {
        //$link = $r['data'][$key-1]; 
        //$link_attr = array();
        $attr['node'] = $this->GetNodeInfo($link['nodeto']['id']); 
        $attr['node_int'] = $link['nodeto'];
      } else {
        $link = $r['data'][$key]; 
        $attr['link'] = $this->GetLinkInfo($link['linkid']);
        $attr['node'] = $this->GetNodeInfo($link['nodefrom']['id']);
        $attr['node_int'] = $link['nodefrom'];
      }
      
      ItinerarySetExtent(&$result['extent'], $attr['node_int']['x'], $attr['node_int']['y']);
      
      $this->_AssignDriveToDirectionAtributes(&$result['itinerary'], false, &$attr['link'], &$link, $glink['node']['attr']);
      
      //Groupping rules
      $this->_GetBreakValues(&$gr_values, &$gr_cache, &$attr);

      $this->_GetGroupBreak(&$gr, &$group_break, &$gr_cache, &$attr, $r['data'][$key-1]['turn']);
      //print_R($gr_cache['values']);
      //$group_break['break'] = true;
      if (!$group_break['break'] && $key > 0 && $key < $last_key) {
        $glink['link']['dist'] = (double)$glink['link']['dist'] + (double)$link['dist']; 
        $glink['link']['time'] = (double)$glink['link']['time'] + (double)$link['time']; 
        $glink['link']['totaldist'] = (double)$link['totaldist']; 
        $glink['link']['totaltime'] = (double)$link['totaltime'];
        //$glink['link']['turn'] = $link['turn'];
        continue; 
      } else {
        if ($glink) {
          $glink['break_index'] = $group_break['index'];
          foreach ($gr_values as $value_key=>$value_val) {
            if ($gr_cache['values'][$value_key]['last_next_waiting'] == 1) {
              $glink[$value_val['type']]['attr'][$value_key] = $gr_cache['values'][$value_key]['last_next'];
              $gr_cache['values'][$value_key]['last_next_waiting'] = 0;
            } elseif ($gr_cache['values'][$value_key]['last']) {
              $glink[$value_val['type']]['attr'][$value_key] = $gr_cache['values'][$value_key]['last'];
            }
          }
          
          $result['itinerary'][] = $glink;
        }
        $glink = array(
          'node'=>($key==$last_key)?$link['nodeto']:$link['nodefrom'],
          'link'=>array(
            'dist'=>$link['dist'],
            'time'=>$link['time'],
            'totaldist'=>$link['totaldist'],
            'totaltime'=>$link['totaltime'],
            'turn'=>$r['data'][$key-1]['turn'],
//            'zattributes'=>$link_attr
          )
        );
        if ($key==$last_key) {
          unset($glink['link']);
        } else {
          $this->_AssignAtributes(&$glink['link'], &$attr['link'], $this->properties['itinerary']['link_attributes']);
          $this->_AssignDriveToDirectionAtributes(&$result['itinerary'], &$glink['link'], &$attr['link'], &$link);
        }
        $this->_AssignAtributes(&$glink['node'], &$attr['node'], $this->properties['itinerary']['node_attributes']);

        $pt = $this->_ConvertCoord($glink['node']['x'],$glink['node']['y'],(integer)$epsg,'from_network');
        $glink['node']['x'] = $pt['x'];
        $glink['node']['y'] = $pt['y'];

        //echo($key.'<br>');
        if ($key==0) $glink['node']['start']=1;
        elseif ($key==$last_key) {
          $glink['node']['end']=1;
          $this->_AssignDriveToDirectionAtributes(&$result['itinerary'], false, &$attr['link'], &$link, &$glink['node']['attr'], true);
        }
      }
    }
    $result['itinerary'][] = $glink;
    ItineraryProjectExtent($this, &$result['extent'], $epsg);
    return $result;
  }

  function _ProcessProfile ($r,$width, $height, $imageformat, $labels) {


    function callbackmarkprofile($val) {
      static $i=0;
      return array($GLOBALS['TMS_ProcessProfile']['urban'][$i++]?2:0,$GLOBALS['TMS_ProcessProfile']['urban_color'],$GLOBALS['TMS_ProcessProfile']['urban_color']); 
    }
    
    function callbackvalueprofile($val) {
      static $i=0;
      return (string)$GLOBALS['TMS_ProcessProfile']['labels'][$i++];
    }

    DEFINE("TTF_DIR",$this->properties['profile']['ttf_dir']);
    require_once(FileUp2(".admin/connector/route/output/lib/jpgraph/src/jpgraph.php"));
    require_once(FileUp2(".admin/connector/route/output/lib/jpgraph/src/jpgraph_line.php"));
    $img_house = FileUp2('.admin/connector/route/output/images/house.gif');
    
    $GLOBALS['TMS_ProcessProfile'] = array('labels'=>array(),'urban'=>array(), 'urban_color'=>$this->properties['profile']['renderer']['urban_color']);
    $data = array();
    $extrem = array('max'=>-1000,'min'=>1000000);
    $sum_h = array('up'=>0,'down'=>0); 
    $last_h = null; 
    $min_dist = $this->properties['profile']['label_min_dist']?$this->properties['profile']['label_min_dist']:12;
    //print_R($this);die();
    $last = '';
    $i = 0;
    $count = Count($r['data']);
    $j = 0;
    foreach ($r['data'] as $pt) {
      if ($pt['elv'] != '?') {
        $data['x'][] = $pt['len']/1000;
        $data['y'][] = $pt['elv'];
        if ($extrem['max'] < $pt['elv']) $extrem['max'] = $pt['elv'];
        if ($extrem['min'] > $pt['elv']) $extrem['min'] = $pt['elv'];
        
        if (!Is_null($last_h)) {
          $dh = $pt['elv']-$last_h;
          if ($dh > 0)
            $sum_h['up'] += $dh;
          else
            $sum_h['down'] += $dh;
        }
        $last_h = $pt['elv']?$pt['elv']:$last_h;
        
        if ($this->properties['profile']['node_urban'] && $this->properties['profile']['renderer']['urban_color']) {
          $urban = $pt['node']['data'][$this->properties['profile']['node_urban']];
          $GLOBALS['TMS_ProcessProfile']['urban'][] = $urban;
        } else {
          $urban = 1;
        }
        $label = iconv(
            $this->properties['code_page'],
            $this->properties['profile']['node_value_code_page'], 
            $pt['node']['data'][$this->properties['profile']['node_value']]
          );
        $j++;
        $i++;
        if ((($j > $min_dist) || ($i==2)) && $last != $label && $label && $urban && ($i<$count-10)) {
          $GLOBALS['TMS_ProcessProfile']['labels'][] = $label;
          $j = 0;
          $last = $label;
        } else {
          $GLOBALS['TMS_ProcessProfile']['labels'][] = '';
        } 
      }
    }
    
    $graph = new Graph($width,$height,'auto');
    $format = strtolower($imageformat?$imageformat:'gif');
    $graph->SetImgFormat($format,85);
    //$graph->SetBackgroundGradient('blue','navy:0.5',GRAD_HOR,BGRAD_MARGIN);
    //$graph->SetColor(0);
    $graph->SetFrame(false);   
    $graph->SetColor('white');
    $graph->SetBackgroundGradient($this->properties['profile']['renderer']['background_gradient']['from'],$this->properties['profile']['renderer']['background_gradient']['to'],GRAD_HOR,BGRAD_PLOT);    
    //$graph->SetBackgroundImage(FileUp2('images/sky.jpg'),BGIMG_FILLPLOT,'auto');
    //$graph->SetTickDensity(TICKD_DENSE);    

    //$graph->SetScale("linlin");
    $graph->SetScale('linlin',0,0,0,$data['x'][Count($data['x'])-1]); 

    if ($labels==1 || $labels == 3) {
      $graph->SetMargin(35,40,20,10);	
      $graph->xaxis->hideline();
      $graph->xaxis->hideticks();
      $graph->xaxis->HideFirstTicklabel();
      $graph->xaxis->SetPos('max');
      $graph->xaxis->SetLabelSide(SIDE_TOP);
      $graph->xaxis->SetTickSide(SIDE_DOWN);
      $graph->xaxis->SetFont(FF_ARIAL,FS_NORMAL,9); 
      $graph->xaxis->SetTitleSide(SIDE_TOP);
      $graph->xaxis->SetTitlemargin(-5);
      //$graph->xaxis->SetLabelAngle(90); 
      //$graph->xaxis->title->Set('km');
      //$graph->yaxis->title->Set('m n.m.');

      $graph->yaxis->hideline();
      $graph->yaxis->hideticks();
      //$graph->yaxis->HideFirstTicklabel();
      $graph->yaxis->HideLastTicklabel();
      $graph->yaxis->SetFont(FF_ARIAL,FS_NORMAL,9);
      //$graph->ygrid->SetFill(true,'#FFFFFF@0.5','#AAAAAA@0.9'); 
      $graph->xgrid->Show();
      $graph->xgrid->SetColor($this->properties['profile']['renderer']['grid_color']);       
      $graph->xgrid->SetLineStyle('dashed');       
      $graph->ygrid->SetColor($this->properties['profile']['renderer']['grid_color']);       
      $graph->ygrid->SetLineStyle('dashed');

    } else {
      $graph->SetMargin(0,0,0,0);	
      $graph->xaxis->hide();
      $graph->yaxis->hide();
    }
    
    $dh = $extrem['max']-$extrem['min'];
    $coef = 300-($dh/1.5);
    $coef = 10+($coef<0?0:Round($coef));
    $graph->yaxis->scale->SetGrace($coef,5);
    
    $p1 = new LinePlot($data['y'],$data['x']);
    $p1->SetColor($this->properties['profile']['renderer']['line_color']);
    $p1->SetFillGradient($this->properties['profile']['renderer']['fill_gradient']['from'],$this->properties['profile']['renderer']['fill_gradient']['to']);
    if ($this->properties['profile']['renderer']['urban_color']) {
      $p1->mark->SetCallback('callbackmarkprofile');
      $p1->mark->SetType(MARK_SQUARE);
      $p1->mark->SetWeight(0);
      $p1->mark->SetSize(0); 
      $p1->mark->show();
    }
    $graph->Add($p1);

    if ($labels > 1) {
      $p2 = new LinePlot($data['y'],$data['x']);
      $p2->SetColor($this->properties['profile']['renderer']['line_color']);
      $p2->value->SetFormatCallback('callbackvalueprofile');
      $p2->value->SetAlign('left');
      $const = get_defined_constants();
      $p2->value->SetFont($const[$this->properties['profile']['renderer']['label_font']],$const[$this->properties['profile']['renderer']['label_style']],$this->properties['profile']['renderer']['label_size']);
      $p2->value->SetAngle($this->properties['profile']['renderer']['label_angle']); 
      $p2->value->SetMargin(5);  
      $p2->value->show();
      $graph->Add($p2);
    }

    //$p1->SetFillcolor('#115511');

    $tmpfile = tempnam($this->properties['profile']['imagepath'],'prf').'.'.$format;
    //$tmpfile = '';
    $graph->Stroke($tmpfile);
    //die();
    return array('min'=>$extrem['min'], 'max'=>$extrem['max'], 'up'=>$sum_h['up'], 'down'=>$sum_h['down'], 'url'=>$this->properties['profile']['imageurl'].BaseName($tmpfile));
  }
  
  function _PrepareNodes($nodes) {
    $nodes = explode(',', $nodes);
    $result = array('type'=>'node','data'=>array());
    foreach ($nodes as $val) {
      if (preg_match('/^([-]{0,1}\d+[.]{0,1}\d*) ([-]{0,1}\d+[.]{0,1}\d*):(\w)/', $val, $res)) {
        $result['type'] = 'coord';
        $result['data'][] = array('x'=>$res[1], 'y'=>$res[2], 'type'=>$res[2]);
      } elseif (preg_match('/^([-]{0,1}\d+[.]{0,1}\d*) ([-]{0,1}\d+[.]{0,1}\d*)/', $val, $res)) {
        $result['type'] = 'coord';
        $result['data'][] = array('x'=>$res[1], 'y'=>$res[2], 'type'=>'n');
      } elseif (preg_match('/^(\d+):(\w)/', $val, $res)) {
        $result['data'][] = array('id'=>$res[1], 'type'=>$res[2]);
      } else {
        $result['data'][] = array('id'=>$val, 'type'=>'n');
      }
    }
    return $result; 
  }

  function _AssignAtributes($link, $attr, $params) {
    foreach ($params as $key=>$val) {
      switch ($val['method']) {
        case 'sum':
           $link['attr'][$key] += $attr[$val['name']];
           if (!$link['attr'][$key]) unset($link['attr'][$key]);
        break;
        case 'first':
        default:
          if (!isset($link['attr'][$key])) {
            if ($attr[$val['name']])
              $link['attr'][$key] = $attr[$val['name']];
          }
        break;
      }
    }
  }
  function _AssignDriveToDirectionAtributes($result, $link, $attr, $attr2, $nodeattr=false, $force=false) {
    static $cache;
    if (!isset($cache)) $cache=array();
    $dir_atr = $this->properties['itinerary']['direction_attributes'];
    if ($link && $dir_atr) {
      if ($attr2['dir'] > 0 && $attr[$dir_atr['link_to']]) {
        $link['attr']['dir_to_drive'] = $attr[$dir_atr['link_to']];
      } elseif ($attr2['dir'] < 0 && $attr[$dir_atr['link_from']]) {
        $link['attr']['dir_to_drive'] = $attr[$dir_atr['link_from']];
      } else {
        $cache[] = Count($result);
      }
      return false;
    } else {
      if ($force) $cache[] = Count($result); 
    }
    if ($nodeattr[$dir_atr['node_municip']]) {
      foreach ($cache as $key=>$id) {
        if ($result[$id] && ($force || ($result[$id]['node']['attr'][$dir_atr['node_municip']] != $nodeattr[$dir_atr['node_municip']]))) {
          $result[$id]['link']['attr']['dir_to_drive'] = $nodeattr[$dir_atr['node_municip']];
          unset($cache[$key]);
        }
      }
    }
    
  }

  function _GetBreakValues($gr, $gr_cache, $attr) {

    foreach ($gr as $rulekey=>$rule) {
      if (!isset($gr_cache['values'][$rulekey]['last'])) {
        $gr_cache['values'][$rulekey]['last'] = false;
      } else {
        $gr_cache['values'][$rulekey]['last'] = $gr_cache['values'][$rulekey]['curr'];
      }
      switch ($rule['method']) {
        case 'border_checkpoint':
          $value = $attr[$rule['type']][$rule['field']];
          if (!isset($gr_cache['values'][$rulekey]['from'])) $gr_cache['values'][$rulekey]['from'] = $value;
          if ($gr_cache['values'][$rulekey]['last_next_waiting'] == -1) {
            $gr_cache['values'][$rulekey]['last_next_waiting'] = 1;
          }
          if ($gr_cache['values'][$rulekey]['from'] != $value) {
            $gr_cache['values'][$rulekey]['last_next'] = $gr_cache['values'][$rulekey]['from'].'-'.$value;
            $gr_cache['values'][$rulekey]['last_next_waiting'] = -1;
            $gr_cache['values'][$rulekey]['from'] = $value;
          }
        break;
        case 'comma_lists':
          $last = Explode(',', $gr_cache['values'][$rulekey]['last']);

          $intersects = array();
          $all_values = array();
          $break = false;  
          $sum = 0;
          foreach ($rule['fields'] as $fld) {
            if ($attr[$rule['type']][$fld]) {
              $value = Explode(',',$attr[$rule['type']][$fld]);
            } else {
              $value = array();
            }
            $first = false;
            if (!isset($gr_cache['values'][$rulekey]['fields'][$fld])) {
              $first = true;
              $gr_cache['values'][$rulekey]['fields'][$fld] = array();
            }
            $inter = array_intersect($gr_cache['values'][$rulekey]['fields'][$fld], $value);
            $sum += Count($inter);
            if (array_diff($gr_cache['values'][$rulekey]['fields'][$fld],$inter) || (!$inter && $value)) { 
              $gr_cache['values'][$rulekey]['fields'][$fld] = $inter; 
              $break = true;
              break;
            }
            $all_values = array_merge($all_values,$value);
          }
          $intersects = array_intersect($last, $all_values);
          if ($break || Count($all_values) == 0 || !$sum) {
            $all_values = array();
            foreach ($rule['fields'] as $fld) {
              if ($attr[$rule['type']][$fld]) {
                $value = Explode(',',$attr[$rule['type']][$fld]);
              } else {
                $value = array();
              }
              $gr_cache['values'][$rulekey]['fields'][$fld] = $value;
              $all_values = array_merge($all_values,$value);
            }
            $intersects = $all_values;
          }

          if (Count($intersects)) {
            $gr_cache['values'][$rulekey]['curr'] = Implode(',', $intersects);
          } else {
            $gr_cache['values'][$rulekey]['curr'] = Implode(',', $all_values);
          } 
        break;
      }
    }
    $attr['values'] = $gr_cache['values'];
  }
  
  function _GetGroupBreak($gr, $group_break, $gr_cache, $attr, $turn) {
    
    static $index;
    if (!isset($index)) $index = 0;
  
    $group_break['break'] = false;
    $group_break['index'] = -1;
    
    foreach ($gr as $rulekey=>$rule) {
      $value = $attr[$rule['type']][$rule['field']];
      $group_break['index'] = $rulekey;
      $group_break['level_last'] = ($rule['level'] && $index++)?$rule['level']:0;
      switch ($rule['method']) {
        case 'group_always':
          if (preg_match($rule['pattern'], $value)) break(2);
        break;
        case 'turn':
          if (($turn > $rule['from']) && ($turn < $rule['to'])) {
            $group_break['break'] = true;
          }
        break;
        case 'empty':
          if (!StrLen($value)) {
            echo $value;
            if ($rule['result'])
              $gr_cache[$rulekey]['result'] = $gr_cache[$rulekey]['lastvalue'];
            $group_break['break'] = true;
          }
        break;
        case 'change':
          if ($rule['pattern']) {
            $cond = preg_match($rule['pattern'],$value);
          } else {
            $cond = true;
          }
          if (($gr_cache[$rulekey]['lastvalue'] != $value)) {
            if (isset($gr_cache[$rulekey]['lastvalue']) && $cond) {
              if ($rule['result'])
                $gr_cache[$rulekey]['result'] = $gr_cache[$rulekey]['lastvalue'].$rule['result_delimiter'].$value;
              $group_break['break'] = true;
            }
            $gr_cache[$rulekey]['lastvalue'] = $value; 
          }
        break;
        case 'comma_list':
          if (!$gr_cache[$rulekey]['lastvalue']) $gr_cache[$rulekey]['lastvalue'] = array();
          $list = Explode(',', $value);
          //$gr_cache[$rulekey]['result_no_unset'] = 1;
          $gr_cache[$rulekey]['result'] = Implode(',',$gr_cache[$rulekey]['lastvalue']);
          $intersects = array_intersect($gr_cache[$rulekey]['lastvalue'], $list);
           if ($intersects) {
            $gr_cache[$rulekey]['lastvalue'] = $intersects;
          } else {
            $gr_cache[$rulekey]['lastvalue'] = $list;
            $group_break['break'] = true;
          }
        break;
        case 'comma_lists':
          //$gr_cache[$rulekey]['result_no_unset'] = 1;
          $gr_cache[$rulekey]['result'] = array();
          //$gr_cache[$rulekey]['prepared_result'] = array();
          foreach ($rule['fields'] as $fld) {
            $value = $attr[$rule['type']][$fld];
            $list[$fld] = Explode(',', $value);
            if (!isset($gr_cache[$rulekey]['lastvalue'][$fld]) && $list[$fld]) {
              $gr_cache[$rulekey]['lastvalue'][$fld] = array();;
            }
            foreach ($gr_cache[$rulekey]['lastvalue'][$fld] as $value) {
              if ($value) $gr_cache[$rulekey]['result'][] = $value;
            }
          }
          $gr_cache[$rulekey]['result'] = Implode(',', $gr_cache[$rulekey]['result']);
          foreach ($rule['fields'] as $fld) {
            $intersects = array_intersect($gr_cache[$rulekey]['lastvalue'][$fld], $list[$fld]);
            if ($intersects) {
              $gr_cache[$rulekey]['lastvalue'][$fld] = $intersects;
              //$gr_cache[$rulekey]['prepared_result'][] = Implode(',',$intersects);
            } else {
              $group_break['break'] = true;
              //$gr_cache['values'][$rule['result']]['curr'] = $gr_cache[$rulekey]['result'];  
            }
          }
          //$gr_cache[$rulekey]['prepared_result'] = Implode(',', $gr_cache[$rulekey]['prepared_result']);
          if ($group_break['break']) {
            foreach ($rule['fields'] as $fld) {
              $gr_cache[$rulekey]['lastvalue'][$fld] = $list[$fld];
            }
          }
        break;
        case 'border_checkpoint':
          if (preg_match($rule['pattern'], $value)) {
            $gr_cache[$rulekey]['result_on_next'] = $gr_cache[$rulekey]['lastvalue'].'-'.$link_attr[$rule['link_field']];
            $group_break['break'] = true;
          }
          $gr_cache[$rulekey]['lastvalue'] = $link_attr[$rule['link_field']];
        break;
        case 'preg_match':
          if (preg_match($rule['pattern'], $value)) {
            $group_break['break'] = true;
          }
        break;
      }
    }
    return $group_break;
  }  

  function _ConvertCoord($x,$y,$epsg=4326,$direction='to_network') {
    if (!$epsg) $epsg=4326;
    switch ($direction) {
      case 'from_network':
        $p_from = ms_newprojectionobj('init=epsg:'.$this->properties['epsg']);
        $p_to = ms_newprojectionobj('init=epsg:'.$epsg);
      break;
      case 'to_network':
      default:  
        $p_from = ms_newprojectionobj('init=epsg:'.$epsg);
        $p_to = ms_newprojectionobj('init=epsg:'.$this->properties['epsg']);
      break;
    }
    $ptobj = ms_newPointObj();
    $ptobj->setXY($x,$y);
    $result = false;
    if (@$ptobj->project($p_from, $p_to) == MS_SUCCESS) {
      $result = array('x'=>$ptobj->x, 'y'=>$ptobj->y);
    }
    $ptobj->free();
    return $result; 
  }
 
}
?>
