<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_route.inc,v 1.8 2007/03/07 07:53:41 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class Route {

  function Route($params) {
    $this->request = $params['request'];
    $this->properties = $params['properties'];
    //Cache
    if (!$this->properties['cache']['type']) $this->properties['cache']['type']='None'; 
    $file = FileUp2('.admin/connector/route/cache/'.$this->properties['cache']['type'].'.inc');
    if ($file) include_once($file);
    $cache = $this->properties['cache']['type'].'_RouteCache';
    $this->cache = new $cache($this->properties['cache']);
    //Engine
    $engine = $this->properties['engine']['type'];
    $file = FileUp2('.admin/connector/route/engine/'.$engine.'.inc');
    if ($file) include_once($file);
    else ErrorMsg(array('msg'=>'<b>Error:</b> Bad route engine connector '.$engine.' or connector is missing'));
    $engine .= '_RouteEngine';
    $this->engine = new $engine($this->properties['engine']['properties'], $this->cache);
    if ($this->request && !preg_match('/^\w+$/',$this->request['format'])) $this->request['format']='XML';
  }
  
  function SetRequest($request) {
    $this->request = $request; 
  } 
  
  function ProcessCommand() {
    $this->start = $this->microtime_float();
    $command = $this->request['command'];
    if (isset($this->properties['method_access'][$command]) && !$this->properties['method_access'][$command]) {
      $this->result = array('err'=>'RM2');
    } else {
      switch ($command) {
        case 'Coord2Node':
          $this->result = $this->_CallMethodWithParams(
            $this->request,$this->engine,'Coord2Node',
            array('x'=>'!double','y'=>'!double','epsg'=>'integer')
          );
        break;
        case 'Coord2NodeM':
          $this->result = $this->_CallMethodWithParams(
            $this->request,$this->engine,'Coord2NodeM',
            array('coords'=>'!/^[\d.]+:[\d.]+/','epsg'=>'integer')
          );
        break;
        case 'RouteBasicInfo':
          $this->result = $this->_CallMethodWithParams(
            $this->request,$this->engine,'RouteBasicInfo',
            array(
              'nodes'=>'!/^([1-9]+\d*:?.?,[1-9]+\d*[\d,]*:?.?|[- 0-9.,]+)/',
              'routetype'=>'integer',
              'epsg'=>'integer',
            )
          );
        break;
        case 'GetFile':
          $this->result = $this->_CallMethodWithParams(
            $this->request,$this->engine,'GetFile',
            array('filename'=>'!/\w+/','format'=>'!/\w+/')
          );
        break;
        case 'RouteGML':
          $this->result = $this->_CallMethodWithParams(
            $this->request,$this->engine,'RouteGML',
            array(
              'nodes'=>'!/^([1-9]+\d*:?.?,[1-9]+\d*[\d,]*:?.?|[- 0-9.,]+)/',
              'routetype'=>'integer',
              'epsg'=>'integer',
            )
          );
        break;
        case 'RouteSHP':
          $this->result = $this->_CallMethodWithParams(
            $this->request,$this->engine,'RouteSHP',
            array(
              'nodes'=>'!/^([1-9]+\d*:?.?,[1-9]+\d*[\d,]*:?.?|[- 0-9.,]+)/',
              'routetype'=>'integer',
              'epsg'=>'integer',
            )
          );
        break;
        case 'RouteMap':
          $this->result = $this->_CallMethodWithParams(
            $this->request,$this->engine,'RouteMap',
            array(
              'nodes'=>'!/^([1-9]+\d*:?.?,[1-9]+\d*[\d,]*:?.?|[- 0-9.,]+)/',
              'routetype'=>'integer',
              'epsg'=>'integer',
              'bbox'=>'!/^[0-9.]+,[0-9.]+,[0-9.]+,[0-9.]+$/',
              'width'=>'!/^[1-9]+\d*$/',
              'height'=>'!/^[1-9]+\d*$/',
              'imageformat'=>'/(GIF|PNG|JPEG)/',
            )
          );
        break;
        case 'RouteItinerary':
          $this->result = $this->_CallMethodWithParams(
            $this->request,$this->engine,'RouteItinerary',
            array(
              'nodes'=>'!/^([1-9]+\d*:?.?,[1-9]+\d*[\d,]*:?.?|[- 0-9.,]+)/',
              'routetype'=>'integer',
              'epsg'=>'integer',
            )
          );
        break;
        case 'RouteProfile':
          $this->result = $this->_CallMethodWithParams(
            $this->request,$this->engine,'RouteProfile',
            array(
              'nodes'=>'!/^([1-9]+\d*:?.?,[1-9]+\d*[\d,]*:?.?|[- 0-9.,]+)/',
              'routetype'=>'integer',
              'epsg'=>'integer',
              'width'=>'!/^[1-9]+\d*$/',
              'height'=>'!/^[1-9]+\d*$/',
              'imageformat'=>'/(GIF|PNG|JPEG)/',
              'labels'=>'/^(0|1|2|3)$/',
            )
          );
        break;
        case 'RouteErrorMsg':
          $this->result=array('errcode'=>$this->request['errcode']);
          $this->result['errmsg']=$this->GetErrorMessage($this->request['errcode']);
        break;
        default:
          $this->result = array('err'=>'RM1');
        break;
      }
    }
    if ($this->result['err']) {
      $this->result['errmsg'] = $this->GetErrorMessage($this->result['err']);
    }
    return $this->result;
  }
  
  function GetOutputObject() {
    $data = array();
    $data['command'] = $this->request['command'];
    $data['result'] = $this->result;
    $data['request_time'] = $this->microtime_float()-$this->start;

    //Output
    if (!$this->request['format']) $this->request['format'] = 'XML'; 
    $file = FileUp2('.admin/connector/route/output/'.$this->request['format'].'.inc');
    if ($file) include_once($file);
    $output = $this->request['format'].'_RouteOutput';
    $this->output = new $output($this->properties['output'][$this->request['format']],$this->cache);
    $this->output->SetData(&$data);
    $this->output->SetRequest(&$this->request);
    return $this->output;
  }
  
  function WriteResult() {
    $this->GetOutputObject();
    $this->output->WriteHeader();
    $this->output->WriteOutput();
  }

  function GetErrorMessage($code) {
    if (preg_match('/^RM([0-9]+)$/',$code)) $result=$this->RouteErrorMsg($code);
    elseif (preg_match('/^RE([-0-9]+)$/',$code)) $result=$this->engine->RouteErrorMsg($code);
    return $result;
  }

  function RouteErrorMsg($code) {
    $msg = array(
      'RM0'=>'No error',
      'RM1'=>'Method does not exists.',
      'RM2'=>'Method is forbidden.',
      'RM10'=>'Missing required parameter.',
      'RM11'=>'Bad value of a parameter.'
    );
    return $msg[$code];
  }
  
  function _CallMethodWithParams($request, $object, $method, $params) {
    $methodparams = array();
    foreach ($params as $key=>$val) {
      if (preg_match('/^!.*/', $val)) {
        if (!isset($request[$key])) {
          $this->result = array('err'=>'RM10');
          return $this->result;
        }
        if ( SubStr($val,1,1) == '/') {
          if (!preg_match(SubStr($val,1), $request[$key])) {
            $this->result = array('err'=>'RM11');
            return $this->result;
          }
        }
        $val = SubStr($val, 1);
      } else {
        if (SubStr($val,0,1) == '/' && !preg_match($val, $request[$key])) {
          $this->result = array('err'=>'RM11');
          return $this->result;
        }
      }
      switch ($val) {
        case 'double':
          $methodparams[]=(double)$request[$key];
        break;
        case 'integer':
          $methodparams[]=(integer)$request[$key];
        break;
        default:
          $methodparams[]=$request[$key];
        break;
      }
    }
    $this->cache->SetIdByParams(array(md5($object),$method,$methodparams));
    $this->result = $this->cache->Get();
    if (Is_Null($this->result)) {
      $this->result = call_user_func_array(array($object,$method),$methodparams);
      $this->cache->Set($this->result);
    }
    
    return $this->result; 
  }
  
  function microtime_float()
{
    list($usec, $sec) = explode(" ", microtime());
    return ((float)$usec + (float)$sec);
}

}
