<?php
require("tmapy_config.inc");

if(!isset($mode)) $mode = "print";

if (!preg_match('/^[a-z_]+$/',$client_lang)) $client_lang = 'cz_win';
$file_lg = FileUp2(".admin/lg/$client_lang.inc");
if (File_exists($file_lg)) require_once($file_lg);
$file_lg_app = FileUp2(".admin/lg/app_$client_lang.inc");
if (File_exists($file_lg_app)) include($file_lg_app);


include_once(FileUp2(".admin/main_manager_extent.inc"));
$extman = new ExtentManager($map);

$f = FileUp2(".admin/output_schema.inc");
if(file_exists($f)) include($f);
else {
  echo "Output schema missing.";
  include(FileUp2("html_footer.inc"));
  die();
}

if(!array_key_exists($mode,$MAP_OUTPUT)) {
  include(FileUp2("html_header.inc"));
  echo "Mode not supported: ".$mode;
  include(FileUp2("html_footer.inc"));
  die();
}

$separator_img = $MAP_OUTPUT[$mode][$client_type]['separator_img']?$MAP_OUTPUT[$mode][$client_type]['separator_img']:$MAP_OUTPUT[$mode]['default']['separator_img'];

if(!$just_print) {
  $sections = $MAP_OUTPUT[$mode][$client_type]['page_sections']?$MAP_OUTPUT[$mode][$client_type]['page_sections']:$MAP_OUTPUT[$mode]['default']['page_sections'];
  $submit_label = $MAP_OUTPUT[$mode][$client_type]['submit_label']?$MAP_OUTPUT[$mode][$client_type]['submit_label']:$MAP_OUTPUT[$mode]['default']['submit_label'];

  $arr = explode(",",$GLOBALS['BBOX']);
  $bbox_array = Array("minx"=>$arr[0],
                      "miny"=>$arr[1],
                      "maxx"=>$arr[2],
                      "maxy"=>$arr[3]);
  $SCALE = $extman->GetScale($bbox_array, $GLOBALS['WIDTH'], $GLOBALS['HEIGHT']);
  $PRINT=1;
  include(FileUp2(".admin/map_prepare.inc"));
  //die(print_r($map->tree));

  require(FileUp2("html_header.inc"));
  echo "<BODY class=\"print\">\n";
}

include_once(FileUp2(".admin/access_map_.inc"));
$metadata_schema = FileUp2(".admin/metadata_schema.inc");
if ($metadata_schema) {
  require($metadata_schema);
  $TOC_TREE_METADATA = MapAccessArray($TOC_TREE_METADATA);
}

// returns array of scale-limited-for-print layers
function PrintLimitedLayers($tree) {
  static $result = Array();
  foreach($tree as $layer=>$param) {
    $target_params = Array();
    $print_restricted = false;
    if($param['min_print_scale']) {
      $target_params['min'] = $param['min_print_scale'];
      $print_restricted = true;
    }
    if($param['max_print_scale']) {
      $target_params['max'] = $param['max_print_scale'];
      $print_restricted = true;
    }
    if($param['title']) $target_params['title'] = $param['title'];
    else $target_params['title'] = $layer;
    if($print_restricted) $result[$layer] = $target_params;
    if($param['layers']) array_merge($result,PrintLimitedLayers($param['layers']));
  }
  return $result;
}

function get_dat_aktualizace($xml) {
//  $xmlpath = FileUp2("xml/jdmp.xml");
  $xmlpath = $xml;

  $file = fOpen($xmlpath, "r");
  if ($file) {
    while (!feof($file)) {
      $xmldata .= FRead($file, 1024);
    }
    FClose($file);
  }
  $xmldata = strstr($xmldata, '<?xml');

  $xml = new XMLEx($xmldata);
  $xmlresult = "";
  $xmlresult = $xml->evaluate("//*");
  $aktualizace = false;
  reset($xmlresult);
  while (list($key, $val) = each($xmlresult)) {
    $attr = $xml->get_attributes ($val);
    if($attr["DAT_AKTUAL"]) {
      list($r,$m,$d) = explode("-",$attr["DAT_AKTUAL"]);
      $dat["DAT_AKTUAL"] = $d.".".$m.".".$r;
    }
    if($attr["NAZEV"]) $dat["NAZEV"] = $attr["NAZEV"];
    if($attr["POPIS"]) $dat["POPIS"] = $attr["POPIS"];
  }
  return($dat);
}

//modify extent with keeping scale
function ChangeExtentByImageSize($bbox, $width, $height, $new_width, $new_height) {
  $res = array();

  $dx = $bbox['maxx']-$bbox['minx'];
  $dy = $bbox['maxy']-$bbox['miny'];

  $scx = $dx/$width;
  $scy = $dy/$height;

  $dw = $new_width - $width;
  $dh = $new_height - $height;

  $difx = $dw*$scx/2;
  $dify = $dh*$scy/2;

  $res['minx'] = $bbox['minx'] - $difx;
  $res['maxx'] = $bbox['maxx'] + $difx;
  $res['miny'] = $bbox['miny'] - $dify;
  $res['maxy'] = $bbox['maxy'] + $dify;

  return $res;
}


if($just_print) {

    if($mode=='save_image') {

      $GLOBALS["WIDTH"] = ($IMG_WIDTH>0)?$IMG_WIDTH:$GLOBALS["WIDTH"];
      $GLOBALS["HEIGHT"] = ($IMG_HEIGHT>0)?$IMG_HEIGHT:$GLOBALS["HEIGHT"];

      list($OLD_BBOX["minx"],$OLD_BBOX["miny"],$OLD_BBOX["maxx"],$OLD_BBOX["maxy"]) = explode(",",$GLOBALS["BBOX"]);
      $OLD_WIDTH=$GLOBALS["WIDTH"];
      $OLD_HEIGHT=$GLOBALS["HEIGHT"];

      if($IMG_SCALE>0 && $IMG_SCALE!=$SCALE) {
        $OLD_BBOX = $extman->ScaleExtent($OLD_BBOX, $IMG_SCALE/(double)$SCALE);
        $NEW_BBOX = ChangeExtentByImageSize($OLD_BBOX, $OLD_WIDTH, $OLD_HEIGHT, $GLOBALS["WIDTH"], $GLOBALS["HEIGHT"]);
        $GLOBALS['BBOX'] = $NEW_BBOX['minx'].','.$NEW_BBOX['miny'].','.$NEW_BBOX['maxx'].','.$NEW_BBOX['maxy'];
        $GLOBALS["SCALE"] = $extman->GetScale($NEW_BBOX, $GLOBALS["WIDTH"], $GLOBALS["HEIGHT"]);
      }

      $map_width = $GLOBALS["WIDTH"];
      $map_height = $GLOBALS["HEIGHT"];

      if(isSet($PRINT_DPI) && $PRINT_DPI!=96) {
        $GLOBALS['PRINT'] = 1;
        if($IMG_DONT_ADAPT=='size') {
          $zoomed_bbox = $extman->ScaleExtent($OLD_BBOX, 96/$GLOBALS["PRINT_DPI"]);
          $GLOBALS['BBOX'] = $zoomed_bbox['minx'].','.$zoomed_bbox['miny'].','.$zoomed_bbox['maxx'].','.$zoomed_bbox['maxy'];
          unset($GLOBALS["PRINT_DPI"]);
        }
        else {
          $map_width = Round($map_width*$PRINT_DPI/96);
          $map_height = Round($map_height*$PRINT_DPI/96);
        }
      }

      // returns base point for place object
      function GetBasePoint($canvas_point,$element,$base_point_type) {
        $result = array();

        // coords of object point
        $def_point_left = $canvas_point['left'] + $element['left'];
        $def_point_top = $canvas_point['top'] + $element['top'];

        switch($element['def_point']) {
          case 'ul':
              switch($base_point_type) {
                case 'ul':
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top;
                  break;
                case 'ur':
                  break;
                case 'lr':
                  break;
                case 'll':
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top + $element['height'];
                  break;
                case 'cc':
                  $result['left'] = $def_point_left + round($element['width']/2);
                  $result['top'] = $def_point_top + round($element['height']/2);
                  break;
                default:
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top;
                  break;
              }
              break;
          case 'ur':
              switch($base_point_type) {
                case 'll':
                  $result['left'] = $def_point_left - $element['width'];
                  $result['top'] = $def_point_top + $element['height'];
                case 'ur':
                  break;
                case 'lr':
                  break;
                case 'ul':
                  $result['left'] = $def_point_left - $element['width'];
                  $result['top'] = $def_point_top;
                  break;
                case 'cc':
                  $result['left'] = $def_point_left - round($element['width']/2);
                  $result['top'] = $def_point_top + round($element['height']/2);
                  break;
                default:
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top;
                  break;
              }
              break;
          case 'lr':
              switch($base_point_type) {
                case 'll':
                  $result['left'] = $def_point_left - $element['width'];
                  $result['top'] = $def_point_top;
                  break;
                case 'ur':
                  break;
                case 'lr':
                  break;
                case 'ul':
                  $result['left'] = $def_point_left - $element['width'];
                  $result['top'] = $def_point_top - $element['height'];
                  break;
                case 'cc':
                  $result['left'] = $def_point_left - round($element['width']/2);
                  $result['top'] = $def_point_top - round($element['height']/2);
                  break;
                default:
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top;
                  break;
              }
            break;
          case 'll':
              switch($base_point_type) {
                case 'll':
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top;
                  break;
                case 'ur':
                  break;
                case 'lr':
                  break;
                case 'ul':
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top - $element['height'];
                  break;
                case 'cc':
                  $result['left'] = $def_point_left + round($element['width']/2);
                  $result['top'] = $def_point_top - round($element['height']/2);
                  break;
                default:
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top;
                  break;
              }
            break;
          case 'cc':
              switch($base_point_type) {
                case 'll':
                  $result['left'] = $def_point_left - round($element['width']/2);
                  $result['top'] = $def_point_top + round($element['height']/2);
                  break;
                case 'ur':
                  break;
                case 'lr':
                  break;
                case 'ul':
                  $result['left'] = $def_point_left - round($element['width']/2);
                  $result['top'] = $def_point_top - round($element['height']/2);
                  break;
                case 'cc':
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top;
                  break;
                default:
                  $result['left'] = $def_point_left;
                  $result['top'] = $def_point_top;
                  break;
              }
            break;
          default: break;
        }

        return $result;
      }

      // places object on canvas
      function PlaceObject(&$canvas,$canv_width,$canv_height,$object_params) {
        switch($object_params['coords']['canvas_point']) {
          case 'ul':
              $canvas_point['left'] = 0;
              $canvas_point['top'] = 0;
            break;
          case 'ur':
              $canvas_point['left'] = $canv_width;
              $canvas_point['top'] = 0;
            break;
          case 'lr':
              $canvas_point['left'] = $canv_width;
              $canvas_point['top'] = $canv_height;
            break;
          case 'll':
              $canvas_point['left'] = 0;
              $canvas_point['top'] = $canv_height;
            break;
          case 'cc':
              $canvas_point['left'] = round($canv_width/2);
              $canvas_point['top'] = round($canv_height/2);
            break;
          default:
              $canvas_point['left'] = 0;
              $canvas_point['top'] = 0;
            break;
        }

        $element['def_point'] = $object_params['coords']['object_point'];
        $element['left'] = $object_params['coords']['left'];
        $element['top'] = $object_params['coords']['top'];

        switch($object_params['type']) {
          case 'text':
                $text = strlen($GLOBALS[$object_params['params']['text_source']]) ? $GLOBALS[$object_params['params']['text_source']] : $object_params['params']['default_text'];
                if(!strlen($text)>0) continue;
                $angle = $object_params['params']['angle'] ? $object_params['params']['angle'] : 0;
                $font_file = $object_params['params']['font_file'];
                $font_size = $object_params['params']['font_size'];
                $fc = Explode(",",$object_params['params']['font_color']);
                $font_color = imagecolorallocate($canvas, $fc[0], $fc[1], $fc[2]);
                $text_box = imagettfbbox($font_size,$angle,$font_file,$text);
                $element['width'] = $text_box[2] - $text_box[0];
                $element['height'] = $text_box[1] - $text_box[7];
                $base_point = GetBasePoint($canvas_point,$element,'ll');
                $text_parts = Explode("\n",$text);
                $i = 0;
                foreach($text_parts as $text_part) {
                  imagettftext($canvas, $font_size, $angle, $base_point['left'], $base_point['top']+($i*($font_size+2)), $font_color, $font_file, $text_part);
                  $i++;
                }
                if($object_params['params']['border']) {
                  $bc = Explode(",",$object_params['params']['border_color']);
                  $color = imagecolorallocate(&$canvas, $bc[0], $bc[1], $bc[2]);
                  $base_point = GetBasePoint($canvas_point,$element,'ul');
                  $diag_point['left'] = $base_point['left'] + $element['width'];
                  $diag_point['top'] = $base_point['top'] + $element['height'];
                  imagerectangle($canvas, $base_point['left']-2, $base_point['top']-2 , $diag_point['left']+2, $diag_point['top']+2, $color);
                }
              break;
          case 'rect':
                $c = Explode(",",$object_params['params']['color']);
                $color = imagecolorallocate(&$canvas, $c[0], $c[1], $c[2]);
                $element['width'] = $object_params['params']['width'];
                $element['height'] = $object_params['params']['height'];
                $base_point = GetBasePoint($canvas_point,$element,'ul');
                $diag_point['left'] = $base_point['left'] + $element['width'];
                $diag_point['top'] = $base_point['top'] + $element['height'];
                imagerectangle($canvas, $base_point['left'], $base_point['top'] , $diag_point['left'], $diag_point['top'] ,$color);
              break;
          case 'ellipse':
                $c = Explode(",",$object_params['params']['color']);
                $color = imagecolorallocate(&$canvas, $c[0], $c[1], $c[2]);
                $element['width'] = $object_params['params']['width'];
                $element['height'] = $object_params['params']['height'];
                $base_point = GetBasePoint($canvas_point,$element,'cc');
                $diag_point['left'] = $base_point['left'] + $element['width'];
                $diag_point['top'] = $base_point['top'] + $element['height'];
                imageellipse($canvas, $base_point['left'], $base_point['top'] , $element['width'], $element['height'] ,$color);
              break;
          case 'line':
                $c = Explode(",",$object_params['params']['color']);
                $color = imagecolorallocate(&$canvas, $c[0], $c[1], $c[2]);
                imageline($canvas, $object_params['params']['left1'], $object_params['params']['top1'] , $object_params['params']['left2'], $object_params['params']['top2'] ,$color);
              break;
          case 'image':
                $src = FileUp2($object_params['params']['src']);
                $img_info = getimagesize(FileUp2($src));
                $img_format = $img_info[2];
                switch($img_format) {
                  case 1: $img = imagecreatefromgif($src); break;
                  case 2: $img = imagecreatefromjpeg($src); break;
                  case 3: $img = imagecreatefrompng($src); break;
                  default: die('Image source '.$src.' is not correct.'); break;
                }
                $element['width'] = $img_info[0];
                $element['height'] = $img_info[1];
                $base_point = GetBasePoint($canvas_point,$element,'ul');
                ImageCopyMerge($canvas, $img, $base_point['left'], $base_point['top'], 0, 0, $element['width'], $element['height'],$object_params['params']['transparency']);
                if($object_params['params']['border']) {
                  $diag_point['left'] = $base_point['left'] + $element['width'];
                  $diag_point['top'] = $base_point['top'] + $element['height'];
                  $bc = Explode(",",$object_params['params']['border_color']);
                  $color = imagecolorallocate(&$canvas, $bc[0], $bc[1], $bc[2]);
                  imagerectangle($canvas, $base_point['left'], $base_point['top'] , $diag_point['left'], $diag_point['top'], $color);
                }
              break;
          default: break;
//           case 'map':
//                 $img = $GLOBALS['map']->ImageGD;
//                 $element['width'] = $GLOBALS['map_width'];
//                 $element['height'] = $GLOBALS['map_height'];
//                 $base_point = GetBasePoint($canvas_point,$element,'ul');
//                 ImageCopyMerge($canvas, $img, $base_point['left'], $base_point['top'], 0, 0, $element['width'], $element['height'],$object_params['params']['transparency']);
//                 if($object_params['params']['border']) {
//                   $diag_point['left'] = $base_point['left'] + $element['width'];
//                   $diag_point['top'] = $base_point['top'] + $element['height'];
//                   $bc = Explode(",",$object_params['params']['border_color']);
//                   $color = imagecolorallocate(&$canvas, $bc[0], $bc[1], $bc[2]);
//                   imagerectangle($canvas, $base_point['left'], $base_point['top'] , $diag_point['left']-1, $diag_point['top']-1, $color);
//                 }
//               break;
//          default: break;
        }
      }

      $GLOBALS['WIDTH'] = $map_width;
      $GLOBALS['HEIGHT'] = $map_height;
      include(FileUp2(".admin/map.inc"));

      $kompost_params = $MAP_OUTPUT['save_image'][$client_type]?$MAP_OUTPUT['save_image'][$client_type]:$MAP_OUTPUT['save_image']['default'];

      foreach($kompost_params['objects'] as $title=>$params) {
        if($params['type']=='text') {
          $text = strlen($GLOBALS[$params['params']['text_source']]) ? $GLOBALS[$params['params']['text_source']] : $params['params']['default_text'];
          if(!strlen($text)>0 && Count($params['params']['if_empty'])>0) {
            foreach($params['params']['if_empty'] as $param=>$val) {
              $gl_params = Explode("|",$param);
              $set_param = '$kompost_params';
              for($i=0;$i<Count($gl_params);$i++) {
                $set_param .= '["'.$gl_params[$i].'"]';
              }
              $set_param .= '='.$val.';';
              eval($set_param);
            }
          }
        }
        elseif($params['type']=='map') $map_obj_title = $title;
      }

      $img_width = $map_width + $kompost_params['padding']['left'] + $kompost_params['padding']['right'];
      $img_height = $map_height + $kompost_params['padding']['top'] + $kompost_params['padding']['bottom'];

      $canvas = ImageCreateTrueColor($img_width, $img_height);
      $bg = Explode(",",$kompost_params['bgcolor']);
      $background = imagecolorallocate($canvas, $bg[0], $bg[1], $bg[2]);
      imagefilledrectangle($canvas, 0, 0, $img_width, $img_height, $background);

      //MAP
      $map_params = $kompost_params['objects'][$map_obj_title]['params'];
      ImageCopyMerge($canvas, $map->ImageGD, 0 + $kompost_params['padding']['left'], 0 + $kompost_params['padding']['top'], 0, 0, $map_width, $map_height, $map_params['transparency']?$map_params['transparency']:100);

      if($map_params['border']) {
        $bc = Explode(",",$map_params['border_color']);
        $color = imagecolorallocate(&$canvas, $bc[0], $bc[1], $bc[2]);
        imagerectangle($canvas, 0 + $kompost_params['padding']['left'], 0 + $kompost_params['padding']['top'], $img_width+$kompost_params['padding']['left']-1, $map_height+$kompost_params['padding']['top']-1, $color);
      }

      foreach($kompost_params['objects'] as $object_params) {
        PlaceObject($canvas,$img_width,$img_height,$object_params);
      }

      if($kompost_params['border']) {
        $bc = Explode(",",$kompost_params['border_color']);
        $color = imagecolorallocate(&$canvas, $bc[0], $bc[1], $bc[2]);
        imagerectangle($canvas, 0, 0 , $img_width-1, $img_height-1, $color);
      }

//        Header("Content-type: image/png");
//        ImagePNG($canvas);
//        die();

      Header("Pragma: public");
      Header("Expires: 0");
      Header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
      Header("Cache-Control: public");
      Header("Content-Description: File Transfer");

      switch($IMG_FORMAT) {
        case 'PNG': Header("Content-Disposition: attachment; filename=image.png");
                    Header("Content-type: image/png");
                    ImagePNG($canvas);
                    break;
        case 'JPEG': Header("Content-Disposition: attachment; filename=image.jpeg");
                     Header("Content-type: image/jpeg");
                     ImageJPEG($canvas);
                    break;
        case 'GIF': Header("Content-Disposition: attachment; filename=image.gif");
                    Header("Content-type: image/gif");
                    ImageGIF($canvas);
                    break;
        default: Header("Content-type: text/html");
                 echo "Bad image format.";
                 break;
      }
      ImageDestroy($canvas);

    }
    else {

      $arr = Explode('&',$QUERY_STRING);

      $keyarr = $HTTP_GET_VARS?$HTTP_GET_VARS:($HTTP_POST_VARS?$HTTP_POST_VARS:Array());

      //vertical
      //horizontal
      //O1 - map alone, rest on one page
      //O2 - all on one page, legend alone

      switch($format) {
        case "A4":
          if($object=="O1") {
            if($orientace=="vertical") {$NEW_WIDTH=620;$NEW_HEIGHT=830;}
            else {$NEW_WIDTH=850;$NEW_HEIGHT=570;}
          } else {
            if($orientace=="vertical") {$NEW_WIDTH=600;$NEW_HEIGHT=700;}
            else {$NEW_WIDTH=800;$NEW_HEIGHT=570;}
          }
        break;
        case "A5":
          if($object=="O1") {
            if($orientace=="vertical") {$NEW_WIDTH=390;$NEW_HEIGHT=550;}
            else {$NEW_WIDTH=570;$NEW_HEIGHT=340;}
          } else {
            if($orientace=="vertical") {$NEW_WIDTH=380;$NEW_HEIGHT=550;}
            else {$NEW_WIDTH=400;$NEW_HEIGHT=340;}
          }
        break;
        case "A3":
          if($object=="O1") {
            if($orientace=="vertical") {$NEW_WIDTH=950;$NEW_HEIGHT=1250;}
            else {$NEW_WIDTH=1350;$NEW_HEIGHT=900;}
          } else {
            if($orientace=="vertical") {$NEW_WIDTH=950;$NEW_HEIGHT=1000;}
            else {$NEW_WIDTH=1100;$NEW_HEIGHT=900;}
          }
        break;
        case "AMV":
          if($orientace=="vertical") {
					  $NEW_HEIGHT=$amv_height;
						$NEW_WIDTH=$amv_width;

//						if($NEW_WIDTH>620) $NEW_WIDTH=620;
//						if($NEW_HEIGHT>830) $NEW_HEIGHT=830;
						if($NEW_WIDTH>620) $AMVM_WIDTH=620;
						else $AMVM_WIDTH=$amv_width;
						if($NEW_HEIGHT>830) $AMVM_HEIGHT=830;
            else $AMVM_HEIGHT=$amv_height;
          }
          else {
					  $NEW_HEIGHT=$amv_height-50;
						$NEW_WIDTH=$amv_width-50;
//            if($NEW_WIDTH>800) $NEW_WIDTH=800;
//						if($NEW_HEIGHT>570) $NEW_HEIGHT=570;
            if($NEW_WIDTH>800) $AMVM_WIDTH=800;
						else $AMVM_WIDTH=$amv_width;
						if($NEW_HEIGHT>570) $AMVM_HEIGHT=570;
            else $AMVM_HEIGHT=$amv_height;
					}
        break;
        default:
          $NEW_WIDTH = $GLOBALS["WIDTH"]/2.54*96;
          $NEW_HEIGHT = $GLOBALS["HEIGHT"]/2.54*96;
      }

      list($OLD_BBOX["minx"],$OLD_BBOX["miny"],$OLD_BBOX["maxx"],$OLD_BBOX["maxy"]) = explode(",",$GLOBALS["BBOX"]);
      $OLD_WIDTH=$amv_width;
      $OLD_HEIGHT=$amv_height;

      $NEW_BBOX = ChangeExtentByImageSize($OLD_BBOX, $OLD_WIDTH, $OLD_HEIGHT, $NEW_WIDTH, $NEW_HEIGHT);

      if($USER_SCALE) $NEW_BBOX = $extman->ScaleExtent($NEW_BBOX, ($USER_SCALE/$SCALE));

			$SCALE = $extman->GetScale($NEW_BBOX, $NEW_WIDTH, $NEW_HEIGHT);

			if($AMVM_HEIGHT && $AMVM_WIDTH) {
        $AMVM_SCALE = $extman->GetScale($NEW_BBOX, $AMVM_WIDTH, $AMVM_HEIGHT);
			}

      if ($scale_adapt=='change_to' && $new_scale>0) {
        $NEW_BBOX = $extman->ScaleExtent($NEW_BBOX, $new_scale/(double)$SCALE);
        $SCALE = $new_scale;
        $keyarr["SCALE"] = $new_scale;
      }

      $keyarr["BBOX"] = $NEW_BBOX["minx"].",".$NEW_BBOX["miny"].",".$NEW_BBOX["maxx"].",".$NEW_BBOX["maxy"];

      require(FileUp2("html_header.inc"));
      $add = $legenda ? 'document.forms.legend_frm.submit();' : '';
      echo "<BODY class=\"print\" onLoad=\"document.forms.map_frm.submit();".$add."try_print();\">\n"; //
      $arr = array();
      while(list($key,$val) = each($keyarr)) {
        $arr[] = "$key=".urlencode($val)."";
      }
      $query = Implode('&',$arr);

/************************** SEKCE TOP TITLE *******************************************************/
      echo "<title>".$RESOURCE_STRING["print_map_caption"]."</title>\n";
      echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">";

      if($TITLE) echo $TITLE;
      else echo $RESOURCE_STRING["print_map_caption"];

      echo "</span><HR class=\"subtitle\">\n";

/************************** SEKCE MAPOVY VYREZ ***************************************************/
if($RAMECEK) echo "<div class=\"border\" style=\"position:relative;float:left;\">\n";
else echo "<div style=\"position:relative;float:left;\">\n";

      echo '<script>
              var i=0;
              function try_print() {
                if(i>30) {
                  alert("Print failed. Try again.");
                  return 0;
                }
                if(window.mapa.document.tms_map_ready) window.setTimeout("window.print();",500);
                else window.setTimeout("try_print()",1000);
                i++;
              }
            </script>'."\n";
      echo '<form id="map_frm" method="POST" action="map.php" target="mapa">'."\n";
      foreach($keyarr as $k=>$val) {
//        if($k=='WIDTH') $val=$NEW_WIDTH;
//        if($k=='HEIGHT') $val=$NEW_HEIGHT;

        if($k=='WIDTH') $val=($AMVM_WIDTH?$AMVM_WIDTH:$NEW_WIDTH);
        if($k=='HEIGHT') $val=($AMVM_HEIGHT?$AMVM_HEIGHT:$NEW_HEIGHT);
        echo '<input type="hidden" name="'.$k.'" value="'.$val.'">'."\n";
      }
      echo '<input type="hidden" name="PRINT" value="1">'."\n";
      echo '<input type="hidden" name="NOPRINT" value="1">'."\n";
      echo '<input type="hidden" name="WAIT" value="0">'."\n";
      echo '<input type="hidden" name="SCRIPT" value="0">'."\n";
      echo '<input type="hidden" name="PRINT_DPI" value="'.$GLOBALS["PRINT_DPI"].'">'."\n";

      echo '</form>'."\n";
      echo "<iframe style='z-index:-1;' scrolling=\"no\" name=\"mapa\" id=\"mapa\" width=\"".($AMVM_WIDTH?$AMVM_WIDTH:$NEW_WIDTH)."\" height=\"".($AMVM_HEIGHT?$AMVM_HEIGHT:$NEW_HEIGHT)."\" frameborder=\"0\"></iframe>\n";

      echo "<br><span class=\"filterblock_main\">".$RESOURCE_STRING["print_map_scale"].($AMVM_SCALE?$AMVM_SCALE:$SCALE)."</span>";
      if($SOURADNICE) {
        list($mx,$my,$xx,$xy) = explode(",",$BBOX);
        echo ",&nbsp;&nbsp;X:".(($mx+$xx)/2).",&nbsp;&nbsp;Y:".(($my+$xy)/2);
      }
      echo "</div>\n";
/************************** SEKCE POZNAMKA,SOURADNICE...**********************************************/
if($orientace=="vertical" && $object=="O1" && ($POZNAMKA || $dat_akt_dkm || $dat_akt_drm)) echo "<p style='page-break-before:always' />\n";

if($orientace=="horizontal" && $object=="O2")  echo "<div style=\"position:relative;float:right;\">\n";
else echo "<div style=\"position:relative;\">\n";

      if($POZNAMKA) {
        echo "<div class='filterblock'>Poznmka</div><P>\n";
        $POZNAMKA = str_replace("\n","<BR>",$POZNAMKA);
        echo $POZNAMKA;
      } else echo "&nbsp;";


      if($dat_akt_dkm) {
        $url = $TOC_TREE_METADATA["metadata_print"]["url"].$TOC_TREE_METADATA["metadata_print"]["dkm"];
        if ($url) {
          require_once($GLOBALS["TMAPY_LIB"]."/lib/phpxml/phpxmlex.inc");
          $DKM = get_dat_aktualizace($url);
          echo "<br>\n";
          echo $DKM["NAZEV"]."&nbsp;<i>(".$DKM["POPIS"].")</i> - aktualizace dne:<b>".$DKM["DAT_AKTUAL"]."</b>\n";
        }
      }
      if($dat_akt_drm) {
        $url = $TOC_TREE_METADATA["metadata_print"]["url"].$TOC_TREE_METADATA["metadata_print"]["drm"];
        if ($url) {
          require_once($GLOBALS["TMAPY_LIB"]."/lib/phpxml/phpxmlex.inc");
          $DKM = get_dat_aktualizace($url);
          echo "<br>\n";
          echo $DKM["NAZEV"]."&nbsp;<i>(".$DKM["POPIS"].")</i> - aktualizace dne:<b>".$DKM["DAT_AKTUAL"]."</b>\n";
        }
      }

echo "</div>\n";
/************************** SEKCE LEGENDA.........**********************************************/

      if($legenda) {
//        echo "<p style='page-break-before:always' />\n";

echo "<div width=\"100%\" height=\"100%\">\n";


        echo '<form id="legend_frm" method="POST" action="map.php" target="legenda">'."\n";
        foreach($keyarr as $k=>$val) {
	        if($k=='WIDTH') $val=($AMVM_WIDTH?$AMVM_WIDTH:$NEW_WIDTH);
	        if($k=='HEIGHT') $val=($AMVM_HEIGHT?$AMVM_HEIGHT:$NEW_HEIGHT);
          echo '<input type="hidden" name="'.$k.'" value="'.$val.'">'."\n";
        }
        echo '<input type="hidden" name="PRINT" value="1">'."\n";
        echo '<input type="hidden" name="NOPRINT" value="1">'."\n";
        echo '<input type="hidden" name="WAIT" value="0">'."\n";
        echo '<input type="hidden" name="SCRIPT" value="0">'."\n";
        echo '<input type="hidden" name="PRINT_DPI" value="'.$GLOBALS["PRINT_DPI"].'">'."\n";
        echo '<input type="hidden" name="MODE" value="lg">'."\n";
        echo '</form>'."\n";
        echo "<iframe id=\"legenda\" name=\"legenda\" width=\"100%\" height=\"100%\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\"></iframe>\n"; //src=\"map.php?".$query."&HEIGHT=".$NEW_HEIGHT."&WIDTH=".$NEW_WIDTH."&MODE=lg\"
echo "</div>\n";
      }

    }
}
else {

  $akt_width = $WIDTH;
  $akt_height = $HEIGHT;


  $hid_inputs = '';

  $vars = Array();
  if(!$QUERY_STRING && Count($HTTP_POST_VARS)>0) $vars = $HTTP_POST_VARS;
  else {
    $pre_vars = explode("&",$QUERY_STRING);
    foreach($pre_vars as $key=>$val) {
      $pair = explode("=",$val);
      $vars[$pair[0]] = urldecode($pair[1]);
    }
  }

  foreach($vars as $klic=>$hodnota) {
    if($mode=='save_image' && $klic=='FORMAT') $hodnota='GD';
    elseif(($klic == "WIDTH") || ($klic == "HEIGHT")) continue;
    $hid_inputs .= "<input name='$klic' value='$hodnota' type='hidden'>\n";
  }

  echo "<form name='frm_size'  method='POST' action='print.php' target='_self' onsubmit='return frm_edit_Validator(this)'>\n";

  echo $hid_inputs;

  echo "<input name='just_print' value='1' type='hidden'>\n";
  echo "<input name='amv_height' value='$HEIGHT' type='hidden'>\n";
  echo "<input name='amv_width' value='$WIDTH' type='hidden'>\n";
  echo "<input name='amv_scale' value='$m_scale' type='hidden'>\n";

  echo "<title>".($MAP_OUTPUT[$mode][$client_type]['title']?$MAP_OUTPUT[$mode][$client_type]['title']:$MAP_OUTPUT[$mode]['default']['title'])."</title>\n";
  echo "<h2>".($MAP_OUTPUT[$mode][$client_type]['title']?$MAP_OUTPUT[$mode][$client_type]['title']:$MAP_OUTPUT[$mode]['default']['title'])."</h2>\n";

  foreach($sections as $name=>$params) {
    switch($name) {
      case 'print_restricted_layers':
          //Control of scale-limited-for-print layers
          $print_limited_layers = PrintLimitedLayers($map->tree);
          //die(print_r($print_limited_layers));

          if(Count($print_limited_layers)>0) {
            $intersection = Array('min'=>-999999999, 'max'=>999999999);
            $not_printable_layers = Array();
            foreach($print_limited_layers as $layer=>$print_limit) {
              if($print_limit['min'] && $print_limit['max']) {
                if(!($print_limit['min']<=$SCALE && $print_limit['max']>=$SCALE)) $not_printable_layers[] = $layer;
              }
              elseif($print_limit['min']) {
                if(!($print_limit['min']<=$SCALE)) $not_printable_layers[] = $layer;
              }
              elseif($print_limit['max']) {
                if(!($print_limit['max']>=$SCALE)) $not_printable_layers[] = $layer;
              }
              if($print_limit['min'] && $print_limit['min']>$intersection['min']) $intersection['min'] = $print_limit['min'];
              if($print_limit['max'] && $print_limit['max']<$intersection['max']) $intersection['max'] = $print_limit['max'];
            }
            if(Count($not_printable_layers)>0) {
              //recommended scale (intersection)
              if(!($SCALE>=$intersection['min'] && $SCALE<=$intersection['max']) && ($intersection['max']>$intersection['min'])) {
                if(($SCALE-$intersection['min']) < ($intersection['max']-$SCALE))
                  $recommended_scale = $intersection['min'];
                else
                  $recommended_scale = $intersection['max'];
                $new_scale_note = "<span id='recommended_scale'><i>(".$RESOURCE_STRING["print_restriction_recommended"].")</i></span></td></tr>";
              }
              else $new_scale_note = '';

              echo "<img src=".FileUpURL('images/alert.gif').">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_scale_restriction"]."</span><HR class=\"subtitle\">\n";
              echo "<table><tr><td><b><font color='red' style='font-size: 12px;'>".$RESOURCE_STRING["print_restriction_warning_start"]." <font color='black'>1:".$SCALE."</font> ".$RESOURCE_STRING["print_restriction_warning_end"].":</font></b></td></tr>";
              foreach($not_printable_layers as $key=>$layer) {
                if($print_limited_layers[$layer]['min'] && $print_limited_layers[$layer]['max']) $range = ' (tisk od 1:'.$print_limited_layers[$layer]['min'].' do 1:'.$print_limited_layers[$layer]['max'].')';
                elseif($print_limited_layers[$layer]['min']) $range = ' (tisk od 1:'.$print_limited_layers[$layer]['min'].')';
                elseif($print_limited_layers[$layer]['max']) $range = ' (tisk do 1:'.$print_limited_layers[$layer]['max'].')';
                else $range = '';
                echo " <tr><td>- ".$print_limited_layers[$layer]["title"].$range."</td></tr>";
              }
              if($recommended_scale) {
                echo " <tr><td><i><b>".$RESOURCE_STRING["print_restriction_recommended_scale"].": 1:".$recommended_scale."</b></i></td></tr>";
                $checked_change_to = ' checked';
                $checked_leave_current = '';
              }
              else {
                $checked_change_to = '';
                $checked_leave_current = ' checked';
              }
              echo "<tr><td height='30px' valign='bottom'><b><font style='font-size: 12px;'>".$RESOURCE_STRING["print_restriction_scale_adaption"].":</font></b><br></td></tr>";
              echo "<tr><td><input type='radio' name='scale_adapt' value='change_to'".$checked_change_to."> ".$RESOURCE_STRING["print_restriction_change_to"].": <b>1:</b><input onClick='javascript:document.getElementById(\"recommended_scale\").style.display=\"none\";' type='text' name='new_scale' value='".($recommended_scale?$recommended_scale:$SCALE)."'> ".$new_scale_note;
              echo "<tr><td><input type='radio' name='scale_adapt' value='leave_current'".$checked_leave_current."> ".$RESOURCE_STRING["print_restriction_leave_current"].": <b><font face='arial, helvetica, sans-serif'>1:".$SCALE."</font></b></td></tr>";
              echo '</td></tr></table>&nbsp;<p>';
              //print_r($intersection);
            }
          }
        break;

      case 'page_layout':
            if(is_array($sections[$name])) {
              echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_objects_settings"]."</span><HR class=\"subtitle\">\n";
              echo "<table border=0>\n";
              if($params['separated']) echo "<tr><td valign='bottom'><input type='radio' name='object' id='object' value='O1' onclick='setImg(\"img_object\",\"o1\")' ".($params['default']=='separated' ? 'checked' : '')."></td><td valign='bottom' width='470'>".$RESOURCE_STRING["print_object_o1"]."</td>\n";
              echo "<td rowspan='2'><img name='img_object' src='".FileUpURL('images/print/o'.($params['default']=='all_in_one'?'2':'1').'.gif')."' width='123' height='90'></td></tr>\n";
              if($params['all_in_one']) echo "<tr><td valign='top'><input type='radio' name='object' id='object' value='O2' onclick='setImg(\"img_object\",\"o2\")' ".($params['default']=='all_in_one' ? 'checked' : '')."></td><td valign='top' width='470'>".$RESOURCE_STRING["print_object_o2"]."</td></tr>\n";
              echo "</table>\n";
            }
          break;

      case 'size':
            if(is_array($sections[$name])) {
              echo "<p>\n";
              echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_map_size"]."</span><HR class=\"subtitle\">\n";
              echo "<table>\n";
              if($params['AMV']) echo "<tr><td><input type='radio' name='format' id='format' value='AMV' ".($params['default']=='AMV' ? 'checked' : '')."></td><td>".$RESOURCE_STRING["print_map_size_amv"]."</td></tr>\n";
              if($params['A3']) echo "<tr><td><input type='radio' name='format' id='format' value='A3' ".($params['default']=='A3' ? 'checked' : '')."></td><td>".$RESOURCE_STRING["print_map_size_a3"]."</td></tr>\n";
              if($params['A4']) echo "<tr><td><input type='radio' name='format' id='format' value='A4' ".($params['default']=='A4' ? 'checked' : '')."></td><td>".$RESOURCE_STRING["print_map_size_a4"]."</td></tr>\n";
              if($params['A5']) echo "<tr><td><input type='radio' name='format' id='format' value='A5' ".($params['default']=='A5' ? 'checked' : '')."></td><td>".$RESOURCE_STRING["print_map_size_a5"]."</td></tr>\n";
              if($params['NVU']) echo "<tr><td><input type='radio' name='format' id='format' value='NVU' ".($params['default']=='NVU' ? 'checked' : '')."></td><td>".$RESOURCE_STRING["print_map_size_nvu"]."</td></tr>\n";
              echo "</table>\n";

              echo "<blockquote>\n";
              echo "<table>\n";
              echo "<tr><td>".$RESOURCE_STRING["print_map_width"]."</td><td><input name='WIDTH' value='' type='text' maxlength='50' size='5' onfocus='setFormat()'>&nbsp;cm</td></tr>\n";
              echo "<tr><td>".$RESOURCE_STRING["print_map_height"]."</td><td><input name='HEIGHT' value='' type='text' maxlength='100' size='5' onfocus='setFormat()'>&nbsp;cm</td></tr>\n";
              echo "</table>\n";
              echo "</blockquote>\n";
            }
          break;

      case 'img_size':
            echo "<br>";
            echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_img_size"]."</span><HR class=\"subtitle\">\n";
            echo "<table>\n";
            echo "<tr><td>".$RESOURCE_STRING["print_map_width"]."</td><td><input id='IMG_WIDTH' name='IMG_WIDTH' type='text' maxlength='5' size='5' value='".$GLOBALS['WIDTH']."'>&nbsp;px</td></tr>\n";
            echo "<tr><td>".$RESOURCE_STRING["print_map_height"]."</td><td><input id='IMG_HEIGHT' name='IMG_HEIGHT' type='text' maxlength='5' size='5' value='".$GLOBALS['HEIGHT']."'>&nbsp;px</td></tr>\n";
            echo "</table>\n";
          break;

      case 'img_scale':
            echo "<br>";
            echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_scale"]."</span><HR class=\"subtitle\">";
            echo "<input type='text' id='IMG_SCALE' name='IMG_SCALE' size='10' maxlength='10' value='".$SCALE."'>\n";
            echo "<br>";
          break;

      case 'user_scale':
            echo "<br>";
            echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_user_scale"]."</span><HR class=\"subtitle\">";
            echo "1:<input type='text' id='USER_SCALE' name='USER_SCALE' size='10' maxlength='10' value='".$USER_SCALE."'>\n";
            echo "<br>";
          break;

      case 'resolution':
            echo "<br>";
            echo "<script language='JavaScript'>\n";
            echo "<!--\n";
            echo "function getCheckedValue(radioObj) {\n";
          	echo "if(!radioObj)\n";
          	echo "  return '';\n";
          	echo "  var radioLength = radioObj.length;\n";
          	echo "  if(radioLength == undefined)\n";
          	echo "    if(radioObj.checked)\n";
          	echo "      return radioObj.value;\n";
          	echo "    else\n";
          	echo "      return '';\n";
          	echo "  for(var i = 0; i < radioLength; i++) {\n";
          	echo "    if(radioObj[i].checked) {\n";
          	echo "      return radioObj[i].value;\n";
          	echo "    }\n";
          	echo "  }\n";
          	echo "  return '';\n";
            echo "}\n";
            echo "function ResolutionSwitch() {\n";
            echo "  var res = document.getElementById('resolution');\n";
            echo "  var size_w = document.getElementById('IMG_WIDTH');\n";
            echo "  var size_h = document.getElementById('IMG_HEIGHT');\n";
            echo "  var scale = document.getElementById('IMG_SCALE');\n";
            echo "  var dpi = document.getElementById('PRINT_DPI');\n";
            echo "  var bbox_radio = document.getElementById('IMG_DONT_ADAPT_BBOX');\n";
            echo "  var size_radio = document.getElementById('IMG_DONT_ADAPT_SIZE');\n";
            echo "  var adapt = document.getElementById('IMG_DONT_ADAPT_BBOX');\n";
            echo "  var res_adapt = getCheckedValue(adapt);\n";
            echo "  if(res.checked) {\n";
            echo "    bbox_radio.disabled=false;\n";
            echo "    size_radio.disabled=false;\n";
            echo "    dpi.disabled=false;\n";
            echo "    if(res_adapt=='bbox') {\n";
            echo "      size_w.readOnly=true;\n";
            echo "      size_h.readOnly=true;\n";
            echo "    }\n else {\n";
            echo "      size_w.readOnly=false;\n";
            echo "      size_h.readOnly=false;\n";
            echo "    }\n";
            echo "  }\n else {\n";
            echo "    size_w.disabled=false;\n";
            echo "    size_h.disabled=false;\n";
            echo "    scale.disabled=false;\n";
            echo "    bbox_radio.disabled=true;\n";
            echo "    size_radio.disabled=true;\n";
            echo "    dpi.disabled=true;\n";
            echo "  }\n";
            echo "}\n";
            echo "//-->\n";
            echo "</script>\n";
            echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_resolution"]."</span>&nbsp;<input type='checkbox' id='resolution' name='resolution' onClick='ResolutionSwitch();' ".($params['default_checked']?'checked':'')."><HR class=\"subtitle\">\n";
            echo "<table><tr>\n";
            echo "<td colspan=2><input id='PRINT_DPI' name='PRINT_DPI' value='96' type='text' maxlength='5' size='5' disabled>&nbsp;DPI</td>\n";
            echo "</tr><tr><td>&nbsp;".$RESOURCE_STRING["print_keep"].":</td><td>";
            echo "<input type='radio' id='IMG_DONT_ADAPT_BBOX' name='IMG_DONT_ADAPT' onClick='ResolutionSwitch();' value='bbox' ".($params['default_keep']=='bbox' ? 'checked' : '')." disabled>".$RESOURCE_STRING["print_keep_bbox"]."<br>";
            echo "<input type='radio' id='IMG_DONT_ADAPT_SIZE' name='IMG_DONT_ADAPT' onClick='ResolutionSwitch();' value='size' ".($params['default_keep']=='size' ? 'checked' : '')." disabled>".$RESOURCE_STRING["print_keep_size"]."</td>";
            echo "</tr>\n";
            echo "</table>\n";
            echo "<script>ResolutionSwitch();</script>\n";
          break;

      case 'orientation':
            if(is_array($sections[$name])) {
              echo "<br>";
              echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_orientation"]."</span><HR class=\"subtitle\">";
              //echo "<font class='info'>".$RESOURCE_STRING["print_orientation_info"]."</font>\n";
              echo "<table>\n";
              if($params['vertical']) echo "<tr><td valign='bottom'><input type='radio' name='orientace' value='vertical' onclick='setImg(\"img_orientace\",\"vertical\")' ".($params['default']=='vertical' ? 'checked' : '')."></td><td valign='bottom' width='470'>".$RESOURCE_STRING["print_orientation_vertical"]."</td>\n";
              echo "<td rowspan='2'><img name='img_orientace' src='".FileUpURL('images/print/vertical.gif')."' width='85' height='85'></td></tr>\n";
              if($params['horizontal']) echo "<tr><td valign='top'><input type='radio' name='orientace' value='horizontal' onclick='setImg(\"img_orientace\",\"horizontal\")' ".($params['default']=='horizontal' ? 'checked' : '')."></td><td valign='top' width='470'>".$RESOURCE_STRING["print_orientation_horizontal"]."</td></tr>\n";
              echo "</table>\n";
            }
          break;

      case 'legend':
            if(is_array($sections[$name])) {
              echo "<br>";
              echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_legend"]."</span><HR class=\"subtitle\">";
              echo "<table>\n";
              echo "<tr><td><input type='checkbox' name='legenda' ".($params['default']?'checked':'')."></td><td>".$RESOURCE_STRING["print_legend_print"]."</td></tr>\n";
              echo "</table>\n";
            }
          break;

      case 'title':
            if(is_array($sections[$name])) {
              echo "<br>";
              echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_title"]."</span><HR class=\"subtitle\">";
              echo "<input type='text' name='TITLE' size='100' maxlength='100' value='".$TITLE."'>\n";
              echo "<br>";
            }
          break;

      case 'note':
            if(is_array($sections[$name])) {
              echo "<br>";
              echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_note"]."</span><HR class=\"subtitle\">";
              echo "<textarea name='POZNAMKA' rows='6' cols='45'>".$POZNAMKA."</textarea>\n";
              echo "<br>";
            }
          break;

      case 'img_format':
            echo "<br>";
            echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_img_format"]."</span><HR class=\"subtitle\">";
            echo "<select name='IMG_FORMAT'>\n";
            foreach($params as $format=>$on) {
              if(in_array($format,array('PNG','JPEG','GIF')) && $on)
                echo "<option value='".$format."'>".$format."</option>\n";
            }
            echo "</select>\n";
            echo "</p>\n";
          break;

      case 'image_frame':
            if(is_array($sections[$name])) {
              echo "<br>";
              echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_border"]."</span><HR class=\"subtitle\">";
              echo "<table>\n";
              echo "<tr><td><input type='checkbox' name='RAMECEK' ".($params['default']?'checked':'')."></td><td>".$RESOURCE_STRING["print_border_print"]."</td></tr>\n";
              echo "</table>\n";
            }
          break;

      case 'coords':
            if(is_array($sections[$name])) {
              echo "<br>";
              echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_xy"]."</span><HR class=\"subtitle\">";
              echo "<table>\n";
              echo "<tr><td><input type='checkbox' name='SOURADNICE' ".($params['default']?'checked':'')."></td><td>".$RESOURCE_STRING["print_xy_print"]."</td></tr>\n";
              echo "</table>\n";
              echo "</p>\n";
            }
          break;

      case 'DKM':
            if(is_array($sections[$name])) {
              echo "<br>";
              echo "<img src=".FileUpURL($separator_img).">&nbsp;<span class=\"filterblock_main\">".$RESOURCE_STRING["print_dat_akt_dkm"]."</span><HR class=\"subtitle\">";
              echo "<table>\n";
              echo "<tr><td><input type='checkbox' name='dat_akt_dkm' ".($params['default']?'checked':'')."></td><td>".$RESOURCE_STRING["print_dat_akt_dkm_print"]."</td></tr>\n";
              //vladr - 20.1.2005 - start
              //echo "<tr><td><input type='checkbox' name='dat_akt_drm'></td><td>".$RESOURCE_STRING["print_dat_akt_drm_print"]."</td></tr>\n";
              //vladr - end
              echo "</table>\n";
              echo "</p>\n";
            }
          break;
    }
  }

  echo "<HR class=\"subtitle\">";
  echo "<input type='submit' value='".$submit_label."'>\n";
  echo "</form>\n";

  if($mode=='print') {
    echo "<script>\n";
    echo "img=new Object();\n";
    echo "img.o1='".FileUpURL('images/print/o1.gif')."';\n";
    echo "img.o2='".FileUpURL('images/print/o2.gif')."';\n";
    echo "img.horizontal='".FileUpURL('images/print/horizontal.gif')."';\n";
    echo "img.vertical='".FileUpURL('images/print/vertical.gif')."';\n";
    echo "</script>\n";
  }
?>
  <script>
    function frm_edit_Validator(f) {
      if(format(f['format']) == 'NVU') {
        if ((f['WIDTH']) && f['WIDTH'].value) {
          if (!IsNumber(f['WIDTH'].value)) {
            alert("<?php =$RESOURCE_STRING['print_validate_width']?>");
            return false;
          }
        } else return false;
        if ((f['HEIGHT']) && f['HEIGHT'].value) {
          if (!IsNumber(f['HEIGHT'].value)) {
            alert("<?php =$RESOURCE_STRING['print_validate_height']?>");
            return false;
          }
        } else return false;
      }
    }
    function IsNumber(str) {
      var valid = "0123456789"
      var temp;
      var IsNumber = true
      for (var i=0; i<str.length; i++) {
        temp = "" + str.substring(i, i+1);
        if (valid.indexOf(temp) == "-1") IsNumber = false;
      }
      return IsNumber;
    }
    function format(f){
      for (var i=1;i<=f.length;i++){
        if (f[i-1].checked) var r=f[i-1].value;
      }
      return r;
    }
    function setFormat() {
      var w = window.document;
      for (var i=1;i<=document.frm_size.format.length;i++){
        if (document.frm_size.format[i-1].value=='NVU') document.frm_size.format[i-1].checked = true;
      }
    }
    function setImg(obj,img_name) {
      document.frm_size[obj].src = img[img_name];
    }
  </script>
<?php
  require(FileUp2("html_footer.inc"));
}
?>
