<?php

class postgthm {

  var $ident = "POSTGTHM";

  function Initial() {
  }

  function Destroy() {
  } 

  function TMapServer_Interface (&$dblayer) {
    static $cache=array();
    
    $this->parameters = array_merge($dblayer->parameters,$dblayer->parameters["HTTP_VARS"]);
    $this->command = $this->parameters[$this->prefix."_Command"];
    switch ($this->command) {
    case 'Clear':
      $this->values = array();
      $this->layers_breaks = array();
    break;
    case 'ThemMap':
      $this->values = array();
      foreach ($this->parameters as $key=>$val) {
        if (preg_match('/^'.$this->prefix.'_PAR_([A-Z_]*)$/',$key,$ret)) {
          if (preg_match('/^[A-Za-z_0-9,]+$/',$val)) {
            $this->values[$ret[1]]=$val;
          } else {
            die('BAD parameter '.$key);
          }
        }
      }
      $db = new $this->db['db_name'];
      $this->layers_properties=array();

      foreach ($this->layers as $key=>$lr) {

        $break_method = $lr['breaks']['method']?$lr['breaks']['method']:$this->default['breaks']['method'];
        switch ($break_method) {
          case 'cumulate':
            $select_cumulate = $this->replace_variable($lr['select_cumulate'],$this->values);
            $cachekey = md5($select_cumulate);
            if ($cache[$cachekey]) {
              $this->layers_breaks[$key] = $cache[$cachekey];
            } else {
              $this->layers_breaks[$key] = array();
              $this->layers_breaks[$key]['method']=$break_method;
              $db->query($select_cumulate['sum']);
              if ($db->next_record()) {
                $sum = $db->Record[0];
                $cnt = $db->Record[1];
              }
              $db->query($select_cumulate['detail']);
              $cumulate = array_merge_recursive($this->default['breaks']['cumulate'], $lr['breaks']['cumulate']);
              $cumulate_index = 0; 
              $cumulate_break = $sum*$cumulate[$cumulate_index]['percentage']/(double)100;
              $sum_cur = 0;
              $count = 0;
              $count_sum = 0;
              while ($db->next_record()) {
                $count++; $count_sum++;
                $sum_cur += $db->Record[0];
                if ($cumulate_break < $sum_cur) {
                  $this->layers_breaks[$key]['breaks'][] = array(
                    'name'=>$cumulate[$cumulate_index]['name'],
                    'value'=>$db->Record[0],
                    'count'=>$count
                  );
                  $count = 0;
                  $cumulate_break += $sum*$cumulate[++$cumulate_index]['percentage']/(double)100;
                }
                if (!isset($cumulate[$cumulate_index+1])) {
                  $this->layers_breaks[$key]['breaks'][] = array(
                    'name'=>$cumulate[$cumulate_index]['name'],
                    'count'=>$cnt-$count_sum
                  );
                  break;
                }
              }
              $cache[$cachekey] = $this->layers_breaks[$key];
            }
          break;
          case 'avg':
          case 'none':
          default:
            $sel_min_max = $this->replace_variable($lr['select_min_max'],$this->values);
            $break_count = isset($lr['breaks']['count'])?$lr['breaks']['count']:$this->default['breaks']['count'];
            $cachekey = md5($sel_min_max);
            if ($cache[$cachekey]) {
              $this->layers_breaks[$key] = $cache[$cachekey];
            } else {
              $db->query($sel_min_max);
              if ($db->next_record()) {
                $this->layers_breaks[$key] = array(
                  'method'=>$break_method,
                  'min'=>(double)$db->Record['MIN'],
                  'max'=>(double)$db->Record['MAX'],
                  'avg'=>(double)$db->Record['AVG'],
                );
                $cache[$cachekey] = $this->layers_breaks[$key];
              }
            }
            $this->layers_breaks[$key]['break_count']=$break_count;
            switch ($break_method) {
              case 'avg':
                $bdiff = $lr['breaks']['avg_diff']?$lr['breaks']['avg_diff']:$this->default['breaks']['avg_diff'];
                $bdiff = $bdiff?$bdiff:0;
                $this->layers_breaks[$key]['diff'] = ($this->layers_breaks[$key]['avg'] - $this->layers_breaks[$key]['min'])/(double)($break_count+$bdiff);
              break;
              case 'none':
              break;
              default:
                $this->layers_breaks[$key]['diff'] = ($this->layers_breaks[$key]['max'] - $this->layers_breaks[$key]['min'])/(double)($break_count+1);
              break;
            }
          break;
        }
      }
      break;
    }
  }
  
  function TMapServer_SaveSession ($project) {
      $GLOBALS["TMapServer"][$project][$this->ident] = array(
        "values"=>$this->values,
        'layers_breaks'=>$this->layers_breaks
      );   
  }
  
  function TMapServer_OpenSession ($project) {
    $settings = $GLOBALS["TMapServer"][$project][$this->ident];
    if ($settings['values']) {
      $this->values = $settings['values'];
      $this->layers_breaks = $settings['layers_breaks'];
    }
  }

  function TMapServer_WriteLayerBefore (&$layer, $type) {
    if (!$this->values) return false;
    $layer->MapTempObject = $this->CheckTemporaryMapFile(&$layer);
    
    function round_thm($value, $diff) {
      if ($diff < 0.1)
        return Round($value,2);
      if ($diff < 1)
        return Round($value,1);
      elseif ($diff > 1000)
        return Round($value/1000)*1000;
      elseif ($diff > 100)
        return Round($value/100)*100;
      elseif ($diff > 10)
        return Round($value/10)*10;
      else
        return Round($value);
    }
    
    foreach ($this->layers as $key=>$lr) {
      $maplr  = '';
      
      $lr['variables'] = array_merge($this->default['variables'], $lr['variables']);
      
      $maplr .= $this->replace_variable($lr['map']['header']?$lr['map']['header']:$this->default['map']['header'],$lr['variables']);
      $maplr .= $this->replace_variable($lr['map']['data']?$lr['map']['data']:$this->default['map']['data'],array('SELECT'=>$this->replace_variable($lr['select'],$this->values)));
      
      //breaks
      $class = $lr['map']['class']?$lr['map']['class']:$this->default['map']['class']; 
      $breaks = $this->layers_breaks[$key];

      switch ($lr['breaks']['method']) {
        case 'cumulate':
          $class_cumulate = array_merge_recursive($this->default['breaks']['cumulate'], $lr['breaks']['cumulate']);
          //die(print_R($breaks));
          for ($i=0; $i<Count($breaks['breaks']); $i++) {
            $break = $breaks['breaks'][$i];
            $vars = array_merge($lr['variables'],$class_cumulate[$i]['class']);
            $vars['CLASS_NAME'] = $break['name'].' ('.$break['count'].')';
            if (isset($break['value'])) {
              $vars['CLASS_BREAK']= '>= '.$break['value'];
            } else {
              $vars['CLASS_BREAK']= '< '.$breaks['breaks'][$i-1]['value'];
            }
            $maplr .= $this->replace_variable($class,$vars);
          }
          //die(print_r($maplr));
        break;
        case 'none':
        case 'avg':
        default:
          $class_vars = array_merge_recursive($this->default['breaks']['class'], $lr['breaks']['class']);
          $text_len = StrLen(Round($breaks['max']));
          if (StrLen(Round($breaks['min'])) > $text_len) $text_len = StrLen(Round($breaks['min']));
          $text_len += 3;
    
          if ($breaks) {
            $break_value = $breaks['min']+($breaks['diff']/(double)2);
            for ($i=0; $i<$breaks['break_count']; $i++) {
              $vars = array_merge($lr['variables'],$class_vars['C'.$i]);
              $class_name = number_format(round_thm($break_value,$breaks['diff']),1, '.', ' ');
              //$class_name = substr($class_name,-1,4);
              $class_name = Preg_Replace('/^(.*)(.{'.$text_len.'})$/','\2','           '.$class_name);
              $class_name = Preg_Replace('/(\.0)$/','  ',$class_name);
              if ($i==($breaks['break_count']-1)) {
                $vars['CLASS_NAME'] = '>= '.$class_name;
                $vars['CLASS_BREAK']= '>='.round_thm($break_value,$breaks['diff']);
              } else {
                $vars['CLASS_NAME'] = '<  '.$class_name;
                $vars['CLASS_BREAK']= '< '.round_thm($break_value,$breaks['diff']);
              }
              if ($i<($breaks['break_count']-2)) {
                $break_value += $breaks['diff'];
              }
              $maplr .= $this->replace_variable($class,$vars);
            }
          }
        break;
      }
      $maplr .= $this->replace_variable($lr['map']['footer']?$lr['map']['footer']:$this->default['map']['footer'],$lr['variables']);

      $lr['variables']['PGBBOX'] = $layer->request['bbox']['minx'].' '.$layer->request['bbox']['miny'].','.$layer->request['bbox']['maxx'].' '.$layer->request['bbox']['maxy'];
      $maplr = $this->replace_variable($maplr,$lr['variables']);

      $bookmark = $lr['map']['bookmark']?$lr['map']['bookmark']:$this->default['map']['bookmark'];
      $layer->MapTempObject->mem_map_file = Str_replace($bookmark,$maplr."\n".$bookmark, $layer->MapTempObject->mem_map_file);
    }
    
    //die(print_r($layer->MapTempObject->mem_map_file));
    $layer->MapTempObject->SaveMapFileFromMemory($lr->MapFileName);
  } 

  function TMapServer_WriteLayerAfter (&$layer, $type, $params) {
  }
   
  function TMapServer_WriteLegend($val) {
  }
  
  function CheckTemporaryMapFile(&$layer) {    
    //Check temporary map file
    if ($layer->MapTempObject) {
    } else if (!$layer->MapFileIsTemp) {
      $proj = &$layer->manager->GetProject($layer->name);
      $mapfile = $proj["servers"][0]["project"];
      $layer->MapTempObject = &$layer->objects->GetCachedObjectByName("mapscript_map");
      $mapfile = $layer->MapTempObject->CopyMapToTempFile($mapfile, true, true); //CopyMapToTempFile ($filename=false, $replace=true, $loadintomemory=false)
      if ($mapfile) {
        $layer->MapFileIsTemp = true;
        $layer->MapFileName = $mapfile;
        $proj["servers"][0]["project"] = $mapfile;
      }
      $layer->objects->SetCachedObject($layer->MapTempObject);
    } else {
      $layer->MapTempObject = &$layer->objects->GetCachedObjectByName("mapscript_map");
    }
    return $layer->MapTempObject;
  }    

  function replace_variable($string, $vars) {
    foreach ($vars as $key=>$val) {
      $string = Str_Replace('%'.$key.'%',$val,$string);
    }
    return $string;
  }
  
}

?>
