<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: thmap_charts.inc,v 1.4 2008/02/07 13:43:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

include_once (FileUp2(".admin/objects/thematic_mapping/thmap.inc")); 

class tmapy_thmap_charts {

//******************************************************************************
  
  //InternalHandlers

  function OnGetDataFromRDBMS(&$record, &$main) {
    $id = $record[$main->map_style["table_data"]["field_id"]];
    switch ($main->map_style["table_data"]["type"]) {
      case "Normal":
        $main->data[$id]["data"] = $record;
      break;
      case "Transp":
        $value = (float)$record[$main->map_style["table_data"]["field_value"]];
        $value_type = $record[$main->map_style["table_data"]["field_value_type"]];
        $main->data[$id]["data"][$value_type] = $value;
        $this->limits["max"] = (!isset($this->limits["max"]) || $this->limits["max"] < $value)?$value:$this->limits["max"];
        $this->limits["min"] = (!isset($this->limits["min"]) || $this->limits["min"] > $value)?$value:$this->limits["min"];
        if ($main->map_style["table_data"]["field_value_desc"])
          $this->unique_value_types[$value_type] = $record[$main->map_style["table_data"]["field_value_desc"]];  
      default:
      break;
    }
  }

  function OnGetDataFromMap(&$record, &$main) {
    $id = $record[$main->map_style["table_data"]["layer_field_id"]];
    if ($record["mid"]) {
      $center = Explode(" ", $record["mid"]);
    } else {
      $ext = Explode(" ", $record["ext"]);
      $center[0] = ($ext[2]+$ext[0])/2;
      $center[1] = ($ext[3]+$ext[1])/2;
    }
    $main->data[$id]["center"] = $center;
//    die(print_r($main->data));
  }
  
  function OnSaveSession(&$var,&$main) {
   $var["data"] = $main->data;
   $var["unique_value_types"] = $this->unique_value_types;
   $var["limits"] = $this->limits;
  }

  function OnOpenSession(&$var,&$main) {
   $main->data = $var["data"];
   $this->unique_value_types = $var["unique_value_types"];
   $this->limits = $var["limits"];
  }
  
  function OnPrepareThematicMapping (&$dblayer, &$main) {
    return true;
  }


  function OnWriteLayerBefore (&$main, &$layer) {

    switch ($main->imgtype) {
      case "PNG":
        $imgext = '.png';
      break;  
      case "JPEG":
        $imgext = '.jpg';
      break;
      case "GIF":
      default:
        $imgext = '.gif';
      break;  
    }
  
    $this->ImageTemp = Eregi_Replace('(.*)\.map$',"\\1".$imgext,$layer->MapFileName);
    
    //Image coord sizes
    $main->request = $layer->request;
    if ($layer->request["print"]) { 
      $this->map_width = $layer->request["print"]["maxx"] - $layer->request["print"]["minx"];
      $this->map_height = $layer->request["print"]["maxy"] - $layer->request["print"]["miny"];
      $this->width = $layer->request["print"]["width"];
      $this->height = $layer->request["print"]["height"];
      $this->bbox = $layer->request["print"]; 
    } else {    
      $this->map_width = $layer->request["bbox"]["maxx"] - $layer->request["bbox"]["minx"];
      $this->map_height = $layer->request["bbox"]["maxy"] - $layer->request["bbox"]["miny"];
      $this->width = $layer->request["width"];
      $this->height = $layer->request["height"];
      $this->bbox = $layer->request["bbox"]; 
    }

    //Diffs
    $main->map_style["pie"]["scale"]["diff_size"] = $main->map_style["pie"]["scale"]["max"]["size"]-$main->map_style["pie"]["scale"]["min"]["size"];
    $main->map_style["pie"]["scale"]["diff_value"] = $main->map_style["pie"]["scale"]["max"]["value"]-$main->map_style["pie"]["scale"]["min"]["value"];
    
    //Create image
    $img = @ImageCreate($this->width, $this->height) or die ("Cannot Initialize new GD image stream");

    //Tranparent color
    if ($main->map_style["image"]["transparent_color"]) {
      $color_transp = imagecolorallocate($img, $main->map_style["image"]["transparent_color"][0], $main->map_style["image"]["transparent_color"][1], $main->map_style["image"]["transparent_color"][2]);
    } else { 
      $color_transp = imagecolorallocate($img, 255, 255, 255);
    }
    imagecolortransparent($img, $color_transp);
    
    //Colors
    $i = 0;
    reset($main->map_style["classes"]);
    while (list($key, $val) = each($main->map_style["classes"])) {
//      $main->map_style["colors"][] = $val["color"];
      $val["id"] = isset($val["id"])?$val["id"]:$i++;
      $main->map_style["colors"][$val["id"]] = $val["color"];
    } 
    
    //
  //      $circleColor = imagecolorallocate($img, 255, 0, 0); 
  //      $circleColor2 = imagecolorallocate($img, 0, 0, 255); 
  
  //die(print_r($main));
/*    include_once ($GLOBALS["TMAPY_LIB"]."/lib/jpgraph/jpgraph.php");
    switch ($main->map_style["type"]){
      case "Pie3D":
        include_once ($GLOBALS["TMAPY_LIB"]."/lib/jpgraph/jpgraph_pie.php");
        include_once ($GLOBALS["TMAPY_LIB"]."/lib/jpgraph/jpgraph_pie3d.php");
      break;
      case "Pie":
        include_once ($GLOBALS["TMAPY_LIB"]."/lib/jpgraph/jpgraph_pie.php");
      break;
    }*/
  
    reset($main->data);
//    die(print_r($main));
    $i = 0;
    reset($main->data);
    while (list($key, $val) = each($main->data)) {
  
      switch ($main->map_style["table_data"]["type"]) {
        case "Normal":
          $data = array();
          reset($main->map_style["classes"]);
          while (list($key2, $val2) = each($main->map_style["classes"])) {
            $data[$val2["id"]] = $val["data"][$val2["id"]];
          }
          $val["data"] = $data;
        break;
      }
  
      if (($this->bbox["minx"] < $val["center"][0] && $this->bbox["maxx"] > $val["center"][0]) &&
          ($this->bbox["miny"] < $val["center"][1] && $this->bbox["maxy"] > $val["center"][1])) {   
       $this->DrawChart (&$img, $main->map_style["type"], $val, $main);
        if ($i++ == $main->map_style["count_limit_in_extent"]) break; 
      }

    }
  
    switch ($main->imgtype) {
      case "PNG":
        ImagePNG($img, $this->ImageTemp);
      break;  
      case "JPEG":
        ImageJPEG($img, $this->ImageTemp);
      break;
      case "GIF":
      default:
        ImageGIF($img, $this->ImageTemp);
      break;  
    }

//    ImageGIF($img, $this->ImageTemp);
//    ImageGIF($img);
  
  
    $ms_class = "DATA '".$this->ImageTemp."'";
    
    return $ms_class;
  }      

  function OnWriteLayerAfter (&$main) {
    @unlink($this->ImageTemp);
  }
  

  function OnWriteLegend (&$main, $showcaption=true) {
      if ($showcaption) {
        $this->output .=  "<span class=\"captionlegend\">".$main->caption["main"]."</span><br>\n";
        if ($main->caption["sub"]) $this->output .=  $main->caption["sub"]."<br>\n";
      }
      $this->output .=  "<table class=\"legend\" border=\"0\" cellspacing=\"0\">\n";

      //BAR - sort data
      if ($this->unique_value_types && ($main->map_style["type"] == "Bar")) ksort($this->unique_value_types);
      
      reset($main->map_style["classes"]);
      while(list(,$class) = each($main->map_style["classes"])) {
        if ($this->unique_value_types && ($main->map_style["type"] == "Bar")) {
          $caption = Current($this->unique_value_types);
          if (!$caption) continue;
          $this->output .=  "<tr class=\"legend\"><td width=$table_img_width height=$table_height>";
          $this->output .=  LegendDrawImage($class["color"], $main->map_style[StrToLower($main->map_style["type"])]["no_border"]?array(255,255,255):$main->map_style[StrToLower($main->map_style["type"])]["border_color"]);
          Next($this->unique_value_types);
        } else {
          $this->output .=  "<tr class=\"legend\"><td width=$table_img_width height=$table_height>";
          $this->output .=  LegendDrawImage($class["color"], $main->map_style[StrToLower($main->map_style["type"])]["no_border"]?array(255,255,255):$main->map_style[StrToLower($main->map_style["type"])]["border_color"]);
          $caption = $class["caption"];
        }
        $this->output .=  "</td><td class=\"legend\">".$caption."</td>";
        $this->output .=  "</tr>\n";
      }
      $this->output .=  "</table><BR>\n";
  }

  
//******************************************************************************
// Internal methods


  function DrawChart (&$im, $type, &$data, &$main) {
    if (!Count($data["data"])) return false;
            
    switch ($type){
      case "Pie":
      case "Pie3D":

        $sum = 0;
//        die(print_r($main));
        reset($data["data"]);
        while (list($key, $val) = each($data["data"])) 
          $sum += ($val>0)?$val:0;

        if ($sum<=0) return false;
        
        $size = @Round($main->map_style["pie"]["scale"]["min"]["size"] + ($main->map_style["pie"]["scale"]["diff_size"])/($main->map_style["pie"]["scale"]["diff_value"])*$sum);
        
        if ($main->map_style["pie"]["scale"]["units"] == "map") 
          $size = Round($this->width/$this->map_width*$size);
          
        if ($size < 5) $size = 10;

        $degrees = Array();
        $diameter = Round($size);
        $radius = $diameter/2;

        $im_pie = ImageCreate($diameter+1, $diameter+1);
        
        // convert each slice into corresponding percentage of 360-degree circle
        reset($data["data"]);
        while (list($key, $val) = each($data["data"])) {
          $degrees[$key] = ($val/$sum) * 360;
        }
        // Allocate colors
        reset($main->map_style["colors"]);
        $border_color = $main->map_style["pie"]["border_color"];
        $main->map_style["pie"]["border_color"]["handle"] = ImageColorAllocate($im_pie, $border_color[0], $border_color[1], $border_color[2]);
        $border_color = $main->map_style["pie"]["border_color"]["handle"];
        $white = ImageColorAllocate($im_pie, 255, 255, 255);
        reset($main->map_style["colors"]);
        while (list($key, $val) = each($main->map_style["colors"])) {
          $main->map_style["colors"][$key]["handle"] = ImageColorAllocate($im_pie, $val[0], $val[1], $val[2]);
        }
        
        // fill image with white
        ImageFill($im_pie, 0, 0, $white);
        imagecolortransparent ($im_pie, $white);
        
        // draw baseline
        $end_x = $diameter;
        $end_y = $radius;
        ImageLine($im_pie, $radius,$radius, $end_x, $end_y, $border_color);

        ImageArc($im_pie, $radius, $radius, $diameter, $diameter, 0, 360, $border_color); 
        
        $last_angle = 0;
        reset($data["data"]);
        $clear_lines = array();
        while (list($key, $val) = each($data["data"])) {

          if (!$val) continue;
          
          // calculate and draw arc corresponding to each slice
          ImageArc($im_pie, $radius, $radius, $diameter, $diameter, $last_angle, ($last_angle+$degrees[$key]), $border_color); 
          $last_angle += $degrees[$key];
        
          ImageFillToBorder($im_pie, $diameter-4, $radius-1, $border_color, $main->map_style["colors"][$key]["handle"]);

          if ($main->map_style["pie"]["no_border"])
            $clear_lines[]=array(
              "color"=>$main->map_style["colors"][$key]["handle"],
              "end_x"=>$end_x,         
              "end_y"=>$end_y
             );
                    
          if ($last_angle == 180) {
            $end_x = 0;
            $end_y = $radius;
          } else { 
            $end_x = round($radius + ($radius * cos($last_angle*pi()/180)));
            $end_y = round($radius + ($radius * sin($last_angle*pi()/180)));
          }

          ImageLine($im_pie, $radius, $radius, $end_x, $end_y, $border_color);

//          if ($i == 2) ImageGIF($im_pie);
          $i++;

        }

        if ($main->map_style["pie"]["no_border"]) {
          reset($clear_lines);
          while (list($key, $val) = each($clear_lines)) {  
            ImageLine($im_pie, $radius, $radius, $val["end_x"], $val["end_y"], $val["color"]);
          }
          ImageArc($im_pie, $radius, $radius, $diameter, $diameter, 0, 360, $white); 
        } 
        ImageArc($im_pie, $radius, $radius, $diameter+2, $diameter+2, 0, 360, $white);
        ImageArc($im_pie, $radius, $radius, $diameter+4, $diameter+4, 0, 360, $white);
        
        // this section is meant to calculate the mid-point of each slice
        // so that it can be filled with colour
        
        // initialize some variables
        $prev_angle = 0;
        $pointer = 0;
        
        $dx = $size/2;
        $dy = $size/2;
        
        $im_pie_w = $size+1;
        $im_pie_h = $size+1;
        $x = Round($this->width/$this->map_width*($data["center"][0] - $this->bbox["minx"])-$dx);
        $y = $this->height - Round($this->height/$this->map_height*($data["center"][1] - $this->bbox["miny"]) + $dy);
        
//        ImageGIF($im_pie);
        
        ImageCopy($im, $im_pie, $x, $y, 0, 0, $im_pie_w ,  $im_pie_h);
        
        ImageDestroy($im_pie);
      break;
      case "Bar":

        $min = 0;
        $max = 0;

        if ($main->map_style["bar"]["scale"]["units"] == "map")  
          $mapcoef = $this->width/$this->map_width;
        else
          $mapcoef = 1;
        
        if ($main->map_style["bar"]["scale"]["column"]["width"]["size"]*$mapcoef < $main->map_style["bar"]["scale"]["column"]["width"]["min_pixels"]) 
          $mapcoef = $main->map_style["bar"]["scale"]["column"]["width"]["min_pixels"]/$main->map_style["bar"]["scale"]["column"]["width"]["size"];

        if ($main->map_style["bar"]["scale"]["column"]["width"]["size"]*$mapcoef > $main->map_style["bar"]["scale"]["column"]["width"]["max_pixels"]) 
          $mapcoef = $main->map_style["bar"]["scale"]["column"]["width"]["max_pixels"]/$main->map_style["bar"]["scale"]["column"]["width"]["size"];
        
        reset($data["data"]);
        $len = 0;
        while (list($key, $val) = each($data["data"])) {
          $min = ($min < $val)?$min:$val;
          $max = ($max > $val)?$max:$val;
          if ($main->map_style["bar"]["text"]) {
//            $val += 150000.54588;
            if (is_numeric($val)) $data["text"][$key] = RTrim(RTrim(number_format($val, 3, ',', ' '),'0'),',');
            else $data['text'][$key] = $val;
            $curlen = imagettfbbox($main->map_style["bar"]["text"]["size"], 90, $main->map_style["bar"]["text"]["font"], $data['text'][$key]);
            $curlen2 = Abs($curlen[4]-$curlen[2]);
            $len2 = ($len2 > $curlen2)?$len2:$curlen2;
            $curlen = Abs($curlen[3]-$curlen[1]);
            $len = ($len > $curlen)?$len:$curlen;
          }
        }
        $value_coef = $main->map_style["bar"]["scale"]["column"]["height"]["max"]/($this->limits["max"]-$this->limits["min"]);
        
        $zerro = $max*$value_coef*$mapcoef+1+$len+4;
        
        $w = ($main->map_style["bar"]["scale"]["column"]["width"]["size"]*$mapcoef+1)*Count($data["data"])+1;
        $h = ($max-$min)*$value_coef*$mapcoef+2+$len+4;
        $im_bar = ImageCreate($w, $h);

        // Allocate colors
        reset($main->map_style["colors"]);
        $border_color = $main->map_style["bar"]["border_color"];
        $main->map_style["bar"]["border_color"]["handle"] = ImageColorAllocate($im_bar, $border_color[0], $border_color[1], $border_color[2]);
        $border_color = $main->map_style["bar"]["border_color"]["handle"];
        if (!$main->map_style["bar"]["zerro_color"])
          $zerro_color = $border_color;
        else {
          $zerro_color = $main->map_style["bar"]["zerro_color"];
          $main->map_style["bar"]["zerro_color"]["handle"] = ImageColorAllocate($im_bar, $zerro_color[0], $zerro_color[1], $zerro_color[2]);
          $zerro_color = $main->map_style["bar"]["zerro_color"]["handle"];
        }
        $white = ImageColorAllocate($im_bar, 255, 255, 255);
        while (list($key, $val) = each($main->map_style["colors"])) {
          $main->map_style["colors"][$key]["handle"] = ImageColorAllocate($im_bar, $val[0], $val[1], $val[2]);
        }
        $main->map_style["bar"]["text"]["color"]["handle"] = ImageColorAllocate($im_bar, $main->map_style["bar"]["text"]["color"][0], $main->map_style["bar"]["text"]["color"][1], $main->map_style["bar"]["text"]["color"][2]);
        if ($main->map_style["bar"]["text"]["outline_color"])
          $main->map_style["bar"]["text"]["outline_color"]["handle"] = ImageColorAllocate($im_bar, $main->map_style["bar"]["text"]["outline_color"][0], $main->map_style["bar"]["text"]["outline_color"][1], $main->map_style["bar"]["text"]["outline_color"][2]);
//        die(print_r($main));
        
        // fill image with white
        ImageFill($im_bar, 0, 0, $white);
        imagecolortransparent ($im_bar, $white);

        //BAR - sort - data
        ksort($data["data"]);        

        reset($data["data"]);
        $x1 = 1;
        $i = 0; 

        while (list($key, $val) = each($data["data"])) {
          $y1 = $zerro-($val*$value_coef*$mapcoef);
          $x2 = $x1+$main->map_style["bar"]["scale"]["column"]["width"]["size"]*$mapcoef;
          $y2 = $zerro;
          if ($this->unique_value_types) {
            $color = $main->map_style["colors"][$i++]["handle"];
          } else {
            $color = $main->map_style["colors"][$key]["handle"];
          } 
          if ($y1 < $y2) 
            ImageFilledRectangle($im_bar, $x1, $y1, $x2, $y2, $color);
          else 
            ImageFilledRectangle($im_bar, $x1, $y2, $x2, $y1, $color);
          if (!$main->map_style["bar"]["no_border"])  
            ImageRectangle($im_bar, $x1, $y1, $x2, $y2, $border_color);
          
          if ($x2-$x1 >= $main->map_style["bar"]["text"]["size"]) {
            $ytext = (($y1 < $y2)?$y1:$y2)-2;
            $xtext = Round($x2-(($x2-$x1-$len2)/2));
            $text = $data["text"][$key];
            if ($main->map_style["bar"]["text"]["outline_color"]) {          
              for ($t=0; $t<8; $t++) {
                switch ($t) {
                  case 0: $dx=-1; $dy= 1; break;
                  case 1: $dx= 0; $dy= 1; break;
                  case 2: $dx= 1; $dy= 1; break;
                  case 3: $dx=-1; $dy=-1; break;
                  case 4: $dx= 0; $dy=-1; break;
                  case 5: $dx= 1; $dy=-1; break;
                  case 6: $dx=-1; $dy= 0; break;
                  case 7: $dx= 1; $dy= 0; break;
                }
                // Add some shadow to the text
                imagettftext($im_bar, $main->map_style["bar"]["text"]["size"], 90, $xtext+$dx, $ytext+$dy, $main->map_style["bar"]["text"]["outline_color"]["handle"], $main->map_style["bar"]["text"]["font"], $text);
              }
            }
            imagettftext($im_bar, $main->map_style["bar"]["text"]["size"], 90, $xtext, $ytext, $main->map_style["bar"]["text"]["color"]["handle"], $main->map_style["bar"]["text"]["font"], $text);
          }
          $x1 = $x2+1;
        }

        ImageLine($im_bar, 1, $zerro, $x2, $zerro, $zerro_color);

        $dx = $w/2;
        $x = Round($this->width/$this->map_width*($data["center"][0] - $this->bbox["minx"])-$dx);

        $dy = $h/2;
        $y = $this->height - Round($this->height/$this->map_height*($data["center"][1] - $this->bbox["miny"])+$dy);
        
/*        $dy = $zerro;
        $y = $this->height - Round($this->height/$this->map_height*($data["center"][1] - $this->bbox["miny"]) + $dy);*/
          
        ImageCopy($im, $im_bar, $x, $y-Round($h/2), 0, 0, $w, $h);

        ImageDestroy($im_bar);
      break;
    }
    return true;
  }  
  
  /*
  function DrawChart (&$im, $type, &$data, &$main) {
//    $data["data"]=array(20,27,45);
//        die(print_r($main));
    if (!Count($data["data"])) return false;
    switch ($type){
      case "Pie":
      case "Pie3D":

        $suma = array_sum($data["data"]);

//        $size = Round($main->map_style["pie"]["scale"]["min"]["size"] + ($main->map_style["pie"]["scale"]["diff_size"])/($main->map_style["pie"]["scale"]["diff_value"])*$suma);
        if ($size < 5) {
          $size = 5;
        }
                
//        include_once($GLOBALS["TMAPY_LIB"]."/lib/jpgraph/jpgraph.php");
//        include_once($GLOBALS["TMAPY_LIB"]."/lib/jpgraph/jpgraph_pie.php");
        
        $chart = new PieGraph($size, $size);
        $chart->SetFrame(false);
        $chart->img->SetTransparent("white");
        
        switch ($type){
          case "Pie":
            $plot = new PiePlot(array_values($data["data"]));
          break;
          case "Pie3D":
            $plot = new PiePlot3D(array_values($data["data"]));
//            $plot->SetCenter(0.5, 0.45);
            $plot->SetCenter(0.4);
            $plot->SetAngle($main->map_style["pie"]["angle"]?$main->map_style["pie"]["angle"]:40);
          break;
        }
        
        $plot->SetStartAngle($main->map_style["pie"]["start_angle"]?$main->map_style["pie"]["start_angle"]:M_PI);
//        $plot->HideLabels(true);
        $plot->SetSliceColors($main->map_style["colors"]);
        if ($main->map_style["pie"]["border_color"]) {
          $plot->color = $main->map_style["pie"]["border_color"];
        }
        @$plot->Stroke($chart->img);

        $dx = $chart->img->width/2;
        $dy = $chart->img->height/2;
        
        $im_w = $chart->img->width;
        $im_h = $chart->img->height;
        $x = Round($main->request["width"]/$this->map_width*($data["center"][0] - $this->bbox["minx"])-$dx);
        $y = $main->request["height"] - Round($main->request["height"]/$this->map_height*($data["center"][1] - $this->bbox["miny"]) + $dy);

        
        ImageCopy($im, $chart->img->img, $x, $y, 0, 0, $im_w, $im_h);
        $chart->img->Destroy();
      break;
    }
    return true;
  }  
  */
}

?>
