<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: thmap.inc,v 1.4 2004/12/01 09:36:55 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

include_once(FileUp2(".admin/map_functions.inc"));

class tmapy_thmap {

  var $prefix = "THMAP";

  function Initial() {
  }

  function Destroy() {
  }

  //******************************************************************************

  //TMapServerHandlers

  function TMapServer_Interface (&$dblayer) {
    $this->parameters = $dblayer->parameters["HTTP_VARS"];
    $this->command = $this->parameters[$this->prefix."_Command"];
    
    if ($this->command) { 
      switch ($this->command) {
        case "JoinSQL":
          
          //Create a database connection
          if ($this->table_sql["db_file"]) include_once($this->table_sql["db_file"]);
          $this->database = new $this->table_sql["db"];

          //Get Select
          $sql_ok = $this->GetSelect(&$dblayer);
          if (!$sql_ok) return false;

          //Get Style of thematic mapping
          if (!$this->GetStyle (&$dblayer)) return false;
          
          //Set object for Thematic mapping type
          $this->InitialRenderer();
          
          //Query database and prepare data
          if (!$this->QueryDataUsingSelect(&$dblayer, $sql)) return false;
//          die(print_r($this->data));
          //Set Extent on dblayer
          if (!$this->QueryDataInMapAndSetExtent(&$dblayer)) return false;

          //Prepare thematic mapping settings
          if (!$this->Renderer->OnPrepareThematicMapping(&$dblayer, $this)) return false;
          
          $this->caption["main"] = $this->parameters[$this->prefix."_Caption"]?$this->parameters[$this->prefix."_Caption"]:$this->caption["main"];
          $this->caption["sub"] = $this->parameters[$this->prefix."_SubCaption"]?$this->parameters[$this->prefix."_SubCaption"]:$this->caption["sub"];
          
        break;
        default:
          //$dblayer->output["error"] = true;
          //$dblayer->output["errorText"] = $this->prefix." (Command=".$this->command."): Unknown command.";
      }
    }
  } 

  function TMapServer_SaveSession ($project) {
    if ($this->map_style) {
//      die(var_dump($this));
      $GLOBALS["TMapServer"][$project][$this->ident] = array(
        "map_style"=>$this->map_style,
        "map_caption"=>$this->caption
      ); 
      $this->Renderer->OnSaveSession(&$GLOBALS["TMapServer"][$project][$this->ident], &$this);
    } else {
      unset($GLOBALS["TMapServer"][$project][$this->ident]);    
    }
  }
  
  function TMapServer_OpenSession ($project) {
    $settings = $GLOBALS["TMapServer"][$project][$this->ident];
    if ($settings["map_style"]) {
      $this->map_style = $settings["map_style"];
      $this->caption = $settings["map_caption"];
      $this->InitialRenderer();
      $this->Renderer->OnOpenSession($settings, &$this);
    }
  }
  
  function TMapServer_WriteLayerBefore (&$layer, $type) {
    if ($this->map_style) {
      $map = $this->CheckTemporaryMapFile(&$layer);      

      $ms_class = $this->Renderer->OnWriteLayerBefore($this, $layer);

      $map->ReplaceBookmarkInMapFile ($this->map_style["mapserver"]["bookmark"], $ms_class, $this->map_style["mapserver"]["start"], $this->map_style["mapserver"]["end"]);
      
      $map->SaveMapFileFromMemory();
    }
  }

  function TMapServer_WriteLayerAfter (&$layer, $type, $params) {
    if ($this->map_style) {
      $this->Renderer->OnWriteLayerAfter($this);
    }
  }
  
/*  function TMapServer_WriteLegend ($up=true, $showcaption=true) {
    if ($this->map_style && $up) {
      $this->Renderer->OnWriteLegend($this,$showcaption);
    }
  }*/

  function TMapServer_WriteLegend (&$layer, $type) {
    if ($this->map_style) {
      $this->Renderer->OnWriteLegend($this,true);
      $layer->legend_output .= $this->Renderer->output;
    }
  }
  
  
//******************************************************************************

  //Internal

  function InitialRenderer() {
    $dir = Str_Replace("\\","/",DirName(__FILE__));
    switch ($this->map_style["type"]) {
      case "ClassBreaks":
      case "ValueMap":
        include_once($dir."/thmap_valuemap_classbreaks.inc");
        $this->Renderer = new tmapy_thmap_valuemap_classbreaks;
      break;
      case "Pie":
      case "Pie3D":
      case "Bar":
        include_once($dir."/thmap_charts.inc");
        $this->Renderer = new tmapy_thmap_charts;
      break;
    }  
  }
  
  function GetSelect (&$dblayer) {

    //Create or get the SQL command
    $table_sql = $this->parameters[$this->prefix."_SQL"]?$this->parameters[$this->prefix."_SQL"]:$this->table_sql["sql"];
    if (!$table_sql) {
      $dblayer->output["error"] = true;
      $dblayer->output["errorText"] = $this->ident." (Command=".$this->command."): Missing settings \"".$this->prefix."_SQL"."\".";
      return false;
    }

    //Type of gettting select
    switch ($this->table_sql["type"]):
      //Direct select
      case "direct":
        $sql = $table_sql;
      break;
      //Select from table
      default:
        //Get field with select id 
        if (!$this->table_sql["field_id"]) {
          $dblayer->output["error"] = true;
          $dblayer->output["errorText"] = $this->ident." (Command=".$this->command."): Missing settings \"table_sql[field_id]\".";
          return false;
        }
        //Get field with select SQL 
        if (!$this->table_sql["field_sql"]) {
          $dblayer->output["error"] = true;
          $dblayer->output["errorText"] = $this->ident." (Command=".$this->command."): Missing settings \"table_sql[field_sql]\".";
          return false;
        }

        //Get Select for id
        switch ($this->table_sql["type"]) {
          case "select_with_sql":
            $sql = $this->table_sql["table"]." AND ".$this->table_sql["field_id"]."=".$table_sql;
          break;
          default:
            $sql = "Select * from ".$this->table_sql["table"]." where ".$this->table_sql["field_id"]."=".$table_sql;
        }
//         die($sql);
        $this->database->Query($sql);
        if ($this->database->Next_Record()) {
          $sql = $this->database->Record[$this->table_sql["field_sql"]];
          
          $this->table_style["style"] = $this->database->Record[$this->table_sql["field_style"]];
          
          $this->caption["main"] = $this->database->Record[$this->table_sql["field_caption"]];
          $this->caption["sub"] = $this->database->Record[$this->table_sql["field_subcaption"]];
        } else {
          $this->output["error"] = true;
          $this->output["errorText"] = $this->ident." (Command=".$this->command."): Cannot get SQL with ".htmlentities($table_sql, ENT_QUOTES).".";
          return false;
        }
      break;
    endswitch;
    $this->table_sql["sql"] = $sql;
//    die(print_r($this));
    return true;
  }

  
  function QueryDataUsingSelect (&$dblayer, $sql) {

    //Query database
    $this->database->Query($this->table_sql["sql"]);
    
    //Field with ident
    if (!$this->map_style["table_data"]["field_id"]) {
      $dblayer->output["error"] = true;
      $dblayer->output["errorText"] = $this->ident." (Command=".$this->command."): Missing settings \"table_data[field_id]\".";
      return false;
    }
    //Field with value
    if (!$this->map_style["table_data"]["field_value"]) {
      $dblayer->output["error"] = true;
      $dblayer->output["errorText"] = $this->ident." (Command=".$this->command."): Missing settings \"table_data[field_value]\".";
      return false;
    }
    //Field with ident in layer
    if (!$this->map_style["table_data"]["layer_field_id"]) {
      $dblayer->output["error"] = true;
      $dblayer->output["errorText"] = $this->ident." (Command=".$this->command."): Missing settings \"table_data[field_id_layer]\".";
      return false;
    }

    //Get features from database
    $this->data = array();
    unset($this->database->Record);
    unset($GLOBALS["TMapServer_Session"]["thematic_mapping_data"]);

    while ($this->database->Next_Record()) {
      //all datas of thematic mapping in session
      $GLOBALS["TMapServer_Session"]["thematic_mapping_data"][] = $this->database->Record; 

      //Call child method
      $this->Renderer->OnGetDataFromRDBMS($this->database->Record, $this);
//      break;
    }
    return true;
  }
  
  function QueryDataInMapAndSetExtent (&$dblayer) {
    //Get data in map with limit
    $data_in_map = array_slice(array_keys($this->data), 0, $this->map_style["table_data"]["count_limit_from_map"]?$this->map_style["table_data"]["count_limit_from_map"]:100000000);
    
    //Count of ident
    if (Count($this->data) > 0) {
      $data_in_map = '^'.Implode('$|^', $data_in_map).'$';
    }
    
    //Create query
    $query = "&mode=itemnquery&qlayer=".$this->map_style["table_data"]["layer_query"];
    if ($this->map_style["table_data"]["all_records"])
      $query .= "&item=".$this->map_style["table_data"]["layer_field_id"]."&value=.";
    else
      $query .= "&item=".$this->map_style["table_data"]["layer_field_id"]."&value=".$data_in_map;

    //Get connection and run query
    $connection = $dblayer->manager->GetActive($dblayer->table["connection"]);
//    die($query);
    $connection->query($query);
    
    //Get extent of selected items
    $dblayer->output["num"] = 0;
    while ($connection->next_record()):
      //Call child method
      $this->Renderer->OnGetDataFromMap(&$connection->Record, &$this);
      
      list($x1,$y1,$x2,$y2) = Explode(" ", $connection->Record["ext"]);
      $dblayer->x1 = (double) $x1;
      $dblayer->y1 = (double) $y1;  
      $dblayer->x2 = (double) $x2;
      $dblayer->y2 = (double) $y2;
      if ($dblayer->x1 > $dblayer->x2) { $aux = $dblayer->x1; $dblayer->x1 = $dblayer->x2; $dblayer->x2 = $aux; }
      if ($dblayer->y1 > $dblayer->y2) { $aux = $dblayer->y1; $dblayer->y1 = $dblayer->y2; $dblayer->y2 = $aux; }
      $dblayer->x = Round($dblayer->x1 + ($dblayer->x2 - $dblayer->x1)/2);
      $dblayer->y = Round($dblayer->y1 + ($dblayer->y2 - $dblayer->y1)/2);
      $dblayer->SetMaxExtent();
      $dblayer->output["num"]++;
    endwhile;
    return true;
  }

  function GetStyle (&$dblayer) {
    $this->map_style = $this->parameters[$this->prefix."_Style"]?$this->parameters[$this->prefix."_Style"]:$this->table_style["style"];
    if (!$this->map_style) {
      $dblayer->output["error"] = true;
      $dblayer->output["errorText"] = $this->ident." (Command=".$this->command."): Missing settings \"".$this->prefix."_Style"."\".";
      return false;
    }

    //Type of gettting style
    switch ($this->table_style["type"]){
      //Style in select
      case "file":
      default:
        include($this->table_style["file"]);
        $msstyle = $this->map_style;
        $this->map_style = $THMAP_STYLES[$this->map_style];
        if (!$this->map_style) {
          $dblayer->output["error"] = true;
          $dblayer->output["errorText"] = $this->ident." (Command=".$this->command."): Missing style \"".$msstyle."\".";
          return false;
        }
      break;
    }
    
    return true;
  }

  function CheckTemporaryMapFile(&$layer) {    
    //Check temporary map file
    if (!$layer->MapFileIsTemp) {
      $proj = &$layer->manager->GetProject($layer->name);
      $mapfile = $proj["servers"][0]["project"];
      $map = &$layer->objects->GetCachedObjectByName("mapscript_map");
      $mapfile = $map->CopyMapToTempFile($mapfile, true, true); //CopyMapToTempFile ($filename=false, $replace=true, $loadintomemory=false)
      if ($mapfile) {
        $layer->MapFileIsTemp = true;
        $layer->MapFileName = $mapfile;
        $proj["servers"][0]["project"] = $mapfile;
      }
      $layer->objects->SetCachedObject($map);
    } else {
      $map = &$layer->objects->GetCachedObjectByName("mapscript_map");
    }
    return $map;
  }
    
}


?>
