<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: mapserver.inc,v 1.9 2008/02/22 14:52:19 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

include_once(dirname(__FILE__)."/main.inc"); 

class selection_mapserver extends selection_main {

  var $ident = "SELMSRV";

  function TMapServer_WriteLayerBefore (&$layer, $type) {
    if ($this->writelayer) {
      $map = $this->CheckTemporaryMapFile(&$layer);
      reset($this->layers);
      while (list($key, $val) = each($this->layers)) {
        $val["values"] = array_unique($val["field_id"]?$val["id_values"]:$val["values"]);
        sort($val["values"]);
        if (preg_match('/^[*]+$/', $val["values"][0])) unset($val["values"][0]);
        if($val['mapserv_usesqlsyntax']) {
          $conds = array();
          $field = ($val["field_id"]?$val["field_id"]:$val["field"]);
          foreach($val["values"] as $v) {
            if($val["field_type"]=='text') $v = "'$v'"; 
            $conds[] = $field.'='.$v;
          }
          $filter = Implode(' OR ',$conds);          
        }
        else $filter = "^".Implode($val["values"],"$|^")."$";
			  switch ($this->mapserver["version"]) {
  				case "3.3":
  				case "3.4":
            $ms_filter = "EXPRESSION /$filter/";
  				break;
  				default:
            $ms_filter = "FILTERITEM '".($val["field_id"]?$val["field_id"]:$val["field"])."'\n";
            $ms_filter .= "FILTER /$filter/";
			  }
/*        $ms_filter = "FILTERITEM '".$val["field"]."'\n";
        $filter = "^".Implode($val["values"],"$|^")."$";
        $ms_filter .= "FILTER /$filter/";*/
        $bookmark = sprintf($this->mapserver["bookmark"], $val["layer"]);
        $map->ReplaceBookmarkInMapFile ($bookmark, $ms_filter, $this->mapserver["start"], $this->mapserver["end"]);
      }
      $map->SaveMapFileFromMemory($layer->MapFileName);
    }
  }

  function TMapServer_WriteLayerAfter (&$layer, $type, $params) {
  }
  

  function CheckTemporaryMapFile(&$layer) {    
    //Check temporary map file
    //if (!$layer->MapFileIsTemp) {
      $proj = &$layer->manager->GetProject($layer->name);
      $mapfile = $proj["servers"][0]["project"];
      $map = &$layer->objects->GetCachedObjectByName("mapscript_map");
      $mapfile = $map->CopyMapToTempFile($mapfile, true, true); //CopyMapToTempFile ($filename=false, $replace=true, $loadintomemory=false)
      if ($mapfile) {
        $layer->MapFileIsTemp = true;
        $layer->MapFileName = $mapfile;
        $proj["servers"][0]["project"] = $mapfile;
      }
      $layer->objects->SetCachedObject($map);
    //} else {
      //$map = &$layer->objects->GetCachedObjectByName("mapscript_map");
    //}
    return $map;
  }
  
}

?>