<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: shortest_path.inc,v 1.10 2008/02/07 13:43:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class tmapy_shortest_path {

  var $ident = "SHRTPATH";
  var $exec = "http://127.0.0.1/cgi-bin/shortest_path";
  var $exec_shell = "/var/www/cgi-bin/shortest_path";
  var $exec_method = "CGI";
  var $shapes = array();
  var $nodes = array();
  var $storepathdescription = false;

  function Initial() {
    $file = FileUp2($this->db_file);
    if (File_Exists($file))
      include_once($file);
  }

  function Destroy() {
  }
  
  function GetObjectDesc() {
    if ($this->path_desc) {
      include_once(dirname(__FILE__)."/".$this->path_desc.".inc");
      $cls = "tmapy_shortest_path_".$this->path_desc;
      return new $cls($this);
    } else {
      return false;
    }
  }
  
  function GetNearestNode($x, $y) {
    $cls = $this->GetObjectDesc();
    return $cls->GetNearestNode($x, $y);
  }

  //Function that assigns records from database to 
  function AssignInfoFromDB (&$arr, &$db, $table, $indexfield) {
    $in = Implode(",", array_keys($arr));
    $sql = $table." AND $indexfield IN ($in)";
    $db->Query($sql);
    while ($db->next_record()) {
      reset($db->Record);
      while (list($key, $val) = each($db->Record)) {
        if (Is_String($key)) {
          $arr[$db->Record[$indexfield]][$key] = $val;
        }
      }
    }
  }
  
  function CreatePathDescription () {
    if ($this->path_desc) {
      $cls = $this->GetObjectDesc();
      return $cls->CreatePathDescription();
    } else {
      return "no_desc";
    }
  }
  
  function FindRoute($fromnode, $tonode) {
    $spath = "";
    switch ($this->exec_method) {
      case "Shell":
        $spath = shell_exec($this->exec_shell." ".$this->network." ".$this->weight." ".$fromnode." ".$tonode);
      break; 
      case "CGI":
      default:
        $exec = $this->exec."?network=".$this->network."&weight=".$this->weight."&node_from=".$fromnode."&node_to=".$tonode;
    
        $fp = fOpen($exec, "r");
        if ($fp) {
          while ($buf = fread($fp, 1024)) {
            $spath .= $buf; 
          }
        }
      break;
    }
    
    //Get links from route
    $this->shapes = array();
    $this->nodes = array();
    $list = Explode(";", $spath);
    $cnt = Count($list);
    $is_node = true;
    for ($i=0; $i<$cnt; $i++) {
      if ($is_node) 
        $this->nodes[] = Abs($list[$i]);
      else 
        $this->shapes[] = $list[$i];
      $is_node = !$is_node;
    }
  }

  function PrepareImage(&$layer, $type) {
    $map = $this->CheckTemporaryMapFile(&$layer);
    $this->mapfilename = $map->filename;
  
    if ($layer->MapFileName) {
      $this->ImageTemp = Eregi_Replace('(.*)\.map$',"\\1".$this->ident.".gif",$layer->MapFileName);
    } else {
      $this->ImageTemp = Tempnam(($GLOBALS["SERVER_SYSTEM"] == "UNIX")?"/tmp":GetEnv("TEMP"), "tms_");
    }
    
    $this->image_ok = false;
  
  //      die(print_r($this));
  //      phpinfo();
    //MapScript version
    switch ($this->draw_method) {
      case "MapScript":
        $map->Open($this->draw_mapscript["mapfile"]);
  
        if ($layer->request["width"]):
          $map->mapobj->set("width", $layer->request["width"]); 
          $map->mapobj->set("height", $layer->request["height"]); 
        endif;
        $map->mapobj->setextent($layer->request['bbox']['minx'], $layer->request['bbox']['miny'], $layer->request['bbox']['maxx'], $layer->request['bbox']['maxy']);
        $map->SwitchAllLayers(false);
        $img = $map->mapobj->draw();
        
        //Draw as shape
        $layer_route = $map->mapobj->getLayerByName($this->draw_mapscript["mapfilelayer"]);
        $shpfile = $layer->objects->GetObjectByName("mapscript_shape");
        $shpfilename = (Eregi("^/", $layer_route->data)?"":$map->mapobj->shapepath."/").$layer_route->data;
        if ($shpfile->Open($shpfilename, -1)) {
          $rectmap = $map->mapobj->extent;
          reset($this->shapes);
          $this->intersects = false;
          reset($this->shapes);
          while (list($key, $val) = each($this->shapes)) {
            $shp = &$shpfile->shapeobj->getShape(abs($val));
            if ($map->Extent_Insersect(&$rectmap, &$shp->bounds)) {
              $this->intersects = true;
              $shp->Draw($map->mapobj,$layer_route,$img,0,'');
            }
            $shp->free();
          }
        } 
        $shpfile->free();
        
        if ($this->intersects) {
          $map->mapobj->transparent = MS_TRUE;
          $fnimg = $map->SaveImageToTempFile(&$img, $type, $this->ImageTemp);
          $this->image_ok = true;
        }
      break;
      case "MapServer":
        $query  = $this->draw_mapserver["cgi"];
        $query .= "?map=".$this->draw_mapserver["mapfile"];
        $query .= "&mapsize=" .$layer->request["width"] .'+' .$layer->request["height"];
        $query .= "&mapext=".$layer->request['bbox']['minx'].'+'.$layer->request['bbox']['miny'].'+'.$layer->request['bbox']['maxx'].'+'.$layer->request['bbox']['maxy'];
        $query .= "&layer=".$this->draw_mapserver["mapfilelayer"];
  //        $query .= "&qlayer=".$this->mapfilelayer;
  //        $query .= "&shapeindex=".$this->shapes[0];
  //        $query .= "&mode=indexquerymap";
        $query .= "&map_transparent=on";
        $query .= "&map_".$this->draw_mapserver["mapfilelayer"]."_filteritem=FID&map_".$this->draw_mapserver["mapfilelayer"]."_filter=/^".Str_Replace("-", "", Implode($this->shapes,"$|^"))."$/";
        $query .= "&mode=map";
  
        $fp = fOpen($query, "r");
        $fpim = fOpen($this->ImageTemp, "w");
        while ($fp && !feof($fp)):
          $buffer = fRead($fp, 4096);
          //echo $buffer;
          fWrite($fpim, $buffer);
        endwhile;
        fClose($fpim);
        $this->image_ok = true;
        //die();
      break;
      case "MapFile":
        $ms_class = $this->draw_mapfile["header"]."\n";
        $ms_class .= "FILTERITEM FID\n";
        $ms_class .= "FILTER /^".Str_Replace("-", "", Implode($this->shapes,"$|^"))."$/\n";
        $ms_class .= $this->draw_mapfile["footer"]."\n";
        $map->ReplaceBookmarkInMapFile ($this->mapfile["bookmark"], $ms_class, $this->mapfile["start"], $this->mapfile["end"]);
        $map->SaveMapFileFromMemory($this->mapfilename);
      break;
    }

  } 
  
  
//******************************************************************************

  //TMapServerHandlers
  
  function TMapServer_Interface (&$dblayer) {
    $parameters = $dblayer->parameters["HTTP_VARS"];
    $command = $parameters[$this->ident."_Command"];
    $this->do_reset = $parameters[$this->ident."_Reset"] || !isset($parameters[$this->ident."_Reset"])?true:false;
    if ($command) { 
      switch ($command) {
        case "Clear":
          unset($GLOBALS["TMapServer"][$dblayer->map_project["name"]][$this->ident]);
        break;
        case "FindRoute":
          //Check parameters
          if (!isset($parameters[$this->ident."_From"])) {
            $dblayer->output["error"] = true;
            $dblayer->output["errorText"] = $this->ident." (Command=".$command."): Missing parameter \"".$this->ident."_From\".";
            return false;
          } 
          if (!isset($parameters[$this->ident."_To"])) {
            $dblayer->output["error"] = true;
            $dblayer->output["errorText"] = $this->ident." (Command=".$command."): Missing parameter \"".$this->ident."_To\".";
            return false;
          } 
          //Get values from interface
          $this->from = $parameters[$this->ident."_From"];
          $this->to = $parameters[$this->ident."_To"];
          if ($parameters[$this->ident."_Weight"]) $this->weight = $parameters[$this->ident."_Weight"];
          
          //Get route information
          $this->FindRoute($this->from, $this->to);
          
          if ($this->storepathdescription) {
            $this->pathdescription = $this->CreatePathDescription();
          }
          
          $shp = $dblayer->objects->GetCachedObjectByName("mapscript_shape");
          $shp->Open($this->shapefile);
          $ext = $shp->GetExtentOfShapes($this->shapes);

          $dblayer->x1 = $ext["minx"]; 
          $dblayer->x2 = $ext["maxx"]; 
          $dblayer->y1 = $ext["miny"]; 
          $dblayer->y2 = $ext["maxy"];
          
/*          $dblayer->x1 = $shp->shapeobj->bounds->minx; 
          $dblayer->x2 = $shp->shapeobj->bounds->maxx; 
          $dblayer->y1 = $shp->shapeobj->bounds->miny; 
          $dblayer->y2 = $shp->shapeobj->bounds->maxy;*/

          $shp->Free();
          
          $dblayer->SetMaxExtent();
          
          $dblayer->output["num"]++;
           
          
        break;
        default:
          $dblayer->output["error"] = true;
          $dblayer->output["errorText"] = $this->ident." (Command=".$command."): Unknown command.";
      }
    }
  } 

  function TMapServer_SaveSession ($project,$connection=0) {
    if ($this->shapes) {
      $GLOBALS["TMapServer"][$project][$this->ident] = array(
        "shapes"=>$this->shapes,
        "nodes"=>$this->nodes,
        "writelayer"=>true,
        "pathdesc"=>$this->pathdescription,
        "from"=>$this->from,
        "to"=>$this->to,
        "weight"=>$this->weight,
//        "mapfile"=>$this->mapfile,
//        "mapfilelayer"=>$this->mapfilelayer,
//        "mapserver"=>$this->mapserver
      ); 
    } elseif ($this->do_reset) {
      unset($GLOBALS["TMapServer"][$project][$this->ident]);    
    }
  }
  
  function TMapServer_OpenSession ($project,$connection=0) {
    if (Substr($this->owner_type, -7) != StrToLower("DBLayer")) {
      $settings = $GLOBALS["TMapServer"][$project][$this->ident];
      if ($settings) {
        $this->shapes = $settings["shapes"];
        $this->nodes = $settings["nodes"];
        $this->writelayer = $settings["writelayer"];
        $this->pathdescription = $settings["pathdesc"];
        $this->from = $settings["from"];
        $this->to = $settings["to"];
        $this->weight = $settings["weight"];
      } else {
        if (((int)$this->cache_from) && ((int)$this->cache_to) && Is_String($this->cache_weight)) {
          $this->from = $this->cache_from;
          $this->to = $this->cache_to;
          $this->weight = $this->cache_weight;
          $this->FindRoute($this->from, $this->to);
          if ($this->storepathdescription) {
            $this->pathdescription = $this->CreatePathDescription();
          }
          session_register("TMapServer");
          $this->TMapServer_SaveSession($project);
        }
      }
//      $this->mapserver = $settings["mapserver"];
//      if (isset($settings["mapfile"])) $this->mapfile = $settings["mapfile"];
//      if (isset($settings["mapfilelayer"])) $this->mapfilelayer = $settings["mapfilelayer"];
    }
  }
  
  function TMapServer_WriteLayerBefore (&$layer, $type) {
   if ($this->writelayer) {
      $this->PrepareImage(&$layer, $type);
      if ($this->image_ok) {
        //Combine images
        
        $ms_class = "DATA '".$this->ImageTemp."'";
        
        $map->ReplaceBookmarkInMapFile ($this->mapfile["bookmark"], $ms_class, $this->mapfile["start"], $this->mapfile["end"]);

        $map->SaveMapFileFromMemory($this->mapfilename);
        
      }
    }
      
  }

  function TMapServer_WriteLayerAfter (&$layer, $type, $params) {
    @unlink($this->ImageTemp);
//    die();
  }
  
/*  function TMapServer_WriteLayerBefore (&$layer, $type) {
    switch ($type) {
      case "GIF":
      case "PNG":
      case "JPEG":
        $layer->SaveToFile = $this->writelayer;
    }
  }

  function TMapServer_WriteLayerAfter (&$layer, $type, $params) {
    if ($layer->SaveToFile) {

//    die(print_r($layer->objects));
      $map = $layer->objects->GetCachedObjectByName("mapscript_map");
      if ($map->Open($this->mapfile)) {
        if ($layer->request["width"]):
          $map->mapobj->set("width", $layer->request["width"]); 
          $map->mapobj->set("height", $layer->request["height"]); 
        endif;
        $map->mapobj->setextent($layer->request['bbox']['minx'], $layer->request['bbox']['miny'], $layer->request['bbox']['maxx'], $layer->request['bbox']['maxy']);
        $map->SwitchAllLayers(false);
        $img = $map->mapobj->draw();
        
        //Draw as shape
        $layer_route = $map->mapobj->getLayerByName($this->mapfilelayer);
        $shpfile = $layer->objects->GetObjectByName("mapscript_shape");
        $shpfilename = (Eregi("^/", $layer_route->data)?"":$map->mapobj->shapepath."/").$layer_route->data;
        if ($shpfile->Open($shpfilename, -1)) {
          $rectmap = $map->mapobj->extent;
          reset($this->shapes);
          while (list($key, $val) = each($this->shapes)) {
            $shp = $shpfile->shapeobj->getShape($val);
//            if ($map->Extent_Insersect(&$rectmap, &$shp->bounds)) {
              $shp->Draw($map->mapobj,$layer_route,$img,0,'');
//            }
            $shp->free();
          }
        }
        $shpfile->free();
        
        //Combine images
        $map->mapobj->transparent = MS_TRUE;
        $fnimg = $map->SaveImageToTempFile(&$img, $type);
        $imginfo = getimagesize($fnimg);  
        switch ($imginfo[2]) {           //1 = GIF, 2 = JPG, 3 = PNG, 4 = SWF
          case 1:
            $imagehadle = ImageCreateFromGIF($fnimg);
          break;  
          case 2:
            $imagehadle = ImageCreateFromJPEG($fnimg);
          break;  
          case 3:
            $imagehadle = ImageCreateFromPNG($fnimg);
          break;
        }
        unlink($fnimg);
        $imgmain = &$params["imagehandle"];
        ImageCopy($imgmain,$imagehadle,0,0,0,0,$imginfo[0],$imginfo[1]);
//        ImageGIF($imgmain); 
      }
    }
  }*/


  function CheckTemporaryMapFile(&$layer) {    
    //Check temporary map file
    if (!$layer->MapFileIsTemp) {
      $proj = &$layer->manager->GetProject($layer->name);
      $mapfile = $proj["servers"][0]["project"];
      $map = &$layer->objects->GetCachedObjectByName("mapscript_map");
      $mapfile = $map->CopyMapToTempFile($mapfile, true, true); //CopyMapToTempFile ($filename=false, $replace=true, $loadintomemory=false)
      if ($mapfile) {
        $layer->MapFileIsTemp = true;
        $layer->MapFileName = $mapfile;
        $proj["servers"][0]["project"] = $mapfile;
      }
    } else {
      $map = &$layer->objects->GetCachedObjectByName("mapscript_map");
    }
    return $map;
  }
    
}
?>
