<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: cz.inc,v 1.4 2008/02/07 13:43:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class tmapy_shortest_path_cz {
  var $parent;

  function tmapy_shortest_path_cz(&$parent) {
    $this->parent = &$parent;
  }

  function CreatePathDescription() {
     
    //Database connection
    $db = $this->parent->db?$this->parent->db:"DB_DEFAULT";
    $db = new $db;


    $route_nodes = array();
    reset($this->parent->nodes);
    while (list(,$val) = each($this->parent->nodes)) $route_nodes[$val] = false;
    $route_shapes = array();
    reset($this->parent->shapes);
    while (list(,$val) = each($this->parent->shapes)) $route_shapes[Abs($val)] = array("sign"=>$val > 0);

    $route_nodes_count = Count($route_nodes);
    
    //Get node and link information from database
    $this->parent->AssignInfoFromDB ($route_nodes, $db, "Select N.*, O.NAME AS OB_NAME, O.OKRES AS OK_NAME, K.NAME AS KU_NAME from ROUTE_NODE N LEFT JOIN OB O ON (N.OB_CODE = O.OB_CODE) LEFT JOIN KU K ON (N.KU_CODE = K.KU_CODE) WHERE 1", "ID");
    $this->parent->AssignInfoFromDB ($route_shapes, $db, "Select * from ROUTE_LINK WHERE 1", "ID");

//      die(print_r($route_nodes));
    
//    echo "<pre>"; print_r($route_shapes); die("</pre>");
    
    //Reset nodes and links arrays
    reset($route_nodes);
    reset($route_shapes);
    
    //Iteration on $route_nodes
    $i = 0;
    $route_description_temp = array();
    $node_previous = array();
    $link_names_previous = array();
    reset($route_nodes);
    while (list($node_id,$node) = each($route_nodes)) {
    
      //Get current link
      if ($i>1) next($route_shapes);
      if ($i>0) $link = current($route_shapes);
      $i++;
    
      $desc_current = array(
        "id"=>$node_id, 
        "type"=>$node["TYPE"],
        "link_type"=>$link["TYPE"],
        "link_time"=>$link["TIME"],
        "name"=>$node["TEXT_CZ"], 
        "obec"=>$node["OB_NAME"],
        "okres"=>$node["OK_NAME"],
        "ku"=>$node["KU_NAME"],
        "is_first"=>($i==$route_nodes_count),
        "x"=>$node["X"],
        "y"=>$node["Y"],
        "is_last"=>($i==1)
      );
      
      $link_desc = "";
      
      //Get link names counts
      if ($link) {
        $link_names = Explode(",", $link["TEXT"]);
        $link_names_current = array();
        reset($link_names);
        while (list($key, $val) = each($link_names)) {
          if ($val) {
            $link_names_current[$val] = $link_names_previous[$val] + 1;
          }
        }
        arsort($link_names_current);
        $link_text = Key($link_names_current);
        $desc_current["link_names"] = $link_names_current;
        $desc_current["link_name"] = $link_text;
        $link_names_previous = $link_names_current;
      }  

      //Set direction desription
      switch ($node["TYPE"]) {
        case 1:
          $node_text = $node["TEXT_CZ"]; 
        break;
        case 2:
          $node_text = Eregi($node["OB_NAME"], $node["KU_NAME"])?$node["KU_NAME"]:$node["OB_NAME"]."-".$node["KU_NAME"]; 
        break;
        case 3:
        
      }

      switch ($desc_current["link_type"]) {
        case 1: 
          $desc_current["desc_road_class"] = "I";
        break;
        case 2: 
          $desc_current["desc_road_class"] = "II";
        break;
        case 3: 
          $desc_current["desc_road_class"] = "III";
        break;
        default: 
          $desc_current["desc_road_class"] = "";
      }
      $desc_current["desc_road_class"] .= $link_text?($desc_current["desc_road_class"]?"/":"").$link_text:"";

      $desc_current["desc_road"] = $link_text;
      
      if ($desc_current["is_firsta"]) {
        $desc_current["desc_turn_to"] = "start";
      } elseif ($desc_current["is_last"]) {
        $desc_current["desc_turn_to"] = "cl";
      } else {
        switch ($link["TYPE"]) {
          case 1:
            $desc_current["desc_turn_to"] = "po silnici ".$desc_current["desc_road"]." smr ";
            if ($link["sign"]) 
              $desc_current["desc_turn_to"] .= $link["DIRECTION_TO"];
            else 
              $desc_current["desc_turn_to"] .= $link["DIRECTION_FROM"];
          break;
          case 2:
            $desc_current["desc_turn_to"] = "po silnici ".$desc_current["desc_road"]." smr ";
            $desc_current["desc_turn_to"] .= $node_previous_texts[1];
          break;
          case 5:
            $desc_current["desc_turn_to"] = "dle po ".$desc_current["desc_road"]." smr ".$node_previous_texts[0];
          break;
          default:
            $desc_current["desc_turn_to"] = "dle smr ".($node_text == $node_previous_texts[0]?$node_previous_texts[1]:$node_previous_texts[0]);
        }
  
      }

      $route_description_temp[$node_id] = $desc_current;
      
      //Set last link
      if (($node_text && $node_text <> $node_previous_texts[0]) || !$node_previous_texts[0]) $node_previous_texts = array(0=>$node_text, 1=>$node_previous_texts[0]);
//      if ($node_text) $node_previous_texts = array(0=>$node_text, 1=>$node_previous_texts[0]);
      $link_last = $link;
    }

    
//    print_r($route_nodes);
    //Remove nodes and set length
    $route_description = array();
    end($route_nodes);
    end($route_shapes);
    $len_summ = 0;
    $len_part = 0;
    $time_summ = 0;
    $time_part = 0;
    $link_name_prev = "";
//    die(print_r($route_shapes));
    while (true) {
    
      //Get current link
      $node_id = Key($route_nodes);
      $node = Current($route_nodes);
      $link = Current($route_shapes);
      $node_desc = $route_description_temp[$node_id];
      
      $write_description = true;
      if (!$node_desc["is_first"] && !$node_desc["is_last"]) {

        //Check for the same link name
        $is_link_same = $node_desc["link_name"] == $link_name_prev; 
        $link_name_prev = $node_desc["link_name"]; 

        switch ($node["TYPE"]) {
          case 1:
//            $write_description = !$is_link_same;
            $write_description = !$is_link_same || $node_desc["link_type"] > 2;
            $node_desc["desc_node"]=$node["TEXT_CZ"];

          break;
          case 2:
            $write_description = !$is_link_same;
          break;
          case 3:
            $write_description = !$is_link_same;
          break;
        }
        
//        $write_description = true;

      }
      
      if ($write_description) { 
    
        //Set Node Description
        switch ($node["TYPE"]) {
          case 1:
            $node_desc["desc_node"] = $node["TEXT_CZ"]; 
          break;
          case 2:
            $node_desc["desc_node"] = $node["OB_NAME"]; 
          break;
          case 3:
            if ($link["TYPE"] == 5 && $link_last["TYPE"] != 5) 
              $node_desc["desc_node"] = "njezd na dlnici v blzkosti obce ";
            elseif ($link["TYPE"] != 5 && $link_last["TYPE"] == 5) 
              $node_desc["desc_node"] = "sjezd z dlnice v blzkosti obce ";
            else
              $node_desc["desc_node"] = "kiovatka v blzkosti obce ";
            $node_desc["desc_node"] .= $node["OB_NAME"];
          break;
        }
        $node_desc["desc_node"] .= !Eregi($node["OB_NAME"], $node["KU_NAME"])?"-".$node["KU_NAME"]:"";
        $node_desc["desc_node"] .= !Eregi($node["OB_NAME"], $node["OK_NAME"])?" (okres ".$node["OK_NAME"].")":"";

        $route_description[$node_id] = $node_desc;

        $route_description[$node_id]["is_link_same"] = $is_link_same;
        
        //Set length for route description
        if ($node_last) $route_description[$node_last["ID"]]["length_part"] = $len_part; 
        $route_description[$node_id]["length_summ"] = $len_summ;
        $len_part = 0;
        //Set time for route description
        if ($node_last) $route_description[$node_last["ID"]]["time_part"] = $time_part; 
        $route_description[$node_id]["time_summ"] = $time_summ;
        $time_part = 0;

        $node_last = $node;  
      } 
      
      //Len summ
      $len_seg = Round($link["LENGTH"]);  
      $len_part += $len_seg;
      $len_summ += $len_seg;
      $time_seg = $link["TIME"];
      $time_part += $time_seg;
      $time_summ += $time_seg;
      $link_last = $link;  
      prev($route_nodes);
      prev($route_shapes);
      if (!Key($route_nodes)) break;
    }
      
    //Reverse route description for output
    //$route_description = array_reverse($route_description);
    
    return $route_description;

  }
}  
?>
