<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: map.inc,v 1.9 2004/12/01 09:24:57 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class mapscript_map {

  var $ident = "MAPSCMAP";
  var $mapobj;
  var $debug=0;
  var $filename="";
  var $extension=".map";
  var $module="php_mapscript36.so";
    
  function mapscript_map ($filename="", $open=true) {
    $this->filename = $filename;
    if ($filename && $open)
      $this->Open($filename);
  }
  
  function Open($filename=false) {
    if ($filename) $this->filename = $filename; 
    $cwd = realpath(".");
    if (!Function_Exists("ms_newMapObj")) dl($this->module);
    if ($this->debug) $this->mapobj = ms_newMapObj($this->filename);
                else @$this->mapobj = ms_newMapObj($this->filename);
    chdir($cwd);
    if (Is_Object($this->mapobj)) {
      return true;
    } else {
      return false;
    }
  }
  
  function CopyMapToTempFile ($filename=false, $replace=true, $loadintomemory=false) {
    if ($filename) $this->filename = $filename;
    if (!$this->tempdir) {
      $this->tempdir = ($GLOBALS["SERVER_SYSTEM"] == "UNIX")?"/tmp":GetEnv("TEMP");
    }
    $tempfile = Tempnam($this->tempdir, "tms_");
    $tempfile .= $this->extension;
    $ok = $this->LoadMapFileIntoMemory();
    if ($ok) {
      if ($replace) $this->filename = $tempfile;
      $this->SaveMapFileFromMemory();
      return $tempfile;
    } else {
      return false;
    }
  }
  
  function LoadMapFileIntoMemory () {
    $fp = fOpen ($this->filename, "r");
    if ($fp) {
      $this->mem_map_file = fread ($fp, filesize ($this->filename));
      fClose($fp);
      return true;
    } else {
      return false;
    }
  }

  function SaveMapFileFromMemory ($filename=false) {
    if (!$filename) $filename = $this->filename; 
    $fp = fOpen ($filename, "w");
    if ($fp) {
      fWrite($fp, $this->mem_map_file);
      fClose($fp);
      return true;
    } else {
      return false;
    }
  }
  
  function ReplaceBookmarkInMapFile ($bookmark, $string, $start="", $end="") {
    $arr = Explode($bookmark, $this->mem_map_file);
		$this->mem_map_file = $arr[0];
		for($i=2; $i<Count($arr);$i+=2) {
      $this->mem_map_file .= "\n".$start."\n".$string."\n".$end."\n".$arr[$i];
	  }
  }
  
  function SwitchAllLayers ($on) {
    $cnt = $this->mapobj->numlayers;
    for ($i=0; $i<$cnt;$i++) {
      $lr = $this->mapobj->getLayer($i);
      $lr->set("status", $on?MS_ON:MS_OFF);
    } 
  }

  function Extent_Insersect (&$which, &$what) {
    $res = false;
    if ((($which->minx >= $what->minx) && ($which->minx <= $what->maxx))) {
      if (($which->miny >= $what->miny) && ($which->miny <= $what->maxy)) {
        $res = true;
      } else if (($which->maxy >= $what->miny) && ($which->maxy <= $what->maxy)) {
        $res = true;
      } else if (($which->miny <= $what->miny) && ($which->maxy >= $what->maxy)) {
        $res = true;
      }
    } 
    if (!$res && ($which->maxx >= $what->minx) && ($which->maxx <= $what->maxx)) {
      if (($which->miny >= $what->miny) && ($which->miny <= $what->maxy)) {
        $res = true;
      } else if (($which->maxy >= $what->miny) && ($which->maxy <= $what->maxy)) {
        $res = true;
      } else if (($which->miny <= $what->miny) && ($which->maxy >= $what->maxy)) {
        $res = true;
      }
    } 
    if (!$res && ($which->minx <= $what->minx) && ($which->maxx >= $what->maxx)) {
      if (($which->miny >= $what->miny) && ($which->miny <= $what->maxy)) {
        $res = true;
      } else if (($which->maxy >= $what->miny) && ($which->maxy <= $what->maxy)) {
        $res = true;
      } else if (($which->miny <= $what->miny) && ($which->maxy >= $what->maxy)) {
        $res = true;
      }
    } 
    return $res;
  }
  
  function SaveImageToTempFile (&$img, $type, $tempfile=false) {
    if (!$this->tempdir) {
      $this->tempdir = ($GLOBALS["SERVER_SYSTEM"] == "UNIX")?"/tmp":GetEnv("TEMP");
    }
    if (!$tempfile) $tempfile = Tempnam($this->tempdir, "tms_");
    switch ($type):
      case "GIF":
//        $size = $img->saveImage($tempfile, $this->mapobj->transparent, $this->mapobj->interlace);
        $size = $img->saveImage($tempfile, MS_GIF, $this->mapobj->transparent, $this->mapobj->interlace, $this->imagequality);
      break;
      case "JPEG":
        $size = $img->saveImage($tempfile, MS_JPEG, $this->mapobj->transparent, $this->mapobj->interlace, $this->imagequality);
      break;
      case "PNG":
        $size = $img->saveImage($tempfile, MS_PNG, $this->mapobj->transparent, $this->mapobj->interlace, $this->imagequality);
      break;
    endswitch;
    return $tempfile;
  }
  
  function Free() {
  }
  
  
}

?>
