<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: ialtersearch.inc,v 1.2 2007/08/01 11:17:52 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

/* Usage - in czech

v souboru .config/settings/objects.inc pridat

$TMAPY_OBJECTS = array(
  ...
  "interface_alternative_search"=>array(
    "path"=>"interface_alternative_search/ialtersearch.inc",
    "object"=>array(
      "name"=>"interface_alternative_search",
      "properties"=>array(
        "ident"=>"IALTERSEARCH",
      )
    ),
    "interfaces"=>array(
      "interface"=>true,
    )
  ),
  ...
);

V ramci konfigurace tematu v interface schema.inc je treba pridat registraci 
objektu IALTERSEARCH a jeho parametry. Callback funkce muze byt vyuzita pri 
slozitejsich prepoctech, kdy se hodnota pro Values noveho hledani neda ziskat
pomoci regularniho vyrazu. 

Priklad pro parcely a katastralni uzemi:

$MAP_INTERFACE["..."] = array(
  "type"=>"...",
  ...
  "tmv_interface"=>array(
    "Command"=>"SelByFld",
    ...
    'IALTERSEARCH_theme'=>'katastrykn',          //ident alternativniho interface 
//    'IALTERSEARCH_function'=>nazev_funkce,     //callback funkce pro prepocet hodnot promennych - function nazev_funkce ($val, $dblayer) {}
    'IALTERSEARCH_pattern'=>'/^([0-9]{6}).*$/',  //pattern regularniho vyrazu pro funkci preg_replace
    'IALTERSEARCH_replacement'=>'$1',            //replacement regularniho vyrazu pro funkci preg_replace
    'IALTERSEARCH_message'=>'Parcely nenalezeny. Vyhledvm pslun katastrln zem.' //volitelny text zpravy zobrazene pri alternativnim hledani - nepovinny 
  ),
  "objects"=>array("IALTERSEARCH")
);

*/


class interface_alternative_search {

  var $ident = "IALTERSEARCH";

  function Initial() {
  }

  function Destroy() {
  } 

  function TMapServer_Interface (&$dblayer) {
    global $RESOURCE_STRING;
    $parameters = $dblayer->parameters;

    $this->alter = array(
      'theme' => $dblayer->properties['tmv_interface'][$this->ident.'_theme'],
      'pattern' => $dblayer->properties['tmv_interface'][$this->ident.'_pattern'],
      'replacement' => $dblayer->properties['tmv_interface'][$this->ident.'_replacement'],
      'function' => $dblayer->properties['tmv_interface'][$this->ident.'_function'],
      'noprompt' => $dblayer->properties['tmv_interface'][$this->ident.'_noprompt'],
    );

    //Interface commands
    switch ($parameters["Command"]) {

      case 'SelByFld':
      
        $this->showmessage = false;
        $this->theme = $dblayer->parameters['Theme'];

        if (!$dblayer->output["num"] && $this->alter['theme'] && 
            (($this->alter['pattern'] && $this->alter['replacement'])||($this->alter['function']))) {

          $this->showmessage = true;
          
          $SetVars = array(); 
          
          $SetVars['Theme'] = $this->alter['theme'];
          
          $separator = isset($parameters["ValuesSeparator"])?$parameters["ValuesSeparator"]:',';
          $values = Explode($separator, $parameters["Values"]);
          $values2 = array();
          foreach ($values as $key=>$val) {
            if ($this->alter['function']) {
              $val = $this->alter['function']($val, $dblayer);
              if ($val !== false) $values2[$key] = $val;
            } else {
              $val = preg_replace($this->alter['pattern'],$this->alter['replacement'],$val);
              if ($val) $values2[$key] = $val;
            }
          }
          $SetVars['Values'] = Implode($separator, $values2);
          
          $UnSetVars = array();
          
          foreach($dblayer->parameters['HTTP_VARS'] as $key=>$val) {
            switch ($key) {
              case 'MAP':
              case 'Project':
              case 'interface':
              case 'client_type':
              case 'client_lang':
              case 'strange_opener':
              case 'cacheID':
              break;
              default:
                $UnSetVars[] = $key;
              break;
            }
          }  

          foreach ($UnSetVars as $val) unset($GLOBALS[$val]);
          foreach ($SetVars as $key=>$val) $GLOBALS[$key]=$val;
          if ($GLOBALS['REQUEST_METHOD'] == 'GET') { 
            foreach ($UnSetVars as $val) unset($GLOBALS['HTTP_GET_VARS'][$val]);
            foreach ($SetVars as $key=>$val) $GLOBALS['HTTP_GET_VARS'][$key]=$val;
          } else {
            foreach ($UnSetVars as $val) unset($GLOBALS['HTTP_POST_VARS'][$val]);
            foreach ($SetVars as $key=>$val) $GLOBALS['HTTP_POST_VARS'][$key]=$val;
          }
            
          $interface = new TMSInterface;
          $interface->RunInterface();
          
          $dblayer->objects = $interface->objects; 
          $dblayer->output["alert"] = $interface->alert;
          $dblayer->output["alertName"] = $interface->alertName;
          $dblayer->output["error"] = $interface->error;
          $dblayer->output["errorName"] = $interface->errorName;
          $dblayer->output["errorText"] = $interface->errorText;
  
          //Show result
          $dblayer->Records = $interface->records;
          $dblayer->output = $interface->extent;
          $dblayer->output["select"] = $interface->select;          
          
        }
        
      break;
    }
  }
  
  function TMapServer_SaveSession ($project,$connection=0) {
    $GLOBALS["TMapServer"][$project][$connection][$this->ident][$this->theme] = array(
      'showmessage'=>$this->showmessage,
      'noprompt'=>$this->alter['noprompt']
    ); 
    
  }
  
  function TMapServer_OpenSession ($project,$connection=0) {
    $this->session_params = $GLOBALS["TMapServer"][$project][$connection][$this->ident];
  }

  function TMapServer_WriteLayerBefore (&$layer, $type) {
  } 

  function TMapServer_WriteLayerAfter (&$layer, $type, $params) {
  }
   
  function TMapServer_WriteLegend($val) {
  }  

  function TMapServer_WriteInterfaceScriptBefore (&$interface) {
    
    if ($this->session_params[$interface->parameters['Theme']]['showmessage'] && $interface->parameters[$this->ident.'_message']) {
      if (!$this->session_params[$interface->parameters['Theme']]['noprompt'])
        echo "if (map_panel.panel_loaded) alert('".$interface->parameters[$this->ident.'_message']."');\n";
      $this->theme = $interface->parameters['Theme'];
      $this->showmessage = false;
      $this->session_params[$interface->parameters['Theme']]['showmessage'] = $this->showmessage;
    }      
  } 
  
  function TMapServer_WriteInterfaceScriptBeforeRefresh (&$interface) {
  } 
}

?>
