<?php

class ObjectsManager {
  
  var $data;
  var $index;
  var $cache=array();
  var $schema=array(); 

  function ObjectsManager() {
    include(Fileup2(".config/settings/objects.inc"));
    $this->data = $TMAPY_OBJECTS;
    @include(FileUp2(".admin/object_schema.inc"));
    include_once(Fileup2(".admin/access_map_.inc"));
    $MAP_OBJECT = MapAccessArray($MAP_OBJECT);
    $this->schema = $MAP_OBJECT;
  }
  
  function GetObjectsWithInterface ($type="all") {
    $res = array();
    reset($this->data);
    while (list($key, $val) = each($this->data)) {
      if (isset($val["interfaces"][$type])) {
        $res[$key] = $val; 
      }
    }
    return $res;
  }

  function &FindObjectByName ($name) {
    reset($this->data);
    while (list($key, $val) = each($this->data)) {
      if ($key == $name) {
        return $val;
      }
    }
    return false;
  } 

  function &FindObjectByIdent ($name) {
    reset($this->data);
    while (list($key, $val) = each($this->data)) {
      if ($val["object"]["properties"]["ident"] == $name) return $val;
    }
    return false;
  } 
   
  function GetObjectPath ($object) {
    $file = FileUp2(".admin/objects/".$object["path"]);
    if (!$file) $file = ".admin/objects/".$object["path"];
    return $file;
  }
  
  function &GetObject ($object) {
    If (!$object) die("Object is empty");
    if (!Class_Exists($object["object"]["name"])) {
      $file = $this->GetObjectPath($object);
      if (!File_exists($file)) {
        echo("objectmanager: Cannot create object: \n");
        die(print_r($object));
      } else {
        include_once($file);
      }
    }
    $obj = new $object["object"]["name"];
    if (Is_array($object["object"]["properties"])) {
      reset($object["object"]["properties"]);
      while (list($key, $val) = each ($object["object"]["properties"])) {
        if (Is_String($key)) {
          $obj->$key = $val;
        }
      }
    }
    if (Is_array($this->schema[$obj->ident]["object"]["properties"])) {
      reset($this->schema[$obj->ident]["object"]["properties"]);
      while (list($key, $val) = each ($this->schema[$obj->ident]["object"]["properties"])) {
        if (Is_String($key)) {
          $obj->$key = $val;
        }
      }
    }
    if (!isset($obj->prefix)) $obj->prefix = $obj->ident;
    if (Method_Exists($obj, "Initial")) $obj->Initial();
    return $obj;             
  }

  function &GetObjectByName ($name) {
    $object = &$this->FindObjectByName($name);
    if ($object) {
      return $this->GetObject($object);
    } else {
      return false;
    }
  }

  function &GetObjectByIdent ($name) {
    $object = &$this->FindObjectByIdent($name);
    if ($object) {
      return $this->GetObject($object);
    } else {
      return false;
    }
  }
  
  function &GetCachedObject ($object) {
    if (!($this->cache[$object["object"]["name"]])) {
      $this->cache[$object["object"]["name"]] = &$this->GetObject($object);
    } 
    $obj = &$this->cache[$object["object"]["name"]];
    return $obj;
  }
  
  function SetCachedObject (&$object) {
    unset($object->owner_type);
    $this->cache[Get_Class($object)] = $object;
  }

  function &GetCachedObjectByName ($name) {
    $object = $this->FindObjectByName($name);
    if ($object)
      return $this->GetCachedObject(&$object);
    else 
      return false;
  }

  function &GetCachedObjectByIdent ($name) {
    $object = $this->FindObjectByIdent($name);
    if ($object)
      return $this->GetCachedObject(&$object);
    else 
      return false;
  }
  
}

?>
