<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: map_vml.inc,v 1.6 2008/03/25 08:20:13 lumo Exp $'.'$Name:  $';exit;}; /* HEADER */

if (!preg_match('/^[a-z_]+$/',$client_lang)) $client_lang = 'cz_win';
$file_lg = FileUp2(".admin/lg/$client_lang.inc");
if (File_exists($file_lg)) require_once($file_lg);
$file_lg_app = FileUp2(".admin/lg/app_$client_lang.inc");
if (File_exists($file_lg_app)) include($file_lg_app);


require_once(FileUp2(".admin/main_map.inc"));
require_once(FileUp2(".admin/browser.inc"));

class VML_Map extends TMS_Map {

  var $wait; //zobrazit cekaci obrazek
  var $pan; //posun
  var $zoom; //zoomovani
  var $script; //skripty
  var $select_content; //obsah vyberu

  function VML_Map($interface) {
    $this->TMS_Map($interface);
    if (!$this->print) {
      $this->script = true;
      $this->zoom = true;
      $this->wait = true;
    }
    $this->select_content = '';
  }

  function WriteMapHeader() {
    echo '<HTML xmlns:v="urn:schemas-microsoft-com:vml">'."\n";

    echo "<HEAD>\n";
    echo "<title>T-MapServer</title>\n";

    echo '<object id="VMLRender" classid="CLSID:10072CEC-8CC1-11D1-986E-00A0C955B42E">'."\n";
    echo '</object>'."\n";
    echo '<style>'."\n";
    echo 'v\:* { behavior: url(#VMLRender); }'."\n";
    echo '</style>'."\n";

    if ($this->script) $this->WriteMapScript();
    echo "</HEAD>\n";
    echo "<body ";                                     //bgColor=".$this->bgColor;
    if ($this->script) echo " onLoad=\"Init();\"";
    else if ($this->print) {
      if (isIE()) {
        if (BrowserVersion()==4) echo " onLoad=\"alert('".$RESOURCE_STRING["map_vml1"]."'".'\n'."'".$RESOURCE_STRING["map_vml2"]."'".'\n'."'".$RESOURCE_STRING["map_vml3"]."');\"";
        else echo " onLoad=\"window.print();window.close();\"";
      }
      else echo " onLoad=\"window.print();\"";
    }
    echo ">\n";
    if ($this->wait && $this->mode != $this->modes["overview"]) $this->WriteWaitLayer();
    if ($this->zoom) $this->WriteZoomLayer();
    if ($this->pan) $this->WritePanLayer();
    if (IsN() && (BrowserVersion() == 4)) {
      echo '<layer name="MapLayers" left=0 top=0 width=' .$this->request["width"] .' height=' .$this->request["height"] .' visibility="show" Z-INDEX=1>'."\n";
    } else {
      echo '<div id="MapLayers" style="position:absolute; overflow:hidden; left:0px; top:0px; width:' .$this->request["width"] .'px; height:' .$this->request["height"] .'px; visibility:visible;">'."\n";
    }
  }

  function WriteMapFooter() {
    if ($this->select_content != '') $this->WriteSelect();
    if (IsN() && (BrowserVersion() == 4)) {
      echo '</layer>'."\n";
    } else {
      echo '</div>'."\n";
    }
    if ($this->scale) $this->WriteScaleBar();
    require_once(FileUp2("map_footer.inc"));
  }

  function WriteMapLayer($tree,$name) {
    switch ($tree["style"]["type"]) {
      case "MapServer":
        static $ms_layer_file = '';
        if ($ms_layer_file=='') {$ms_layer_file = Fileup2(".admin/msrv_maplayer.inc"); require_once($ms_layer_file);}
        $layer = new MapServer_MapLayer(&$tree, $name, &$this->request, &$this->manager);
      break;
      case "Image":
        static $img_layer_file = '';
        if ($img_layer_file=='') {$img_layer_file = Fileup2(".admin/img_maplayer.inc"); require_once($img_layer_file);}
        $layer = new Image_MapLayer(&$tree, $name, &$this->request, &$this->manager);
      break;
      case "Table":
        static $tbl_layer_file = '';
        if ($tbl_layer_file=='') {$tbl_layer_file = Fileup2(".admin/tbl_maplayer.inc"); require_once($tbl_layer_file);}
        $layer = new Table_MapLayer(&$tree, $name, &$this->request, &$this->manager);
      break;
      case "Postgres":
        static $pg_layer_file = '';
        if ($pg_layer_file=='') {$pg_layer_file = Fileup2(".admin/pg_maplayer.inc"); require_once($pg_layer_file);}
        $layer = new Postgres_MapLayer(&$tree, $name, &$this->request, &$this->manager);
      break;
      case "OpenGIS":
        static $ogc_layer_file = '';
        if ($ogc_layer_file=='') {$ogc_layer_file = Fileup2(".admin/ogc_maplayer.inc"); require_once($ogc_layer_file);}
        $layer = new OpenGIS_MapLayer(&$tree, $name, &$this->request, &$this->manager);
      break;
      default:
        die("Bad ServerType (".$tree["style"]["type"].")");
      break;
    }
    $layer->WriteVML();
    if ($tree["select"]) $this->WriteSelectContent(&$tree);
    Flush();
  }

  function WriteMapScript() {
    echo "<SCRIPT>\n";
    echo "function CallPanel() {\n";
    echo "  f_panel = parent.map_panel;\n";
    echo "  if (f_panel.env.isN && (f_panel.env.version == 4)) {\n";
    echo "    document.captureEvents(Event.MOUSEMOVE);\n";
    echo "    document.captureEvents(Event.MOUSEDOWN);\n";
    echo "    document.captureEvents(Event.MOUSEUP);\n";
    echo "    document.captureEvents(Event.KEYPRESS);\n";
    echo "  }\n";
    if ($this->mode == $this->modes["map"]) {
      echo "  document.onmousemove = f_panel.MapMouseMove;\n";
      echo "  document.onmousedown = f_panel.MapMouseDown;\n";
      echo "  document.onmouseup = f_panel.MapMouseUp;\n";
      echo "  document.onkeypress = f_panel.MapKeyPress;\n";
      echo "  f_panel.win_ready.map = true;\n";
      echo "  f_panel.MapExtent(".$this->request["bbox"]['minx'].",".$this->request["bbox"]['miny'].",".$this->request["bbox"]['maxx'].",".$this->request["bbox"]['maxy'].");\n";
      if ($this->wait) echo "  f_panel.SetPageLayerVisible(window, 'MapWait', false);\n";
    }
    elseif ($this->mode == $this->modes["overview"]) {
      echo "  document.onmousemove = f_panel.OVMouseMove;\n";
      echo "  document.onmousedown = f_panel.OVMouseDown;\n";
      echo "  document.onmouseup = f_panel.OVMouseUp;\n";
      echo "  document.onkeypress = f_panel.OVKeyPress;\n";
      echo "  f_panel.win_ready.ov = true;\n";
    }
    echo "}\n\n";
    echo "function Init() {\n";
    echo "  if (parent.map_panel)\n";
    echo "    if (parent.map_panel.panel_loaded) CallPanel();\n";
    echo "    else window.setTimeout(Init, 100);\n";
    echo "  else window.setTimeout(Init, 200);\n";
    echo "}\n";
    echo "</SCRIPT>\n";
  }

  function WriteZoomLayer() {
    echo "WriteZoomLayer not implemented<br>\n";
  }

  function WriteWaitLayer() {
    $left = $this->style['wait']["left"];
    $top = $this->style['wait']["top"];
    $width = $this->request['width'] - $left;
    $height = $this->request['height'] - $top;
    $tree["style"]=array("type"=>"Image","image"=>FileUpURL("images/wait.gif"),"zIndex"=>99, "left"=>$left, "top"=>$top, "width"=>$width, "height"=>$height);
    $this->WriteMapLayer(&$tree,"MapWait");
  }

  function WritePanLayer() {
    echo "WritePanLayer not implemented<br>\n";
  }

  function WriteScaleBar() {
    echo "WriteScaleBar not implemented<br>\n";
  }

  function WriteSelectContent($tree) {
    $img_file = FileUpURL("images/arrow_red.gif");
    for($j=0;$j<Count($tree["select"]);$j++) {
      List($x,$y) = Explode(":", $tree["select"][$j]);
      $left = Round(($x - $this->request["bbox"]["minx"])/($this->request["bbox"][maxx] - $this->request["bbox"]["minx"])*$this->request["width"]);
      $top = $this->request["height"] - Round(($y - $this->request["bbox"]["miny"])/($this->request["bbox"][maxy] - $this->request["bbox"]["miny"])*$this->request["height"]);
      $this->select_content .= '<div style="position:absolute;left:'.$left.';top:'.$top.'"><img src="'.$img_file.'"></div>';
    }
  }

  function WriteSelect() {
    $tree["style"]=array("type"=>"Image","text"=>&$this->select_content,"zIndex"=>99);
    $this->WriteMapLayer(&$tree,"MapSelect");
  }

}

?>
