<?php

$ov_file = FileUp2(".admin/overview_schema.inc");
if (!file_exists($ov_file)) ErrorMsg(array("msg"=>"overview_schema.inc does not exists"));
require_once($ov_file);

require_once(FileUp2(".admin/main_map.inc"));
require_once(FileUp2(".admin/browser.inc"));

$ov_w = $OV_WIDTH;
$ov_h = $OV_HEIGHT;
$OV_NAME = $OV_NAME?$OV_NAME:'default';

List($minx,$miny,$maxx,$maxy)=Explode(",",$MAP_OVERVIEW[$OV_NAME]["extent"]);

if ($MAP_OVERVIEW[$OV_NAME]["method"] != "dynamic") {  
  $img_ov_name = "img_".$OV_NAME;
  switch ($MAP_OVERVIEW[$OV_NAME]["method"]) {
    case "url":
      $img_ov = $MAP_OVERVIEW[$OV_NAME]["url"];
    break;
    case "image":
      $img_ov = $MAP_OVERVIEW[$OV_NAME]["image"];
    break;
  }	 
	

    echo "<HTML>\n";
    echo "<HEAD>\n";
    echo "<title>T-MapServer</title>\n";

    echo "<SCRIPT>\n";
    echo "function CallPanel() {\n";
    echo "  f_panel = parent.map_panel;\n";
    echo "  if (f_panel.env.isN && (f_panel.env.version == 4)) {\n";
    echo "    document.captureEvents(Event.MOUSEMOVE);\n";
    echo "    document.captureEvents(Event.MOUSEDOWN);\n";
    echo "    document.captureEvents(Event.MOUSEUP);\n";
    echo "    document.captureEvents(Event.KEYPRESS);\n";
    echo "  }\n";

    echo "  document.onmousemove = f_panel.OVMouseMove;\n";
    echo "  document.onmousedown = f_panel.OVMouseDown;\n";
    echo "  document.onmouseup = f_panel.OVMouseUp;\n";
    echo "  document.onkeypress = f_panel.OVKeyPress;\n";
    echo "  f_panel.win_ready.ov = true;\n\n";
	  
    echo "  f_panel.map.ov.id='".$OV_NAME."';\n"; 
    echo "  f_panel.map.minx=".$minx.";\n";
    echo "  f_panel.map.miny=".$miny.";\n";
    echo "  f_panel.map.maxx=".$maxx.";\n";
    echo "  f_panel.map.maxy=".$maxy.";\n";

    echo "  f_panel.RefreshOV();\n";
    echo "}\n\n";

    echo "function Init() {\n";
    echo "  if (parent.map_panel)\n";
    echo "    if (parent.map_panel.panel_loaded) CallPanel();\n";
    echo "    else window.setTimeout(Init, 100);\n";
    echo "  else window.setTimeout(Init, 200);\n";
    echo "}\n";

    echo "</SCRIPT>\n";

    echo "</HEAD>\n";
    echo "<body bgColor=\"white\" onLoad=\"Init();\">\n";
		
    if (IsN() && (BrowserVersion() == 4)) {
			
      echo "<layer name='MapRectTop' left=0 top=0 width=".$ov_w." height=".$ov_h." visibility='hide' bgColor=#ff0000 Z-INDEX=99>\n";
      echo "<img name='Img_MapRectTop' src='".FileUpURL("images/pixel.gif")."'>\n"; 
      echo "</layer>\n";

      echo "<layer name='MapRectLeft' left=0 top=0 width=".$ov_w." height=".$ov_h." visibility='hide' bgColor=#ff0000 Z-INDEX=99>\n";
      echo "<img name='Img_MapRectLeft' src='".FileUpURL("images/pixel.gif")."'>\n";
      echo "</layer>\n";
		
      echo "<layer name='MapRectRight' left=0 top=0 width=".$ov_w." height=".$ov_h." visibility='hide' bgColor=#ff0000 Z-INDEX=99>\n";
      echo "<img name='Img_MapRectRight' src='".FileUpURL("images/pixel.gif")."'>\n";
      echo "</layer>\n";
		
      echo "<layer name='MapRectBottom' left=0 top=0 width=".$ov_w." height=".$ov_h." visibility='hide' bgColor=#ff0000 Z-INDEX=99>\n";
      echo "<img name='Img_MapRectBottom' src='".FileUpURL("images/pixel.gif")."'>\n";
      echo "</layer>\n";
		
      echo "<layer name='MapLayers' left=0 top=0 width=".$ov_w." height=".$ov_h." visibility='show' Z-INDEX=1>\n";
      echo "<layer name='".$OV_NAME."'  left=0 top=0 width=".$ov_w." height=".$ov_h." visibility='show' Z-INDEX=1>\n";
      echo "<img name='".$img_ov_name."' src='".$img_ov."' hspace=0 vspace=0 border=0 width=".$ov_w." height=".$ov_h.">\n";
      echo "</layer></layer>\n";

    } 
    else {
      echo "<div id='MapRectTop' style='position:absolute; overflow:hidden; left:0px; top:0px; width:".$ov_w."px; height:".$ov_h."px; visibility:hidden;background-color:#ff0000;z-index:99;'>\n";
      echo "<img name='Img_MapRectTop' src='".FileUpURL("images/pixel.gif")."'>\n"; 
      echo "</div>\n";

      echo "<div id='MapRectLeft' style='position:absolute; overflow:hidden; left:0px; top:0px; width:".$ov_w."px; height:".$ov_h."px; visibility:hidden;background-color:#ff0000;z-index:99;'>\n";
      echo "<img name='Img_MapRectLeft' src='".FileUpURL("images/pixel.gif")."'>\n";
      echo "</div>\n";
		
      echo "<div id='MapRectRight' style='position:absolute; overflow:hidden; left:0px; top:0px; width:".$ov_w."px; height:".$ov_h."px; visibility:hidden;background-color:#ff0000;z-index:99;'>\n";
      echo "<img name='Img_MapRectRight' src='".FileUpURL("images/pixel.gif")."'>\n";
      echo "</div>\n";
		
      echo "<div id='MapRectBottom' style='position:absolute; overflow:hidden; left:0px; top:0px; width:".$ov_w."px; height:".$ov_h."px; visibility:hidden;background-color:#ff0000;z-index:99;'>\n";
      echo "<img name='Img_MapRectBottom' src='".FileUpURL("images/pixel.gif")."'>\n";
      echo "</div>\n";
		
      echo "<div id='MapLayers' style='position:absolute; overflow:hidden; left:0px; top:0px; width:".$ov_w."px; height:".$ov_h."px; visibility:visible;'>\n";
      echo "<div id='".$OV_NAME."' style='position:absolute; overflow:hidden; left:0px; top:0px; width:".$ov_w."px; height:".$ov_h."px; visibility:visible;z-index:1;'>\n";
      echo "<img name='".$img_ov_name."' src='".$img_ov."' hspace=0 vspace=0 border=0 width=".$ov_w." height=".$ov_h.">\n";
      echo "</div>\n";
      echo '</div>'."\n";
    }
	
  require(FileUp2("map_footer.inc"));
}
else {


  $GLOBALS["MAP"] = $MAP;
  $GLOBALS["VERSION"] = "1.1.0";
  $GLOBALS["FORMAT"] = "HTML";
  $GLOBALS["BBOX"] = $MAP_OVERVIEW[$OV_NAME]["extent"];
  $GLOBALS["WIDTH"] = $OV_WIDTH?$OV_WIDTH:185;
  $GLOBALS["HEIGHT"] = $OV_HEIGHT?$OV_HEIGHT:150;
  $GLOBALS["LAYERS"] = $MAP_OVERVIEW[$OV_NAME]["dynamic"]["layers"];
  $GLOBALS["STYLES"] = $MAP_OVERVIEW[$OV_NAME]["dynamic"]["styles"];
  $GLOBALS["SELECT"] = $MAP_OVERVIEW[$OV_NAME]["dynamic"]["select"];
  $GLOBALS["OVERVIEW"] = 1;
  //require("./.admin/map.inc");
//  die('map:'.$MAP.'&bbox:'.$MAP_OVERVIEW[$OV_NAME]["extent"].'&width:'.$OV_WIDTH.'&height:'.$OV_HEIGHT.'&layers:'.$MAP_OVERVIEW[$OV_NAME]["dynamic"]["layers"].'&styles:'.$MAP_OVERVIEW[$OV_NAME]["dynamic"]["styles"].'&select:'.$MAP_OVERVIEW[$OV_NAME]["dynamic"]["select"]);
  include(FileUp2(".admin/map.inc"));
    echo "<SCRIPT>\n";
    echo "  f_panel = parent.map_panel;\n";
    echo "  f_panel.map.ov.id='".$OV_NAME."';\n"; 
    echo "  f_panel.map.minx=".$minx.";\n";
    echo "  f_panel.map.miny=".$miny.";\n";
    echo "  f_panel.map.maxx=".$maxx.";\n";
    echo "  f_panel.map.maxy=".$maxy.";\n";
    echo "if (!parent.map_panel.panel_loaded) window.setTimeout(Init, 500);\n";
		echo "else window.setTimeout(Init, 200);\n";
    echo "</SCRIPT>\n";
  

}
?>