<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: map_ifrm.inc,v 1.7 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2('.admin/main_map.inc'));
require_once(FileUp2('.admin/browser.inc'));
require_once(FileUp2('.admin/map_functions.inc'));

class IFRM_Map extends TMS_MAP{

  var $xhtml=array();
	var $encoding='iso-8859-2';
	
  function IFRM_Map($interface) {
    $this->TMS_Map($interface);
    if (!$this->project['client_type']) $this->project['client_type']='ifrm';
    if ($this->project['encoding']) $this->encoding=$this->project['encoding'];
		$this->xhtml['header']='<?xml version="1.0" encoding="'.$this->encoding.'"?>'."\n".
		                       '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n".
		                       '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="cs" lang="cs">'."\n".
		                       "<head>\n".
													 '<meta http-equiv="Content-Type" content="text/html; charset='.$this->encoding.'" />'."\n".
													 '<meta name="Author" content="T-MAPY spol.s r.o." />'."\n".
		                       "<title>T-MapServer(IFRM) ".Date('H:m:s')."</title>\n";
		$this->xhtml['footer']="</body></html>\n";
		$this->xhtml['js']['header']='<script type="text/javascript">'."\n/* <![CDATA[ */\n";
		$this->xhtml['js']['footer']="/* ]]> */\n</script>\n";
    $this->panel=GetPanelSettings($this->project['client_type']);
//    die(print_r($this->panel));
  }

  function WriteMap() {
    switch ($this->request['command']) {
      case 'map':
        echo $this->CommandMap();
      break;
      case 'create':
      default:
        echo $this->CommandCreate();
      break;
    }
    //print_r($this);
    //$this->WriteMapContent(); 
  }

  function CommandCreate() {
    $ret  = $this->xhtml['header'];
    $ret .= '<style type="text/css">'."\n/* <![CDATA[ */\n";
    $ret .= "@media print {div.lrs{top:0px;left:0px}\n}\n";
    $ret .= "/* ]]> */\n</style>\n";
    $ret .= $this->xhtml['js']['header'];
      $ret .= "var _tMapStyle;\nif (document.styleSheets) { if (document.styleSheets[0].cssRules) _tMapStyle=document.styleSheets[0].cssRules[0].cssRules[0].style; else _tMapStyle=document.styleSheets[0].rules[0].style;}\n";
      if ($this->project['ifrmmap']['js_document_domain'])
        $ret .= "document.domain='".Preg_Replace("/^[^.]*\.(.*)$/",'\\1',$GLOBALS['HTTP_SERVER_VARS']['HTTP_HOST'])."';\n";
    $ret .= $this->xhtml['js']['footer'];
    if ($this->project['ifrmmap']['js_document_domain'])
      $ret .= '<script type="text/javascript" src="'.FileUpURL('javascript/ifrmmap/tmapobj.js').'"></script>'."\n";
    else
      $ret .= '<script type="text/javascript" src="?c=js"></script>'."\n";
    if ($this->request["css"]) {
      $ret .= '<link rel="stylesheet" type="text/css" href="'.$this->request["css"].'" />'."\n";
    }
    $ret .= "</head><body>\n";
      $ret .= $this->xhtml['js']['header'];
        $ret .= "var tMap=new tMapObj({win:this,cbn:'".$this->request['name']."',src:'".($this->project['ifrmmap']['src']?$this->project['ifrmmap']['src']:'')."'});\n";
        $ret .= "if (tMap) {\n";
        //PanSize
        if ($this->project['pan']['size']) {
          $ret .= "tMap._panSize=".$this->project['pan']['size'].";\n";
        }
        //Debug
        if ($this->project['ifrmmap']['debug']) {
          $ret .= "tMap._debug=true;\n";
        }
	if ($this->request['tool']) 
           $ret .= "tMap.setTool('".$this->request['tool']."');\n"; 
        //ZoomList
        if ($this->panel['zoom_bar']) {
          $zoomlist=array();
          foreach ($this->panel['zoom_bar']['zoom_array'] as $key=>$val) {
            $zoomlist[$key]=array(
              'k'=>$val['name']?$val['name']:'',
              'n'=>$val['alt']?$val['alt']:'',
              'p'=>$val['pixel']?$val['pixel']:0
            );
            if ($val['ext']) $zoomlist[$key]['e']=$val['ext'];
          }
          $ret .= $this->FormatJSObject($zoomlist,'tMap._zoomLvls',0,true);
          $ret .= "tMap._zoomLvlsCount=".Count($zoomlist).";\n";
        }
        $ret .= "tMap._init();\n";
        $ret .= "}\n";
      $ret .= $this->xhtml['js']['footer'];
    $ret .= $this->xhtml['footer'];
    return $ret;
  }

  function ShowError ($text) {
    $ret  = $this->xhtml['header'];
    $ret .= $this->xhtml['js']['header'];
        $ret .= "alert('$text');\n";
    $ret .= $this->xhtml['js']['footer'];
    $ret .= "</head><body>\n";
    $ret .= $this->xhtml['footer'];
    return $ret;
  }
  
	function CommandMap() {
    if ((isset($this->project['size_limit']['max_width']) && ($this->request['width'] > $this->project['size_limit']['max_width'])) ||
        (isset($this->project['size_limit']['max_height']) && ($this->request['height'] > $this->project['size_limit']['max_height']))) {
      $ret = $this->ShowError('T-MapServer warning: Size is limited.');
    } else {
      $em=&$this->extent_manager;
      while (true) {
        if (!$em->active_tile) {
          $cnt = Count($em->tiles);
          $last=array();
          for ($i=0; $i<$cnt; $i++) {
            $tile = $em->tiles[$i];
            $em->active_tile=$tile;
            if ($em->pixel_input < $tile['maxpixel']) break;
          }
          $bbox=$em->SetExtentRatioByExtent($tile['extent'], array('minx'=>0,'miny'=>0,'maxx'=>$this->request['width'],'maxy'=>$this->request['height']));
          $pixel=$em->getPixelSize($bbox, $this->request['width'], $this->request['height']);
          $bbox=$em->ScaleExtent($bbox, $tile['maxpixel']/$pixel);
          if ($tile['maxpixel'] > $pixel) $em->active_tile['extent']=$bbox;
          $pixel=($bbox['maxx']-$bbox['minx'])/(double)$this->request['width'];
//          die(print_r($em));
          $em->result = array(
            'connection'=>'', 
            'extent'=>$bbox, 
            'name'=>$tile['name'], 
            'pixel'=>$pixel, 
            'minscale'=>$tile['minscale'], 
            'maxscale'=>$tile['maxscale'], 
            'minpixel'=>$tile['minpixel'], 
            'maxpixel'=>$tile['maxpixel']
          );
          $this->request['pixel']=$pixel;
          if ($pixel) $this->request['bbox']=$em->ScaleExtent($bbox, $tile['maxpixel']/$pixel);
        }
        $ret  = $this->xhtml['header'];
        $ret .= $this->xhtml['js']['header'];
        if ($this->project['ifrmmap']['js_document_domain'])
            $ret .= "document.domain='".Preg_Replace("/^[^.]*\.(.*)$/",'\\1',$GLOBALS['HTTP_SERVER_VARS']['HTTP_HOST'])."';\n";
        $ret .= $this->xhtml['js']['footer'];
        $ret .= "</head><body>\n";
          $ret .= $this->xhtml['js']['header'];
          $ret .= "var tMap=parent.tMap;\n";
          $ret .= "if (tMap) {";
          $m = $this->FormatJSObject($this->GetMapProp(),'m');
          if ($m) {
      			$ret .= $m;
            $ret .= "tMap._initMap(m);\n";
            flush();
            $data=$this->GetMapData();
            //die(print_r($data)); 
            $d = $this->FormatJSObject($data,'d');
            $i = $this->FormatJSObject($this->invislrs,'i');
            if ($this->project['ifrmmap']['commandmap_callback']) {
              if (!$this->project['ifrmmap']['commandmap_callback'](&$this, &$data)) {
                continue;
              }
            }
            if ($d) {
        			$ret .= $d.$i;
              $ret .= "tMap._refreshMapContent(d,i);\n";
              flush();
            }
            $ret .= "if (tMap._map.center) var ccache=tMap._map.center;\n"; 
            if ($this->request['dopan_opera']) {
              $ret .= "if (tMap._map.fext.changed) tMap.scrollToPoint(tMap.getBBOXCenter(m.bbox));\n";
            }
            if ($this->request['dopan']) {
              $ret .= "tMap.scrollToPoint(tMap.getBBOXCenter(m.bbox));\n";
            }
            $ret .= "tMap._initMapEnd(m);\n";
            $ret .= "if (ccache) tMap._map.center=ccache;\n"; 
          }
          $ret .= "};\n";
          $ret .= $this->xhtml['js']['footer'];
        $ret .= $this->xhtml['footer'];
        break;
      }
    }
		return $ret;
	}
	
  function GetMapProp () {
    $em = $this->extent_manager;
    $m=array();
    if ($em->active_tile) {
      $m['fext']=$em->active_tile['extent'];
      foreach($m['fext'] as $key=>$val) {
        $m['fext'][$key]=(double)$val;
      }
//      print_r($em);
//      $m['at'] = $em->active_tile;
      $m['id'] = $em->active_tile['map_id'];
      $m['px'] = Round(Round($em->result['extent']['maxx']-$em->result['extent']['minx'])/(double)$this->request['width'],2);
      $m['w'] = Round(($m['fext']['maxx']-$m['fext']['minx'])/$m['px']);
      if ($m['w'] <= $this->request['width']) $m['w']=$this->request['width']+2; 
      $m['h'] = Round(($m['fext']['maxy']-$m['fext']['miny'])/$m['px']); 
      if ($m['h'] <= $this->request['height']) $m['h']=$this->request['height']+2;
      
      //DIV size in Opera is limited to 32768px
      if (Preg_match('/opera/i',$GLOBALS['HTTP_USER_AGENT'])) {
        $this->request['browser_type']='opera';
        if ($m['w'] > 32768) {
          $d = Floor(($em->result['extent']['minx']-$m['fext']['minx'])/$m['px']);
          $cel = floor($d/32768);
          $dpx = $cel*32768;
          if (($d%32768) > 31768) $dpx+=31000;
          $m['fext']['minx'] += $dpx*$m['px'];
          $m['w'] = Round(($m['fext']['maxx']-$m['fext']['minx'])/$m['px']);
          
          if ($m['w'] > 32768) {
            $d = Floor(($m['fext']['maxx']-$m['fext']['minx'])/$m['px']);
            $cel = floor($d/32768);
            if ($cel) {
              $m['fext']['maxx'] = $m['fext']['minx']+(32768)*$m['px'];
            }
            $m['w'] = Round(($m['fext']['maxx']-$m['fext']['minx'])/$m['px']);
          }
          $this->request['dopan_opera'] = 1;
        }
      }
 
      $m['bbox']=$em->result['extent'];
      
      $cnt=Count($this->panel['zoom_bar']['zoom_array']);
      //die(print_r($em));
      for($i=$cnt-1; $i>=0; $i--) {
        $lvl=$this->panel['zoom_bar']['zoom_array'][$i];
        if ($lvl['pixel'] > $em->last_tile['minpixel']) {
          break;
        } else {
          $last_level=$i;
        } 
      }
      $m['lstLvl']=$last_level?$last_level:$cnt;
      if ($this->request['overview']) {
        $ov=$this->GetOverview($m);
        foreach($ov['ext'] as $key=>$val) $ov['ext'][$key]=(double)$val;
        if ($ov['nam']!=$this->request['overview']) $m['ov'] = $ov;
      }
      if ($this->request['noov']) $m['noov']=1;
      if ($this->request['nobboxch']) $m['nobboxch']=1;

    }
    return $m;
  }
    
  function GetMapData () {
	  $m = array();
    $layers = &$this->tree[$this->request["map"]]["layers"];
    $key_arr = array_keys($layers);
    $this->invislrs=array();
    if (!(Count($key_arr)==1 && $key_arr[0]=='')) {
      for($i=0;$i<Count($key_arr);$i++)
			  $this->WriteMapTree(&$layers[$key_arr[$i]],$key_arr[$i],&$m);
    }
    return $m;
  } 

  function GetOverview ($MAP) {
	  $res=array();
		$BBOX=$MAP['bbox'];
    $PIXEL=$MAP['px'];
    $file_ov_schema = FileUp2(".admin/overview_schema.inc");
    if ($file_ov_schema) include($file_ov_schema);
		$ov=false;
    reset($MAP_OVERVIEW);
    while (list($key, $val) = each($MAP_OVERVIEW)){
      list($minx_t,$miny_t,$maxx_t,$maxy_t) = explode(",",$val["extent"]);
      if (($minx_t<=$BBOX['minx']) && ($miny_t<=$BBOX['miny']) && ($maxx_t>=$BBOX['maxx']) && ($maxy_t>=$BBOX['maxy'])) {
        $ov = $val;
        break;
      }
    }
		if (!$ov) $ov=$MAP_OVERVIEW['default'];
    $ov_bbox = Explode(",", $ov["extent"]);
		$res['ext']=array('minx'=>$ov_bbox[0],'miny'=>$ov_bbox[1],'maxx'=>$ov_bbox[2],'maxy'=>$ov_bbox[3]);
		$res['nam']=$ov['name']?$ov['name']:'';
		$res['cap']=$ov['caption']?$ov['caption']:'';
//		$res['met']=$ov['method']?$ov['method']:'';
		switch($ov['method']) {
		  case 'image':
			  $res['img']=$ov['image'];
			break;
		}
    if ($this->project['overview']['max_pixel']) {$res['maxp']=$this->project['overview']['max_pixel'];}

		return $res;
	}
  
  function WriteMapTree($tree,$name,$data) {
    $writelayers=0;
    if ($tree["params"]['visible'] && !$tree['subtree']) {
      $lr = $this->WriteMapLayer(&$tree,$name);
      $lr['vis']=1;
      $writelayers=1;
    } else {
      $this->invislrs[]=$name;
      if ($this->request['init']) {
        $lr = array('pro'=>array(
          'typ'=>'div',
          'nam'=>$name,
          'vis'=>0
        ));
        $writelayers=1;
      }
    }
    if ($this->request['init']) {
      $lr['pro']['tit']=$tree['params']['title'];
      $lr['pro']['dvis']=$tree['params']['defvisible'];
    }
    if ($writelayers && $tree["layers"]) {
      if ($tree["collection"]) 
        $target=&$lr['lrs'];
      else { 
        $target=&$lr['pro']['lrs'];
        $subtree=1;
      }
      reset($tree["layers"]);
      while(list($layer_name,$layer) = each($tree["layers"])) {
        if ($layer_name) {
          $data_tree = array();
          $layer['subtree']=$subtree;
          $this->WriteMapTree(&$layer,$layer_name,&$target);
        }
      }
      if (!$target) { 
        if ($tree["collection"]) 
          unset($lr['lrs']);
        else  
          unset($lr['pro']['lrs']);
      }
    }
    if ($tree['subtree']) {
      $lr['pro']['typ']='sub';
    }    
    if ($lr) $data[] = $lr; 
  }

  function WriteMapLayer($tree,$name) {
    $ServerType = $tree["style"]["type"];
    switch ($ServerType) {
      case "TMapServer":
        $tree["collection"] = true;
        $lr = array('pro'=>array(
          'typ'=>'div', 
          'nam'=>$name, 
        )); 
      break;
      default:
        $file = FileUp2(".admin/connector/maplayer/$ServerType.inc");
        if ($file) include_once($file);
        else ErrorMsg(array("image"=>false, "msg"=>"Error: Bad connector $ServerType or connector is missing"));
        $MapLayer = $ServerType."_MapLayer";
        $layer = new $MapLayer(&$tree, $name, &$this->request, &$this->manager);
        $layer->params = $this->layer_params;
        $lr = $layer->WriteIFRM();
      break;
    }
    return $lr;
  }

  function FormatJSObject($arr,$name,$level=0,$novar=0) {
    $nl=!$level?"\n":'';
    $nl="\n";
    if (!$level)
      $ret .= ($novar?'':"var ").Str_Repeat($nl?' ':'',$level).$name."={";
    else
      $ret .= $nl.Str_Repeat($nl?' ':'',$level-1).$name.":{";
    if ($arr) {
      foreach($arr as $key=>$val) {
        switch (getType($val)) {
          case 'boolean':
            $ret .= $nl.Str_Repeat($nl?' ':'',$level)."$key:".($val?'1':'0').",";
          break;
          case 'string':
            $ret .= $nl.Str_Repeat($nl?' ':'',$level)."$key:";
            if (Preg_match("/'/", $val))
              $ret .= '"'.$val.'",';
            else
              $ret .= "'$val',";
          break;
          case 'array':
            $ret .= $this->FormatJSObject($val,$key,$level+1);
          break;
          default:
            $ret .= $nl.Str_Repeat($nl?' ':'',$level)."$key:$val,";
          break;
        }
      }
      $ret = RTrim($ret,',');
    }
    if (!$level) 
      $ret .= $nl.Str_Repeat($nl?' ':'',$level)."};\n";
    else 
      $ret .= $nl.Str_Repeat($nl?' ':'',$level-1)."},";
    return $ret;
  }
  
}  

?>
