<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: map_html.inc,v 1.28 2008/09/05 06:20:57 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_map.inc"));
require_once(FileUp2(".admin/browser.inc"));


class HTML_Map extends TMS_Map {

  var $wait; //zobrazit cekaci obrazek
  var $pan; //posun
  var $zoom; //zoomovani
  var $script; //skripty
  var $select_content; //obsah vyberu

  function HTML_Map($interface) {
    $this->TMS_Map($interface);
    if (!$this->print && !$this->request["include"]) {
      $this->script = true;
      $this->zoom = true;
      $this->wait = true;
    }
    $this->select_content = '';
  }

  function WriteMapHeader() {
   if (!$this->request["include"]) {
    if (0) echo '<HTML xmlns:v="urn:schemas-microsoft-com:vml">'."\n";
    else echo "<HTML>\n";
    echo "<HEAD>\n";
    echo "<title>T-MapServer</title>\n";

    if($this->request["live_refresh"]) {
      echo '<SCRIPT language="JavaScript" SRC="'.FileUpURL('javascript/MapFunc.js').'"></SCRIPT>'."\n";;
      echo "</HEAD>\n";
      echo "<body onLoad=\"UpdateLayerOutput();\">\n";
      echo "<SCRIPT language=\"JavaScript\">\n var refr_layers = new Array; \n</SCRIPT>\n";
    }
    else {
      if ($this->request["charset"]) echo '<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset='.$this->request["charset"].'">'."\n";
      if (0) {
        echo '<object id="VMLRender" classid="CLSID:10072CEC-8CC1-11D1-986E-00A0C955B42E">'."\n";
        echo '</object>'."\n";
        echo '<style>'."\n";
        echo 'v\:* { behavior: url(#VMLRender); }'."\n";
        echo '</style>'."\n";
      }
      echo '<link href="'.FileUpURL("default_style.css").'" rel="stylesheet" type="text/css">'."\n";
      
      if (!isset($GLOBALS["client_lang"])) $GLOBALS["client_lang"] = "cz_win";
      include(FileUp2(".admin/lg/map_".$GLOBALS["client_lang"].".inc"));
      @include(FileUp2(".admin/lg/app_map_".$GLOBALS["client_lang"].".inc"));
      $this->RESOURCE_STRING = $RESOURCE_STRING;
      switch ($this->mode) {
        case $this->modes["legend"]:
          echo "</HEAD>\n";
          echo "<Title>".$RESOURCE_STRING["legend_title"]."</Title>\n";
          echo "<body class=\"legend\">\n";
          echo "<div class=\"filterblock\">".$RESOURCE_STRING["legend_title"]."</div><P>\n";
        break;
        default:
          if ($this->script) $this->WriteMapScript();
          echo "</HEAD>\n";
          echo "<body class=\"mapwindow\"";                                     //bgColor=".$this->bgColor;
          if ($this->request["bgcolor"]) echo " bgColor=\"".$this->request["bgcolor"]."\"";
          if ($this->script) echo " onLoad=\"Init();\"";
          else if ($this->print && !$this->request["print"]["noprint"]) {
            if (isIE()) {
              if (BrowserVersion() < 5) echo " onLoad=\"alert('Funkce pro tisk v IE verze 4 nen podporovna,".'\n'."zkuste kliknout v tiskovm okn na prav".'\n'."tlatko myi a vybrat v kontextovm menu tisk.');\"";
              //else echo " onLoad=\"window.print();window.close();\"";
              else echo " onLoad=\"window.print();\"";
            }
            else echo " onLoad=\"window.print();\"";
          }
          else echo " onLoad=\"document.tms_map_ready=true;\"";          
          if ($this->request["mapwinfit"]) {
            echo " onresize=\"top.map_panel.Refresh()\"";
          }
          echo ">\n";
          echo "<script>\n";
          echo "  var origWidth = '".$this->request["width"]."';\n";
          echo "  var origHeight = '".$this->request["height"]."';\n";
  
          echo "  if (top.map_panel) {\n";
          echo "    if (top.map_panel.env.isN) {\n";
          echo "      h = window.innerHeight;\n";
          echo "      w = window.innerWidth;\n";
          echo "    } else {\n";
          echo "      h = window.document.body.clientHeight;\n";
          echo "      w = window.document.body.clientWidth;\n";
          echo "    }\n";
          echo "  } else {\n";
          echo "    w = false;\n";
          echo "    h = false;\n";
          echo "  }\n";
  
          echo "  if (w && h && ((origWidth != w) || (origHeight != h))) {\n";
          echo "    top.map_panel.map.window.width=w;\n";
          echo "    top.map_panel.map.window.height=h;\n";
          echo "    top.map_panel.Refresh();\n";
          echo "  }\n";
          echo "</script>\n";
  
          if ($this->wait && $this->mode != $this->modes["overview"]) $this->WriteWaitLayer();
          if ($this->zoom) $this->WriteZoomLayer();
          if ($this->pan) $this->WritePanLayer();
          if (IsN() && (BrowserVersion() == 4)) {
            echo '<layer name="MapLayers" left=0 top=0 width=' .$this->request["width"] .' height=' .$this->request["height"] .' visibility="show" Z-INDEX=1>'."\n";
          } else {
            echo '<div id="MapLayers" style="position:absolute; overflow:hidden; left:0px; top:0px; width:' .$this->request["width"] .'px; height:' .$this->request["height"] .'px; visibility:visible;">'."\n";
          }
          if ($this->measure && $this->mode != $this->modes["overview"] && !$this->print) $this->WriteMeasureLayer();
          if ($this->selection_shape && $this->mode != $this->modes["overview"] && !$this->print) $this->WriteSelectionShapeLayer();
          if ($this->selection_shape_maponly && $this->mode != $this->modes["overview"] && !$this->print) $this->WriteSelectionShapeLayer('selection_shape_maponly');
          if ($this->edit_vector && $this->mode != $this->modes["overview"] && !$this->print) $this->WriteEditVectorLayer();
        break;
      }
    }
   }
  }

  function WriteMapFooter() {
   if (($this->point_layer != '') || ($this->select_content != '')) $this->WritePointLayer();
//   if ($this->select_content != '') $this->WriteSelect();
   if (!$this->request["include"]) {
     if ($this->mode != $this->modes["legend"]) {
        if (IsN() && (BrowserVersion() == 4)) {
          echo '</layer>'."\n";
        } else {
          echo '</div>'."\n";
        }
        if ($this->scale) $this->WriteScaleBar();
     }
    require_once(FileUp2("map_footer.inc"));
   }
  }

  function WriteMapLayer($tree,$name) {
    if($this->request["live_refresh"]) {
      //print($name.':'.$tree['style']['parameters']['live_refresh'].'<br>');
      if($tree['style']['parameters']['live_refresh'])  echo "<script> refr_layers.push('".$name."');</script>\n";
      else return 0;              
    }
    else {
      if($tree['style']['parameters']['live_refresh'] && $this->request['mode']==0 && !$this->live_refresh_written) {
        $interval = $this->project['refresh_interval']?$this->project['refresh_interval']:5000;
        echo '<iframe style="display:none; position:absolute; overflow:hidden; left:25px; top:25px; width:100px; height:100px; z-index:999;" name="ifrm_refresher" id="ifrm_refresher"></iframe>';
        echo "<script>\n setInterval('window.parent.map_panel.Refresh(true,\"ifrm_refresher\", true)',$interval);\n</script>\n";
        $this->live_refresh_written = true;
       }      
    }
    switch ($this->mode) {
      case $this->modes["legend"]:
        $ServerType = $tree["style"]["legend"]["type"]?$tree["style"]["legend"]["type"]:$tree["style"]["type"];
      break;
      default:
        $ServerType = $tree["style"]["type"];
      break;
    }
    switch ($ServerType) {
      case "TMapServer":
        $tree["collection"] = true;
        if ($tree["select"]) $this->WriteSelectContent(&$tree);
        return;
      break;
      default:
        $file = FileUp2(".admin/connector/maplayer/$ServerType.inc");
        if ($file) include_once($file);
        else {
          ErrorMsg(array("image"=>false, "msg"=>"Error: Bad connector $ServerType or connector is missing"));
        }
        $MapLayer = $ServerType."_MapLayer";
        $layer = new $MapLayer(&$tree, $name, &$this->request, &$this->manager);
        $layer->cache_output = $this->cache_output;
        $layer->params = $this->layer_params;
        //die("Bad ServerType (".$tree["style"]["ServerType"].")");
      break;
    }
    switch ($this->mode) {
      case $this->modes["legend"]:
        $layer->WriteLegendHTML();
        if ($this->cache_output) {
          $this->output .= $layer->output;
        }
      break;
      default:
        if (IsN() && (BrowserVersion() == 4) && $this->print) {
          $layer->WriteHTMLPrint();
        }
        else {
          $layer->WriteHTML();
          if ($tree["select"]) $this->WriteSelectContent(&$tree);
        }
        if ($this->cache_output) {
         $this->output .= $layer->output;
        }
        $this->point_layer .= $layer->GetPointLayer();
      break;
    }
  }

  function WriteMapScript() {
    echo "<SCRIPT>\n";
    echo "function CallPanel() {\n";
    echo "  f_panel = parent.map_panel;\n";
    if ($this->mode == $this->modes["map"]) {
      echo "  if (f_panel.env.isN && (f_panel.env.version == 4)) {\n";
      echo "    document.captureEvents(Event.MOUSEMOVE);\n";
      echo "    document.captureEvents(Event.MOUSEDOWN);\n";
      echo "    document.captureEvents(Event.MOUSEUP);\n";
      echo "    document.captureEvents(Event.KEYPRESS);\n";
      echo "  } else {\n";
  		echo "    document.onmousemove = f_panel.MapMouseMove;\n";
      echo "    document.onmousedown = f_panel.MapMouseDown;\n";
      echo "    document.onmouseup = f_panel.MapMouseUp;\n";
      echo "    document.onkeypress = f_panel.MapKeyPress;\n";
      echo "    if (f_panel.env.isN) document.addEventListener('DOMMouseScroll', f_panel.MapMouseWheel, false); else document.onmousewheel=f_panel.MapMouseWheel;\n";
      echo "  }\n";
      echo "  f_panel.win_ready.map = true;\n";
//      die(print_r($this));
      echo "  f_panel.MapExtent(".$this->request["bbox"]['minx'].",".$this->request["bbox"]['miny'].",".$this->request["bbox"]['maxx'].",".$this->request["bbox"]['maxy'].");\n";
      if ($this->wait)     echo "  f_panel.SetPageLayerVisible(window, 'MapWait', false);\n";
    	if ($this->overview) { echo "  f_panel.ChangeOV('".$this->overview."');\n";	}

    }
    elseif ($this->mode == $this->modes["overview"]) {

		  echo "  document.onmousemove = f_panel.OVMouseMove;\n";
      echo "  document.onmousedown = f_panel.OVMouseDown;\n";
      echo "  document.onmouseup = f_panel.OVMouseUp;\n";
      echo "  document.onkeypress = f_panel.OVKeyPress;\n";
      echo "  f_panel.win_ready.ov = true;\n";

    }
    echo "}\n\n";
    echo "function Init() {\n";
    echo "  if (parent.map_panel)\n";
    echo "    if (parent.map_panel.panel_loaded) CallPanel();\n";
    echo "    else window.setTimeout(Init, 100);\n";
    echo "  else window.setTimeout(Init, 200);\n";
    echo "}\n";
    echo "</SCRIPT>\n";
  }

  function WriteZoomLayer($prefix="Map") {
    $color = $this->style["zoom"]["color"]?$this->style["zoom"]["color"]:"red";
    $tree["style"]=array("type"=>"Image","image"=>FileUpURL("images/pixel.gif"),"bgColor"=>$color,"visible"=>false,"zIndex"=>99, "absolute"=>true);
    $this->WriteMapLayer(&$tree,$prefix."RectTop");
    $this->WriteMapLayer(&$tree,$prefix."RectLeft");
    $this->WriteMapLayer(&$tree,$prefix."RectRight");
    $this->WriteMapLayer(&$tree,$prefix."RectBottom");
    if (IsN()) {
      include_once(FileUp2(".admin/main_maplayer.inc"));
      $lr = new MapLayer(&$this->tree, $prefix."MoZoom", $this->request, $this->manager);
      $lr->cache_output = true;
      $lr->content = " ";
      $lr->WriteHTMLLayer(array("visible"=>true, "left"=>$this->layer_params["left"], "top"=>$this->layer_params["top"], "zIndex"=>2));
      $this->output .= $lr->output;
      if (!$this->cache_output) {
        echo $lr->output;
      }
    }
  }

  function WriteMeasureLayer($prefix="measure") {

    $output .= '<div id="'.$prefix.'Main" style="visibility:hidden;left:0;top:0;width:100%;height:100%;position:absolute;z-index:101;">'."\n";
    $output .= '<img id="'.$prefix.'ImgOver" src="'.FileUpURL("images/pixel_transp.gif").'" width="100%" height="100%" style="visibility:hidden;left:0;top:0;position:absolute;z-index:109" ondblclick="f_panel.'.$prefix.'dblclickhandler(window.event);" onmousemove="f_panel.'.$prefix.'mousemovehandler(window.event)" onmousedown="f_panel.'.$prefix.'mousedownhandler(window.event)" onmouseup="f_panel.'.$prefix.'mouseuphandler(window.event)" galleryimg="no">'."\n";
    $output .= '<div id="'.$prefix.'CanvasLast" style="left:0;top:0;width:100%;height:100%;position:absolute;z-index:100"></DIV>'."\n";
    $output .= '<div id="'.$prefix.'CanvasMain" style="left:0;top:0;width:100%;height:100%;position:absolute;z-index:100"></DIV>'."\n";
    $output .= '<div style="left:0;top:0;position:absolute;z-index:1010">'."\n";
      $output .= '<table id="'.$prefix.'Tools" style="z-index:1010"><tr><td class="mapdrawtoolbar">'."\n";
        $output .= '<span id="'.$prefix.'Tool_polyline"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'polyline'".')"><img id="'.$prefix.'_polyline" src="'.FileUpURL("images/measure/polyline.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_rect"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'rect'".')"><img id="'.$prefix.'_rect" src="'.FileUpURL("images/measure/rect.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_circle"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'circle'".')"><img id="'.$prefix.'_circle" src="'.FileUpURL("images/measure/circ.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_polygon"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'polygon'".')"><img id="'.$prefix.'_polygon" src="'.FileUpURL("images/measure/poly.gif").'" border="0"></a></span>'."\n";
      $output .= '</td></tr></table>'."\n";
      $output .= '<div id="'.$prefix.'Properties" class="mapdrawhelp" style="display:none">
                  <h1>'.$this->RESOURCE_STRING['edit_vector_shape_properties'].'</h1>
                  <ul>
                  <li id="'.$prefix.'Prop_1"></li>
                  <li id="'.$prefix.'Prop_2"></li>
                  <li id="'.$prefix.'Prop_3"></li>
                  <li id="'.$prefix.'Prop_X"></li>
                  <li id="'.$prefix.'Prop_Y"></li>
                  </div>'."\n";
    $output .= '</div>'."\n";
    $output .= '</div>'."\n";
    $output .= '
    <SCRIPT language="JavaScript">
      if (window.panel)
        var f_panel = window;
      else
        var f_panel = parent.map_panel;
      f_panel.'.$prefix.'Init(window);
    </SCRIPT>
    '."\n";

    $this->output = $output;
    if (!$this->cache_output) echo $output;
  }

  function WriteSelectionShapeLayer($prefix="selection_shape") {

    $output .= '<div id="'.$prefix.'Main" style="visibility:hidden;left:0;top:0;width:100%;height:100%;position:absolute;z-index:101">'."\n";
    $output .= '<img id="'.$prefix.'ImgOver" src="'.FileUpURL("images/pixel_transp.gif").'" width="100%" height="100%" style="visibility:hidden;left:0;top:0;position:absolute;z-index:109" ondblclick="f_panel.'.$prefix.'dblclickhandler(window.event);" onmousemove="f_panel.'.$prefix.'mousemovehandler(window.event)" onmousedown="f_panel.'.$prefix.'mousedownhandler(window.event)" onmouseup="f_panel.'.$prefix.'mouseuphandler(window.event)" galleryimg="no">'."\n";
    $output .= '<div id="'.$prefix.'CanvasLast" style="left:0;top:0;width:100%;height:100%;position:absolute;z-index:100"></DIV>'."\n";
    $output .= '<div id="'.$prefix.'CanvasMain" style="left:0;top:0;width:100%;height:100%;position:absolute;z-index:100"></DIV>'."\n";
    $output .= '<div style="left:0;top:0;position:absolute;z-index:1010">'."\n";
      $output .= '<table id="'.$prefix.'Tools" style="z-index:1010"><tr><td class="mapdrawtoolbar">'."\n";
        $output .= '<span id="'.$prefix.'Tool_rect"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'rect'".')"><img id="'.$prefix.'_rect" src="'.FileUpURL("images/selection_shape/rect.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_polyline"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'polyline'".')"><img id="'.$prefix.'_polyline" src="'.FileUpURL("images/selection_shape/polyline.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_circle"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'circle'".')"><img id="'.$prefix.'_circle" src="'.FileUpURL("images/selection_shape/circ.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_polygon"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'polygon'".')"><img id="'.$prefix.'_polygon" src="'.FileUpURL("images/selection_shape/poly.gif").'" border="0"></a></span>'."\n";
      $output .= '</td></tr></table>'."\n";
    $output .= '</div>'."\n";
    $output .= '</div>'."\n";
    $output .= '
    <SCRIPT language="JavaScript">
      if (window.panel)
        var f_panel = window;
      else
        var f_panel = parent.map_panel;
      f_panel.'.$prefix.'Init(window);
      f_panel.'.$prefix.'InitSelectionShape(window);
    </SCRIPT>
    '."\n";

    $this->output = $output;
    if (!$this->cache_output) echo $output;
  }

  function WriteEditVectorLayer($prefix="edit_vector") {

    $output .= '<div id="'.$prefix.'Main" style="visibility:hidden;left:0;top:0;width:100%;height:100%;position:absolute;z-index:101">'."\n";
    $output .= '<div id="'.$prefix.'CanvasVertex" style="left:0;top:0;width:100%;height:100%;position:absolute;"></div>'."\n";
    $output .= '<img id="'.$prefix.'ImgOver" src="'.FileUpURL("images/pixel_transp.gif").'" width="100%" height="100%" style="visibility:hidden;left:0;top:0;position:absolute;z-index:109" ondblclick="f_panel.'.$prefix.'dblclickhandler(window.event);" onmousemove="f_panel.'.$prefix.'mousemovehandler(window.event)" onmousedown="f_panel.'.$prefix.'mousedownhandler(window.event)" onmouseup="f_panel.'.$prefix.'mouseuphandler(window.event)" galleryimg="no">'."\n";
    $output .= '<div id="'.$prefix.'CanvasLast" style="left:0;top:0;width:100%;height:100%;position:absolute;z-index:100"></DIV>'."\n";
    $output .= '<div id="'.$prefix.'CanvasMain" style="left:0;top:0;width:100%;height:100%;position:absolute;z-index:100"></DIV>'."\n";

      $output .= '<div style="left:0;top:0;position:absolute;z-index:1010">'."\n";
        $output .= '<table id="'.$prefix.'Tools" style="z-index:1010"><tr><td class="mapdrawtoolbar">'."\n";
        $output .= '<span id="'.$prefix.'Tool_select"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'select'".')"><img id="'.$prefix.'_select" src="'.FileUpURL("images/edit_vector/select.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_selectpol"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'selectpol'".')"><img id="'.$prefix.'_selectpol" src="'.FileUpURL("images/edit_vector/selectpol.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_point"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'point'".')"><img id="'.$prefix.'_point" src="'.FileUpURL("images/edit_vector/point.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_line"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'line'".')"><img id="'.$prefix.'_line" src="'.FileUpURL("images/edit_vector/line.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_polyline"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'polyline'".')"><img id="'.$prefix.'_polyline" src="'.FileUpURL("images/edit_vector/polyline.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_rect"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'rect'".')"><img id="'.$prefix.'_rect" src="'.FileUpURL("images/edit_vector/rect.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_circle"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'circle'".')"><img id="'.$prefix.'_circle" src="'.FileUpURL("images/edit_vector/circ.gif").'" border="0"></a></span>'."\n";
        $output .= '<span id="'.$prefix.'Tool_polygon"><a href="javascript:f_panel.'.$prefix.'ChangeTypeShp('."'polygon'".')"><img id="'.$prefix.'_polygon" src="'.FileUpURL("images/edit_vector/poly.gif").'" border="0"></a></span>'."\n";
        $output .= '</td></tr></table>'."\n";
    
        $output .= '<div id="'.$prefix.'Properties" class="mapdrawhelp" style="display:none">
                    <h1>'.$this->RESOURCE_STRING['edit_vector_shape_properties'].'</h1>
                    <ul>
                    <li id="'.$prefix.'Prop_1"></li>
                    <li id="'.$prefix.'Prop_2"></li>
                    <li id="'.$prefix.'Prop_3"></li>
                    <li id="'.$prefix.'Prop_X"></li>
                    <li id="'.$prefix.'Prop_Y"></li>
                    </div>'."\n";
        $output .= '<div id="'.$prefix.'UpdateHelp" class="mapdrawhelp" style="display:none">
                    <h1>'.$this->RESOURCE_STRING['edit_vector_shape_editing'].'</h1>
                    '.$this->RESOURCE_STRING['edit_vector_shape_editing_how'].'?
                    <ul>
                    '.$this->RESOURCE_STRING['edit_vector_help_text'].'
                    <li><form><input type="checkbox" id="'.$prefix.'chbxdrawshapelines" onclick="f_panel.'.$prefix.'SwitchDrawShapeLines()">'.$this->RESOURCE_STRING["edit_vector_shape_show"].'</form></li>
                    </ul>
                    <div style="text-align:right;padding:1em">
                    <form>
                      <input type="button" value="'.$this->RESOURCE_STRING["edit_vector_shape_save_button"].'" onclick="f_panel.'.$prefix.'SaveEditing();">
                    </form>
                    </div>
                    </div>'."\n";
      $output .= '</div>'."\n";

    $output .= '</div>'."\n";
    $output .= '
    <SCRIPT language="JavaScript">
      if (window.panel)
        var f_panel = window;
      else
        var f_panel = parent.map_panel;
      f_panel.'.$prefix.'Init(window);
      f_panel.'.$prefix.'InitEdit(window);
    </SCRIPT>
    '."\n";

    $this->output = $output;
    if (!$this->cache_output) echo $output;
  }

  function WriteWaitLayer() {
    $img = FileUpURL("images/".($this->style['wait']["image"]?$this->style['wait']["image"]:"wait.gif"));
    if ($this->style['wait']['position'] == "center") {
      $size = getimagesize($img);
      $width = $size[0];
      $height = $size[1];
      $left = ($this->request['width'] - $width)/2 + $this->layer_params["left"];
      $top = ($this->request['height'] - $height)/2 + $this->layer_params["top"];
    } else {
      $left = $this->style['wait']["left"];
      $top = $this->style['wait']["top"];
      $width = $this->request['width'] - $left;
      $height = $this->request['height'] - $top;
    }
    $tree["style"]=array("type"=>"Image","image"=>$img,"zIndex"=>99, "left"=>$left, "top"=>$top, "width"=>$width, "height"=>$height, "absolute"=>true);
    $this->WriteMapLayer(&$tree,"MapWait");
  }

  function WritePanLayer() {
    echo "";
  }

  function WriteScaleBar() {
    if ($this->style["scalebar"]["direct_connection"]) {
      $content = $this->manager->GetUrl($this->style['scalebar']["project"],"MapServer");
    }
    else {
      $content = "map_image.php?name=".$this->style['scalebar']["project"];
    }
    $content .= "&mapext=".$this->request['bbox']['minx'].'+'.$this->request['bbox']['miny'].'+'.$this->request['bbox']['maxx'].'+'.$this->request['bbox']['maxy'];
    $content .= "&mapsize=".$this->request['width'].'+'.$this->request['height'];
    if ($this->request["cacheId"]) $content .= '&cacheId=' .$this->request["cacheId"];
    if (Is_Array($this->style["scalebar"]["parameters"])) {
      foreach($this->style["scalebar"]["parameters"] as $key=>$value) {
        $content .= '&'.$key.'='.$value;
      }
    }

    $left = $this->style['scalebar']["left"]+ $this->layer_params["left"];
    if ($left < 0) $left += $this->request['width'];
    $top = $this->style['scalebar']["top"]+ $this->layer_params["top"];
    if ($top < 0) $top += $this->request['height'];
    $width = $this->request['width'] - $left;
    $height = $this->request['height'] - $top;
    $tree["style"]=array("type"=>"Image","image"=>$content,"zIndex"=>99, "left"=>$left, "top"=>$top, "width"=>$width, "height"=>$height);
    $this->WriteMapLayer(&$tree,"MapScaleBar");
  }

  function WriteSelectContent($tree) {
    if ($tree["style"]["select"]) {
      $select = $tree["style"]["select"];
      $type = $select["SelectType"];
      $values = $select["Values"];
    }
    else {
      $img_file = FileUpURL("images/arrows/red.gif");
      $relative_left = 0;
      $relative_top = 0;
    }

//    include_once(FileUp2(".admin/functions.inc"));
//    ShowArray($tree["select"]);

    for($j=0;$j<Count($tree["select"]);$j++) {

      List($x,$y,$t,$alt) = Explode(":", $tree["select"][$j]);
      if ($type) {
        if ($values[$t]) {
          $img_file = FileUpURL("images/".$values[$t]["image"].".gif");
          $relative_left = $values[$t]["left"];
          $relative_top = $values[$t]["top"];
        }
        else {
          $img_file = FileUpURL("images/arrow_red.gif");
          $relative_left = 0;
          $relative_top = 0;
        }
      }
      $left = Round(($x - $this->request["bbox"]["minx"])/($this->request["bbox"][maxx] - $this->request["bbox"]["minx"])*$this->request["width"]) - $relative_left;
      if ($left < 0 or $left > $this->request["width"]) continue;
      $top = $this->request["height"] - Round(($y - $this->request["bbox"]["miny"])/($this->request["bbox"][maxy] - $this->request["bbox"]["miny"])*$this->request["height"]) - $relative_top;
      if ($top < 0 or $top > $this->request["height"]) continue;
      $this->select_content .= '<div style="position:absolute;left:'.$left.';top:'.$top.';"><img id="tpin" name="tpin" src="'.$img_file.'"'.($alt?" alt=\"".$alt."\"":"").'></div>';
    }
  }

  function WriteSelect() {
// presunuto do WritePointLayer (jiva)
//    $tree["style"]=array("type"=>"Image","text"=>&$this->select_content,"zIndex"=>99);
//    $this->WriteMapLayer(&$tree,"MapSelect");
  }

  function WritePointLayer() {
    $points = $this->point_layer.$this->select_content;
    $tree["style"]=array("type"=>"Image","text"=>&$points,"zIndex"=>99,"no_size"=>true);
    $this->WriteMapLayer(&$tree,"PointLayer");
  }

  function WriteLegend() {
  }

}

?>
