<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: map_gd.inc,v 1.8 2008/03/27 09:54:46 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_map.inc"));
//require_once(FileUp2(".admin/browser.inc"));

class GD_Map extends TMS_Map {

  var $select_content; //obsah vyberu
  var $width;
  var $height;
  var $cache;

  function GD_Map($interface) {
    $this->TMS_Map($interface);
    $this->select_content = array();
    if ($this->request["print"]) {
      $this->width = $this->request["print"]["width"]*$this->request["print"]["dpi"]/96;
      $this->height = $this->request["print"]["height"]*$this->request["print"]["dpi"]/96;
    }
    else {
      $this->width = $this->request["width"];
      $this->height = $this->request["height"];
    }
    $tiles = $this->style[$this->request['style']]['tiles'];
    if (Is_array($tiles)) {
      include_once(FileUp2('.admin/cache/'.$tiles['type'].'.inc'));
      $cachetype = 'Map_Cache_'.$tiles['type'];
      $params = array(
        'project'=>$this->project,
        'request'=>$this->request,
        'style'=>$this->style,
        'tree'=>$this->tree
      );
      $this->cache = new $cachetype($tiles,$params);
    }
  }

  function WriteMapHeader() {
    $this->WriteMapHeaderGD();
  }

  function WriteMapHeaderGD() {
    if ($this->cache && !$this->cache->disabled && !$this->cache->force) {
      $this->cacheddata = $this->cache->Find();
    }
    if (!$this->cacheddata) $this->CreateImage($this->width, $this->height);
  }

  function WriteMapFooter() {
    $this->WriteMapFooterGD();
    if ($this->cache) $this->cache->Free();
  }

  function WriteMapFooterGD() {
   if ($this->cacheddata) {
     echo $this->cacheddata;
     return false;
   }
   if ($this->cache) 
     $this->cache->WriteImage($this->request['format'], $this->ImageGD);
   if (($this->point_layer != '') || Count($this->select_content)) 
     $this->WritePointLayer();
   return true;
  }

  function WriteMapContent () {
    $size = 0;
    $layers = &$this->tree[$this->request["map"]]["layers"];
    $key_arr = array_keys($layers);
    if (!(Count($key_arr)==1 && $key_arr[0]=='')) {
      for($i=0;$i<Count($key_arr);$i++) $size += $this->WriteMapTree(&$layers[$key_arr[$i]],$key_arr[$i]);
    }
    if ($this->request['format'] == 'PNG' && Is_Numeric($this->request['pngalpha'])) {
      $this->ImageSetAlpha(&$this->ImageGD, $this->request['pngalpha']);
    }
    return $size;
  } 

  function WriteMapLayer($tree,$name) {
    $this->WriteMapLayerGD(&$tree,$name);
  }
  
  function WriteMapLayerGD($tree,$name) {
    if ($this->cacheddata) return false;

    $ServerType = $tree["style"]["type"];
    switch ($ServerType) {
      case "TMapServer":
        $tree["collection"] = true;
        if ($tree["select"]) $this->WriteSelectContent(&$tree);
        return;
      break;
      default:
        $file = FileUp2(".admin/connector/maplayer/$ServerType.inc");
        if ($file) include_once($file);
        else ErrorMsg(array("image"=>false, "msg"=>"Error: Bad connector $ServerType or connector is missing"));
        $MapLayer = $ServerType."_MapLayer";
        $layer = new $MapLayer(&$tree, $name, &$this->request, &$this->manager);
        $layer->MapImageFormat=$this->request["format"];
        $layer->cache_output = $this->cache_output;
        $layer->params = $this->layer_params;
        //die("Bad ServerType (".$tree["style"]["ServerType"].")");
      break;
    }
    if (method_exists($layer, 'WriteGD')) {
      $img = $layer->WriteGD();
      if ($img) {
        //Legend
        if ($this->request['mode'] == 2) {
          ImageDestroy($this->ImageGD);
          $this->ImageGD = null;
          $this->CreateImage(imagesx($img), imagesy($img));
        } else {
          //die(print_R($this));
        }
        //Transparency merging
        $transparency = 100-($layer->properties['composite']['transparency']?$layer->properties['composite']['transparency']:100);
        $transparency = Round($transparency*1.27);
        if ($transparency > 0) {
          //Palette image must be converted to truecolor first and then blended  
          if (!imageistruecolor($img)) {
            $colorcache = array();
            $original_transparency = imagecolortransparent($img);
            $rgb = imagecolorsforindex($img, $original_transparency);
            $original_transparency = ($rgb['red'] << 16) | ($rgb['green'] << 8) | $rgb['blue'];
            imagecolortransparent($img, imagecolorallocate($img, 0, 0, 0));
            $img2 = imagecreatetruecolor($this->width, $this->height);
            imagefilledrectangle($img2, 0, 0, $this->width, $this->height, $bg);
            imageSaveAlpha($img2, true);
            ImageCopy($img2, $img, 0, 0, 0, 0, $this->width, $this->height);
            ImageDestroy($img);
            $img = $img2;
            imageAlphaBlending($img, false);
            for ($x = 0; $x < $this->width; $x++) {
              for ($y = 0; $y < $this->height; $y++) {
                if (imagecolorat($img, $x, $y) == $original_transparency) {
                  imagesetpixel($img, $x, $y, 127 << 24);
                } else {
                  $color = imagecolorat($img,$x,$y);
                  if (!isset($cache[$color])) {
                    $rgba = imagecolorsforindex($img,$color);
                    $rgba['alpha'] += $transparency;
                    $cache[$color] = imagecolorallocatealpha($img, $rgba['red'], $rgba['green'], $rgba['blue'], ($rgba['alpha']>127)?127:$rgba['alpha']);
                  }
                  imagesetpixel($img, $x, $y, $cache[$color]);
                }
              }
            }
            unset($colorcache);
            
          //true color blending
          } else {
            $this->ImageSetAlpha(&$img, $transparency);
          }
        }
        ImageCopy($this->ImageGD, $img, 0, 0, 0, 0, $this->width, $this->height);
        ImageDestroy($img);
      }
    }

    if ($tree["select"]) $this->WriteSelectContent(&$tree);
    $this->point_layer .= $layer->GetPointLayer();
  }

  function WriteSelectContent($tree) {
     if ($tree["style"]["select"]) {
      $select = $tree["style"]["select"];
      $type = $select["SelectType"];
      $values = $select["Values"];
    }
    else {
      $img_file = FileUpURL("images/arrows/red.gif");
      $relative_left = 0;
      $relative_top = 0;
    }

    for($j=0;$j<Count($tree["select"]);$j++) {

      List($x,$y,$t,$alt) = Explode(":", $tree["select"][$j]);
      if ($type) {
        if ($values[$t]) {
          $img_file = FileUp2("images/".$values[$t]["image"].".gif");
          $relative_left = $values[$t]["left"];
          $relative_top = $values[$t]["top"];
        }
        else {
          $img_file = FileUp2("images/arrow_red.gif");
          $relative_left = 0;
          $relative_top = 0;
        }
      }
      $left = Round(($x - $this->request["bbox"]["minx"])/($this->request["bbox"][maxx] - $this->request["bbox"]["minx"])*$this->width) - $relative_left;
      if ($left < 0 or $left > $this->width) continue;
      $top = $this->height - Round(($y - $this->request["bbox"]["miny"])/($this->request["bbox"][maxy] - $this->request["bbox"]["miny"])*$this->height) - $relative_top;
      if ($top < 0 or $top > $this->height) continue;
      $this->select_content[] = array(
        'img'=>$img_file,
        'left'=>$left,
        'top'=>$top,
      );
    }

  }

  function WritePointLayer() {
    $points = $this->select_content;
    foreach($points as $point) {
      $img_info = getimagesize($point['img']);
      $img_format = $img_info[2];
      switch($img_format) {
        case 1:  $img = imagecreatefromgif($point['img']); break;

        case 2: $img = imagecreatefromjpeg($point['img']); break;

        case 3:  $img = imagecreatefrompng($point['img']); break;

        default: die('GD_Map: Image source '.$point['img'].' is not correct.'); break;
      }
      ImageCopy($this->ImageGD, $img, $point['left'], $point['top'], 0, 0, $img_info[0], $img_info[1]);
      imagedestroy($img);
    }
  }

  function CreateImage($width, $height) {
    if (!$this->ImageGD) {
      $map = $this->request['map'];
      $params = $this->tree[$map]['layers'][$map]['style']['parameters'];
      if($params['color_depth']=='256') $this->ImageGD = ImageCreate($width, $height);
      else $this->ImageGD = ImageCreateTruecolor($width, $height);
      $bgcolor = $this->properties['parameters']['background']['color']?$this->properties['parameters']['background']['color']:array(255,255,255);
      $bgcolor = imagecolorallocate($this->ImageGD, $bgcolor[0], $bgcolor[1], $bgcolor[2]);
      imagefilledrectangle($this->ImageGD, 0, 0, $width, $height, $bgcolor);
      
      if ($params['background']['transparent'] != false) 
        imagecolortransparent($this->ImageGD, $bgcolor);
    }
  }
  
  function ImageSetAlpha($img, $alpha) {
    $cache = array();
    $w = imagesx($img);
    $h = imagesy($img);
    imageSaveAlpha($img, true);
    imageAlphaBlending($img, false);
    for ($x = 0; $x < $w; $x++) {
      for ($y = 0; $y < $h; $y++) {
        $color = imagecolorat($img,$x,$y);
        if (!isset($cache[$color])) {
          $rgba = imagecolorsforindex($img,$color);
          if ($rgba['alpha'] == 127) {
            $cache[$color] = false;
            continue;
          } 
          $rgba['alpha'] += $alpha;
          $cache[$color] = imagecolorallocatealpha($img, $rgba['red'], $rgba['green'], $rgba['blue'], ($rgba['alpha']>127)?127:$rgba['alpha']);
        }
        if ($cache[$color] !== false) imagesetpixel($img, $x, $y, $cache[$color]);
      }
    }
  }
  
}

?>
