<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: map_functions.inc,v 1.15 2008/03/07 10:35:32 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

function LegendDrawImage($color, $ocolor = false, $width = 24, $height = 13, $hspace = 7) {
  $color = $color?"&COLOR=".$color[0].",".$color[1].",".$color[2]:"";
  $ocolor = $ocolor?"&OCOLOR=".$ocolor[0].",".$ocolor[1].",".$ocolor[2]:"";
  return "<img src=\"legend_image.php?WIDTH=$width&HEIGHT=$height".$color.$ocolor."\" width=\"$width\" height=\"$height\" hspace=\"$hspace\">";
}

function getMetasystemConfig() {
  include_once(FileUp2(".admin/agenda_func.inc"));
  $meta_main_dir = GetAgendaPath('TW_MAIN');
  if($meta_main_dir=='.') return false;
  $meta_main_dir = preg_replace("/(\.?\.?\/?)*(\/[^\.]+)$/","\\2",$meta_main_dir);
  $config = $GLOBALS['TMAPY_DIR'].$meta_main_dir."/.admin/config.inc";
  if($meta_main_dir && is_file($config)) {
    include_once($config);
    return true;
  }
  else {
    //die('map_functions: metasystem config not found.');
    return false;
  }
}

function ServiceInfo() {
  $arr = array();
  if(getMetasystemConfig()) {
    include_once(FileUp2(".admin/db/db_twist_tms.inc"));
    include(FileUp2(".admin/properties.inc"));
    $arr = array();
    $db = new DB_TWIST_TMS;
    $sql = "select l.title, l.name from ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."project_layers l ".
           "left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."map_project p on (l.id_project = p.id) ".
           "left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."services v on (l.id_service = v.id) ".
           "left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."servers s on (v.id_server = s.id) ".
           "where p.ident_name = '".$PROPERTIES["AGENDA_IDENT"]."' ".
  				 "and l.queryable = '1' ".
  				 "and l.layer_type = 'layer' ".
           // "and s.external = 0 ". //disabled by tono 2005-11-05
           "order by l.title";
    $db->query($sql);
    while($db->next_record()) {
      $title = $db->Record["TITLE"];
      $name = $db->Record["NAME"];
      $arr[$name]['id'] = $name;
      $arr[$name]['name'] = $name;
      $arr[$name]['title'] = $title;
    }
    $sql = "select f.*, l.name as layer_name, g.f_type, g.f_size, g.f_precision from ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."project_layers l left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."map_project p on (l.id_project = p.id) left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."player_fields f on (l.id = f.id_player) left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."service_layers s on (l.name = s.name and l.id_service = s.id_service) left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."slayer_fields g on (g.id_slayer = s.id and g.name = f.name) where p.ident_name = '".$PROPERTIES["AGENDA_IDENT"]."' and l.queryable = '1' and l.layer_type = 'layer'";
    $db->query($sql);
    while($db->next_record()) {
      $l_name = $db->Record["LAYER_NAME"];
      $name = $db->Record["NAME"];
      $type = $db->Record["F_TYPE"];
      if ($type==-5||$type==4||$type==5||$type==6||$type==8||$type==1||$type==12) {
        $arr[$l_name]["fields"][$name]["name"] = $db->Record["NAME"];
        $arr[$l_name]["fields"][$name]["title"] = $db->Record["TITLE"];
        $arr[$l_name]["fields"][$name]["type"] = $db->Record["F_TYPE"];
        $arr[$l_name]["fields"][$name]["size"] = $db->Record["F_SIZE"];
        $arr[$l_name]["fields"][$name]["precision"] = $db->Record["F_PRECISION"];
      }
    }
  }
  return $arr;
}

function GetBufferLayers() {
  $arr = array();
  if(getMetasystemConfig()) {
    include_once(FileUp2(".admin/db/db_twist_tms.inc"));
    include(FileUp2(".admin/properties.inc"));
    getMetasystemConfig();
    
    $db = new DB_TWIST_TMS;
    $sql = "select l.title, l.name from ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."project_layers l left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."map_project p on (l.id_project = p.id) left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."service_layers s on (l.name = s.name and l.id_service = s.id_service) where p.ident_name = '".$PROPERTIES["AGENDA_IDENT"]."' and l.queryable = '1' and l.layer_type = 'layer' and s.feature in (1,2,3)";
    $db->query($sql);
    while($db->next_record()) {
      $title = $db->Record["TITLE"];
      $name = $db->Record["NAME"];
      $arr[$name]['name'] = $name;
      $arr[$name]['title'] = $title;
    }
  }

  return $arr;
}

function GetActiveLayersPL() {
  include_once(FileUp2(".admin/db/db_twist_tms.inc"));
  include(FileUp2(".admin/properties.inc"));
  getMetasystemConfig();

  $arr = array();
  $db = new DB_TWIST_TMS;
  $sql = "select l.title, l.name from ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."project_layers l left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."map_project p on (l.id_project = p.id) left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."service_layers s on (l.name = s.name and l.id_service = s.id_service) where p.ident_name = '".$PROPERTIES["AGENDA_IDENT"]."' and l.active = '1' and l.layer_type = 'layer' and s.feature in (2,3)";
  $db->query($sql);
  while($db->next_record()) {
    $title = $db->Record["TITLE"];
    $name = $db->Record["NAME"];
    $arr[$name]['name'] = $name;
    $arr[$name]['title'] = $title;
  }

  return $arr;
}

function GetActiveLayers() {
  /*
  global $ACTIVE_LAYERS;
  $layers = $GLOBALS["MAP_LAYER"];
  $order = ChangeOrder($GLOBALS["MAP_LAYER"]);
  for($i=Count($order)-1;$i>=0;$i--) {
    $name = $order[$i];
    if ($layers[$name]["layers"])
      WriteCollectionActiveLayer($layers[$name],$layers[$name]['name'].".");
    else {
      if (!$layers[$name]['hidden']) {
        WriteActiveLayer($layers[$name]);
      }
    }
  }
  return $ACTIVE_LAYERS;
  */

  $arr = array();
  if(getMetasystemConfig()) {
    include_once(FileUp2(".admin/db/db_twist_tms.inc"));
    include(FileUp2(".admin/properties.inc"));
    $db = new DB_TWIST_TMS;
    $sql = "select l.title, l.name from ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."project_layers l left join ".$GLOBALS['CONFIG_WIZARD']['TABLE_PREFIX']."map_project p on (l.id_project = p.id) where p.ident_name = '".$PROPERTIES["AGENDA_IDENT"]."' and l.active = '1'";
    $db->query($sql);
    while($db->next_record()) {
      $title = $db->Record["TITLE"];
      $name = $db->Record["NAME"];
      $arr[$name]['name'] = $name;
      $arr[$name]['title'] = $title;
    }
  }
  return $arr;
}

function GetServiceFromLayer($tree,$layer) {
  reset($tree);
  while(list($key,$val) = each($tree)) {
    if ($key == $layer) return $key;
    if ($val["layers"]) {
      if (IsLayerInSubTree(&$val["layers"],$layer)) return $key;
    }
  }
  return false;
}

function IsLayerInSubTree($tree,$layer) {
  reset($tree);
  while(list($key,$val) = each($tree)) {
    if ($key == $layer) return true;
    if ($val["layers"]) {
      if (IsLayerInSubTree(&$val["layers"],$layer)) return true;
    }
  }
  return false;
}

function WriteActiveLayer($layer, $prefix='', $exp='') {
  if (!$layer['hidden']) {
    if ($layer['active']) {
      $GLOBALS["ACTIVE_LAYERS"][$layer['name']]['name'] = $layer['name'];
      $GLOBALS["ACTIVE_LAYERS"][$layer['name']]['title'] = $layer['title'];
    }
  }
}

function WriteCollectionActiveLayer($layer, $prefix, $space="", $collprefix=false) {
  if (!$layer['hidden']) WriteActiveLayer($layer,$collprefix);
  $order = ChangeOrder($layer['layers']);
  for($i=Count($order)-1;$i>=0;$i--) {
    $name = $order[$i];
    if (!$layer['layers'][$name]['hidden']) {
      if ($layer['layers'][$name]["layers"]) {
        WriteCollectionActiveLayer($layer['layers'][$name], $prefix.$layer['layers'][$name]['name'].".", '', $prefix);
      } else {
        WriteActiveLayer($layer['layers'][$name], $prefix);
      }
    }
  }
}

function ChangeOrder($in) {
  $out = array();
  reset($in);
  while (list($key, $val) = each($in)) {
    $out[] = $key;
  }
  return $out;
}

function GetPanelSettings($client_type) {
  include_once(FileUp2('.admin/access_map_.inc'));
  if (!preg_match('/^[a-z_]+$/',$client_type)) $client_type = 'all';
  $file_lg = FileUp2(".admin/mapclient/panel_$client_type.inc");
  if (File_exists($file_lg)) include($file_lg);
  $PANEL_OBJECT = MapAccessArray($PANEL_OBJECT);
  include(FileUp2('.admin/panel_schema.inc'));
  $MAP_PANEL = MapAccessArray($MAP_PANEL);
  $res=array();
  foreach($PANEL_OBJECT as $i=>$obj) {
    if (($obj["name"] == "tool")||($obj["name"] == "function")||($obj["name"] == "select_box")) {
      reset($obj[$obj["name"]."_array"]);
      while (list($key,$val) = each($obj[$obj["name"]."_array"])) {
        $user_obj = isset($MAP_PANEL[$client_type][$key])?$MAP_PANEL[$client_type][$key]:$MAP_PANEL["DEFAULT"][$key];
        if (Is_Array($user_obj)) {
          reset($user_obj);
          while (list($key2,$val2) = each($user_obj)) {
            $obj[$obj["name"]."_array"][$key][$key2] = $val2;
          }
        }
      }
    }else{
      if ($obj["name"]) {
        $user_obj = isset($MAP_PANEL[$client_type][$obj["name"]])?$MAP_PANEL[$client_type][$obj["name"]]:$MAP_PANEL["DEFAULT"][$obj["name"]];
        if (Is_Array($user_obj)) {
          reset($user_obj);
          while (list($key,$val) = each($user_obj)) {
            $obj[$key] = $val;
          }
        }
      }
    }
    $res[$obj["name"]?$obj["name"]:$i]=$obj;
  }
  return $res;
}

function GetLayersNames($map_tree) {
  foreach($map_tree as $layer) {
    $layers[] = $layer['name'];
    if(is_array($layer['layers']))
      $layers = array_merge($layers,GetLayersNames($layer['layers']));
  }
  return $layers;
}

function GetProjectLayers($map_tree,$filter='name') {
  foreach($map_tree as $layer) {
    if($layer[$filter]) {
      $layers[$layer['name']]['name'] = $layer['name'];
      $layers[$layer['name']]['title'] = $layer['title'];
    }
    if(is_array($layer['layers'])) {
      if(!is_array($layers)) $layers = Array();
      $layers = array_merge($layers,GetProjectLayers($layer['layers'],$filter));
    }
  }
  return $layers;
}

function GetInterfaceLayers() {
  $MAP_INTERFACE = $GLOBALS['MAP_INTERFACE'];
  if(!$MAP_INTERFACE)
    include(FileUp2(".admin/interface_schema.inc"));
  $arr = array();
  if(is_array($MAP_INTERFACE)) {
    foreach($MAP_INTERFACE as $theme=>$params) {
      $layer_name = $params['query_layer']?$params['query_layer']:$params['tmv_interface']['Theme'];
      if(in_array($layer_name,$arr)) continue;
      if($layer_name && is_array($params['objects'])) {
        foreach($params['objects'] as $ob) {
          if(preg_match('/^SEL.+$/',$ob)) {
            $arr[] = $layer_name;
            break;
          }
        }
      } 
    }
  }
  return $arr;
}

function Shape_ConvertWKTPoint($wkt_point) {
  $pt = Explode(' ', trim($wkt_point));
  return $pt[0].':'.$pt[1].($z?':'.$pt[2]:'');
}

function Shape_CreateFromWKT(&$shape, $wkt) {
  $shape['text'] = '';
  preg_match('/^([a-z]+)[ ]*[(]{1,2}([-0-9., ]*)[)]{1,2}$/i',trim($wkt), $res);
  switch (StrToUpper($res[1])) {
    case 'POINT':
      $shape['text'] .= ($shape['text']?'|':'').Shape_ConvertWKTPoint($res[2]);
      $shape['type'] = 'point';
    break;
    case 'LINESTRING':
      $pts = Explode(',',$res[2]);
      foreach ($pts as $val) {
        $shape['text'] .= ($shape['text']?'|':'').Shape_ConvertWKTPoint($val);
      }
      $shape['type'] = 'polyline';
    break;
    case 'POLYGON':
      $pts = Explode(',',$res[2]);
      foreach ($pts as $val) {
        $shape['text'] .= ($shape['text']?'|':'').Shape_ConvertWKTPoint($val);
      }
      $shape['type'] = 'polygon';
    break;
    default:
      return false;
    break;
  }
  return true;
}

function Shape_ConvertPoint(&$point, $bbox, $width, $height) {
    @$point['x'] = $bbox['minx'] + $point['x']/$width*$bbox['width'];
    @$point['y'] = $bbox['maxy'] - $point['y']/$height*$bbox['height'];
  }
  
function Shape_PrepareShape(&$shape, $type, $circleasline, $bbox, $width, $height) {
    $shape['envelope']=false;
    if ($shape['coords']) {
      if (!is_array($bbox)) {
        list($minx, $miny, $maxx, $maxy) = Explode(',',$bbox);
        $bbox = array('minx'=>$minx, 'miny'=>$miny, 'maxx'=>$maxx, 'maxy'=>$maxy);  
      }
      $bbox['width'] = $bbox['maxx'] - $bbox['minx'];
      $bbox['height'] = $bbox['maxy'] - $bbox['miny'];
      $coords_arr = Explode('|',$shape['coords']);
      $clockwise_sum = 0;
      $last_point = false;
      foreach ($coords_arr as $key=>$val) {
        list($x, $y) = Explode(':',$val);
        if ($key>2 && $last_pt['x']==$x && $last_pt['y']==$y) {
          unset($coords_arr[$key]);
          continue;
        }
        $coords_arr[$key] = array('x'=>$x, 'y'=>$y);
        $last_pt = $coords_arr[$key];
        Shape_ConvertPoint($coords_arr[$key], $bbox, $width, $height);
        if ($last_point) {
          $clockwise_sum += $last_point['y']*$coords_arr[$key]['x']-$coords_arr[$key]['y']*$last_point['x'];
        } else {
          $first_point = $coords_arr[$key];
        }
        $last_point = $coords_arr[$key]; 
      } 
      $clockwise_sum += $last_point['y']*$first_point['x']-$first_point['y']*$last_point['x'];
      switch ($shape['type']) {
        case "polygon":
          if ($clockwise_sum > 0) {
            $coords_arr = array_reverse($coords_arr);
          }
        break;
      }

      switch ($shape['type']) {
        case "point":
          $shape[$shape['type']] = $coords_arr[0];
          $shape['text'] = $coords_arr[0]['x'].':'.$coords_arr[0]['y'];
        break;
        case "line":
        case "polyline":
          $shape[$shape['type']] = $coords_arr;
          foreach ($coords_arr as $key=>$val) {
            if ($key) $shape['text'] .= '|';
            $shape['text'] .= $val['x'].':'.$val['y'];
          }
        break;
        case "polygon":
          $coords_arr[] = $coords_arr[0];
          $shape[$shape['type']] = $coords_arr;
          foreach ($coords_arr as $key=>$val) {
            if ($key) $shape['text'] .= '|';
            $shape['text'] .= $val['x'].':'.$val['y'];
          }
        break;
        case "rect":
          $shape[$shape['type']][0] = $coords_arr[0]; 
          $shape[$shape['type']][1] = array('x'=>$coords_arr[0]['x'], 'y'=>$coords_arr[1]['y']); 
          $shape[$shape['type']][2] = $coords_arr[1]; 
          $shape[$shape['type']][3] = array('x'=>$coords_arr[1]['x'], 'y'=>$coords_arr[0]['y']); 
          $shape[$shape['type']][4] = $coords_arr[0];
          foreach ($shape[$shape['type']] as $key=>$val) { 
            if ($key) $shape['text'] .= '|';
            $shape['text'] .= $val['x'].':'.$val['y'];
          }
        break;
        case "circle":
          $dx = $coords_arr[1]['x']? $coords_arr[1]['x']-$coords_arr[0]['x'] : 0;
          $dy = $coords_arr[1]['y']? $coords_arr[1]['y']-$coords_arr[0]['y'] : 0;
        
          $shape[$shape['type']] = $coords_arr[0];
          $shape[$shape['type']]['perim'] = sqrt($dx*$dx+$dy*$dy);
          if ($circleasline) {
            $val = $shape[$shape['type']];
            $cir = array();
            for ($i=0; $i<90; $i+=1) {
              $dx = cos(pi()/180*$i)*$val['perim'];
              $dy = sin(pi()/180*$i)*$val['perim'];
              $cir[0][]=array('x'=>$val['x']+$dx,'y'=>$val['y']+$dy);
              $cir[1][]=array('x'=>$val['x']-$dy,'y'=>$val['y']+$dx);
              $cir[2][]=array('x'=>$val['x']-$dx,'y'=>$val['y']-$dy);
              $cir[3][]=array('x'=>$val['x']+$dy,'y'=>$val['y']-$dx);
            }
            $coords_arr=array_merge($cir[0],$cir[1],$cir[2],$cir[3]);
            $coords_arr[]=$coords_arr[0];
            switch ($type) {
              case 'polyline':
                $shape['type'] = 'polyline'; 
              break;
              case 'polygon':
               $shape['type'] = 'polygon'; 
              break;
            }
            $shape[$shape['type']] = $coords_arr; 
            foreach ($coords_arr as $key=>$val) { 
              if ($key) $shape['text'] .= '|';
              $shape['text'] .= $val['x'].':'.$val['y'];
            }
          } else {
            $shape['text'] = $coords_arr[0]['x'].':'.$coords_arr[0]['y'].'|'.$shape[$shape['type']]['perim'];
          }
//          print_r($shape);die();
        break;
      }
      foreach ($shape[$shape['type']] as $key=>$val) {
        if (!isset($shape['envelope']['minx']) || $shape['envelope']['minx'] > $val['x']) $shape['envelope']['minx'] = $val['x']; 
        if (!isset($shape['envelope']['miny']) || $shape['envelope']['miny'] > $val['y']) $shape['envelope']['miny'] = $val['y']; 
        if (!isset($shape['envelope']['maxx']) || $shape['envelope']['maxx'] < $val['x']) $shape['envelope']['maxx'] = $val['x']; 
        if (!isset($shape['envelope']['maxy']) || $shape['envelope']['maxy'] < $val['y']) $shape['envelope']['maxy'] = $val['y']; 
      }
      $shape['envelope']['width']=$shape['envelope']['maxx']-$shape['envelope']['minx'];
      $shape['envelope']['height']=$shape['envelope']['maxy']-$shape['envelope']['miny'];
      
    } else if ($shape['text']) {
      $text = $shape['text'];
      switch ($shape['type']) {
        case "point":
          list($shape[$shape['type']]['x'], $shape[$shape['type']]['y']) = Explode(':', $text); 
        break;
        case "line":
        case "polyline":
        case "polygon":
        case "rect":
          $coords = Explode('|', $text);
          foreach($coords as $key=>$val) {
            $arr = array(); 
            list($arr['x'], $arr['y']) = Explode(':', $val);
            //if ($last_pt['x']==$x && $last_pt['y'] == $y) continue;
            if ($last_pt['x']==$arr['x'] && $last_pt['y'] == $arr['y']) continue;
            $shape[$shape['type']][] = $arr;
            $last_pt = $arr;
          } 
        break;
        case "circle":
          $coords = Explode('|', $text);
          list($shape[$shape['type']]['x'], $shape[$shape['type']]['y']) = Explode(':', $coords[0]);
          $shape[$shape['type']]['perim'] = $coords[1];
        break;
      }
    }
}

function GetGDVersion() {
   static $gd_version_number = null;
   if ($gd_version_number === null) {
       // Use output buffering to get results from phpinfo()
       // without disturbing the page we're in.  Output
       // buffering is "stackable" so we don't even have to
       // worry about previous or encompassing buffering.
       ob_start();
       phpinfo(8);
       $module_info = ob_get_contents();
       ob_end_clean();
       if (preg_match("/\bgd\s+version\b[^\d\n\r]+?([\d\.]+)/i",
               $module_info,$matches)) {
           $gd_version_number = $matches[1];
       } else {
           $gd_version_number = 0;
       }
   }
   return (integer)$gd_version_number;
}
?>
