<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: Database.inc,v 1.4 2006/03/06 14:22:43 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */
 
require_once(FileUp2(".admin/main_manager_extent.inc"));
 
class Database_ExtentManager extends ExtentManager {
  
  function Database_ExtentManager($interface, $params=false) {
    if ($params["db"]) {
      $this->db = $params["db"];
    } else {
      include_once(FileUp2(".admin/manager.inc"));
      $man = new Manager();
      $srv = $man->GetServer($params["connection"]);
      include_once(FileUp2($srv["file"]));
      $this->db = new $srv["name"];
    }
    $this->table = $params['table']?$params['table']:'extent';
    $this->ExtentManager($interface, $params);
  }
  
  function ValidateExtent($bbox, $width, $height, $scale=false, $coord_sys=false, $format=false, $check_last_level=false, $snap_method=false) {
    $this->gettilescount = 0;
    $i = 2;
    while ($i--) {
      $res = $this->MainValidateExtent($bbox, $width, $height, $scale, $coord_sys, $format, false, $snap_method);
      if (!$this->active_tile) {
        $center = $this->GetCenter($bbox);
        $tiles=$this->GetTiles(array("minx"=>$center["x"],"miny"=>$center["y"],"maxx"=>$center["x"],"maxy"=>$center["y"]), $width, $height, $scale);
        end($tiles);
        $bbox = current($tiles);
        reset($tiles);
        $bbox = $this->ScaleExtent($bbox["extent"],0.9);
        continue;
        
      }
      break; 
    }
    if ($check_last_level && $this->active_tile) {
      $this->gettilescount = 1;
      $center = $this->GetCenter($res);
      $tiles=$this->GetTiles(array("minx"=>$center["x"],"miny"=>$center["y"],"maxx"=>$center["x"],"maxy"=>$center["y"]), $width, $height, $scale);
      $this->active_tile["is_last_level"] = ($this->active_tile["name"] == $tiles[0]["name"] && $this->active_tile["maxpixel"] == $tiles[0]["maxpixel"]);
      $this->last_tile = $tiles[0];
    }
    return $res;
  }

  function GetTiles($bbox, $width, $height, $scale) {
    static $cache;
    $center = $this->GetCenter($bbox);
    $pixel = ($bbox["maxx"]-$bbox["minx"])/(double)$width;
    $sql  = "SELECT e.map_id, m.name, e.minx, e.miny, e.maxx, e.maxy, e.pixel FROM ".$this->table." e LEFT JOIN map m ON (e.map_id=m.map_id)";
    $sql .= " WHERE e.minx <= ".$center["x"];
    $sql .= " AND e.maxx >= ".$center["x"];
    $sql .= " AND e.miny <= ".$center["y"];
    $sql .= " AND e.maxy >= ".$center["y"];
//    $sql .= " AND e.pixel+0.1 >= ".$pixel;
    $sql .= " AND e.sort>0";
    if ($this->params['sql_where']) $sql .= ' '.$this->params['sql_where'];
    $sql .= " ORDER BY e.sort, pixel";
//    die(print_r($this));
    if ($this->gettilescount)
      $sql .= " LIMIT 1";
    if (!$cache[$sql]) {
      $this->db->query($sql);
  //    echo($sql."<br>");
      $tiles = array();
      while ($this->db->next_record()) {
        $tile = array();
        $tile["map_id"] = $this->db->Record["MAP_ID"];
        $tile["name"] = $this->db->Record["NAME"];
        $tile["extent"]["minx"] = $this->db->Record["MINX"];
        $tile["extent"]["miny"] = $this->db->Record["MINY"];
        $tile["extent"]["maxx"] = $this->db->Record["MAXX"];
        $tile["extent"]["maxy"] = $this->db->Record["MAXY"];
        $tile["minpixel"] = $this->db->Record["PIXEL"];
        $tile["maxpixel"] = $this->db->Record["PIXEL"];
        $tile["tiles"] = array(
          "x"=>$this->db->Record["MINX"],
          "y"=>$this->db->Record["MINY"],
          "stepx"=>$this->db->Record["PIXEL"]*125,
          "stepy"=>$this->db->Record["PIXEL"]*125,
        );
        $tiles[] = $tile;
      }
      $cache[$sql]=$tiles;
  //    p1($this->tiles);
    } else {
      $tiles=$cache[$sql];
    }
    $this->tiles = $tiles;
    return $tiles;
  }

}
 
?>
