<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: manager.inc,v 1.9 2007/05/04 11:44:26 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class Manager {
  var $tms_dir; //korenovy adresar T-MapServeru
  var $connection; //pole spojeni na databaze nebo mapove servery
  var $project = array();

  function Manager() {
    $this->tms_dir = $GLOBALS["TMAPY_TMS"];
    $this->connection = array();
  }

  function GetActive($name) {
    if (Is_Array($name) || !$name) $name = $name["DB_NAME"]?$name["DB_NAME"]:"DB_DEFAULT";
    if (!$this->connection[$name]) $this->SetActive($name);
    return $this->connection[$name];
  }

  function SetActive($name) {
    $server = $this->GetServer($name);
    if (!$server)
      ErrorMsg(array("image"=>false, "msg"=>"<b>Error:</b> Bad connection : ".$name));
    $file = $GLOBALS["TMAPY_LIB"]."/ms/".$server["type"].".inc";
    if (File_Exists($file)) include_once($file);
    else ErrorMsg(array("image"=>$server["type"], "msg"=>"<b>Error:</b> Bad type of map server: ".$server["type"]));
    $ServerObject = "MS_".$server["type"];
    $this->connection[$name] = new $ServerObject($server);
  }

  function SetProject($name) {
    if (!$this->project[$name]) {
      $project_file = FileUp2(".admin/connector/project/".$name.".inc");
      if (!file_exists($project_file)) {
        $project_file = FileUp2(".admin/connector/project/wizard/".$name.".inc");
        if (!file_exists($project_file)) return 0;
      }
      include($project_file);
      $this->project[$name] = $CONNECTOR;
    }
    return 1;
  }

  function &GetProject($name) {
    if (!$this->SetProject($name)) return 0;
    return $this->project[$name];
  }

  function GetUrl($name) {
    $conn = $this->GetActive($name);
    return $conn->GetURL();
  }

  function GetStyle($name) {
    if (!$this->SetProject($name)) return 0;
    include($this->tms_dir."/".$this->project[$name]["dir"]."/.admin/style_schema.inc");
    return $MAP_STYLE;
  }

  function GetLayer($name) {
    if (!$this->SetProject($name)) return 0;
    include($this->tms_dir."/".$this->project[$name]["dir"]."/.admin/layer_schema.inc");
    include_once(FileUp2(".admin/access_map_.inc"));
    $MAP_LAYER = MapAccessArray($MAP_LAYER);
    return $MAP_LAYER;
  }
  
  function GetLog($name) {
    if (!$this->SetProject($name)) return 0;
    return $this->project[$name]["log"];
  }

  function GetServer($name) {
    if (!$this->SetProject($name)) return 0;
    $project=$this->project[$name];

    $count = Count($project["servers"]); 
    if ($count > 1) {

      switch ($project["algorithm"]) {
        case "all_access":
          if (1) {
            $db = $this->Active("DB_IMS");
            if (!$db) {
              $this->SetActive("DB_IMS","Postgres");
              $db = $this->Active("DB_IMS");
            }
            $db->query("SELECT nextval ('\"www_access_id_seq\"');");
            $db->next_record();
            $access_number = $db->Record[0];
          }
/*
          else {
            $fp = FSockOpen("", 3333);
            if ($fp) {FPuts($fp, "next_value"); while ($number = FGets($fp,128)) {}; }
            FClose($fp);
          }
*/
          $i = $access_number % $count;
        break;
        case "random":
          SRand((double)MicroTime()*1e6);
          $server_arr[0] = 0;
          for($j=0;$j<$count;$j++) {
            $server_arr[$j+1] = $server_arr[$j] + 100*($project["servers"][$j]["value"]?$project["servers"][$j]["value"]:1);
          }
          $r = Rand(0,$server_arr[$j]);
          for($j=0;$j<$count;$j++) {
            if ($r <= $server_arr[$j+1]) break;
          }
          $i = $j;
        break;
        case "randomfailover":
          $notrunning=array();
          $timeout = ini_set('default_socket_timeout', 1);
          while (true) {
            $i=rand(0,$count-1);
            if ($notrunning[$i]) continue;
            $fp = @FOpen($project["servers"][$i]["failovertest"], "r");
            if ($fp) break;
            $notrunning[$i]=true;
            if (Count($notrunning)==$count) {
              die('Manager: No server is running.');
              break;
            }
          }
          ini_set('default_socket_timeout', $timeout);
        break;
        case "load_balance":
          //die('Not implemented for operating system Windows NT');
          $i = -1;
          for($j=0;$j<$count;$j++) {
            $fp = FOpen("http://".$project["servers"][$j]["server_name"]."/uptime.php", "r");
            if ($fp) {
              while (!feof($fp)):
                $values = FRead($fp, 256);
              endwhile;
              list($t1,$t2,$t3) = Explode(" ", $values);
              if ($t1 < $project["max_uptime"]) {
                $i = $j;
                break;
              }
              else {
                $project["servers"][$j]["uptime"]["t1"] = $t1;
                $project["servers"][$j]["uptime"]["t2"] = $t2;
                $project["servers"][$j]["uptime"]["t3"] = $t3;
              }
            }
          }  
          if ($i == -1) {
            $min = 10000;
            for($j=0;$j<$count;$j++) {
              if ($project["servers"][$j]["uptime"]["t1"] < $min) {
                $min = $project["servers"][$j]["uptime"]["t1"];
                $i = $j;
              }
            }
          }        
        break;
        case "user_access":
        default:
          $i = $GLOBALS["access_number"] % $count;
        break;
      }
    }
    else $i = 0;
    return $project["servers"][$i];
  }

}

?>
