<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_toc_tree.inc,v 1.9 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class TOC {

  var $layers; //seznam vrstev a jejich vlastnosti
	var $settings; //obecne vlastnosti TOC
  var $state;  //zobrazovat stav
  var $image;  //zobrazovat legendu
  var $legend; //zobrazovat tematicke mapovani
  var $order;  //poradi vrstev
  var $images; //cesta k obrazkum stavu vrstvy
  var $folders;
  var $vnoreni; //evidence uzlu
	var $metadata; //metadata k jednotlivym vrstvam
  
  function WriteTOC() {
    $this->order = $this->ChangeOrder($this->layers);
    for($i=Count($this->order)-1;$i>=0;$i--) {
      $this->vnoreni[0]++;
      $name = $this->order[$i];
      if ($this->layers[$name]["layers"]) 
        $this->WriteCollectionLayer($this->layers[$name],$this->layers[$name]['name'].".",'','',1);
      else {
        if (!$this->layers[$name]['hidden']) { 
          $this->WriteLayer($this->layers[$name]);
        }
      }
    }
    $this->WriteJScript();
  }

  function WriteLayer($layer, $prefix='', $exp='') {
    // state
    if ($this->state) {
      if($layer["metadata"] && $this->metadata["metadata_tooltip"]["visible"]) echo $this->MetadataTooltip($layer);
      else echo '<div>';
      $this->folders[$exp] = $exp;

      //nastaveni zobrazeni obrazku pred node - (pokud podvrstvy jsou visible)
      $n_cll=true;
      if($layer["layers"]) {
        foreach($layer["layers"] as $hk=>$vk) {
          if(!$vk["hidden"]) $n_cll=false;
        }
      }    
      else $n_cll=false;
      
      //obrazek pred checkboxem - +/-/*
      if($exp && !$n_cll) echo "<img class=\"img_odkaz\" id=\"img".$exp."\" width=\"16\" height=\"16\" src=\"".$this->images["tree_expand"]."\" onClick=\"FolderCollapse('".$exp."')\">";
      else echo "<img width=\"16\" height=\"16\" src=\"".$this->images["tree_empty"]."\">"; //tree_leaf
      echo '<img src="';
      if ($layer['visible']) {
        if ($layer['active']) echo $this->images['active_visible'];
        else echo $this->images['visible'];
      }
      else {
        if ($layer['active']) echo $this->images['active_hidden'];
        else echo $this->images['hidden'];
      }
      echo '" id="lr_'.$prefix.$layer['name'].'" name="'.$prefix.$layer['name'].'" ';
			if($this->check_parent)
        echo "onmousedown=\"LayerCheckNodesRefresh('" .$prefix.$layer['name']. "');\">";
			else
			  echo "onmousedown=\"parent.map_panel.ChangeLayerVisible('" .$prefix.$layer['name']. "',null)\">"; 	
      echo '&nbsp;';
    }

    //title + metadata
//    die(print_r($this->metadata));
		if($layer["metadata"]["hotlink_id"] && $this->metadata["metadata_hotlink"]["visible"]) {
		  switch($this->metadata["metadata_hotlink"]["type"]) {
			  case "image":
				  $img = FileUpURL("images/".$this->metadata["metadata_hotlink"]["image"]);
					echo $layer["title"]."&nbsp;<a href='".$this->metadata["metadata_hotlink"]["url"].$layer["metadata"]["hotlink_id"]."' target='".($this->metadata["metadata_hotlink"]["target"]?$this->metadata["metadata_hotlink"]["target"]:"_blank")."'><img src='".$img."' alt='".$this->metadata["metadata_hotlink"]["alt"]."' border='0'></a>";
				break;
				case "text":
				  echo "<a class='".$this->metadata["metadata_hotlink"]["class"]."' href='".$this->metadata["metadata_hotlink"]["url"].$layer["metadata"]["hotlink_id"]."' target='".($this->metadata["metadata_hotlink"]["target"]?$this->metadata["metadata_hotlink"]["target"]:"_blank")."'>";
					echo $layer["title"]."</a>";
				break;
				default: 
				  echo $layer["title"];
			}
		} else echo $layer["title"];
		echo "</div>\n";
  }

  function WriteCollectionLayer($layer, $prefix, $space="", $collprefix=false, $exp="") {
    $aktualni_uzel = (($exp*1000)+$this->vnoreni[$exp]);
    if (!$layer['hidden']) $this->WriteLayer($layer,$collprefix,$aktualni_uzel);
    echo "<div id=\"fc".$aktualni_uzel."\" class=\"s_h\" style=\"display: ".($layer["expand"]?"block":"none").";\">\n";
    $this->folders[$aktualni_uzel] = $aktualni_uzel;
    $order = $this->ChangeOrder($layer['layers']);
    for($i=Count($order)-1;$i>=0;$i--) {
      $this->vnoreni[$exp]++;
      $name = $order[$i];
      if (!$layer['layers'][$name]['hidden']) { 
        if ($layer['layers'][$name]["layers"]) {
          echo "<div id=\"ft".(($exp*1000)+$this->vnoreni[$exp])."\">";
          $this->folders[(($exp*1000)+$this->vnoreni[$exp])] = (($exp*1000)+$this->vnoreni[$exp]);
          $this->WriteCollectionLayer($layer['layers'][$name], $prefix.$layer['layers'][$name]['name'].".", '', $prefix, $exp++);
          echo "</div>\n";
        } else {
          $this->WriteLayer($layer['layers'][$name], $prefix);
        }
      }
    }
    echo "</div>\n";
  }

  function WriteLayerImage($layer, $colection = false) {
  }

  function ChangeOrder($in) {
    $out = array();
    reset($in);
    while (list($key, $val) = each($in)) {
      //echo $key."<br>";
      $out[] = $key;
    }
    return $out;
  }

  function CreateTOC($params = false) {
    $this->layers = ($params["layers"])?$params["layers"]:array();
		$this->check_parent = (isset($params["settings"]["check_parent"])?$params["settings"]["check_parent"]:true);
  	$this->metadata = ($params["metadata"])?$params["metadata"]:array();

    $this->state = ($params["state"])?$params["state"]:true;
    $this->image = ($params["image"])?$params["image"]:false;
    $this->legend = ($params["legend"])?$params["legend"]:false;
    $this->order = array();
    if ($this->state) {
      $this->images["visible"] = FileUpURL("images/checked.gif");
      $this->images["hidden"] = FileUpURL("images/unchecked.gif");
      $this->images["active_visible"] = FileUpURL("images/checked_active.gif");
      $this->images["active_hidden"] = FileUpURL("images/unchecked_active.gif");

      $this->images["tree_expand"] = FileUpURL("images/toc_tree/tree_expand.gif");
      $this->images["tree_collapse"] = FileUpURL("images/toc_tree/tree_collapse.gif");
      $this->images["tree_split"] = FileUpURL("images/toc_tree/tree_split.gif");
      $this->images["tree_end"] = FileUpURL("images/toc_tree/tree_end.gif");
      $this->images["tree_vertline"] = FileUpURL("images/toc_tree/tree_vertline.gif");
      $this->images["tree_empty"] = FileUpURL("images/toc_tree/tree_empty.gif");
      $this->images["tree_leaf"] = FileUpURL("images/toc_tree/tree_leaf.gif");
      
    }
  }
  function MetadataTooltip($layer) {
    if($layer["metadata"]["title"]) {
      $title = $layer["metadata"]["title"];
      if(strstr($title,"#min_scale#") && $layer["metadata"]["min_scale"]) $title = str_replace("#min_scale#",$layer["metadata"]["min_scale"],$title);
      if(strstr($title,"#max_scale#") && $layer["metadata"]["max_scale"]) $title = str_replace("#max_scale#",$layer["metadata"]["max_scale"],$title);
      $res = '<div title="'.$title.'">'; 
    }
    elseif($this->metadata["metadata_tooltip"]["scale"] && ($layer["metadata"]["min_scale"] || $layer["metadata"]["max_scale"])) {
      $title = $GLOBALS["RESOURCE_STRING"]["metadata_tooltip_scale"];
      if ($layer["metadata"]["min_scale"]) $title .= $GLOBALS["RESOURCE_STRING"]["metadata_tooltip_scale_from"].$layer["metadata"]["min_scale"];
      if ($layer["metadata"]["max_scale"]) $title .= $GLOBALS["RESOURCE_STRING"]["metadata_tooltip_scale_to"].$layer["metadata"]["max_scale"];
      $res = '<div title="'.$title.'">';
    }  
    else $res = '<div>';
    return $res;
  }
  function WriteJScript() {
   $folders = "";
//   print_r($this->folders);
   foreach($this->folders as $k=>$v) {
     if($k) $folders .= ($folders?",".$k:$k);
   }
  ?>
  <script>
    var FolderOpen = new Array();

    function Init() {
      var f = "<?php echo $folders ?>";
      var arr = f.split(",");
      for(i=0;i<arr.length;i++) {
        if(document.getElementById("fc"+arr[i]).style.display=="block") {
          FolderOpen["ft"+arr[i]] = 1;
					if(document.getElementById("img"+arr[i]))
            document.getElementById("img"+arr[i]).src = '<?php echo $this->images["tree_collapse"]?>';
        }
      }
    }
    function FolderCollapse(folderID) {
      if (FolderOpen["ft"+folderID]==1) {
        FolderOpen["ft"+folderID] = 0;
        document.getElementById("fc"+folderID).style.display = "none";
        document.getElementById("img"+folderID).src = '<?php echo $this->images["tree_expand"]?>';
      } else {
        FolderOpen["ft"+folderID] = 1;
        document.getElementById("fc"+folderID).style.display = "block";
        document.getElementById("img"+folderID).src = '<?php echo $this->images["tree_collapse"]?>';
      }
    }
    function CheckNodes(layer) {
      var l=parent.map_panel.GetLayer(layer);

      im=parent.map_panel.f_layer.document.getElementById(l.name);
  		if(im == null) im=parent.map_panel.f_layer.document.getElementById('lr_'+layer);
      if(im == null) im=parent.map_panel.f_layer.document.getElementById('lr_'+l.name);

    	if (im) {
    		if (l.visible) {
          var nodes=layer.split(".");
          var node = false;
          for(var i=0;i<nodes.length-1;i++) {
            if(node) node += "."+nodes[i];
            else node = nodes[i];
            var l=parent.map_panel.GetLayer(node);
            if(!l.visible) l.visible=true;

            im=parent.map_panel.f_layer.document.getElementById(l.name);
            if(im == null) im=parent.map_panel.f_layer.document.getElementById('lr_'+l.name);
            if(im == null) im=parent.map_panel.f_layer.document.getElementById('lr_'+node);

            if (im) {
          		if (l.visible) {
          			if (l.active) im.src=parent.map_panel.ImgOn('check_r');
          			else im.src=parent.map_panel.ImgOn('check_w');
              }
            }
          }
        }
      }
      if (parent.map_panel.map.layer_refresh) parent.map_panel.Refresh();                
    }
    function LayerCheckNodesRefresh(layer) {
      var rfrh = parent.map_panel.map.layer_refresh;
      parent.map_panel.map.layer_refresh=false;
      parent.map_panel.ChangeLayerVisible(layer,null);
      parent.map_panel.map.layer_refresh = rfrh;
      CheckNodes(layer);
    }
  </script>
  <?php   
  }
}

?>
