<?php
/* HEADER */ if (isSet($TWIST_FILE_INFO)) {echo __FILE__.': $Id: main_panel.inc,v 1.43 2008/03/07 10:45:20 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/browser.inc"));
require_once(FileUp2(".admin/functions.inc"));

class Panel {

  var $version;          //verze
  var $lang;             //jazyk
  var $type;             //typ klienta

  var $objects;          //objekty panelu
  var $map;              //mapovy projekt
  var $layers;           //seznam vrstev
  var $windows;          //popisy oken
  var $resource;         //texty v pozadovanem jazyce
  var $link;             //databazova propojeni

//  var $pan_layout;

  function Panel($params) {
    $this->version = $params["version"];
    $this->lang = $params["lang"]?$params["lang"]:"cz_win";
    $this->type = $params["type"]?$params["type"]:"all";

    $this->settings = $params["settings"];
    $this->objects = $params["objects"];
    $this->panel = $params["panel"];
    $this->map = $params["map"];
    $this->layers = $params["layers"];
    $this->windows = $params["windows"];
    $this->resource = $params["resource"];
    $this->link = false;

    for($i=0;$i<Count($this->objects);$i++) {
      $obj = &$this->objects[$i];
      if (($obj["name"] == "tool")||($obj["name"] == "function")||($obj["name"] == "select_box")) {
        reset($obj[$obj["name"]."_array"]);
        while (list($key,$val) = each($obj[$obj["name"]."_array"])) {
          $user_obj = $this->GetPanelParam($key);
          if (Is_Array($user_obj)) {
            reset($user_obj);
            while (list($key2,$val2) = each($user_obj)) {
              $obj[$obj["name"]."_array"][$key][$key2] = $val2;
            }
          }
        }
      }
      else{
        if ($obj["name"]) {
          $user_obj = $this->GetPanelParam($obj["name"]);
          if (Is_Array($user_obj)) {
            reset($user_obj);
            while (list($key,$val) = each($user_obj)) {
              $obj[$key] = $val;
            }
          }
        }
      }
    }
  }

  //Metoda WritePanel vytvo strnku pro javascriptov funkce, vlastnosti map. projektu a nstroje pro prci s mapou
  //-----------------------------------------------------------------------------------------------------------------

  function WritePanel() {

    $this->WriteHeader();
    $this->WriteScripts(); //vytvoen javascriptovch funkc a vlastnost
    $this->WriteObjects(); //vzhled strnky pro panel
    $this->WriteFooter();
  }

  function WriteScripts() {
    $this->WriteScriptFiles();   //nataen javascriptovch soubor
    $this->WriteMapScripts();    //vlastnosti mapovho projektu
    $this->WriteObjectScripts(); //vlastnosti objekt danho klienta
  }

  //-----------------------------------------------------------------------------------------------------------------

  function GetPanelParam($name) {
    return (isset($this->panel[$this->type][$name])?$this->panel[$this->type][$name]:$this->panel["DEFAULT"][$name]);
  }

  function WriteScriptFiles() {
    if (EReg("gz2ip",$GLOBALS["HTTP_ACCEPT_ENCODING"])) {
      $extension = "";
      $type = "";
      //$extension = ".gz";
      //$type = "type=\"gzip/javascript\"";
    }
    else {
      $extension = "";
      $type = 'language="JavaScript"';
    }
    echo "<SCRIPT $type SRC=\"".FileUpURL("javascript/MouseEvent.js".$extension)."?client_version=".$this->version."\"></SCRIPT>\n";
    echo "<SCRIPT $type SRC=\"".FileUpURL("javascript/BaseFunc.js".$extension)."?client_version=".$this->version."\"></SCRIPT>\n";

    if (($this->GetPanelParam("toc")) || ($this->GetPanelParam("tree_toc"))) {
      echo "<SCRIPT $type SRC=\"".FileUpURL("javascript/TOC.js".$extension)."?client_version=".$this->version."\"></SCRIPT>\n";
    }
    echo "<SCRIPT $type SRC=\"".FileUpURL("javascript/MapFunc.js".$extension)."?client_version=".$this->version."\"></SCRIPT>\n";
    if ($this->GetPanelParam("hotlink") || $this->GetPanelParam("info") || $this->GetPanelParam("hotlink_support")) {
      echo "<SCRIPT $type SRC=\"".FileUpURL("javascript/MapFuncExt.js".$extension)."?client_version=".$this->version."\"></SCRIPT>\n";
    }
    if ($this->GetPanelParam("edit")) {
      echo "<SCRIPT $type SRC=\"".FileUpURL("javascript/Edit.js".$extension)."?client_version=".$this->version."\"></SCRIPT>\n";
    }
    if ($this->GetPanelParam("simple_func")) {
      echo "<SCRIPT $type SRC=\"".FileUpURL("javascript/MapFuncSimple.js".$extension)."?client_version=".$this->version."\"></SCRIPT>\n";
    }
    if ($this->GetPanelParam("benchmark")) {
      echo "<SCRIPT $type SRC=\"".FileUpURL("javascript/Benchmark.js".$extension)."?client_version=".$this->version."\"></SCRIPT>\n";
    }
    if ($this->panel[$this->type]["js"]["files"]) {
      reset($this->panel[$this->type]["js"]["files"]);
      while (list($key, $val) = each($this->panel[$this->type]["js"]["files"])) {
        $url = FileUpURL("javascript/$val".$extension);
        if ($url) echo "<SCRIPT $type SRC=\"".$url."?client_version=".$this->version."\"></SCRIPT>\n";
      }
    }
    if ($this->GetPanelParam("select_view")) {
      echo "<SCRIPT SRC=\"".FileUpURL("javascript/tms_scripts.php")."?MAP=".$GLOBALS["params"]["map"]["name"]."&client_type=".$GLOBALS["client_type"]."&client_lang=".$this->lang."\"></SCRIPT>\n";
    }
    if ($this->GetPanelParam("measure")) {
      $wz_jsgraphics = true;
      echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/wz_jsgraphics.js").'?client_version='.$this->version.'"></SCRIPT>'."\n";
      echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/draw.php").'?prefix=measure&client_lang='.$this->lang.'&client_version='.$this->version.'&units='.$this->map['units'].'"></SCRIPT>'."\n";
    }
    if ($this->GetPanelParam("selection_shape")) {
      if (!$wz_jsgraphics) {
        $wz_jsgraphics = true;
        echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/wz_jsgraphics.js").'?client_version='.$this->version.'"></SCRIPT>'."\n";
      }
      echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/draw.php").'?prefix=selection_shape&client_lang='.$this->lang.'&client_version='.$this->version.'"></SCRIPT>'."\n";
      echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/selection_shape.php").'?prefix=selection_shape&client_lang='.$this->lang.'&client_version='.$this->version.'&units='.$this->map['units'].'"></SCRIPT>'."\n";
    }
    if ($this->GetPanelParam("selection_shape_maponly")) {
      if (!$wz_jsgraphics) {
        $wz_jsgraphics = true;
        echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/wz_jsgraphics.js").'?client_version='.$this->version.'"></SCRIPT>'."\n";
      }
      echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/draw.php").'?prefix=selection_shape_maponly&client_lang='.$this->lang.'&client_version='.$this->version.'"></SCRIPT>'."\n";
      echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/selection_shape.php").'?prefix=selection_shape_maponly&client_lang='.$this->lang.'&client_version='.$this->version.'&units='.$this->map['units'].'"></SCRIPT>'."\n";
    }
    if ($this->GetPanelParam("edit_vector")) {
      if (!$wz_jsgraphics) {
        $wz_jsgraphics = true;
        echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/wz_jsgraphics.js").'?client_version='.$this->version.'"></SCRIPT>'."\n";
      }
      echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/draw.php").'?prefix=edit_vector&client_lang='.$this->lang.'&client_version='.$this->version.'&color=blue&size=2&units='.$this->map['units'].'"></SCRIPT>'."\n";
      echo '<SCRIPT '.$type.' SRC="'.FileUpURL("javascript/draw/edit.php").'?prefix=edit_vector&client_lang='.$this->lang.'&client_version='.$this->version.'"></SCRIPT>'."\n";
    }
  }

  function WriteLayer($name,$layer) {
    $newLayer="$name=new Layer(";
    $newLayer .= "'".$layer['name']."',";
//    $newLayer .= "'".($layer['hidden']?"":$layer['title'])."',";
    $newLayer .= "'".$layer['title']."',";
    $newLayer .= $layer['visible']?"true":"false";
    $newLayer .= ",";
    $newLayer .= $layer['queryable']?"true":"false";
    $newLayer .= ",";
    $newLayer .= $layer['active']?"true":"false";
    $newLayer .= ",";
    $newLayer .= $layer['overview']?"true":"false";
    $newLayer .= ",";
    $newLayer .= ($layer['min_scale'])?$layer['min_scale']:"''";
    $newLayer .= ",";
    $newLayer .= ($layer['max_scale'])?$layer['max_scale']:"''";
    $newLayer .= ",";
    $newLayer .= ($layer['style'])?"'".$layer['style']."'":"''";
    $newLayer .= ",";
    $newLayer .= ($layer['condition'])?"'".$layer['condition']."'":"''";

    $newLayer .= ",";
    $newLayer .= $layer['hidden']?"true":"false";

    $newLayer .= ");";

    echo "$newLayer\n";
    Flush();
  }

  function WriteLayers($arr_layers, $prefix='') {
    reset($arr_layers);
    while (list($key, $val) = each($arr_layers)) {
      if ($prefix!='') $obj_layer = $prefix.".layers['$key']";
      else $obj_layer = "layer['$key']";

      $this->WriteLayer($obj_layer,$val);
      if ($val["layers"]) {
        echo $obj_layer.".layers=new Object();\n";
        $this->WriteLayers($val["layers"],$obj_layer);
//        while (list($key2, $val2) = each($val["layers"])) {
//          $obj_sublayer = $obj_layer.".layers['$key2']";
//          $this->WriteLayer($obj_sublayer,$val2);
//        }
      }
    }
  }

  function WriteMapScripts() {
    echo "<script>\n";

    echo "map=new Object();\n";
    echo "map.version='".$this->version."';\n";
    echo "map.name='".$this->map["name"]."';\n";
    echo "map.units=".(($this->map["units"]=="degree")?"1000":"1").";\n";
    echo "map.session=false;\n";
    echo "map.minx=".$this->map["full_extent"]["minx"].";\n";
    echo "map.miny=".$this->map["full_extent"]["miny"].";\n";
    echo "map.maxx=".$this->map["full_extent"]["maxx"].";\n";
    echo "map.maxy=".$this->map["full_extent"]["maxy"].";\n";
    echo "map.cur=new Object();\n";
    echo "map.cur.minx=".$this->map["first_extent"]["minx"].";\n";
    echo "map.cur.miny=".$this->map["first_extent"]["miny"].";\n";
    echo "map.cur.maxx=".$this->map["first_extent"]["maxx"].";\n";
    echo "map.cur.maxy=".$this->map["first_extent"]["maxy"].";\n";
    echo "map.minScale=".$this->map["scale"]["min"].";\n";
    echo "map.maxScale=".$this->map["scale"]["max"].";\n";
    echo "map.refreshMethod=".($this->map["refresh_method"]?"'".$this->map["refresh_method"]."'":"false").";\n";

    echo "function Layer(name, title, visible, queryable, active, ov, minScale, maxScale, style, condition, hidden) {\n";
    echo "  this.name=name;\n";
    echo "  this.title=title;\n";
    echo "  this.visible=visible;\n";
    echo "  this.queryable=queryable;\n";
    echo "  this.active=active;\n";
    echo "  this.ov=ov;\n";
    echo "  this.minScale=minScale;\n";
    echo "  this.maxScale=maxScale;\n";
    echo "  this.style=style;\n";
    echo "  this.condition=condition;\n";
    echo "  this.select='';\n";
    echo "  this.hidden=hidden;\n";
    echo "}\n";

    echo "layer=new Object();\n";

    $this->WriteLayers($this->layers);

    echo "</script>\n";
    Flush();
  }

  function WriteObjectScripts() {
    echo "<script>\n";

    echo "win_ready=new Object();\n";
    echo "map_db=null;\n";
    echo "f_map=parent.map;\n";
    echo "f_ov=parent.map_overview;\n";
    echo "f_info=parent.map_info;\n";
    if ($this->GetPanelParam("legend_extern")) echo "f_legend=parent.map_legend;\n";
    else echo "f_legend=parent.map_info;\n";

    if (($this->GetPanelParam("toc")) || ($this->GetPanelParam("tree_toc"))) {
      if ($this->GetPanelParam("f_layer")) echo "f_layer=parent.".$this->GetPanelParam("f_layer").";\n";
      else echo "f_layer=parent.map_layer;\n";
    }
    echo "f_panel=parent.map_panel;\n";
    echo "if (parent.table) f_db=parent.table;\n";
    echo "if (parent.map_location) f_loc=parent.map_location;\n";

    echo "resource=new Object();\n";
    echo "r=resource;\n";
    echo "r.scale_prompt='".$this->resource["panel_scale_prompt"]."';\n";
    echo "r.scale='".$this->resource["panel_scale"]."';\n";
    echo "r.changeLayer_warning='".$this->resource["changeLayer_warning"]."';\n";
    echo "r.hotlink_layer='".$this->resource["hotlink_layer"]."';\n";
    echo "r.edit_layer='".$this->resource["edit_layer"]."';\n";
    echo "doc=new Object();\n";
    echo "doc.link='<LINK href=\"".FileUpURL("default_style.css")."\" rel=\"stylesheet\" type=\"text/css\">';\n";
    switch ($this->lang) {
      case "cz_iso":
        $charset = "iso-8859-2";
      break;
      case "cz_win":
        $charset = "windows-1250";
      break;
      case "en":
      case "de":
        $charset = "iso-8859-1";
      break;
      default:
        $charset = "windows-1250";
      break;
    }
    echo "doc.meta='<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=$charset\">';\n";

    echo "map.rect=new Object();\n";
    echo "map.rect.size=".$this->map["rectangle"]["size"].";\n";
    echo "map.point=new Object();\n";
    echo "map.status=".($this->map["status_bar"]["info"]?"true":"false").";\n";  //vypisovat informace do status baru

    if(isset($this->map["layer"]["refresh"])) {
		  switch($this->map["layer"]["refresh"]) {
			  case "false": $lrfsh = "false";break;
				case "true":
				default: $lrfsh = "true";break;
			}
		} else $lrfsh = "true";
    //echo "map.layer_refresh=".(isset($this->map["layer"]["refresh"])?($this->map["layer"]["refresh"]?'true':'false'):"true").";\n";
    echo "map.layer_refresh=\"".$lrfsh."\";\n";

    echo "map.refresh_button=new Object();\n";
    echo "map.refresh_button.blink=".(isset($this->map["layer"]["refresh_button"]["blink"])?$this->map["layer"]["refresh_button"]["blink"]:"false").";\n";
    if ($this->map["layer"]["refresh_button"]["blink"]) {
      echo "map.refresh_button.img_static = '".FileUp2("images/".$this->map["layer"]["refresh_button"]["img_static"].".gif")."';\n";
      echo "map.refresh_button.img_blink = '".FileUp2("images/".$this->map["layer"]["refresh_button"]["img_blink"].".gif")."';\n";
    }

    if ($this->GetPanelParam("toc")) {
      echo "map.toc=".(isset($this->map["layer"]["visible"])?$this->map["layer"]["visible"]:"true").";\n";
    }
    else echo "map.toc=false;\n";
    echo "map.lang='".$this->lang."';\n";
    echo "map.cl_type='".$this->type."';\n";
    echo "map.test='cvicny test';\n";
    echo "map.onClick='".(isset($this->map["mapEvent"]["onClick"])?$this->map["mapEvent"]["onClick"]:"default")."';\n";
    echo "map.window=new Object();\n";

    switch ($this->map["content_type_charset"]) {
      case "AUTO":
        $this->map["content_type_charset"] = $GLOBALS["RESOURCE_STRING"]["content_type_charset"]?$GLOBALS["RESOURCE_STRING"]["content_type_charset"]:false;
      break;
    }
    if ($this->map["content_type_charset"]) {
      echo "map.charset='".$this->map["content_type_charset"]."';\n";
    } else echo "map.charset='".$charset."';\n";

    echo "w=map.window;\n";
    echo "w.width=".$this->windows[$this->type]["map"]["width"].";\n";
    echo "w.height=".$this->windows[$this->type]["map"]["height"].";\n";
    echo "w.left=0;\n";
    echo "w.top=0;\n";
    echo "w.bgColor='".($this->map["bg_color"]?$this->map["bg_color"]:"white")."';\n";
    echo "w.ratio=w.height/w.width;\n";
// ------->
    echo "w.mapscale=".($this->map["scale"]["no_scale_bar"]?"false":"true").";\n";
    echo "w.fit=".($this->windows[$this->type]["map"]["fit"]?"true":"false").";\n";
    echo "w.help=new Object();\n";
    echo "h=w.help;\n";
    echo "h.left=".($this->windows[$this->type]["help"]["left"]?$this->windows[$this->type]["help"]["left"]:300).";\n";
    echo "h.top=".($this->windows[$this->type]["help"]["top"]?$this->windows[$this->type]["help"]["top"]:20).";\n";
    echo "h.width=".($this->windows[$this->type]["help"]["width"]?$this->windows[$this->type]["help"]["width"]:500).";\n";
    echo "h.height=".($this->windows[$this->type]["help"]["height"]?$this->windows[$this->type]["help"]["height"]:500).";\n";
    echo "w.print=new Object();\n";
    echo "p=w.print;\n";
    echo "p.left=".($this->windows[$this->type]["map"]["left"]?$this->windows[$this->type]["map"]["left"]:50).";\n";
    echo "p.top=".($this->windows[$this->type]["map"]["top"]?$this->windows[$this->type]["map"]["top"]:50).";\n";
    echo "p.width=".($this->windows[$this->type]["map"]["width"]?$this->windows[$this->type]["map"]["width"]:500).";\n";
    echo "p.height=".($this->windows[$this->type]["map"]["height"]?$this->windows[$this->type]["map"]["height"]:500).";\n";
    Flush();
    if ($this->GetPanelParam("db_extern")) {
      echo "w.db=new Object();\n";
      echo "w.db.name='".($this->windows[$this->type]["db"]["name"]?$this->windows[$this->type]["db"]["name"]:"Search")."';\n";
      echo "w.db.left=".($this->windows[$this->type]["db"]["left"]?$this->windows[$this->type]["db"]["left"]:300).";\n";
      echo "w.db.top=".($this->windows[$this->type]["db"]["top"]?$this->windows[$this->type]["db"]["top"]:20).";\n";
      echo "w.db.width=".($this->windows[$this->type]["db"]["width"]?$this->windows[$this->type]["db"]["width"]:500).";\n";
      echo "w.db.height=".($this->windows[$this->type]["db"]["height"]?$this->windows[$this->type]["db"]["height"]:500).";\n";
    }
    if ($this->GetPanelParam("info_extern")) {
      echo "w.info=new Object();\n";
      echo "i=w.info;\n";
      echo "i.left=".($this->windows[$this->type]["info"]["left"]?$this->windows[$this->type]["info"]["left"]:100).";\n";
      echo "i.top=".($this->windows[$this->type]["info"]["top"]?$this->windows[$this->type]["info"]["top"]:20).";\n";
      echo "i.width=".($this->windows[$this->type]["info"]["width"]?$this->windows[$this->type]["info"]["width"]:400).";\n";
      echo "i.height=".($this->windows[$this->type]["info"]["height"]?$this->windows[$this->type]["info"]["height"]:400).";\n";
    }
    if ($this->GetPanelParam("legend_extern")) {
      echo "w.legend=new Object();\n";
      echo "l=w.legend;\n";
      echo "l.left=".($this->windows[$this->type]["legend"]["left"]?$this->windows[$this->type]["legend"]["left"]:100).";\n";
      echo "l.top=".($this->windows[$this->type]["legend"]["top"]?$this->windows[$this->type]["legend"]["top"]:20).";\n";
      echo "l.width=".($this->windows[$this->type]["legend"]["width"]?$this->windows[$this->type]["legend"]["width"]:400).";\n";
      echo "l.height=".($this->windows[$this->type]["legend"]["height"]?$this->windows[$this->type]["legend"]["height"]:400).";\n";
    }
    echo "map.ov=new Object();\n";
    if ($this->GetPanelParam("overview")) {
      echo "map.ov.left=0;\n";
      echo "map.ov.top=0;\n";
      echo "map.ov.width=".$this->windows[$this->type]["overview"]["width"].";\n";
      echo "map.ov.height=".$this->windows[$this->type]["overview"]["height"].";\n";
      echo "map.ov.refresh=true;\n";
      echo "map.ov.rect=new Object();\n";
      echo "map.ov.rect.active=false;\n";
      echo "map.ov.rect.size=".$this->map["rectangle"]["size"].";\n";
      echo "map.ov.min_size=".$this->map["overview"]["min_size"].";\n";
      echo "map.ov.id='default';\n";
      echo "map.ov.schema_init=".($this->map["overview"]["schema_init"]?'true':'false').";\n";
      $ext = ($this->map["ov_extent"]?$this->map["ov_extent"]:$this->map["full_extent"]);
      $file = FileUp2(".admin/manager/extent/Default.inc");
      if ($file) include_once($file);
      $extman = new Default_ExtentManager($interface);
      $ext = $extman->SetExtentRatioByExtent($ext, array('minx'=>0, 'miny'=>0, 'maxx'=>$this->windows[$this->type]["overview"]["width"], 'maxy'=>$this->windows[$this->type]["overview"]["height"]));
      echo "map.ov.minx=".$ext["minx"].";\n";
      echo "map.ov.miny=".$ext["miny"].";\n";
      echo "map.ov.maxx=".$ext["maxx"].";\n";
      echo "map.ov.maxy=".$ext["maxy"].";\n";
    }
    else {
      echo "map.ov.refresh=false;\n";
    }
    if ($this->GetPanelParam("change_project")) {
      echo "w.change_project=new Object();\n";
      echo "ch=w.change_project;\n";
      echo "ch.left=".($this->windows[$this->type]["change_project"]["left"]?$this->windows[$this->type]["change_project"]["left"]:0).";\n";
      echo "ch.top=".($this->windows[$this->type]["change_project"]["top"]?$this->windows[$this->type]["change_project"]["top"]:0).";\n";
      echo "ch.width=".($this->windows[$this->type]["change_project"]["width"]?$this->windows[$this->type]["change_project"]["width"]:400).";\n";
      echo "ch.height=".($this->windows[$this->type]["change_project"]["height"]?$this->windows[$this->type]["change_project"]["height"]:300).";\n";
    }

    echo "w.measure=".($this->GetPanelParam("measure")?"true":"false").";\n";
    echo "w.selection_shape=".($this->GetPanelParam("selection_shape")?"true":"false").";\n";
    echo "w.selection_shape_maponly=".($this->GetPanelParam("selection_shape_maponly")?"true":"false").";\n";
    echo "w.edit_vector=".($this->GetPanelParam("edit_vector")?"true":"false").";\n";

    echo "img=new Object();\n";
    echo "function SetImg(n,src1,src2) {\n";
    echo "  img[n+'_on']=new Image();\n";
    echo "  img[n+'_on'].src=src1;\n";
    echo "  img[n+'_off']=new Image();\n";
    echo "  img[n+'_off'].src=src2;\n";
    echo "}\n";

    Flush();
    echo "SetImg('check_w','".FileUpURL("images/checked.gif")."','".FileUpURL("images/unchecked.gif")."');\n";
    echo "SetImg('check_r','".FileUpURL("images/checked_active.gif")."','".FileUpURL("images/unchecked_active.gif")."');\n";

    echo "panel=new Object();\n";


    $first=true;
    $tool_img=true;
    $zoombar=false;

    echo "panel.cursor=new Object();\n";
    echo "panel.cursor['default']='".($this->map["cursor"]["default"]?$this->map["cursor"]["default"]:'default')."';\n";
    for($i=0;$i<Count($this->objects);$i++) {
      $tool = $this->objects[$i];
      if ($tool["tool"]) {
        echo "SetImg('".$tool["name"]."','".FileUpURL("images/".$tool["image"].".gif")."','".FileUpURL("images/".$tool["image_off"].".gif")."');\n";
      }
      if (($tool["type"])=="tool") {
        if ($tool["image"]) {
          echo "SetImg('".$tool["name"]."','".FileUpURL("images/".$tool["image"].".gif")."','".FileUpURL("images/".$tool["image_off"].".gif")."');\n";
  		  }
				elseif($tool_img) {
				  $tool_img=false;
          reset($tool["tool_array"]);
          while(list($key,$val) = each($tool["tool_array"])) {
            $tool_p = $val;
						if($tool_p["active"] && $first) {
              $first=false;
              echo "panel.state='".$tool_p["name"]."';\n";
						}
            if ($tool_p["cursor"]) echo "panel.cursor['".$tool_p["name"]."']='".$tool_p["cursor"]."';\n";
					  echo "SetImg('".$tool_p["name"]."','".FileUpURL("images/".$tool_p["image"].".gif")."','".FileUpURL("images/".$tool_p["image_off"].".gif")."');\n";
					}
				}
      }
      if ($tool["active"] && $first) {
        $first=false;
        echo "panel.state='".$tool["name"]."';\n";
      }
      if (($tool["type"]=="zoom_bar") && $this->GetPanelParam("zoom_bar")) {
      	if ($tool["zoom_array"]) $zoom_bar = $tool;
        elseif ($this->GetPanelParam("zoom_bar")) $zoom_bar = $this->GetPanelParam("zoom_bar");
        if ($tool["zoom_array"] || $this->GetPanelParam("zoom_bar")) {
      	  echo "zoom=new Array();\n";
      	  echo "zoom.index='1';\n";
      	  for($i=1;$i<=Count($zoom_bar["zoom_array"]);$i++) {
            echo "zoom[$i]=".$zoom_bar["zoom_array"][$i-1]["scale"].";\n";
            echo "SetImg('"."zoom_$i"."','".FileUpURL("images/".$zoom_bar["zoom_array"][$i-1]["img"])."','".FileUpURL("images/".$zoom_bar["zoom_array"][$i-1]["img2"])."');\n";
      	  }
	        $zoombar = true;
        }
        else echo "zoom=false;\n";
      }
    }
    if (!$zoombar) echo "zoom=false;\n";


    if ($this->GetPanelParam("xycreator")) {
      $xycreator = $this->GetPanelParam("xycreator");
      echo "xycreator=new Object();\n";
      echo "xycreator.prefix='".$xycreator["prefix"]."';\n";
      echo "xycreator.suffix='".$xycreator["suffix"]."';\n";
      echo "xycreator.separator='".$xycreator["separator"]."';\n";
      echo "xycreator.message='".$xycreator["message"]."';\n";
    }
    if ($this->GetPanelParam("xy2agend")) {
      $xy2agend = $this->GetPanelParam("xy2agend");
      echo "xy2agend=new Object();\n";
      echo "xy2agend.windb_name='".($GLOBALS["windb_name"]?$GLOBALS["windb_name"]:"")."';\n";
      echo "xy2agend.agend='".($GLOBALS["SERVER_CONFIG"]["AGENDA_PATH"][$xy2agend["AGENDA_IDENT"]]?$GLOBALS["SERVER_CONFIG"]["AGENDA_PATH"][$xy2agend["AGENDA_IDENT"]]:"")."';\n";
      echo "xy2agend.top='".($xy2agend["TOP"]?$xy2agend["TOP"]:"")."';\n";
      echo "xy2agend.left='".($xy2agend["LEFT"]?$xy2agend["LEFT"]:"")."';\n";
      echo "xy2agend.height='".($xy2agend["HEIGHT"]?$xy2agend["HEIGHT"]:"")."';\n";
      echo "xy2agend.width='".($xy2agend["WIDTH"]?$xy2agend["WIDTH"]:"")."';\n";
      echo "xy2agend.map_close='".($xy2agend["MAP_CLOSE"]?$xy2agend["MAP_CLOSE"]:"")."';\n";
    }
    if ($this->GetPanelParam("search_field")) {
      $search_field = $this->GetPanelParam("search_field");
      echo "search=new Object();\n";
      reset($search_field);
      while (list($key,$ar) = each($search_field)) {
        echo "search['$key']=new Object();\n";
        echo "search['$key'].link='".$ar["link"]."';\n";
        echo "search['$key'].field='".$ar["field"]."';\n";
      }
    }

    if ($this->GetPanelParam("hotlink") || $this->GetPanelParam("hotlink_support")) {
      if (!$this->link) {
        include_once(FileUp2(".admin/hotlink_schema.inc"));

        include_once(FileUp2(".admin/access_map_.inc"));
        $MAP_LINK = MapAccessArray($MAP_LINK);
        $MAP_LINK_EX = MapAccessArray($MAP_LINK_EX);

        $this->link = $MAP_LINK;
        $this->link_ex = $MAP_LINK_EX;
      }
      else reset($this->link);

      echo "var sel_el=new Object();\n";
      echo "sel_el.active = false;\n";
      echo "link=new Object();\n";
      echo "link.layers=new Object();\n";
      echo "link.groups=new Object();\n";
      switch ($this->link_ex["search_type"]) {
        case "first_from_all":
          echo "link.type = 'ffa';\n";
          $hotlink = $this->link_ex["output"];
          echo "link.all=new Object();\n";
          echo "l=link.all;\n";
          echo "l.output='".($hotlink["target"]?StrToLower($hotlink["target"]):"")."';\n";
          echo "l.name='".($hotlink["name"]?$hotlink["name"]:"Hotlink")."';\n";
          echo "l.features='".($hotlink["features"]?$hotlink["features"]:"")."';\n";
        break;
        case "all_from_group":
          echo "link.type = 'afg';\n";
          echo "link.group = '".$this->link_ex["group"]."';\n";
          $hotlink = $this->link_ex["output"];
          echo "link.groups['".$this->link_ex["group"]."']=new Object();\n";
          echo "l=link.groups['".$this->link_ex["group"]."'];\n";
          echo "l.output='".($hotlink["target"]?StrToLower($hotlink["target"]):"")."';\n";
          echo "l.name='".($hotlink["name"]?$hotlink["name"]:"Hotlink")."';\n";
          echo "l.features='".($hotlink["features"]?$hotlink["features"]:"")."';\n";
        break;
        default: //"first_from_one"
          echo "link.type = 'ffo';\n";
        break;
      }
      reset($this->link);
      while (list($key,$val) = each($this->link)) {
        if ($val && $val["output"]) {
          $hotlink = $val["output"];
          echo "link.layers['$key']=new Object();\n";
          echo "l=link.layers['$key'];\n";
          echo "l.output='".($hotlink["target"]?StrToLower($hotlink["target"]):"")."';\n";
          echo "l.name='".($hotlink["name"]?$hotlink["name"]:"Hotlink")."';\n";
          echo "l.features='".($hotlink["features"]?$hotlink["features"]:"")."';\n";
          if ($hotlink["parameters"]) echo "l.parameters='".$hotlink["parameters"]."';\n";
          if ($val["query_layers"]) echo "l.query_layers='".$val["query_layers"]."';\n";
          if($val["session_parameters"]) echo "l.session_parameters='".$val["session_parameters"]."';\n";
        }
      }

      echo "link.select_type=".($this->link_ex["select_type"]?$this->link_ex["select_type"]:"1").";\n";
      //echo "link.select_num=".($this->link_ex["select_num"]?$this->link_ex["select_num"]:"0").";\n";
      if($this->GetPanelParam("hotlink1") || $this->GetPanelParam("hotlink2") || $this->GetPanelParam("hotlink3") || $this->GetPanelParam("hotlink4") || $this->GetPanelParam("hotlink5")) {
        echo "link.hotlink_layers=new Object();\n";
        echo "l_hl=link.hotlink_layers;\n";
        for($i=0;$i<5;$i++) {
          $h_set = $this->GetPanelParam("hotlink".($i+1));
          if($h_set["hotlink_layer"]) echo "l_hl.hotlink".($i+1)."='".$h_set["hotlink_layer"]."';\n";
        }
      }
    } else {
      echo "var sel_el=new Object();\n";
      echo "sel_el.active = false;\n";
    }

    if ($this->GetPanelParam("edit_vector")) {
      $inc = FileUp2(".admin/edit_schema.inc");
      if (!File_Exists($inc)) {
        echo "alert('Neexistuje edit_schema.inc.');\n";
        die();
      }
      include($inc);
      include_once(FileUp2(".admin/access_map_.inc"));
      $MAP_EDIT = MapAccessArray($MAP_EDIT);

      echo "edit_vector=new Object();\n";
      echo "edit_vector.layers=new Object();\n";
      Reset($MAP_EDIT);
      while (list($key,$val) = each($MAP_EDIT)) {
      if ($val["output"]) {
        $edit = $val["output"];
        echo "edit_vector.layers['$key']=new Object();\n";
        echo "l=edit_vector.layers['$key'];\n";
        echo "l.output='".($edit["target"]?StrToLower($edit["target"]):"")."';\n";
        echo "l.name='".($edit["name"]?$edit["name"]:"Edit")."';\n";
        echo "l.features='".($edit["features"]?$edit["features"]:"")."';\n";
        $edit = $val["edit"];
//        if ($edit["parameters"]) echo "l.parameters='".$edit["parameters"]."';\n";
        if ($edit["type"]) echo "l.edittype='".$edit["type"]."';\n";
        if ($edit["tools"]) echo "l.edittools='".$edit["tools"]."';\n";
        if ($val["brush"]["color"]) echo "l.brush_color='".$val["brush"]["color"]."';\n";
        if ($val["brush"]["size"]) echo "l.brush_size=".$val["brush"]["size"].";\n";
      }
    }
    }

    if ($this->GetPanelParam("edit")) {
      if (!$this->link) {
        include_once(FileUp2(".admin/hotlink_schema.inc"));
        $MAP_LINK = MapAccessArray($MAP_LINK);
        $MAP_LINK_EX = MapAccessArray($MAP_LINK_EX);
        $this->link = $MAP_LINK;
        $this->link_ex = $MAP_LINK_EX;
      }
      else reset($this->link);

      echo "edit=new Object();\n";
      echo "edit.state = 0;\n";

      reset($this->link);
      while (list($key,$l) = each($this->link)) {
        if ($l && $l["edit"]) {
          echo "edit['$key']=new Object();\n";
          echo "e=edit['$key'];\n";
          echo "e.link='".$l["edit"]["link"]."';\n";
          echo "e.request='".$l["edit"]["request"]."';\n";
          echo "e.left='".$l["edit"]["left"]."';\n";
          echo "e.top='".$l["edit"]["top"]."';\n";
          echo "e.width='".$l["edit"]["width"]."';\n";
          echo "e.height='".$l["edit"]["height"]."';\n";
        }
      }
    }

    echo "env=new Object();\n";
    echo "env.leftButton=1;\n";
    echo "env.middleButton=4;\n";

    echo "var visible_layers=new Object();\n";
    echo "visible_layers.name=new Array();\n";
    echo "visible_layers.count=0;\n";

    echo "subproject=".($GLOBALS["subproject"]?"'".$GLOBALS["subproject"]."'":"false").";";

    $this->WriteLinkTree();
    echo "meta=new Object();\n";
    if($GLOBALS["FROM_SERVER"]) echo "meta.from_server='".$GLOBALS["FROM_SERVER"]."';\n";
    if($GLOBALS["FROM_PROJECT"]) echo "meta.from_project='".$GLOBALS["FROM_PROJECT"]."';\n";

    echo "</script>\n";
    Flush();
  }

  //----------------------------------------------------------------
  //Metody pro vytvareni layoutu
  //----------------------------------------------------------------

  function WriteObjects() {
    echo "</HEAD>\n";

    if (isset($GLOBALS["map_refresh"]) && $GLOBALS["map_refresh"] == 0) $param_refresh = 'false';
    else $param_refresh = 'true';
    if ($GLOBALS["layer_refresh"] == 1) $param_initLayer = 'true';
    else $param_initLayer = 'false';

    echo "<BODY class=\"map\" onLoad=\"Init(".$param_refresh.",".$param_initLayer.");\">";

    if ($this->GetPanelParam("panel")) {
      echo "<form name=\"panel_f\">\n";
      if(is_numeric($this->settings["rel_top"]) || is_numeric($this->settings["rel_left"])) echo "<div style='position:absolute;left:0;top:0;width:100%;height:100%;'>\n";
      if (isN()) {
        echo "<table frame=\"border\" cellspacing=\"0\" cellpadding=\"0\" border=\"1\" width='100%'><tr><td>\n";
      } else {
        if(is_numeric($this->settings["rel_top"]) || is_numeric($this->settings["rel_left"])) {
          echo "<div style='position:relative'>";
          echo "<table width='100%' height='100%'><tr><td class=\"border\">&nbsp;</td></tr></table>";
          echo "</div>\n";
        } else echo "<table width='100%'><tr><td class=\"border\">\n";
      }
      //relativni pozicovani?
      if(!$this->settings["rel_top"] && !$this->settings["rel_left"]) {
        echo "<table width='100%' cellspacing=\"0\" cellpadding=\"0\" border=\"0\">";
        echo "<tr>\n";
      }
    }
    else if(!$this->GetPanelParam("file")) echo "<form name=\"panel_f\">\n";

    if ($this->GetPanelParam("file")) {
     include_once (FileUp2($this->GetPanelParam("file")));
    }

    if(is_numeric($this->settings["rel_top"]) || is_numeric($this->settings["rel_left"])) {
      $p_top = 0;
      $p_left = 0;
    }

    for($i=0;$i<Count($this->objects);$i++) {
      if($this->settings["rel_top"] || $this->settings["rel_left"]) {
        if(is_numeric($this->objects[$i]["top"])) $p_top = $this->objects[$i]["top"];
        if(is_numeric($this->objects[$i]["left"])) $p_left = $this->objects[$i]["left"];
        switch($this->settings["direction"]) {
          case "vertical":
            $p_top += (is_numeric($this->objects[$i]["rel_top"])?$this->objects[$i]["rel_top"]:$this->settings["rel_top"]);
            $p_left = (is_numeric($this->objects[$i]["rel_left"])?$this->objects[$i]["rel_left"]:$this->settings["rel_left"]);
          break;
          case "horizontal":
          default:
            $p_top = (is_numeric($this->objects[$i]["rel_top"])?$this->objects[$i]["rel_top"]:$this->settings["rel_top"]);
            $p_left += (is_numeric($this->objects[$i]["rel_left"])?$this->objects[$i]["rel_left"]:$this->settings["rel_left"]);
        }
      }
      $this->ShowObject($this->objects[$i],$p_top,$p_left);
      Flush();
    }

    if ($this->GetPanelParam("panel")) {
      if(!is_numeric($this->settings["rel_top"]) && !is_numeric($this->settings["rel_left"])) {
        echo "</tr>";
        echo "</table>\n";
      }
      if(is_numeric($this->settings["rel_top"]) || is_numeric($this->settings["rel_left"])) echo "</div>\n";
      else echo "</table>\n";

      echo "</form>\n";
    }
    else if(!$this->GetPanelParam("file")) echo "</form>\n";
    //if ($this->map["refresh_method"]=="POST")
      echo "<form name=\"frm_refresh\" method=\"POST\" style=\"position:absolute;\"></form>\n";
  }

  function ShowObject($params,$top,$left) {
    if ($params["layout"] == "panel") {
      if (!$params["name"] || ($params["name"]&&$this->GetPanelParam($params["name"]))) {
	      static $first=true;
	      if ($params["active"]&&$params["tool"]&&$first) {
	        $img="image_off";
	        $first=false;
       }
	      else $img="image";
      	if ($params["image"]) $width = (($params["width"])?$params["width"]:20);
      	else $width = (($params["width"])?$params["width"]:'');
      	$align = ($params["align"])?"align=\"".$params["align"]."\"":'';

        if ($params["name"]=="mapscale") {
          if (!$this->map["noscalebar"]) {
            if(is_numeric($this->settings["rel_top"]) || is_numeric($this->settings["rel_left"])) echo "<div style='position:absolute;left:$left;top:$top;width:".$width."px;'>";
        	  else echo "<td width=$width".($align?" $align":"").">";
          }
        } else {
          if(is_numeric($this->settings["rel_top"]) || is_numeric($this->settings["rel_left"])) echo "<div style='position:absolute;left:$left;top:$top;width:".$width."px;'>";
      	  else echo "<td width=$width".($align?" $align":"").">";
        }
      	if ($params["image"]) {
          if ($params["name"]=="mapscale") {
            if (!$this->map["noscalebar"]) {
              if($params["function"]) {
            	  echo "<a href=\"javascript:".$params["function"]."\"";
                if ($this->map["status_bar"]["alt"] && $params["alt"]) " onmouseover=\"window.status='".$params["alt"]."';return true;\" onmouseout=\"window.status='';return true;\">";
                else echo ">";
              }
          	  if ($params["name"]) echo InsertImage("../images/".$params[$img].".gif",$params["alt"],"border='0' name='".$params["name"]."'");
          	  else echo InsertImage("../images/".$params[$img].".gif",$params["alt"]);
              if($params["function"]) echo "</a>";
            }
          } else {
            if($params["function"]) {
          	  echo "<a href=\"javascript:".$params["function"]."\"";
              if ($this->map["status_bar"]["alt"] && $params["alt"]) echo " onmouseover=\"window.status='".$params["alt"]."';return true;\" onmouseout=\"window.status='';return true;\">";
              else echo ">";
            }
        	  if ($params["name"]) echo InsertImage("../images/".$params[$img].".gif",$params["alt"],"border='0' name='".$params["name"]."'");
        	  else echo InsertImage("../images/".$params[$img].".gif",$params["alt"]);
        	  if($params["function"]) echo "</a>";
          }
      	}
        elseif ($params["hotlink"]) {
          if (!$this->link) {
            include_once(FileUp2(".admin/hotlink_schema.inc"));
            include_once(FileUp2(".admin/access_map_.inc"));
            $MAP_LINK = MapAccessArray($MAP_LINK);
            $MAP_LINK_EX = MapAccessArray($MAP_LINK_EX);
            $this->link = $MAP_LINK;
            $this->link_ex = $MAP_LINK_EX;
          }
          if ($this->link_ex["search_type"] != "all_from_group") {
            echo "<font class=\"hotlink\"><select name=\"hotlink\" ".($this->GetPanelParam("select_hide")?" id=\"hotlink\" style=\"position:absolute;visibility:hidden\"":"").">\n<option value=''> \n";
            if (Is_Array($this->link)) {
              Reset($this->link);
              while (list($key,$value) = each($this->link)) {
                if ($value && !$value["hidden"]) echo "<option value='".$key."'".($value["selected"]?" selected":"").">".($value["caption"]?$value["caption"]:$key);
              }
            }
            echo "</select></font>\n";
          }
        }
        elseif ($params["selection"] || $params["neighbours"]) {
          $type = $params["selection"] ? 'selection' : 'neighbours';
          $name = $params["selection"] ? $type.'_select' : $type;
          require_once(FileUp2(".admin/map_functions.inc"));

          if(getMetasystemConfig()) $layers = GetActiveLayersPL();
          else {
            $layers = array();
            $layers = GetProjectLayers($GLOBALS['MAP_LAYER'],$type);
            $int_layer_names = GetInterfaceLayers();
            foreach($layers as $k=>$params) {
              if(!in_array($params['name'],$int_layer_names)) unset($layers[$k]);
            }
          }
          
          echo "<font class=\"hotlink\"><select name=\"$name\" ".($this->GetPanelParam("select_hide")?" id=\"$name\" style=\"position:absolute;visibility:hidden\"":"").">\n"; //<option value=''> \n
          if (Is_Array($layers)) {
            Reset($layers);
            while (list($key,$value) = each($layers)) {
              echo "<option value='{$value['name']}'>".$value['title'];
            }
          }
          echo "</select></font>\n";
        }
        elseif ($params["edit_vector"]) {
          include(FileUp2(".admin/edit_schema.inc"));
          include_once(FileUp2(".admin/access_map_.inc"));
          $MAP_EDIT = MapAccessArray($MAP_EDIT);
          echo "<font class=\"hotlink\"><select name=\"edit_vector\" id=\"edit_vector\" style=\"position:absolute;visibility:hidden\" onchange=\"edit_vectorComboChanged(this)\">\n<option value=''> \n";
          if (Is_Array($MAP_EDIT)) {
            Reset($MAP_EDIT);
            while (list($key,$value) = each($MAP_EDIT)) {
              echo "<option value='$key'".($value["selected"]?" selected":"").">".($value["caption"]?$value["caption"]:$key);
            }
          }
          echo "</select></font>\n";
        }
        elseif ($params["select_box"]) {
//          die(print_r($params));
          echo "<select id=\"".($params["type"]?$params["type"]:"")."\" name=\"".($params["type"]?$params["type"]:"")."\"";
            if($params["onchange"]) echo " onchange=\"".$params["onchange"]."\"";
            if($params["onblur"]) echo " onblur=\"".$params["onblur"]."\"";
            if($params["onclick"]) echo " onclick=\"".$params["onclick"]."\"";
          echo ">\n";
          if($params["insertnull"]) echo "<option value=''>\n";
          reset($params["select_schema"]);
          while (list($key,$value) = each($params["select_schema"])) {
            echo "<option ".($value["class"]?"class='".$value["class"]."'":"")." value='".$value["value"]."'".($value["selected"]?" selected":"").">".($value["caption"]?$value["caption"]:"")."\n";
          }
          echo "</select>\n";
        }
	      else {
          echo $params["text"];
        }
        if ($params["name"]=="mapscale") {
          if (!$this->map["noscalebar"]) {
            if(is_numeric($this->settings["rel_top"]) || is_numeric($this->settings["rel_left"])) echo "</div>\n";
        	  else echo "</td>\n";
          }
        } else {
          if(is_numeric($this->settings["rel_top"]) || is_numeric($this->settings["rel_left"])) echo "</div>\n";
      	  else echo "</td>\n";
        }
      }
    }
    else {
      switch ($params["type"]) {
        case "tool":
          if($this->GetPanelParam("tool") || $params["tool_array"]) {
            reset($params["tool_array"]);
            while(list($key,$val) = each($params["tool_array"])) {
              $tool_p = $val;
              if($this->GetPanelParam($val["name"])) {
         	      if (isset($tool_p["left"])||isset($tool_p["top"])) {
            	    $left = (isset($tool_p["left"])?$tool_p["left"]:0);
            	    $top = (isset($tool_p["top"])?$tool_p["top"]:0);
            	    echo "<div".($tool_p["name"]?" name=\"DIV_".$tool_p["name"]."\"":"")." style=\"position:absolute;left:".$left.";top:".$top."\">";
          	    }
      	        static $first=true;
          	    if ($tool_p["active"]&&$tool_p["tool"]&&$first) {
            	    $img="image_off";
            	    $first=false;
          	    }
      	        else $img = "image";
      	        if ($tool_p["image"] && !$tool_p["hidden"]) {
            	    echo "<a href=\"javascript:".$tool_p["function"]."\">";
            	    if ($tool_p["name"]) echo InsertImage("../images/".$tool_p[$img].".gif",$tool_p["alt"],"border='0' id='".$tool_p["name"]."' name='".$tool_p["name"]."'");
            	    else echo InsertImage("../images/".$tool_p[$img].".gif",$tool_p["alt"]);
             	    echo "</a>";
          	    }
          	    if ($tool_p["title"]) echo "&nbsp;".$tool_p["title"];
          	    if (isset($tool_p["left"])||isset($tool_p["top"])) echo "</div>\n";
              }
            }
          }
        break;
        case "function":
          if($this->GetPanelParam("function") || $params["function_array"]) {
            reset($params["function_array"]);
            while(list($key,$val) = each($params["function_array"])) {
              if ($this->GetPanelParam($val["name"])) {
                $image_p = $val;
                $left = (isset($image_p["left"])?$image_p["left"]:0);
                $top = (isset($image_p["top"])?$image_p["top"]:0);
                echo "<div".($image_p["name"]?" name=\"DIV_".$image_p["name"]."\"":"")." style=\"position:absolute;left:".$left.";top:".$top."\">";
                $imag = "images/" . $image_p["img"];
                if ($image_p["function"]) echo "<a href=\"javascript:".$image_p["function"]."\">";
                echo "<img src=\"".FileUpURL($imag)."\"".($image_p["alt"]?" alt=\"".$image_p["alt"]."\"":"").($image_p["name"]?" id=\"".$image_p["name"]."\" name=\"".$image_p["name"]."\"":"")." border='0'>";
                if ($image_p["function"]) echo "</a>";
                if ($image_p["title"]) echo "&nbsp;".$image_p["title"];
                echo "</div>\n";
              }
            }
         }
        break;
        case "zoom_bar":
    	    if (($params["layout"] != "hidden") && $this->GetPanelParam($params["name"])) {
	          if (isset($params["left"]) || isset($params["top"])) {
  	          $left = (isset($params["left"])?$params["left"]:0);
        	    $top = (isset($params["top"])?$params["top"]:0);
  	          for($i=1;$i<=Count($params["zoom_array"]);$i++) {
    	          if(($params["direction"])<>"horizontal") {
  		            if(isset($params["zoom_array"][$i-1]["rel_top"])) $top += $params["zoom_array"][$i-1]["rel_top"];
  		            else $top += $param["rel_top"];
  		            echo "<div".($params["zoom_array"][$i-1]["name"]?" name=\"".$params["zoom_array"][$i-1]["name"]."\"":"")." style=\"position:absolute;left:".$left.";top:".$top."\">";
                }
  		          else {
  		            if(isset($params["zoom_array"][$i-1]["rel_left"])) $left = $left + $params["zoom_array"][$i-1]["rel_left"];
  		            else $left = $left + $param["rel_left"];
  		            echo "<div".($params["zoom_array"][$i-1]["name"]?" name=\"".$params["zoom_array"][$i-1]["name"]."\"":"")." style=\"position:absolute;left:".$left.";top:".$top."\">";
  		          }
      	        if ($params["zoom_array"][$i-1]["img"]) {
                  $imag = "images/" . $params["zoom_array"][$i-1]["img"];
        		      if ($params["zoom_array"][$i-1]["function"]) echo "<a href=\"javascript:".$params["zoom_array"][$i-1]["function"]."\">";
        		      echo "<img src=\"".FileUpURL($imag)."\"".($params["zoom_array"][$i-1]["alt"]?" alt=\"".$params["zoom_array"][$i-1]["alt"]."\"":"").($params["zoom_array"][$i-1]["name"]?" name=\"".$params["zoom_array"][$i-1]["name"]."\"":"")." border='0'>";
                  if ($params["zoom_array"][$i-1]["function"]) echo "</a>";
  		          }
      		      if ($params["zoom_array"][$i-1]["title"]) echo "&nbsp;".$params["zoom_array"][$i-1]["title"];
      		      if (isset($params["left"])||isset($params["top"])) echo "</div>\n";
  	          }
    	      }
         }
        break;
        case "layer_bar":
         if ((isset($params["left"])||isset($params["top"]))&& $this->GetPanelParam($params["name"])) {
           $left = (isset($params["left"])?$params["left"]:0);
    	     $top = (isset($params["top"])?$params["top"]:0);
           $lay_b = $params["layer_bar"];
           for($i=1;$i<=Count($lay_b);$i++) {
             if(isset($lay_b[$i-1]["rel_top"])) $top = $top + $lay_b[$i-1]["rel_top"];
             else $top = $top + $params["rel_top"];
             echo "<div".($params["name"]?" name=\"".$params["name"]."\"":"")." style=\"position:absolute;left:$left;top:$top\">";
              if ($lay_b[$i-1]["img"]) {
              $imag = "images/" . $lay_b[$i-1]["img"];
    		        if ($lay_b[$i-1]["function"]) echo "<a href=\"javascript:".$lay_b[$i-1]["function"]."\">";
    		        echo "<img src=\"".FileUpURL($imag)."\"".($lay_b[$i-1]["alt"]?" alt=\"".$lay_b[$i-1]["alt"]."\"":"").($lay_b[$i-1]["name"]?" name=\"".$lay_b[$i-1]["name"]."\"":"")." border='0'>";
    		        if ($lay_b[$i-1]["function"]) echo "</a>";
             }
  	          if ($lay_b[$i-1]["title"]) echo "&nbsp;".$lay_b[$i-1]["title"];
  	          if (isset($params["left"])||isset($params["top"])) echo "</div>\n";
           }
  	      }
        break;
        case "select_box":
          foreach($params["select_box_array"] as $key=>$val) {
            if($this->GetPanelParam($val["type"])) {
              if (isset($val["left"])||isset($val["top"])) {
        	      $left = (isset($val["left"])?$val["left"]:0);
        	      $top = (isset($val["top"])?$val["top"]:0);
        	      echo "<div".($val["type"]?" name=\"DIV_".$val["type"]."\"":"")." style=\"position:absolute;left:$left;top:$top\">\n";
              }

              echo "<select id=\"".($val["type"]?$val["type"]:"")."\" name=\"".($val["type"]?$val["type"]:"")."\"";
              if($val["onchange"]) echo " onchange=\"".$val["onchange"]."\"";
              if($val["onblur"]) echo " onblur=\"".$val["onblur"]."\"";
              if($val["onclick"]) echo " onclick=\"".$val["onclick"]."\"";
              echo ">\n";

              if($val["insertnull"]) echo "<option value=''>\n";
              reset($val["select_schema"]);
              while (list($key,$value) = each($val["select_schema"])) {
                echo "<option ".($value["class"]?"class='".$value["class"]."'":"")." value='".$value["value"]."'".($value["selected"]?" selected":"").">".($value["caption"]?$value["caption"]:"")."\n";
              }
              echo "</select>\n";
      	      if (isset($val["left"])||isset($val["top"])) echo "</div>\n";
            }
          }
        break;
        default:
          if (isset($params["left"])||isset($params["top"])) {
    	      $left = (isset($params["left"])?$params["left"]:0);
    	      $top = (isset($params["top"])?$params["top"]:0);
    	      echo "<div".($params["name"]?" name=\"".$params["name"]."\"":"")." style=\"position:absolute;left:$left;top:$top\">";
          }
  	      if ($params["image"]) {
    	      if ($params["function"]) echo "<a href=\"javascript:".$params["function"]."\">";
    	      echo "<img src=\"".FileUpURL($params["image"])."\"".($params["alt"]?" alt=\"".$params["alt"]."\"":"").($params["name"]?" name=\"".$params["name"]."\"":"")." border='0'>";
    	      if ($params["function"]) echo "</a>";
  	      }
  	      elseif ($params["html"]) echo $params["html"];
          if ($params["title"]) echo "&nbsp;".$params["title"];
  	      if (isset($params["left"])||isset($params["top"])) echo "</div>\n";
      }
    }
  }

  function WriteJSLink() {
    $LinkTree= "var tree = new Array();\n";
    $LinkTree.= "tree.link = new Array();\n";
    foreach($GLOBALS["link"] as $key=>$val) {
      if(is_Array($val["layer_on"]) || is_Array($val["layer_off"])) {
        $LinkTree.="tree.link[\"".$val["link"]."\"] = new Array();\n";
        if($val["layer_on"]) {
          $LinkTree.="tree.link[\"".$val["link"]."\"][\"layer_on\"] = new Array();\n";
          for($i=0;$i<count($val["layer_on"]);$i++) {
            if($val["layer_on"][$i]) $LinkTree.="tree.link[\"".$val["link"]."\"][\"layer_on\"][$i] = \"".$val["layer_on"][$i]."\";\n";
          }
        }
        if($val["layer_off"]) {
          $LinkTree.="tree.link[\"".$val["link"]."\"][\"layer_off\"] = new Array();\n";
          for($i=0;$i<count($val["layer_off"]);$i++) {
            if($val["layer_off"][$i]) $LinkTree.="tree.link[\"".$val["link"]."\"][\"layer_off\"][$i] = \"".$val["layer_off"][$i]."\";\n";
          }
        }
        if($val["layer_reverse"]) {
          $LinkTree.="tree.link[\"".$val["link"]."\"][\"layer_reverse\"] = true;\n";
        }
      }
    }
    echo "$LinkTree\n";
  }

  function WriteLinkLayers($arr_layers, $prefix='', $duplicita=false) {
    reset($arr_layers);
    while (list($key, $val) = each($arr_layers)) {
      if ($prefix!='') $obj_layer = $prefix.".$key";
      else $obj_layer = "$key";
      if($GLOBALS["link"][$val["name"]] && $val["name"]) {
        return false;
      }
      if($duplicita) {
        $d = explode(".",$obj_layer);
        $GLOBALS["link"][$d[0].".".$val["name"]]["link"] = $obj_layer;
      }
      else $GLOBALS["link"][$val["name"]]["link"] = $obj_layer;
      if ($val["layers"]) {
        $this->WriteLinkLayers($val["layers"],$obj_layer,$duplicita);
      }
    }
    return true;
  }
  function ArrayLink($layer,$duplicita=false) {
    $GLOBALS["link"] = array();
    $ok = $this->WriteLinkLayers($layer,'',$duplicita);
    if(!$ok) {
      $GLOBALS["link"] = array();
      $this->ArrayLink($layer,true);
    }
    foreach($GLOBALS["link"] as $key=>$val) {
      $l="";
      if (strstr($key, ".")) list($l,$z) = explode(".",$key);
      else $l = $key;

      $l_on = $layer;
      $arr_coll = explode(".",$GLOBALS["link"][$key]["link"]);
      for($j=0;$j<Count($arr_coll)-1;$j++) {
       $l_on = $l_on[$arr_coll[$j]]["layers"];
      }
      $l_on=$l_on[$l];

      if($l_on["link"]["layer_on"]) {
         $j=0;
         foreach($l_on["link"]["layer_on"] as $l_on_k=>$l_on_v) {
           $cesta_on = $GLOBALS["link"][$l_on_v]["link"];
           $GLOBALS["link"][$key]["layer_on"][$j] = $cesta_on;
           $j++;
         }
      }
      if($l_on["link"]["layer_off"]) {
         $j=0;
         foreach($l_on["link"]["layer_off"] as $l_on_k=>$l_on_v) {
           $cesta_off = $GLOBALS["link"][$l_on_v]["link"];
           $GLOBALS["link"][$key]["layer_off"][$j] = $cesta_off;
           $j++;
         }
      }
      if($l_on["link"]["layer_reverse"]) {
        $GLOBALS["link"][$key]["layer_reverse"] = true;
      }
    }
  }
  function WriteLinkTree() {
    $this->ArrayLink($this->layers);
    $this->WriteJSLink();
  }

  function WriteHeader() {
    global $client_lang;
    require_once(FileUp2("html_header.inc"));
  }

  function WriteFooter() {
    require_once(FileUp2("html_footer.inc"));
  }

}

?>
