<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_mint_tms12.inc,v 1.22 2008/04/16 08:37:00 lumo Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_mint.inc"));
require_once(FileUp2(".config/settings/agenda_path.inc"));

class Map_TMS12_Interface extends Map_Interface {

  var $connector; //konektor mapoveho projektu
  //var $layers; //asociativni pole viditelnych vrstev

  function Map_TMS12_Interface($input,$interface="") {
    $this->Map_Interface($input,$interface);
  }

  function ParseInterface($input,$interface) {
    if ($interface->extent['num']) {
      if($input['WIDTH'] && $input['HEIGHT']) {
        $interface->RunMintProcessParameters($input['WIDTH'],$input['HEIGHT']);
        if($interface->parameters['DrawPin'])
          $input['SELECT'] = $interface->properties['connection'].'.'.$interface->properties['map_layer'].'('.$interface->select.')';
        $input['BBOX'] = $interface->extent['minx'].','.$interface->extent['miny'].','.$interface->extent['maxx'].','.$interface->extent['maxy'];
      }
      else die('ParseInterface: Bad parameters (TMS 1.2)');
    }
  }

  function ParseParameters($input) {
    if ($input['BBOX'] && $input['MAP'] && $input['WIDTH'] && $input['HEIGHT']) {
      if (Is_Array($input['BBOX'])) {
        $this->parameters["bbox"] = $input['BBOX'];
      } else { 
			  $bbox = Explode(",", $input['BBOX']);
        $this->parameters["bbox"]["minx"] = $bbox[0];
        $this->parameters["bbox"]["miny"] = $bbox[1];
        $this->parameters["bbox"]["maxx"] = $bbox[2];
        $this->parameters["bbox"]["maxy"] = $bbox[3];
      }
      $this->parameters["width"] = $input['WIDTH'];
      $this->parameters["height"] = $input['HEIGHT'];
#      $this->parameters["layers"] = Explode("),", substr($input['LAYERS'],0,-1)); 
    //$this->parameters["layers"] = Explode(",", $input['LAYERS']);
      $this->parameters["ulayers"] = $input['ULAYERS']?Explode(",", $input['ULAYERS']):array();
      $this->parameters["ulayers_on"] = $input['ULAYERS_ON']?Explode(",", $input['ULAYERS_ON']):array();
      $this->parameters["ulayers_off"] = $input['ULAYERS_OFF']?Explode(",", $input['ULAYERS_OFF']):array();
      $this->parameters["client_lang"] = $input['client_lang'];

      $this->parameters["format"] = $input['FORMAT'];
      $this->parameters["bgcolor"] = $input['BGCOLOR'];
      $this->parameters["select"] = Explode("),", substr($input['SELECT'],0,-1));
      $this->parameters["scale"] = $input['SCALE'];

      $this->parameters["map"] = $input['MAP'];
      switch ($input['MODE']) {
        case "ov":
          $this->parameters["mode"] = 1;
        break;
        case "lg":
          $this->parameters["mode"] = 2;
        break;
        default:
          $this->parameters["mode"] = 0;
        break;
      }

      $this->parameters['ulayers_visible'] = array();

      
    }
    else die('Bad parameters of TMS interface (version 1.2)');
  }

  function TreeGenerator() {

    if (!$this->parameters['client_lang']) $this->parameters['client_lang'] = 'cz_win';
    $file = FileUp2(".admin/lg/".$this->parameters['client_lang'].".inc");
    if (!file_exists($file)) ErrorMsg(array("msg"=>"main_mint_tms12: lang file ".$this->parameters['client_lang'].".inc does not exist"));
    require(FileUp2(".admin/lg/".$this->parameters['client_lang'].".inc"));
    @include(FileUp2(".admin/lg/app_".$this->parameters['client_lang'].".inc"));

    $file = FileUp2(".admin/connector/project/".$this->parameters["map"].".inc");
    if (!file_exists($file)) {
      $file = FileUp2(".admin/connector/project/wizard/".$this->parameters["map"].".inc");
      //if (!file_exists($file)) ErrorMsg(array("msg"=>"connector ".$this->map.".inc not exist"));
    }
    if (file_exists($file)) include($file);
    $this->connector = $CONNECTOR;

    if ($this->connector["dir"]) $dir = $this->connector["dir"];
    else $dir = preg_replace('/\/tms\//', '', Dirname($GLOBALS['PHP_SELF']));
    $file = $GLOBALS["TMAPY_TMS"]."/".$dir."/.admin/layer_schema.inc";
    if (!file_exists($file)) ErrorMsg(array("msg"=>"layer_schema.inc not exist"));
    include($file);

    include_once(FileUp2(".admin/access_map_.inc"));
    $MAP_LAYER = MapAccessArray($MAP_LAYER);
    
    $file = $GLOBALS["TMAPY_TMS"]."/".$this->connector["dir"]."/.admin/style_schema.inc";
    if (!file_exists($file)) ErrorMsg(array("msg"=>"style_schema.inc not exist"));
    include($file);
/*    if ($MAP_STYLE["__properties"]["ext_manager"]) {
      $file = $GLOBALS["TMAPY_TMS"]."/".$this->connector["dir"]."/.admin/extent_schema.inc";
      if (!file_exists($file)) ErrorMsg(array("msg"=>"extent_schema.inc not exist"));
      if ($GLOBALS["MAP_EXTENTS"])
        $MAP_EXTENTS = $GLOBALS["MAP_EXTENTS"];
      else
        require($file);
      $MAP_STYLE["__properties"]["ext_manager"] = $MAP_EXTENTS;
    }
*/
    $this->style = $MAP_STYLE;
    //print_r($MAP_STYLE);

    //$this->layers = array();
    //for($i=0;$i<Count($this->parameters["layers"]);$i++) {
    //  $this->layers[$this->parameters["layers"][$i]] = true;
    //}
    
    //TOKR removed
    /*if ($MAP_LAYER[$this->parameters["map"]]) {
      $this->tree[$this->parameters["map"]]["layers"] = $this->CreateTree($MAP_LAYER);
    } else {
      $lr = Current($MAP_LAYER);
      $this->tree[$this->parameters["map"]]["layers"] = $this->CreateTree($lr['layers']);
    }*/
    $this->tree[$this->parameters["map"]]["layers"] = $this->CreateTree($MAP_LAYER);
    
    for($i=0;$i<Count($this->parameters["select"]);$i++) {
      list($key,$val) = Explode("(",$this->parameters["select"][$i]);
      $arr_coll = Explode(".",$key);
      $arr_point = Explode(",",$val);

      $layer = &$this->tree;
      for($j=0;$j<Count($arr_coll)-1;$j++) {
        $layer = &$layer[$arr_coll[$j]]["layers"];
      }
      $layer = &$layer[$arr_coll[$j]];
      $layer["select"]=$arr_point;
    }
//    die(print_r($this->tree));

    //$this->tree = $this->CreateTree($MAP_LAYER);
  }

  function CreateTree($layers) {
    $tree = array();

    include_once(Fileup2(".admin/main_manager_extent.inc"));
    //BAD PARAMETR $this - BUT WE DONT NEED THE RIGHT ONE :-)
    $extent_manager = new ExtentManager($this);
    
    $pixel = $extent_manager->GetPixelSize($this->parameters["bbox"], $this->parameters["width"], $this->parameters["height"]);
    $scale = $extent_manager->GetScale($this->parameters["bbox"], $this->parameters["width"], $this->parameters["height"]);
    $has_ulayers = Count($this->parameters["ulayers"]);
    reset($layers);
    while (list($key,$val) = each($layers)) {
        if ((
            ((!is_numeric($val["minpixel"]) || $val["minpixel"] <= $pixel) &&
            (!is_numeric($val["maxpixel"]) || $val["maxpixel"] >= $pixel)) || 
            ((!is_numeric($val["min_scale"]) || $val["min_scale"] <= $scale) &&
            (!is_numeric($val["max_scale"]) || $val["max_scale"] >= $scale))) &&
            ($val["load"] || ($val["visible"] && !$has_ulayers) || In_array($val["name"],$this->parameters["ulayers_on"]) || In_Array($val["name"],$this->parameters["ulayers"]))
           ) {
          if (!$has_ulayers) {
            $val["visible"] = !$val["visible"]?In_array($val["name"],$this->parameters["ulayers_on"]):$val["visible"];
            $val["visible"] = $val["visible"]?!In_array($val["name"],$this->parameters["ulayers_off"]):$val["visible"];
            if (!$val["visible"] && !$val["load"]) {
              continue;
            }
          } else {
            $val["visible"] = In_Array($val["name"],$this->parameters["ulayers"]);
          }
          if ($val["visible"]) $this->parameters['ulayers_visible'][] = $key;
          $tree[$val["name"]] = array();
          if ($val["style"]) $tree[$val["name"]]["style"] = $this->style[$val["style"]];
          if ($val["layers"]) {$tree[$val["name"]]["layers"] = $this->CreateTree($val["layers"]); }
          unset($val["layers"]);
          unset($val["style"]);
//          $tree[$val["name"]]["params"] = $val;
          $tree[$val["name"]]["params"] = $val;
          $tree[$val["name"]]["index"] = $this->NewIndex();
        }
    }
    return $tree;
  }

  function SetStyles() {
    $this->tree[$this->parameters["map"]]["collection"] = true;
/*
    $layers = &$this->tree[$this->parameters["map"]]["layers"];
    $key_arr = array_keys($layers);
    for($i=0;$i<Count($key_arr);$i++) $this->GetReferences(&$layers[$key_arr[$i]]);
*/
  }

  
}
?>
