<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_mint_tms.inc,v 1.27 2008/04/16 08:37:00 lumo Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_mint.inc"));
require_once(FileUp2(".config/settings/agenda_path.inc"));

class Map_TMapServer_Interface extends Map_Interface {

  function Map_TMapServer_Interface($input,$interface="") {
    $this->Map_Interface($input,$interface);
  }

  function ParseInterface($input,$interface) {
    if ($interface->extent['num']) {
      if($input['WIDTH'] && $input['HEIGHT']) {
        $interface->RunMintProcessParameters($input['WIDTH'], $input['HEIGHT']);
        $input['BBOX'] = $interface->extent['minx'].','.$interface->extent['miny'].','.$interface->extent['maxx'].','.$interface->extent['maxy'];
      }
      else die('ParseInterface: Bad parameters (TMS)');
    }
  }

  function ParseParameters($input) {
//  die(print_r($input));
    if ($input['BBOX'] && $input['WIDTH'] && $input['HEIGHT'] && isset($input['LAYERS']) && isset($input['STYLES'])
        && $input['FORMAT']) {
      $bbox = Explode(",", $input['BBOX']);
      $this->parameters["bbox"]["minx"] = $bbox[0];
      $this->parameters["bbox"]["miny"] = $bbox[1];
      $this->parameters["bbox"]["maxx"] = $bbox[2];
      $this->parameters["bbox"]["maxy"] = $bbox[3];
      $this->parameters["width"] = $input['WIDTH'];
      $this->parameters["height"] = $input['HEIGHT'];
      $this->parameters["layers"] = Explode("),", substr($input['LAYERS'],0,-1));
      $this->parameters["styles"] = Explode("),", substr($input['STYLES'],0,-1));
      $this->parameters["format"] = $input['FORMAT'];
      $this->parameters["srs"] = $input['SRS'];
      $this->parameters["bgcolor"] = $input['BGCOLOR'];
      $this->parameters["version"] = $input['VERSION'];
      $this->parameters["interface"] = "TMS";
      $this->parameters["charset"] = $input['charset'];
      $this->parameters["mapwinfit"] = $input['MAPWINFIT'];
      $this->parameters["session"] = $input['SESSION'];
      $this->parameters["client_lang"] = $input['client_lang'];

      $this->parameters["map"] = $input['MAP'];
      $this->parameters["select"] = Explode("),", substr($input['SELECT'],0,-1));
      $this->parameters["condition"] = Explode("),", substr($input['CONDITION'],0,-1));

      $this->parameters["scale_value"] = $input['SCALE'];
      $this->parameters["scale"] = $input['MAPSCALE'];
      $this->parameters["measure"] = $input['MEASURE'];
      $this->parameters["selection_shape"] = $input['SELECTION_SHAPE'];
      $this->parameters["selection_shape_maponly"] = $input['SELECTION_SHAPE_MAPONLY'];
      $this->parameters["edit_vector"] = $input['EDIT_VECTOR'];
      $this->parameters["cacheId"] = $input['cacheID'];
      $this->parameters["print"] = $input['PRINT']?array():false;
      if ($input['PRINT']) {
        $this->parameters["print"]["height"] = $input['PRINT_HEIGHT']?$input['PRINT_HEIGHT']:$input['HEIGHT'];
        $this->parameters["print"]["width"] = $input['PRINT_WIDTH']?$input['PRINT_WIDTH']:$input['WIDTH'];
        $coef = ($bbox[2] - $bbox[0])/$input['WIDTH'];
        $dx = ($this->parameters["print"]["width"]-$input['WIDTH'])/2*$coef;
        $dy = ($this->parameters["print"]["height"]-$input['HEIGHT'])/2*$coef;
        $this->parameters["print"]["minx"] = $bbox[0]-$dx;
        $this->parameters["print"]["miny"] = $bbox[1]-$dy;
        $this->parameters["print"]["maxx"] = $bbox[2]+$dx;
        $this->parameters["print"]["maxy"] = $bbox[3]+$dy;
        $this->parameters["print"]["dpi"] = $input['PRINT_DPI']?$input['PRINT_DPI']:96;
        $this->parameters["print"]["noprint"] = $input['NOPRINT']?$input['NOPRINT']:false;
      }
      $this->parameters["include"] = $input['MAPPART'];
      $this->parameters["live_refresh"] = $input['live_refresh'];
      $this->parameters['ulayers_visible'] = array();

      switch ($input['MODE']) {
        case "ov":
          $this->parameters["mode"] = 1;
        break;
        case "lg":
          $this->parameters["mode"] = 2;
        break;
        default:
          $this->parameters["mode"] = 0;
        break;
      }
    }
    else die('Bad parameters of TMS interface');
  }

  function TreeGenerator() {
    for($i=0;$i<Count($this->parameters["layers"]);$i++) {
      list($key,$val) = Explode("(",$this->parameters["layers"][$i]);
      //echo $key." ".$val."<br>\n";
      $arr_coll = Explode(".",$key);
      $arr_layer = Explode(",",$val);
      $arr_style = Explode(",",substr($this->parameters["styles"][$i],1));

      $layer = &$this->tree;
      for($j=0;$j<Count($arr_coll)-1;$j++) {
        $layer = &$layer[$arr_coll[$j]]["layers"];
      }
      if (!Is_Array($layer[$arr_coll[$j]])) $layer[$arr_coll[$j]] = array();
      $layer = &$layer[$arr_coll[$j]];

      $layer["index"] = $this->NewIndex();
      for($j=0;$j<Count($arr_layer);$j++) {
        if ($arr_style[$j]) {
          $layer["layers"][$arr_layer[$j]]["style"] = $arr_style[$j];
        }
        else $layer["layers"][$arr_layer[$j]] = array('name'=>(string)$arr_layer[$j], 'visible'=>true);
      }
    }
    for($i=0;$i<Count($this->parameters["select"]);$i++) {
      list($key,$val) = Explode("(",$this->parameters["select"][$i]);
      $arr_coll = Explode(".",$key);
      $arr_point = Explode(",",$val);

      $layer = &$this->tree;
      for($j=0;$j<Count($arr_coll)-1;$j++) {
        $layer = &$layer[$arr_coll[$j]]["layers"];
      }
      $layer = &$layer[$arr_coll[$j]];
      $layer["select"]=$arr_point;
    }
    if ($this->parameters["session"] && Is_Array($GLOBALS["TMapServer_Session"]["Map"]["Select"])) {
      reset($GLOBALS["TMapServer_Session"]["Map"]["Select"]);
      while(list($key,$val) = each($GLOBALS["TMapServer_Session"]["Map"]["Select"])) {
        $key = $this->parameters["map"].".".$key;
        $arr_coll = Explode(".",$key);
        $arr_point = Explode(",",$val);

        $layer = &$this->tree;
        for($j=0;$j<Count($arr_coll)-1;$j++) {
          $layer = &$layer[$arr_coll[$j]]["layers"];
        }
        $layer = &$layer[$arr_coll[$j]];
        $layer["select"]=$arr_point;
      }
    }
    for($i=0;$i<Count($this->parameters["condition"]);$i++) {
      list($key,$val) = Explode("(",$this->parameters["condition"][$i]);
      $arr_coll = Explode(".",$key);

      $layer = &$this->tree;
      for($j=0;$j<Count($arr_coll)-1;$j++) {
        $layer = &$layer[$arr_coll[$j]]["layers"];
      }
      $layer = &$layer[$arr_coll[$j]];
      $layer["condition"]=$val;
    }

    $this->tree[$this->project['name']]['layers'] = $this->SetLayerParams($this->tree[$this->project['name']]['layers']);
//    print_r($this->tree);
  }

  function SetStyles() {
    $style_file = FileUp2(".admin/style_schema.inc");
    if (!file_exists($style_file)) ErrorMsg(array("msg"=>"style_schema.inc not exist"));
    require($style_file);
/*
    if ($MAP_STYLE["__properties"]["ext_manager"]) {
      $extent_file = FileUp2(".admin/extent_schema.inc");
      if (!file_exists($extent_file)) ErrorMsg(array("msg"=>"style_schema.inc not exist"));
      //require_once($extent_file);
      include($extent_file);
      $MAP_STYLE["__properties"]["ext_manager"] = $MAP_EXTENTS;
    }
*/
    $this->style = $MAP_STYLE;
    //print_r($MAP_STYLE);

    $this->tree[$this->parameters["map"]]["collection"] = true;
    $layers = &$this->tree[$this->parameters["map"]]["layers"];
    $key_arr = array_keys($layers);
    for($i=0;$i<Count($key_arr);$i++) $this->GetReferences(&$layers[$key_arr[$i]]);
  }

  function SetLayerParams($tree, $treesch=array(), $cnt=0, $visible=true) {
    static $MAP_LAYER, $extent_manager, $pixel, $scale;
    if (!$MAP_LAYER) {

      if (!$this->parameters['client_lang']) $this->parameters['client_lang'] = 'cz_win';
      $file = FileUp2(".admin/lg/".$this->parameters['client_lang'].".inc");
      if (!file_exists($file)) ErrorMsg(array("msg"=>"main_mint_tms: lang file ".$this->parameters['client_lang'].".inc does not exist"));
      require(FileUp2(".admin/lg/".$this->parameters['client_lang'].".inc"));
      @include(FileUp2(".admin/lg/app_".$this->parameters['client_lang'].".inc"));

      $file = FileUp2(".admin/connector/project/".$this->parameters["map"].".inc");
      if (!file_exists($file)) {
        $file = FileUp2(".admin/connector/project/wizard/".$this->parameters["map"].".inc");
        //if (!file_exists($file)) ErrorMsg(array("msg"=>"connector ".$this->map.".inc not exist"));
      }
      if (file_exists($file)) include($file);
      $this->connector = $CONNECTOR;

      if ($this->connector["dir"]) $dir = $this->connector["dir"];
      else $dir = preg_replace('/\/tms\//', '', Dirname($GLOBALS['PHP_SELF']));
      $file = $GLOBALS["TMAPY_TMS"]."/".$dir."/.admin/layer_schema.inc";
      if (!file_exists($file)) ErrorMsg(array("msg"=>"layer_schema.inc not exist"));
      include($file);

      include_once(FileUp2(".admin/access_map_.inc"));
      $treesch = MapAccessArray($MAP_LAYER);
      reset($tree);

      include_once(Fileup2(".admin/main_manager_extent.inc"));
      //BAD PARAMETER $this - BUT WE DONT NEED THE RIGHT ONE :-)
      $extent_manager = new ExtentManager($this);

      $pixel = $extent_manager->GetPixelSize($this->parameters["bbox"], $this->parameters["width"], $this->parameters["height"]);
      $scale = $extent_manager->GetScale($this->parameters["bbox"], $this->parameters["width"], $this->parameters["height"]);

    }
    foreach ($treesch as $keysch=>$layersch) {
      $layer = $tree[$keysch];
      if (isset($tree[$keysch])) {
        foreach ($layersch as $key=>$val) {
          switch ($key) {
            case 'layers':
            case 'index':
            break;
            default:
              $layer[$key] = $val;
            break;
          }
        }
        if (((is_numeric($layer["minpixel"]) && $layer["minpixel"] > $pixel) ||
             (is_numeric($layer["maxpixel"]) && $layer["maxpixel"] < $pixel)) ||
            ((is_numeric($layer["min_scale"]) && $layer["min_scale"] > $scale) ||
             (is_numeric($layer["max_scale"]) && $layer["max_scale"] < $scale))) {
          $layer['visible'] = false;
        } else {
          if (is_array($this->parameters['print']) &&
              ((is_numeric($layer['max_print_scale']) && $layer['max_print_scale'] < $this->parameters['scale_value']) ||
               (is_numeric($layer['min_print_scale']) && $layer['min_print_scale'] > $this->parameters['scale_value'])) ) {
              $layer['_hidden_for_print_'] = true;
              $layer['visible'] = false;
          } else {
            $layer['visible'] = $visible;
          }
        }
        if ($layer["visible"]) $this->parameters['ulayers_visible'][] = $keysch;

        if ($layersch['layers'] && $layer['layers']) {
          $layer['layers'] = $this->SetLayerParams($layer['layers'], $layersch['layers'], $cnt++, $layer['visible']);
        }

        $tree[$keysch] = $layer;

      }
    }
    return $tree;
  }

  function GetReferences($tree) {
    //Style
//        die('tokr');
    if ($tree["style"]) {
      $style = $this->style[$tree["style"]];

      //Nastaveni dynamickych stylu pomoci Session
      if ($style["session"]) {
//        die('tokr');
        if (!$this->session) {
          $this->session = true;
          session_start();
        }
        $session_style = $GLOBALS["TMapServer"][$this->parameters["map"]][$tree["style"]]["style"];
        if (Is_Array($session_style)) {
          reset($session_style);
          while(list($key,$val) = each($session_style)) {
            $style[$key] = $val;
          }
        }

        //Select
        $session_sel = $GLOBALS["TMapServer"][$this->parameters["map"]][$tree["style"]]["select"];
        if ($session_sel) {
          $tree["select"] = $session_sel;
        }

        //SelectInMap
        $session_select = $GLOBALS["TMapServer"][$this->parameters["map"]][$tree["style"]]["selectInMap"];
        if (Is_Array($session_select)) {
          reset($session_select);
          while(list($key,$val) = each($session_select)) {
            $tree["selectInMap"][$key] = $val;
          }
        }
      }

      if ($style) {
        if ($style["reference"]) {
          if ($style["catalog"]) $this->global_references[] = $style["reference"];
          elseif (Is_Array($style["reference"])) {
            //$this->local_references[] = $arr_style["reference"];
          }
        }
        $style["name"] = $tree["style"];
        $tree["style"] = &$style;
      }
      else $tree["style"] = array();

      if ($tree["layers"]) {
        $layers = &$tree["layers"];
        $key_arr = array_keys($layers);
        for($i=0;$i<Count($key_arr);$i++) $this->GetReferences(&$layers[$key_arr[$i]]);
      }
    }
  }

}
?>
