<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_mint_seznam.inc,v 1.3 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(".admin/main_mint.inc");

class Map_Seznam_Interface extends Map_Interface {

  function Map_Seznam_Interface($input,$interface="") {
    $this->Map_Interface($input,$interface);
  }

  function ParseParameters($input) {
    if ($input['IDA']) {
      if (!$input['R']) $input['R'] = "600x400";
      $w_h = Explode("x", $input['R']);
      $this->parameters["width"] = $w_h[0];
      $this->parameters["height"] = $w_h[1];

      if (!isset($input['Z'])) $input['Z'] = 1000;

      $this->SetMap($input['IDA'],$input['Z']);
      $this->parameters["layers"] = Explode("),", substr($this->parameters["layers"],0,-1));
      $this->parameters["styles"] = Explode("),", substr($this->parameters["styles"],0,-1));

//      $this->parameters["format"] = "PNG";
      $this->parameters["format"] = "GIF";
      $this->parameters["version"] = "1.0.0";
      $this->parameters["interface"] = "TMS";
      $this->parameters["no_output"] = ($input['NO_OUTPUT']?1:0);

      $this->parameters["map"] = "TMS_MAPA_CR";

      $this->parameters["type"] = 'map';
    }
    else die('Bad parameters of Seznam interface');
  }

  function SetMap($name, $zoom) {
    $my_const_h = 1;
    switch (StrToUpper($name)) {
      case "BM0": //Brno
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3602999,"miny"=>5443999,"maxx"=>3629000,"maxy"=>5463000);
        $min_width = 700; 
      break;
      case "CB0": //. Budjovice			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3455999,"miny"=>5422999,"maxx"=>3471000,"maxy"=>5433000);
        $min_width = 700; 
      break;
      case "CZREP": //. Republika	
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr_relief,cr2000,cr1000,cr500,cr200,praha,mesta,okresy,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,,,,,)";
        $extent = array("minx"=>3283112, "miny"=>5315774, "maxx"=>3792469, "maxy"=>5738735);
        $min_width = 7000; 
        $my_const_h = 0.5;
      break;
      case "HK0": //Hradec Krlov			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3551999,"miny"=>5558999,"maxx"=>3566000,"maxy"=>5570000);
        $min_width = 700; 
      break;
      case "JI0": //Jihlava			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3538999,"miny"=>5471999,"maxx"=>3547000,"maxy"=>5481000);
        $min_width = 700; 
      break;
      case "KV0": //Karlovy Vary			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3341999,"miny"=>5563999,"maxx"=>3355000,"maxy"=>5573000);
        $min_width = 700; 
      break;
      case "LI0": //Liberec			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3497999,"miny"=>5620999,"maxx"=>3510000,"maxy"=>5631000);
        $min_width = 700; 
      break;
      case "OC0": //Olomouc			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3658999,"miny"=>5494999,"maxx"=>3671000,"maxy"=>5503000);
        $min_width = 700; 
      break;
      case "OV0": //Ostrava			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3722999,"miny"=>5516999,"maxx"=>3745000,"maxy"=>5537000);
        $min_width = 700; 
      break;
      case "PM0": //Plze			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3375999,"miny"=>5506999,"maxx"=>3393000,"maxy"=>5519000);
        $min_width = 700; 
      break;
      case "PRAHA": //Praha			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,praha,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3450999,"miny"=>5543999,"maxx"=>3468000,"maxy"=>5556000);
        $min_width = 700; 
      break;
      case "PU0": //Pardubice			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3547999,"miny"=>5541999,"maxx"=>3560000,"maxy"=>5551000);
        $min_width = 700; 
      break;
      case "SR": //Slovensko			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr_relief,cr2000,cr1000,cr500,cr200,praha,mesta,okresy,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,,,,,)";
        $extent = array("minx"=>3283112, "miny"=>5315774, "maxx"=>3792469, "maxy"=>5738735);
        $min_width = 7000; 
        $my_const_h = 0.5;
      break;
      case "UL0": //st n. L.			
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3423999,"miny"=>5608999,"maxx"=>3439000,"maxy"=>5620000);
        $min_width = 700; 
      break;
      case "ZL0": //Zln
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(cr200,mesta,copyright)";
        $this->parameters["styles"] = "(mapa_cr),(,,)";
        $extent = array("minx"=>3686999,"miny"=>5453999,"maxx"=>3699000,"maxy"=>5463000);
        $min_width = 700; 
      break;
      default:
        $this->parameters["layers"] = "TMS_MAPA_CR(mapa_cr),TMS_MAPA_CR.mapa_cr(copyright)";
        $this->parameters["styles"] = "(mapa_cr),()";
        $extent = array("minx"=>3686999,"miny"=>5453999,"maxx"=>3699000,"maxy"=>5463000);
        $min_width = 700; 
      break;
    }
    $W = $extent["maxx"]-$extent["minx"];
    $H = $extent["maxy"]-$extent["miny"];
    $x = $extent["minx"] + ($W)/2;
    $y = $extent["miny"] + ($H)/2;
    $zoom = $zoom / 1000;
    $width = $min_width + $zoom * ($W - $min_width);
    $height = $this->parameters["height"] * $width/$this->parameters["width"];

    SRand((double)MicroTime()*1e6);
    $r = Rand(0,1000)/1000;
    $dx = ($W - $width)*$r - ($W - $width)/2;
    $r = Rand(0,1000)/1000;
    $dy = (($H - $height)*$r - ($H - $height)/2) * $my_const_h;

    $this->parameters["bbox"]["minx"] = $x - $width/2 - $dx;
    $this->parameters["bbox"]["miny"] = $y - $height/2 - $dy;
    $this->parameters["bbox"]["maxx"] = $x + $width/2 - $dx;
    $this->parameters["bbox"]["maxy"] = $y + $height/2 - $dy;
  }

  function TreeGenerator() {
    for($i=0;$i<Count($this->parameters["layers"]);$i++) {
      list($key,$val) = Explode("(",$this->parameters["layers"][$i]);
      //echo $key." ".$val."<br>\n";
      $arr_coll = Explode(".",$key);
      $arr_layer = Explode(",",$val);
      $arr_style = Explode(",",substr($this->parameters["styles"][$i],1));

      $layer = &$this->tree;
      for($j=0;$j<Count($arr_coll)-1;$j++) {
        $layer = &$layer[$arr_coll[$j]]["layers"];
      }
      if (!Is_Array($layer[$arr_coll[$j]])) $layer[$arr_coll[$j]] = array();
      $layer = &$layer[$arr_coll[$j]];

      for($j=0;$j<Count($arr_layer);$j++) {
        if ($arr_style[$j]) {
          $layer["layers"][$arr_layer[$j]]["style"] = $arr_style[$j];
        }
        else $layer["layers"][$arr_layer[$j]] = array();
      }
      //echo $key." / ".$this->tree["T"]["layers"]["L2"]["style"]."<br>\n";
    }
    for($i=0;$i<Count($this->parameters["select"]);$i++) {
      list($key,$val) = Explode("(",$this->parameters["select"][$i]);
      $arr_coll = Explode(".",$key);
      $arr_point = Explode(",",$val);

      $layer = &$this->tree;
      for($j=0;$j<Count($arr_coll)-1;$j++) {
        $layer = &$layer[$arr_coll[$j]]["layers"];
      }
      $layer = &$layer[$arr_coll[$j]];
      $layer["select"]=$arr_point;
    }
    for($i=0;$i<Count($this->parameters["condition"]);$i++) {
      list($key,$val) = Explode("(",$this->parameters["condition"][$i]);
      $arr_coll = Explode(".",$key);

      $layer = &$this->tree;
      for($j=0;$j<Count($arr_coll)-1;$j++) {
        $layer = &$layer[$arr_coll[$j]]["layers"];
      }
      $layer = &$layer[$arr_coll[$j]];
      $layer["condition"]=$val;
    }
  }

  function SetStyles() {
    $style_file = FileUp2(".admin/style_schema.inc");
    if (!file_exists($style_file)) ErrorMsg(array("msg"=>"style_schema.inc not exist"));
    require_once($style_file);
    if ($MAP_STYLE["__properties"]["ext_manager"]) {
      $extent_file = FileUp2(".admin/extent_schema.inc");
      if (!file_exists($extent_file)) ErrorMsg(array("msg"=>"style_schema.inc not exist"));
      require_once($extent_file);
      $MAP_STYLE["__properties"]["ext_manager"] = $MAP_EXTENTS;
    }
    $this->style = $MAP_STYLE;

    $this->tree[$this->parameters["map"]]["collection"] = true;
    $layers = &$this->tree[$this->parameters["map"]]["layers"];
    $key_arr = array_keys($layers);
    for($i=0;$i<Count($key_arr);$i++) $this->GetReferences(&$layers[$key_arr[$i]]);
  }

  function GetReferences($tree) {
    //die($this->style["mapa_cr"]);
    if ($tree["style"]) {
      $style = $this->style[$tree["style"]];

      //Nastaveni dynamickych stylu pomoci Session
      if ($style["session"]) {
        if (!$this->session) {
          $this->session = true;
          session_start();
        }
        $session_style = $GLOBALS["TMapServer"][$this->parameters["map"]][$tree["style"]]["style"];
	      if (Is_Array($session_style)) {
          reset($session_style);
          while(list($key,$val) = each($session_style)) {
            $style[$key] = $val;
          }
        }
      }

      if ($style) {
        if ($style["reference"]) {
          if ($style["catalog"]) $this->global_references[] = $style["reference"];
          elseif (Is_Array($style["reference"])) {
            //$this->local_references[] = $arr_style["reference"];
          }
        }
        $tree["style"] = &$style;
      }
      else $tree["style"] = array();
      
      if ($tree["layers"]) {
        $layers = &$tree["layers"];
        $key_arr = array_keys($layers);
        for($i=0;$i<Count($key_arr);$i++) $this->GetReferences(&$layers[$key_arr[$i]]);
      }
    }
  }
  
}

?>
