<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_mint.inc,v 1.10 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class Map_Interface {

  var $parameters; //parametry pro objekt Map
  var $tree; //vygenerovany strom vrstev
  var $style; //styl mapoveho projektu
  var $global_references; //globalni odkaz na katalog
  var $local_references; //vice lokalnich odkazu
  var $session = false; //zda se uz provedlo natazeni session
  var $index = 0; //index aktualni vrstvy

  function Map_Interface($input,$interface) {
    @include(FileUp2("/.admin/map_schema.inc"));
    $this->project = $MAP_PROJECT;

    $this->ParseInterface(&$input, $interface);

    $this->ParseParameters($input);
    
    $this->ExtentManagerValidation();

//    print_r($GLOBALS["TMapServer_Session"]);
    session_register("TMapServer_Session");

    if (!Is_Array($this->parameters["layers"])) $this->parameters["layers"] = array();
    $this->TreeGenerator();

    $this->SetStyles();
  
    $this->ProcessCallBack(&$this);
    
    //$this->Debug($this->tree[$this->parameters["map"]],$this->parameters["map"],0);
    //die();
  }
  
  function ParseInterface($input, $interface) {
    //dummy function
  }

  function Debug($tree,$name,$level) {
    for($i=0;$i<$level;$i++) echo "&nbsp;&nbsp;";
    echo $name." ".$tree["style"]."<br>";
    
    if ($tree["layers"]) {
      reset($tree["layers"]);
      while(list($n,$coll) = each($tree["layers"])) $this->Debug($coll,$n,$level+1);
    }
  }

  function NewIndex() {
    $this->index++;
    return $this->index;
  }  
  
  function ExtentManagerValidation() {
    if ($this->project["extent_manager"]) {
      $file = FileUp2(".admin/manager/extent/".$this->project["extent_manager"]["type"].".inc");
      if ($file) include_once($file);
      else ErrorMsg(array("msg"=>"<b>Error:</b>Extent Manager '".$this->project["extent_manager"]["type"]."' is missing"));
      $extman = $this->project["extent_manager"]["type"]."_ExtentManager";
      $this->extent_manager = new $extman(&$this, $this->project["extent_manager"]);
      if ($this->parameters["width"] && $this->parameters["height"]) {
        $bbox = $this->extent_manager->ValidateExtent($this->parameters["bbox"], $this->parameters["width"], $this->parameters["height"], $this->parameters["scale_value"], $this->project["coord_sys"], false, $this->check_last_level);
        if ($bbox) $this->parameters["bbox"] = $bbox;
      }
    } else {
      if ($this->parameters['bbox'] && $this->parameters['width'] && $this->parameters['height']) {
        include_once(FileUp2(".admin/main_manager_extent.inc"));
        $extent_manager = new ExtentManager($this);
        $this->parameters["bbox"] = $extent_manager->SetExtentRatioByExtent($this->parameters["bbox"], array("minx"=>0,"miny"=>0,"maxx"=>$this->parameters['width'],"maxy"=>$this->parameters['height']));
      }
    }
  }
  
  
  
  function ProcessCallBack ($par) {
    if (Is_array($par)) {
      foreach ($par as $key=>$val) {
        if (!StrCmp($key,'callback_functions')) {
          if (function_exists($val['mint'])) $val['mint'](&$par, &$this);
        } elseif (Is_array($val)) {
          $par[$key] = $this->ProcessCallBack($val);
        }
      }
    } elseif (Is_object($par)) {
      $params = get_object_vars($par);
      foreach ($params as $key=>$val) {
        if (Is_array($val)) {
          $par->$key = $this->ProcessCallBack($val);
        }
      }
    }
    return $par;
  }
}

?>
