<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_maplayer.inc,v 1.23 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class MapLayer {
  
  var $name;             //nazev vrstvy
  var $manager;          //serverovy manager
  var $connection;       //spojeni na server
  var $properties;       //nastaveni vrstvy
  var $request;          //parametry pozadavku
  var $content;          //obsah vystupu
  var $point_layer;      //specialni bodova vrstva, ktera shromazduje body z bodovych vrstev
  var $cache_output = false; //nevypisovat output na stdout ale ukladat do output
  var $output = "";
  var $params = array();

  function MapLayer($tree, $name, $request, $manager) {
    $this->name = $name;
    $this->manager = $manager;
    $this->tree = &$tree;
    $this->properties = $this->tree["style"];
    $this->request = $request;
    $this->content = '';
    $this->point_layer = '';
  }

  function WriteHTML() {die('HTML output not implemented');}
  function WriteVML() {die('VML output not implemented');}
  function WriteSVG() {die('SVG output not implemented');}
  function WritePNG() {die('PNG output not implemented');}
  function WriteGIF() {die('GIF output not implemented');}
  function WriteJPEG() {die('JPEG output not implemented');}
  function WriteGML() {die('GML output not implemented');}

  function WriteLegendHTML() {}

  function WriteHTMLLayer($params) {
    $class = isset($params["class"])?$params["class"]:(isset($this->params["class"])?$this->params["class"]:(isset($this->tree["style"]["html_layer"]["class"])?$this->tree["style"]["html_layer"]["class"]:false));
    $visible = isset($params["visible"])?$params["visible"]:(isset($this->params["visible"])?$this->params["visible"]:(isset($this->tree["style"]["html_layer"]["visible"])?$this->tree["style"]["html_layer"]["visible"]:true));
    $bgColor = $params["bgColor"]?$params["bgColor"]:($this->params["bgColor"]?$this->params["bgColor"]:(isset($this->tree["style"]["html_layer"]["bg_color"])?$this->tree["style"]["html_layer"]["bg_color"]:false));
    $left = $params["left"]?$params["left"]:($this->params["left"]?$this->params["left"]:(isset($this->tree["style"]["html_layer"]["left"])?$this->tree["style"]["html_layer"]["left"]:0));
    $top = $params["top"]?$params["top"]:($this->params["top"]?$this->params["top"]:(isset($this->tree["style"]["html_layer"]["top"])?$this->tree["style"]["html_layer"]["top"]:0));
    $width = $params["width"]?$params["width"]:($this->params["width"]?$this->params["width"]:(isset($this->tree["style"]["html_layer"]["width"])?$this->tree["style"]["html_layer"]["width"]:($this->request["print"]?$this->request["print"]["width"]:$this->request["width"])));
    $height = $params["height"]?$params["height"]:($this->params["height"]?$this->params["height"]:(isset($this->tree["style"]["html_layer"]["height"])?$this->tree["style"]["html_layer"]["height"]:($this->request["print"]?$this->request["print"]["height"]:$this->request["height"])));
    $zIndex = $params["zIndex"]?$params["zIndex"]:($this->params["zIndex"]?$this->params["zIndex"]:(isset($this->tree["style"]["html_layer"]["z_index"])?$this->tree["style"]["html_layer"]["z_index"]:1));
    $absolute = isset($params["absolute"])?$params["absolute"]:false; //For Netscape only
    $no_size = isset($params["no_size"])?$params["no_size"]:false; 
    $position = $this->params["position"]?$this->params["position"]:"absolute";
    $overflow = isset($params["overflow"])?$params["overflow"]:"hidden";
    
    $this->output = "";

    if ($this->content != '') {
      if (IsN() && (BrowserVersion() == 4)) {
        if ($absolute)
          $this->output .= '<layer name="' .$this->name .'" '.($class?' class="'.$class.'" ':"").'left='.$left.' top='.$top.' width=' .$width .' height=' .$height .' visibility=' .($visible?'"show"':'"hide"') .($bgColor?' bgColor='.$bgColor:'') .($zIndex?' Z-INDEX='.$zIndex:'') .'>'."\n";
        else 
          $this->output .= '<layer name="' .$this->name .'" '.($class?' class="'.$class.'" ':"").'width=' .$this->request["width"] .' height=' .$this->request["height"] .' visibility=' .($visible?'"show"':'"hide"') .($bgColor?' bgColor='.$bgColor:'') .($zIndex?' Z-INDEX='.$zIndex:'') .'>'."\n";
        $this->output .= $this->content."\n";
        $this->output .= '</layer>'."\n";
      } else {
        if ($no_size) 
          $this->output .= '<div id="' .$this->name .'" '.($class?' class="'.$class.'" ':"").'style="position:absolute; left:'.$left.'px; top:'.$top.'px; visibility:' .($visible?'visible;':'hidden;')  .($bgColor?'background-color:'.$bgColor.';':'') .($zIndex?'z-index:'.$zIndex.';':'') .'">'."\n";
        else
          $this->output .= '<div id="' .$this->name .'" '.($class?' class="'.$class.'" ':"").'style="position:absolute; overflow:'.$overflow.'; left:'.$left.'px; top:'.$top.'px; width:' .$width .'px; height:' .$height .'px; visibility:' .($visible?'visible;':'hidden;')  .($bgColor?'background-color:'.$bgColor.';':'') .($zIndex?'z-index:'.$zIndex.';':'') .'">'."\n";
        $this->output .= $this->content;
        $this->output .= '</div>'."\n";
      }
    }
    if (!$this->cache_output) {
      echo $this->output;
    }
  }

  function GetPointLayer() { return $this->point_layer; }
  
  function GetMapProject() {
    if (!$this->map_project) {
      @include_once(FileUp2(".admin/agenda_func.inc"));
      $f = GetAgendaPath($this->parameters["Project"],false)."/.admin/map_schema.inc";
      if(file_exists($f)) include($f);
      $this->map_project = $MAP_PROJECT;
    }
    return $this->map_project;
  }
  
  function CoordSysConvertExtent($extent=false) {
    $extent = $extent?$extent:$this->request["bbox"];
    $this->GetMapProject();
    if ($this->properties["coord_sys"] && ($this->map_project["coord_sys"] != $this->properties["coord_sys"])) {
      include_once ($GLOBALS["TMAPY_LIB"]."/matkart/transformation.inc");
      $extent = TransformBBOX_For_TMS($this->map_project["coord_sys"], $this->properties["coord_sys"], $extent);
    }
    return $extent;
  }
  
  function CoordSysConvertPoint($coordsys_from,$coordsys_to,$x,$y) {
    include_once ($GLOBALS["TMAPY_LIB"]."/matkart/transformation.inc");
    return Transform_For_TMS($coordsys_from, $coordsys_to, $x, $y);
  }
  
  function GetFromCollection($tree, $name) {
    reset($tree["layers"]);
    while (list($key,$val) = each($tree["layers"])) {
      $layers[] = $key;
      $styles[] = Is_Array($val["style"])?$val["style"]["name"]:"";
      $conditions[] = $val["condition"];
      $selects[] = $val["select"];
    }
    $ret["layers"] = $name."(".Implode($layers,",").")";
    $ret["styles"] = "(".Implode($styles,",").")";
    $ret["conditions"] = "(".Implode($conditions,",").")";
    $ret["selects"] = "(".Implode($selects,",").")";
    return $ret;
  }     

  function GetFromTree($tree, $name) {
    if ($tree["layers"]) {
      $aux = $this->GetFromCollection($tree, $name);
      $layers[] = $aux["layers"];
      $styles[] = $aux["styles"];
      $conditions[] = $aux["conditions"];
      $selects[] = $aux["selects"];
      reset($tree["layers"]);
      while (list($key,$val) = each($tree["layers"])) {
        $aux = $this->GetFromTree($val, $name.".".$key);
        if ($aux) {
          $layers[] = $aux["layers"];
          $styles[] = $aux["styles"];
          $conditions[] = $aux["conditions"];
          $selects[] = $aux["selects"];
        }
      }
      $ret["layers"] = Implode($layers,",");
      $ret["styles"] = Implode($styles,",");
      $ret["conditions"] = Implode($conditions,",");
      $ret["selects"] = Implode($selects,",");
    }
    return $ret;
  }

  function WriteHTMLPrint() {
//    if (!$this->tree["select"]) $this->WriteHTML();
    if (1) $this->WriteHTML();
/*    else {
      echo "<IMG src=\"map.php?";
      echo "VERSION=".$this->request["version"];
      echo "&MAP=".$this->name;
      echo "&BBOX=".$this->request["bbox"]["minx"].",".$this->request["bbox"]["miny"].",".$this->request["bbox"]["maxx"].",".$this->request["bbox"]["maxy"];
      echo "&WIDTH=".$this->request["width"];
      echo "&HEIGHT=".$this->request["height"];
      echo "&FORMAT=".($this->properties["format"]?$this->properties["format"]:"GIF");
      echo "&MAPSCALE=".$this->request["scale"];

      $aux = $this->GetFromTree($this->tree,$this->name.".".$this->name);
      echo "&LAYERS=".$this->name."(".$this->name."),".$aux["layers"];
      echo "&STYLES=(".$this->properties["name"]."),".$aux["styles"];
//      echo "&CONDITION=(),".$aux["conditions"];
      echo "&SELECT=".$this->name.".".$this->name."(".Implode($this->tree["select"],",").")";//,".$aux["selects"];

      echo '" hspace=0 vspace=0 border=0 width="'.$this->request["width"].'" height="'.$this->request["height"].'">';
      echo "\n";
    }*/
  }

  function GetCollectionLayers($tree, $mode="visible", $all=false) {
    $res = '';
    if (Is_Array($tree["layers"])) {
      reset($tree["layers"]);
      while (list($key,$val) = each($tree["layers"])) {
        if (!$all) {
          $params = $val["params"]?$val["params"]:$val;
          switch ($mode) {
            case "visible":
            case "overview":
            default:
              $test = $params[$mode];
            break;
            case "legend":
              $test = isset($params[$mode])?$params[$mode]:true;
            break;
          }
        }
        if (isset($test) && !$test && !$all) continue;
        if ($all) $key = isset($val["name"])?$val["name"]:$val["params"]["name"];
        if ($res!='') $res .= ",".$key;
        else $res = (string)$key;
        $aux_res = $this->GetCollectionLayers($val, $mode, $all);
        if ($aux_res != '') $res .= ",".$aux_res;
      }
    }
    return $res;
  }

  function GetLayers($mode="visible", $all=false) {
//    if ($all || $mode == "legend") {
    if ($all) {
      $tree = $this->manager->GetLayer($this->name);
      $tree = $tree[$this->name];
    } else { 
      $tree = $this->tree;
    }
    if (!$tree) $tree = $this->tree;
    $res = Explode(",",$this->GetCollectionLayers($tree, $mode, $all));
    return $res;
  }

  function ObjectHandlerWriteLegend ($type) {
    include_once(FileUp2(".admin/obj_manager.inc"));
    if (Class_Exists("ObjectsManager")) {
      $this->objects = new ObjectsManager();
      $this->objectlist = array();
      $objects = $this->tree["style"]["objects"]?$this->tree["style"]["objects"]:array();
//      @include_once(FileUp2(".admin/agenda_func.inc"));
//      include(GetAgendaPath($this->parameters["Project"],false)."/.admin/map_schema.inc");
//      $project = $MAP_PROJECT["name"];
      $this->GetMapProject();
      $project = $this->map_project["name"];
      reset($objects);
      while (list($key, $val) = each(&$objects)) {
        $val = &$this->objects->FindObjectByIdent($val);
        if ($val["interfaces"]["writelegend"][$type]) {
          $this->objectlist[] = $val;
          $obj = &$this->objects->GetCachedObject($val);
          $obj->owner_type = Get_Class($this);
          $obj->TMapServer_OpenSession($project,$this->name);
          $obj->TMapServer_WriteLegend(&$this, $type);
          $this->objects->SetCachedObject($obj);
        }
      }
    }
  }
  
  function ObjectHandlerWriteLayerBefore ($type) {
    include_once(FileUp2(".admin/obj_manager.inc"));
    if (Class_Exists("ObjectsManager")) {
      $this->objects = new ObjectsManager();
      $this->objectlist = array();
      $objects = $this->tree["style"]["objects"]?$this->tree["style"]["objects"]:array();
      if (Count($objects) > 0) {
  //      @include_once(FileUp2(".admin/agenda_func.inc"));
  //      include(GetAgendaPath($this->parameters["Project"],false)."/.admin/map_schema.inc");
  //      $project = $MAP_PROJECT["name"];
        $this->GetMapProject();
        $project = $this->map_project["name"];
        reset($objects);
        while (list($key, $val) = each(&$objects)) {
          $val = &$this->objects->FindObjectByIdent($val);
          if ($val["interfaces"]["writelayer"][$type]) {
            $this->objectlist[] = $val;
            $obj = &$this->objects->GetCachedObject($val);
            $obj->owner_type = Get_Class($this);
            $obj->TMapServer_OpenSession($project,$this->name);
            $obj->TMapServer_WriteLayerBefore(&$this, $type);
            $this->objects->SetCachedObject($obj);
          }
        }
      }
    }
    if ($this->SaveToFile) { 
      $this->File = Tempnam(($GLOBALS["SERVER_SYSTEM"] == "UNIX")?"/tmp":GetEnv("TEMP"), "tms_");
    }
  }

  function ObjectHandlerWriteLayerAfter ($type) {
    if ($this->MapFileIsTemp) {
      @unlink($this->MapFileName);
      @unlink(Eregi_Replace("^(.*)\.map$","\\1", $this->MapFileName));
    }
    $imagehadle = false;
    if ($this->File) {
      switch ($type) {
        case "GIF":
        case "PNG":
        case "JPEG":
          $imginfo = getimagesize($this->File);  
          switch ($imginfo[2]) {           //1 = GIF, 2 = JPG, 3 = PNG, 4 = SWF
            case 1:
              $imagehadle = ImageCreateFromGIF($this->File);
            break;  
            case 2:
              $imagehadle = ImageCreateFromJPEG($this->File);
            break;  
            case 3:
              $imagehadle = ImageCreateFromPNG($this->File);
            break;
          }
          unlink($this->File);
          $params["imagehandle"] = $imagehadle; 
        break;
      }
    } 
    reset($this->objectlist);
    while (list($key, $val) = each($this->objectlist)) {
      $obj = &$this->objects->GetCachedObject(&$this->objectlist[$key]);
      $obj->owner_type = Get_Class($this);
      $obj->TMapServer_WriteLayerAfter(&$this, $type, $params);
    }

    if ($this->File) {
      switch ($type) {
        case "GIF":
        case "PNG":
        case "JPEG":
          switch ($imginfo[2]) {           //1 = GIF, 2 = JPG, 3 = PNG, 4 = SWF
            case 1:
              ImageGIF($imagehadle);
            break;  
            case 2:
              ImagePNG($imagehadle);
            break;  
            case 3:
              ImageJPEG($imagehadle);
            break;
          }
        break;
      }
    }
    //Remove old unlinked files
    $temp = ($GLOBALS["SERVER_SYSTEM"] == "UNIX")?"/tmp":GetEnv("TEMP");
    if ($dir = @opendir($temp)) {
      while (($file = readdir($dir)) !== false) {
        if (Eregi("^tms_", $file)) {
          $file = $temp."/".$file;
          if ((@time() - filemtime($file)) > 60) {
            @unlink($file);
          }
        }
      }  
      @closedir($dir);
    }

  }
  
}

?>
