<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_map.inc,v 1.11 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class TMS_Map {

  var $type; //typ: map, overview, legend
  var $modes = array("map"=>0, "overview"=>1, "legend"=>2);
  var $request;
  var $style;
  var $tree;
  var $manager; //serverovy manager

  var $session; //pouzivat session
  var $scale; //zobrazit meritko
  var $print; //pro tisk
  var $overview = false; //identifikator prehledky v pripade pouziti extent_schema

  var $point_layer = ''; //bodova vrstva pro zobrazeni popisek
  var $cache_output = false; //nevypisovat output na stdout ale ukladat do output
  var $output = "";

  function TMS_MAP($interface) {

    $this->request = &$interface->parameters;
    $this->style = &$interface->style;
    $this->tree = &$interface->tree;
    $this->project = &$interface->project;
    $this->extent_manager = &$interface->extent_manager;
    
    $this->mode = $this->request["mode"];
    
    require_once(Fileup2(".admin/manager.inc"));
    $this->manager = new Manager();

    //lube - podpora dynamickych prehledovek 
    if ($this->project["overview"]["dynamic"] && $this->extent_manager) {
      $ext = $this->extent_manager->ValidateExtent($this->request["bbox"], $this->request["width"], $this->request["height"], $this->request["scale_value"]);
      $this->overview = $this->extent_manager->active_tile["overview"]?$this->extent_manager->active_tile["overview"]:"default";
    }

    if ($this->request["width"]) $this->request["pixel"] = ($this->request["bbox"]["maxx"] - $this->request["bbox"]["minx"])/$this->request["width"];
    $this->scale = $this->request["scale"];
    $this->print = $this->request["print"];
    $this->measure = $this->request["measure"];
    $this->selection_shape = $this->request["selection_shape"];
    $this->selection_shape_maponly = $this->request["selection_shape_maponly"];
    $this->edit_vector = $this->request["edit_vector"];
  }
  
  function WriteMap() {
    $this->WriteMapHeader();

    //logovani
    $t_start = GetTimeOfDay();

    $size = $this->WriteMapContent(); 
    
    //logovani
    $t_end = GetTimeOfDay();
    if ($this->log) $this->WriteLog($size, $t_start, $t_end);
    
    $this->WriteMapFooter();
  }

  function WriteMapContent () {
    $size = 0;
    $layers = &$this->tree[$this->request["map"]]["layers"];
    $key_arr = array_keys($layers);
    if (!(Count($key_arr)==1 && $key_arr[0]=='')) {
      for($i=0;$i<Count($key_arr);$i++) $size += $this->WriteMapTree(&$layers[$key_arr[$i]],$key_arr[$i]);
    }
    return $size;
  } 
  
  function WriteMapTree($tree,$name) {
    if ((!$tree["params"]["min_pixel"] || $this->request["pixel"] >= $tree["params"]["min_pixel"]) &&
        (!$tree["params"]["max_pixel"] || $this->request["pixel"] <= $tree["params"]["max_pixel"])) {
      $size = $this->WriteMapLayer(&$tree,$name);
      if ($tree["layers"] && $tree["collection"]) {
        reset($tree["layers"]);
        while(list($layer_name,$layer) = each($tree["layers"])) {
          if ($layer_name) $size += $this->WriteMapTree(&$layer,$layer_name);
        }
      }
    } else {
      $size = 0; 
    } 
    return $size;
  }

  function WriteMapLayer($tree,$name) {
    die("Not implemented WriteMapLayer");
    //echo $name." ".$tree["style"]."<br>";
  }

  function WriteMapHeader() {}

  function WriteMapFooter() {}

  function WriteLog($size, $t_start, $t_end) {
    $size = ((double) $size)/1000;
    $size = (string) $size;
    $size = Str_Replace(",",".",$size);

    //$t_diffm = DiffTime($t_middle["sec"], $t_middle["usec"], $t_start["sec"], $t_start["usec"]);
    $t_diffm = 0;
    $t_diff = DiffTime($t_end["sec"], $t_end["usec"], $t_start["sec"], $t_start["usec"]);

    $sep = "\t";
    $log = $this->manager->GetLog($this->request["map"]);
    if (Is_File($log["file"])):
      $fp = FOpen($log["file"],"a");
      if ($fp):
        $row = $log["name"];
        $row .= $sep.Date("D d.m.Y H:i:s", $GLOBALS["t_time"]);
        $row .= $sep.$t_diffm.$sep.$t_diff;
        $row .= $sep.$size;
        $row .= $sep.$GLOBALS["REMOTE_ADDR"];
        $row .= $sep.$GLOBALS["cook_ident"];
        $row .= $sep.$GLOBALS["HTTP_USER_AGENT"];
        $row .= $sep.$GLOBALS["QUERY_STRING"];
        $row .= "\n";
        FPutS($fp, $row);
        FClose($fp);
      endif;
    endif;

    if ($log["db"]["inc"]):
      $file = FileUp2($log["db"]["inc"]);
      if (Is_File($file)):
        include_once ($file);
      endif;
      $sep = ",";
      $DB_LOG = new DB_LOG;
      $row = "INSERT INTO ".$log["db"]["table"]." VALUES (0,";
      $row .= "'".$log["name"]."'";
      $row .= $sep."'".($DB_LOG->datetime2dbdatetime($GLOBALS["t_time"]))."'";
      $row .= $sep.$t_diffm.$sep.$t_diff;
      $row .= $sep.$size;
      $row .= $sep."'".$GLOBALS["REMOTE_ADDR"]."'";
      $row .= $sep.$GLOBALS["cook_ident"];
      $row .= $sep."'".$GLOBALS["HTTP_USER_AGENT"]."'";
      $row .= $sep."'".$GLOBALS["QUERY_STRING"]."'";
      $row .= ")";
      $DB_LOG->Query($row);
    endif;
  }

}

function DiffTime($sec1, $msec1, $sec2, $msec2) {
    $sec = $sec1 - $sec2;
    if ($msec1 < $msec2):
      $msec1 = $msec1 + 1000000;
      $sec--;
    endif;
    $msec = $msec1 - $msec2;
    $msec = Round($msec/1000)/1000;
    $msec = Split("[.,]",$msec); 
    $res = $sec.".".$msec[1];
    return $res;
}

?>
