<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_manager_extent.inc,v 1.6 2006/03/06 14:49:00 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class ExtentManager {

  var $snap_method = 0;  //0 - Center in extent, 1 - Contained, 2 - Intersect, 3 - Intersect percent
  var $no_snap = 0;
  var $tiles = array();
  var $active_tile;
  var $extent_tolerance=0.01;

  function ExtentManager(&$interface, $params=false) {
    $this->interface = &$interface;
    $this->params = $params;
    if (isset($params['extent_tolerance'])) $this->extent_tolerance=$params['extent_tolerance'];
  }
  
  function MainValidateExtent($bbox, $width, $height, $scale=false, $coord_sys=false, $format=false, $check_last_level=false, $snap_method=false) {
    $bbox = $this->ConvertExtent($bbox);
//    print_r($bbox);
    $bbox = $this->SetExtentRatioByExtent($bbox, array("minx"=>0,"miny"=>0,"maxx"=>$width,"maxy"=>$height));
    $this->bbox_input = $bbox;
//    echo "<br>";
//    print_r($bbox);
//    echo "<br>";
    if (!$scale) $scale = $this->GetScale($bbox, $width, $height);
    $pixel = $this->GetPixelSize($bbox, $width, $height);
    $this->pixel_input = $pixel;

    $this->GetTiles($this->bbox_input, $width, $height, $scale, $coord_sys);
    //print_r($this->tiles);
    reset($this->tiles);
    while (list($key,$val) = each($this->tiles)) {

      $this->snap_method = is_numeric($val["snap_method"])?$val["snap_method"]:($snap_method!==false?$snap_method:0);

      $tile_ok = false;
      $ext_val = $this->bbox_input;
      $val["index"] = $key;

      if ($coord_sys && $val["coord_sys"]) {
        if ($coord_sys != $val["coord_sys"]) {
          include_once($GLOBALS["TMAPY_LIB"]."/matkart/transformation.inc");
          $ext_val = $this->TransformExtent($coord_sys, $val["coord_sys"],$ext_val);
          if (!$ext_val) continue;
        }
      }

      //Overeni meritkovych omezeni

      //pomoci scale - zavisle na rozliseni
      if ($val["maxscale"] || $val["minscale"]) {
        if ($scale && $val["maxscale"] < $scale)
          continue;
        //Prepocet pro minimalni meritko
        if ($scale && $scale < $val["minscale"]) {
          $ext_val = $this->ScaleExtent ($ext_val, (double)$val["minscale"]/$scale);
        }
      //pomoci width / dx - nezavisle na rozliseni
      } elseif ($val["maxpixel"] || $val["minpixel"]) {
        if ((StrCmp($coord_sys,"WGS84") != 0) && $dxpx > 0 && $dxpx < $this->extent_tolerance) {
          $ext_val = $this->ScaleExtent ($ext_val, (double)$val["maxpixel"]/$pixel);
          $pixel = $val["maxpixel"];
        }
        if ($pixel && ($val["maxpixel"]+$this->extent_tolerance) < $pixel) {
          continue;
        }
        //Prepocet pro minimalni meritko
        if ($pixel && $pixel < ($val["minpixel"]-$this->extent_tolerance)) {
          $ext_val = $this->ScaleExtent ($ext_val, (double)$val["minpixel"]/$pixel);
        }
      }
      switch ($this->snap_method) {
        //Center in extent
        case 0:
          $tile_ok = $this->CenterIn ($val["extent"], $ext_val); 
          break;
        //Contained
        case 1: 
          $tile_ok = $this->Contained ($val["extent"], $ext_val);
          break;
        //Intersect
        case 2: 
          $tile_ok = $this->Intersect ($val["extent"], $ext_val);
          break;
        //Intersect percent
        case 3: 
          $tile_ok = $this->IntersectPercent ($val["extent"], $ext_val, $percent);
          break;
      }

      //die('a');
      if ($tile_ok) {
//        print_r($ext_val["maxx"]-$ext_val["minx"]);echo "<br>";

        if (!$this->tiles["params"]["center_point_contain"] && !$this->Contained ($val["extent"], $ext_val)):
          //Snap
          if (!$this->no_snap)
            $ext_val = $this->SnapTo($val["extent"], $ext_val);
          //Contained by tile
          if (!$this->Contained ($val["extent"], $ext_val))
            if (($tiles_count-1) != $key) continue;
        endif; 
//print_r($ext_val);

        $ext_val = $this->SetExtentRatioByExtent($ext_val, array("minx"=>0,"miny"=>0,"maxx"=>$width,"maxy"=>$height));

        //Tileing
        if ($this->params['snaptotile'] && $val["tiles"]) {
          $difx = $ext_val["minx"]-$val["tiles"]["x"];
          $dify = $val["tiles"]["y"]-$ext_val["maxy"];
          $cntx = Round($difx/$val["tiles"]["stepx"]);
          $cnty = Round($dify/$val["tiles"]["stepy"]);
          $x = $val["tiles"]["x"] + $cntx*$val["tiles"]["stepx"];
          $y = $val["tiles"]["y"] - $cnty*$val["tiles"]["stepy"];
          $ext_val["maxx"] += $x-$ext_val["minx"];
          $ext_val["miny"] += $y-$ext_val["maxy"];
          $ext_val["minx"] = $x;
          $ext_val["maxy"] = $y;
        }
        if ($check_last_level) {
          $bbox = $this->ScaleExtent($ext_val, 1/($ext_val["maxx"]-$ext_val["minx"]));
//          $bbox = $this->MainValidateExtent($bbox,$width,$height,false,false,false,false,$snap_method);
          $bbox = $this->ValidateExtent($bbox,$width,$height);
          $val["is_last_level"] = $this->active_tile["index"] == $val["index"];
          $this->last_tile = $this->active_tile;  
        }

        $this->active_tile = $val;
        
        if (StrCmp($coord_sys,"WGS84") != 0) {
          reset($ext_val);
          while (list($k, $v) = each($ext_val)) {
            $ext_val[$k] = Round($v,$this->params['coordroundto']);
          }
          reset($ext_val);
        }

        if ($coord_sys) {
//          $this->result = array("connection"=>$val["connection"], "extent"=>$ext_val, "name"=>$val["name"], "minscale"=>$val["minscale"], "maxscale"=>$val["maxscale"], "minpixel"=>$val["minpixel"], "maxpixel"=>$val["maxpixel"]); 
          $this->result = array("connection"=>$val["connection"], "extent"=>$ext_val, "name"=>$val["name"], "pixel"=>$this->GetPixelSize($ext_val, $width, $height), "minscale"=>$val["minscale"], "maxscale"=>$val["maxscale"], "minpixel"=>$val["minpixel"], "maxpixel"=>$val["maxpixel"]); 
          return $this->result["extent"];
        } else {
          switch ($format) {
            case 1:
              return $ext_val["minx"].",".$ext_val["miny"].",".$ext_val["maxx"].",".$ext_val["maxy"];
            break;
            default:
              return $ext_val;
            break;
          }
        }
        break;
      }
    }
    return false;
  }
  
  //strExt je retezec "minX,minY,maxX,maxY"
/*  function ValidateExtent ($strExt, $scale=0, $percent=0, $coord_sys=0, $width=0, $height=0, $format=0, $check_last_level=false) {

//    echo $strExt;
    $ext_input = $this->ConvertExtent($strExt);
    $this->GetTiles($ext, $scale, $width, $height);
    
    @$pixel = ($ext_input["maxx"]-$ext_input["minx"])/(double)$width;

//    echo($pixel."<br>");
//    if (StrCmp($coord_sys,"WGS84") != 0) $pixel = Round($pixel, 2);

//    echo($pixel."<br>");
    //$ext_val = $ext_input;
    
    if ($this->tiles["params"]["no_snap"]) 
      $this->no_snap = true;

    reset($this->tiles);
    
    while (list($key,$val) = each($this->tiles)):
      $tile_ok = false;
      $ext_val = $ext_input;
      $val["index"] = $key;

      if ($coord_sys) {
        if ($coord_sys != $val["coord_sys"]) {
          include_once($GLOBALS["TMAPY_LIB"]."/matkart/transformation.inc");
          $ext_val = $this->TransformExtent($coord_sys, $val["coord_sys"],$ext_val);
          if (!$ext_val) continue;
        }
      }
//      else $ext = $ext_input;

      //Overeni meritkovych omezeni

      //pomoci scale - zavisle na rozliseni
      if ($val["maxscale"] || $val["minscale"]) {
        if ($scale && $val["maxscale"] < $scale)
          continue;
        //Prepocet pro minimalni meritko
        if ($scale && $scale < $val["minscale"]) {
          $ext_val = $this->ScaleExtent ($ext_val, (double)$val["minscale"]/$scale);
        }
      //pomoci width / dx - nezavisle na rozliseni
      } elseif ($val["maxpixel"] || $val["minpixel"]) {
        $dxpx = $pixel - $val["maxpixel"];
        if ((StrCmp($coord_sys,"WGS84") != 0) && $dxpx > 0 && $dxpx < 0.1) {
          $ext_val = $this->ScaleExtent ($ext_val, (double)$val["maxpixel"]/$pixel);
          $pixel = $val["maxpixel"];
        }
        if ($pixel && $val["maxpixel"] < $pixel)
          continue;
        //Prepocet pro minimalni meritko
        if ($pixel && $pixel < $val["minpixel"]) {
          $ext_val = $this->ScaleExtent ($ext_val, (double)$val["minpixel"]/$pixel);
        }
      }

      switch ($this->snap_method) {
        //Center in extent
        case 0:
          $tile_ok = $this->CenterIn ($val["extent"], $ext_val); 
          break;
        //Contained
        case 1: 
          $tile_ok = $this->Contained ($val["extent"], $ext_val);
          break;
        //Intersect
        case 2: 
          $tile_ok = $this->Intersect ($val["extent"], $ext_val);
          break;
        //Intersect percent
        case 3: 
          $tile_ok = $this->IntersectPercent ($val["extent"], $ext_val, $percent);
          break;
      }

      if ($tile_ok):
//        print_r($ext_val["maxx"]-$ext_val["minx"]);echo "<br>";

        if (!$this->Contained ($val["extent"], $ext_val)):
          //Snap
          if (!$this->no_snap)
            $ext_val = $this->SnapTo($val["extent"], $ext_val);
          //Contained by tile
          if (!$this->Contained ($val["extent"], $ext_val))
            continue;
        endif; 
//print_r($ext_val);

        //Tileing
        if ($val["tiles"]) {
          $difx = $ext_val["minx"]-$val["tiles"]["x"];
          $dify = $val["tiles"]["y"]-$ext_val["maxy"];
          $cntx = Round($difx/$val["tiles"]["stepx"]);
          $cnty = Round($dify/$val["tiles"]["stepy"]);
          $x = $val["tiles"]["x"] + $cntx*$val["tiles"]["stepx"];
          $y = $val["tiles"]["y"] - $cnty*$val["tiles"]["stepy"];
          $ext_val["maxx"] += $x-$ext_val["minx"];
          $ext_val["miny"] += $y-$ext_val["maxy"];
          $ext_val["minx"] = $x;
          $ext_val["maxy"] = $y;
        }
        
        if ($check_last_level) {
          $bbox = $this->ScaleExtent($ext_val, 1/($ext_val["maxx"]-$ext_val["minx"]));
          $bbox = $this->ValidateExtent($bbox,0,0,0,$width,$height);
          $val["is_last_level"] = $this->active_tile["index"] == $val["index"];  
        }

        $this->active_tile = $val;
        
        if (StrCmp($coord_sys,"WGS84") != 0) {
          reset($ext_val);
          while (list($k, $v) = each($ext_val)) {
            $ext_val[$k] = Round($v);
          }
          reset($ext_val);
        }

        if ($coord_sys) {
          return array("connection"=>$val["connection"], "extent"=>$ext_val, "name"=>$val["name"], "minscale"=>$val["minscale"], "maxscale"=>$val["maxscale"], "minpixel"=>$val["minpixel"], "maxpixel"=>$val["maxpixel"]);
        } else {
          switch ($format) {
            case 1:
              return $ext_val["minx"].",".$ext_val["miny"].",".$ext_val["maxx"].",".$ext_val["maxy"];
            break;
            default:
              return $ext_val;
            break;
          }
        }
        break;
        
      endif;
    endwhile;
    return false;
  }
 */ 
  //format 0 - MapServer, 1-Postgres  
  function ConvertExtent ($strExt, $format=0) {  
    if (Is_Array($strExt)):
      $res = $strExt;
    else:
      if ($format): 
        $strExt = Str_Replace("(", "", $strExt);
        $strExt = Str_Replace(")", "", $strExt);
        $res2 = Explode(",", $strExt);
      else:
        $res2 = Explode(",", $strExt);
      endif;
      $res = array();
      $res["minx"] = $res2[0];
      $res["miny"] = $res2[1];
      $res["maxx"] = $res2[2];
      $res["maxy"] = $res2[3];
    endif;
    return $res;
  } 
  
  function GetCenter($what) {
    $center["x"] = ($what["maxx"] - $what["minx"]) / 2 + $what["minx"];
    $center["y"] = ($what["maxy"] - $what["miny"]) / 2 + $what["miny"];
    return $center;
  }

  function SetCenter($what, $center) {
    $cx = ($what["maxx"] + $what["minx"])/2;
    $cy = ($what["maxy"] + $what["miny"])/2;
    $dx = $center["x"] - $cx;
    $dy = $center["y"] - $cy;
    $what["minx"] += $dx;
    $what["maxx"] += $dx;
    $what["miny"] += $dy;
    $what["maxy"] += $dy;
    return $what;
  }
  
  function CenterIn ($which, $what) {
    $center[0] = ($what["maxx"] - $what["minx"]) / 2 + $what["minx"];
    $center[1] = ($what["maxy"] - $what["miny"]) / 2 + $what["miny"];
    $tile_ok = ($which["minx"] <= $center[0] &&
                $which["miny"] <= $center[1] &&
                $which["maxx"] >= $center[0] &&
                $which["maxy"] >= $center[1]);
    return $tile_ok;
  }
  
  function Contained ($which, $what) {
    $tile_ok = ($which["minx"] <= $what["minx"] &&
                $which["miny"] <= $what["miny"] &&
                $which["maxx"] >= $what["maxx"] &&
                $which["maxy"] >= $what["maxy"]);
    return $tile_ok;
  }
  
  function Intersect ($which, $what) {
    $res = false;
    if ((($which["minx"] >= $what["minx"]) && ($which["minx"] <= $what["maxx"]))) {
      if (($which["miny"] >= $what["miny"]) && ($which["miny"] <= $what["maxy"])) {
        $res = true;
      } else if (($which["maxy"] >= $what["miny"]) && ($which["maxy"] <= $what["maxy"])) {
        $res = true;
      } else if (($which["miny"] <= $what["miny"]) && ($which["maxy"] >= $what["maxy"])) {
        $res = true;
      }
    } 
    if (!$res && ($which["maxx"] >= $what["minx"]) && ($which["maxx"] <= $what["maxx"])) {
      if (($which["miny"] >= $what["miny"]) && ($which["miny"] <= $what["maxy"])) {
        $res = true;
      } else if (($which["maxy"] >= $what["miny"]) && ($which["maxy"] <= $what["maxy"])) {
        $res = true;
      } else if (($which["miny"] <= $what["miny"]) && ($which["maxy"] >= $what["maxy"])) {
        $res = true;
      }
    } 
    if (!$res && ($which["minx"] <= $what["minx"]) && ($which["maxx"] >= $what["maxx"])) {
      if (($which["miny"] >= $what["miny"]) && ($which["miny"] <= $what["maxy"])) {
        $res = true;
      } else if (($which["maxy"] >= $what["miny"]) && ($which["maxy"] <= $what["maxy"])) {
        $res = true;
      } else if (($which["miny"] <= $what["miny"]) && ($which["maxy"] >= $what["maxy"])) {
        $res = true;
      }
    } 
    return $res;
  }
  
  function IntersectPercent ($which, $what, $percent=0) {
    $tile_ok = $this->GetIntersection($which, $what);
    if ($tile_ok):
      $area = $this->GetArea($what);
      $area_int = $this->GetArea($tile_ok);
      $tile_ok = (($area_int/$area)*100 >= $percent);
    endif; 
    return $tile_ok;
  }
  
  function GetArea($ext) {
    return ($ext["maxx"]-$ext["minx"])*($ext["maxy"]-$ext["miny"]);
  }
  
  function GetIntersection ($which, $what) {
    if ($this->Insersect($which, $what)):
      $res = array();
      $res["minx"] = (($what["minx"]-$which["minx"]) > 0)?$what["minx"]:$which["minx"];
      $res["maxx"] = (($what["maxx"]-$which["maxx"]) < 0)?$what["maxx"]:$which["maxx"];
      $res["miny"] = (($what["miny"]-$which["miny"]) < 0)?$what["miny"]:$which["miny"];
      $res["maxy"] = (($what["maxy"]-$which["maxy"]) > 0)?$what["maxy"]:$which["maxy"];
      return $res;
    else:
      return false;
    endif;
  }
  
  function SnapTo ($which, $what) {
    $dxl = $what["minx"] - $which["minx"];
    $dxr = $what["maxx"] - $which["maxx"];
    $dyl = $what["miny"] - $which["miny"];
    $dyr = $what["maxy"] - $which["maxy"];
  
    if (($dxl > 0 && $dxr > 0) || ($dxl < 0 && $dxr < 0)):
      $l = Abs($dxl) < Abs($dxr);
      $what["minx"] = $what["minx"] - ($l?$dxl:$dxr);  
      $what["maxx"] = $what["maxx"] - ($l?$dxl:$dxr);
    endif;  
  
    if (($dyl > 0 && $dyr > 0) || ($dyl < 0 && $dyr < 0)):
      $l = Abs($dyl) < Abs($dyr);
      $what["miny"] = $what["miny"] - ($l?$dyl:$dyr);  
      $what["maxy"] = $what["maxy"] - ($l?$dyl:$dyr);
    endif;  
  
    return $what;  
  }
  
  function ScaleExtent ($what, $ratio) {

    $width = $what["maxx"] - $what["minx"];
    $height = $what["maxy"] - $what["miny"];
  
    $width2 = $width*$ratio;
    $height2 = $height*$ratio;
    
    $dx = ($width2 - $width)/2;
    $dy = ($height2 - $height)/2;

    $what["minx"] = $what["minx"] - $dx; 
    $what["maxx"] = $what["maxx"] + $dx; 
    $what["miny"] = $what["miny"] - $dy; 
    $what["maxy"] = $what["maxy"] + $dy; 
    
    return $what;
  }
  
  function SetExtentRatioByExtent ($which, $what) {
    $center = $this->GetCenter($which);
    $dx = ($which["maxx"]-$which["minx"]);
    $dy = ($which["maxy"]-$which["miny"]);
    if (!$dx || !$dy) {
      $which = $what;
      $dx = ($which["maxx"]-$which["minx"]);
      $dy = ($which["maxy"]-$which["miny"]);
    }
    $rat = @$dx/$dy;
    $dxto = ($what["maxx"]-$what["minx"]);
    $dyto = ($what["maxy"]-$what["miny"]);
    $ratto = @$dxto/$dyto;
    if ($rat > $ratto) {
      $bbox = $this->ScaleExtent($what, ($which["maxx"]-$which["minx"])/($what["maxx"]-$what["minx"]));
    } else {
      $bbox = $this->ScaleExtent($what, ($which["maxy"]-$which["miny"])/($what["maxy"]-$what["miny"]));
    } 
    $bbox = $this->SetCenter($bbox, $center);
    return $bbox;
  } 
  
  function GetTiles($ext, $scale, $width, $height) {
    $this->tiles = array();
    return $this->tiles;
  }
  
  function GetScale($ext, $width, $height) {
    $pixelsize = $this->GetPixelSize($ext, $width, $height);
    return $this->GetScaleFromPixelSize($pixelsize, $width, $height);
  }

  function GetScaleFromPixelSize($pixelsize, $width, $height) {
    return Round($pixelsize/(1 / 96 * 2.54 /100));
  }

  function GetPixelSize($ext, $width, $height) {
    $ext = $this->SetExtentRatioByExtent($ext, array("minx"=>0,"miny"=>0,"maxx"=>$width,"maxy"=>$height));
    return ($ext['maxx']-$ext['minx'])/(double)$width;
  }

  function TransformExtent($coordsys_from, $coordsys_to, $ext_val) {
//    print_r($coordsys_to);
    switch ($coordsys_from) {
              case "WGS84":
/*                $x1 = degtorad($ext_val["miny"]);
                $y1 = degtorad($ext_val["minx"]);
                $x2 = degtorad($ext_val["maxy"]);
                $y2 = degtorad($ext_val["maxx"]);*/
                $y1 = degtorad($ext_val["miny"]);
                $x1 = degtorad($ext_val["minx"]);
                $y2 = degtorad($ext_val["maxy"]);
                $x2 = degtorad($ext_val["maxx"]);
                
              break;
              default:
                $x1 = $ext_val["minx"];
                $y1 = $ext_val["miny"];
                $x2 = $ext_val["maxx"];
                $y2 = $ext_val["maxy"];
    }

    $min = Transform($coordsys_from, $coordsys_to, $x1, $y1);
    $max = Transform($coordsys_from, $coordsys_to, $x2, $y2);
    if ($min && $max) {
      switch ($coordsys_to) {
              case "S42":
                $ext_val["minx"] = $min["y"];
                $ext_val["miny"] = $min["x"];
                $ext_val["maxx"] = $max["y"];
                $ext_val["maxy"] = $max["x"];
              break;
              case "SJTSK":
                $ext_val["minx"] = -$min["y"];
                $ext_val["miny"] = -$min["x"];
                $ext_val["maxx"] = -$max["y"];
                $ext_val["maxy"] = -$max["x"];
              break;
              case "WGS84":
                $ext_val["minx"] = radtodec($min["x"]);
                $ext_val["miny"] = radtodec($min["y"]);
                $ext_val["maxx"] = radtodec($max["x"]);
                $ext_val["maxy"] = radtodec($max["y"]);
              break;
              default:
                $ext_val["minx"] = $min["x"];
                $ext_val["miny"] = $min["y"];
                $ext_val["maxx"] = $max["x"];
                $ext_val["maxy"] = $max["y"];
      }
      return $ext_val;
      //print_r($ext_val);
    }
    else return false;
  } 
}

?>
