<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_interface.inc,v 1.29 2008/04/15 14:35:18 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

class TMSInterface {

  var $type; //typ: mapa, prehledka
  var $const = array("TMV"=>0, "OGC"=>1);

  var $parameters; //vtupni parametry
  var $extent;
  var $error; //info o chybe
  var $errorName; //nazev chyby
  var $alert; //info o informacni hlasce
  var $alertName; //nazev informacni hlasky
  var $data; //ziskana data
  var $select; //nastaveni vyberu
  var $properties; //vlastnosti propojeni
  var $objects;

  //abstract function
  function GetResult() {}

  function TMSInterface() {
    $this->error = false;
    $this->select = '';
    $this->manager = new Manager();
    $this->ParseParameters();
  }

  function ParseParameters() {
    //Params in Session
    if ($GLOBALS["ParamMethod"] == "Session") {
      session_start();
      reset($GLOBALS["TMapServer_Interface_Params"]);
      while (list($key, $val) = each($GLOBALS["TMapServer_Interface_Params"])) {
        $GLOBALS[$key] = $val;
      }
    }
    if ($GLOBALS["request_method"]=="Session") {
      session_register("TMapServer_Session");
      if (Is_Array($GLOBALS["TMapServer_Session"]["Interface"])) {
        reset($GLOBALS["TMapServer_Session"]["Interface"]);
        while(list($key,$val) = each($GLOBALS["TMapServer_Session"]["Interface"])) {
          $GLOBALS[$key] = $val;
        }
      }
    }

    $this->parameters["Command"] = $GLOBALS["Command"]?$GLOBALS["Command"]:$this->properties["tmv_interface"]["Command"];

    //Aliasy
    if ( isset($GLOBALS["Theme"]) || ($this->parameters["Command"] == 'Activate')) {

      //Default params
      $this->parameters["SQLType"]      = 'ID';
      $this->parameters["AddToSel"]     = 0;
      $this->parameters["DoSel"]        = 1;
      $this->parameters["ChangeSel"]    = 1;
      $this->parameters["DrawPin"]      = 0;
      $this->parameters["PinColor"]     = '$FF';
      $this->parameters["Percent"]      = 120;
      $this->parameters["MinScale"]     = 0;
      $this->parameters["MaxScale"]     = 0;
      $this->parameters["ValuesSeparator"] = ',';
      $this->parameters["TM_SQLType"]   = 'ID';
      $this->parameters["TM_StyleType"] = 'ID';
      $this->parameters["TM_Reset"]     = true;
      $this->parameters["lang"]         = false;
      $this->parameters["Theme"]        = $GLOBALS["Theme"];
      $this->parameters["Group"]        = false;
      $this->parameters["CoordSys"]     = false;

      //Load predefine params
      $this->properties = $GLOBALS["MAP_INTERFACE"][$this->parameters["Theme"]];
      if (!$this->properties && ($this->parameters["Command"] != 'Activate')) {
        $this->error = true;
        $this->errorName = "error_theme";
      }


      if (Count($this->properties["tmv_interface"]) > 0) {
        reset($this->properties["tmv_interface"]);
        while (List($key,$value) = each($this->properties["tmv_interface"])) {
          $this->parameters[$key] = $value;
        }
      }
      //Set request params
      $this->parameters["Project"]      = $GLOBALS["Project"]?$GLOBALS["Project"]:$this->parameters["Project"];
      $this->parameters["Command"]      = $GLOBALS["Command"]?$GLOBALS["Command"]:$this->parameters["Command"];
      $this->parameters["Zoom"]         = $GLOBALS["Zoom"]?$GLOBALS["Zoom"]:$this->parameters["Zoom"];
      $this->parameters["Field"]        = $GLOBALS["Field"]?$GLOBALS["Field"]:$this->parameters["Field"];
      $this->parameters["Values"]       = isset($GLOBALS["Values"])?$GLOBALS["Values"]:$this->parameters["Values"];
      $this->parameters["Scale"]        = $GLOBALS["Scale"]?$GLOBALS["Scale"]:$this->parameters["Scale"];
      $this->parameters["SQL"]          = isset($GLOBALS["SQL"])?$GLOBALS["SQL"]:$this->parameters["SQL"];
      $this->parameters["SQLType"]      = isset($GLOBALS["SQLType"])?$GLOBALS["SQLType"]:$this->parameters["SQLType"];
      $this->parameters["ThemeField"]   = $GLOBALS["ThemeField"]?$GLOBALS["ThemeField"]:$this->parameters["ThemeField"];
      $this->parameters["TableField"]   = $GLOBALS["TableField"]?$GLOBALS["TableField"]:$this->parameters["TableField"];
      $this->parameters["AddToSel"]     = isset($GLOBALS["AddToSel"])?$GLOBALS["AddToSel"]:$this->parameters["AddToSel"];
      $this->parameters["DoSel"]        = isset($GLOBALS["DoSel"])?$GLOBALS["DoSel"]:$this->parameters["DoSel"];
      $this->parameters["ChangeSel"]    = isset($GLOBALS["ChangeSel"])?$GLOBALS["ChangeSel"]:$this->parameters["ChangeSel"];
      $this->parameters["DrawPin"]      = isset($GLOBALS["DrawPin"])?$GLOBALS["DrawPin"]:$this->parameters["DrawPin"];
      $this->parameters["TypePin"]       = isset($GLOBALS["TypePin"])?$GLOBALS["TypePin"]:$this->parameters["TypePin"];
      $this->parameters["PinColor"]     = isset($GLOBALS["PinColor"])?$GLOBALS["PinColor"]:$this->parameters["PinColor"];
      $this->parameters["Percent"]      = isset($GLOBALS["Percent"])?$GLOBALS["Percent"]:$this->parameters["Percent"];
      $this->parameters["MinScale"]     = isset($GLOBALS["MinScale"])?$GLOBALS["MinScale"]:$this->parameters["MinScale"];
      $this->parameters["MaxScale"]     = isset($GLOBALS["MaxScale"])?$GLOBALS["MaxScale"]:$this->parameters["MaxScale"];
      $this->parameters["ValuesSeparator"] = isset($GLOBALS["ValuesSeparator"])?$GLOBALS["ValuesSeparator"]:$this->parameters["ValuesSeparator"];
      $this->parameters["TM_SQLType"]   = isset($GLOBALS["TM_SQLType"])?$GLOBALS["TM_SQLType"]:$this->parameters["TM_SQLType"];
      $this->parameters["TM_StyleType"] = isset($GLOBALS["TM_StyleType"])?$GLOBALS["TM_StyleType"]:$this->parameters["TM_StyleType"];
      if (isset($GLOBALS["TM_SQL"]))
        $this->parameters["TM_SQL"]       = $GLOBALS["TM_SQL"];
      if (isset($GLOBALS["TM_Style"]))
        $this->parameters["TM_Style"]   = $GLOBALS["TM_Style"];
      $this->parameters["TM_Reset"]     = isset($GLOBALS["TM_Reset"])?$GLOBALS["TM_Reset"]:$this->parameters["TM_Reset"];
      $this->parameters["lang"]         = isset($GLOBALS["client_lang"])?$GLOBALS["client_lang"]:"cz_win";
      $this->parameters["Group"]        = $GLOBALS["Group"]?$GLOBALS["Group"]:$this->parameters["Group"];
      $this->parameters["Coords"]       = $GLOBALS["Coords"]?$GLOBALS["Coords"]:$this->parameters["Coords"];
      $this->parameters["CoordSys"]     = $GLOBALS["CoordSys"]?$GLOBALS["CoordSys"]:$this->parameters["CoordSys"];

      $this->parameters["Layers"]     = $GLOBALS["Layers"]?$GLOBALS["Layers"]:$this->parameters["Layers"];
      $this->parameters["Extent"]     = isset($GLOBALS["Extent"])?$GLOBALS["Extent"]:$this->parameters["Extent"];

      if ($GLOBALS["request_method"]=="Session" || $GLOBALS["ParamMethod"] == "Session") {
        $this->parameters["HTTP_VARS"] = $this->parameters;
      } else {
        $this->parameters["HTTP_VARS"]     = $GLOBALS["REQUEST_METHOD"] == "GET"?$GLOBALS["HTTP_GET_VARS"]:$GLOBALS["HTTP_POST_VARS"];
      }

    }
    else {
      $this->error = true;
      $this->errorName = "error_parameters";
    }
  }

  function ShowError() {
    include_once(FileUp2("html_header.inc"));
    if ($this->parameters["lang"]) {
      include_once(FileUp2(".admin/lg/".$this->parameters["lang"].".inc"));
      @include_once(FileUp2(".admin/lg/app_".$this->parameters["lang"].".inc"));
    }

    echo "<script>\n";
    echo "function Error() {\n";
    echo "  alert('".($GLOBALS["RESOURCE_STRING"][$this->errorName]?$GLOBALS["RESOURCE_STRING"][$this->errorName]:"Error: ".$this->errorText)."');\n";
    $this->ObjectHandlerInterface('before');
    echo "  Reload_Map();\n";
    echo "}\n";
    //oprava chyby (tokr)
    //-------------------
    //pri nenalezeni objektu se nezobrazila mapa - timto se mapa nastavi na prvotni vyrez nadefinovany v map_schema.inc
    echo "function Reload_Map() {\n";
    echo "  map_panel = parent.map_panel;\n";
    echo "  if (map_panel) {\n";
    echo "   if (map_panel.panel_loaded) map_panel.Refresh(true);\n";
    echo "   else window.setTimeout('Reload_Map()', 500);\n";
    echo "  } else window.setTimeout('Reload_Map()', 700);\n";

    //echo "  alert('".$this->errorName."');\n";
    echo "}\n";
    echo "</script>\n";
    echo "</head>\n";
    echo "<BODY onLoad='Error()'>\n";
    echo "&nbsp;\n";

    include_once(FileUp2("html_footer.inc"));
  }

  //For updating styles
  function Array_Update(&$ar_what, &$ar_with) {
    reset($ar_with);
    while (list($key, $val) = each($ar_with)) {
      if (Is_array($val))
        $this->Array_Update(&$ar_what[$key], &$val);
      else
        $ar_what[$key] = $val;
    }
  }

  function RunInterface() {
    // DEBUG
//    if ($GLOBALS["REMOTE_ADDR"] == "192.168.1.30") {
//      $this->parameters["TM_Style"] = 2;
//      $this->parameters["TM_SQL"] = 1;
//    }
    //END DEBUG

    if (isset($this->parameters["TM_Style"]) || $this->parameters["TM_Reset"] || $this->parameters["session"]) Session_register("TMapServer");

    //Reset thematic nmapping
/*    if ($this->parameters["TM_Reset"]) {
      unset($GLOBALS["TMapServer"]);
    }*/
    //While for break on error
    while (!$this->error) {

//      if ($this->parameters["Command"] == 'Activate')  break;

      //Groups
      $this->groups = array();
      if ($this->parameters["Group"]) {
        //Get the project
        if (!$this->parameters["Project"]) {
          $this->error = true;
          $this->errorName = "error_missing_project";
          break;
        }
        @include_once(FileUp2(".admin/agenda_func.inc"));
        include(GetAgendaPath($this->parameters["Project"],false)."/.admin/map_schema.inc");
        $project = $MAP_PROJECT["name"];
        $this->manager_layers = $this->manager->GetLayer($project);
        $this->GetGroups(&$this->manager_layers);
      }

      //Thematic mapping
      if ($this->parameters["TM_Style"]) {
        $this->GetTM();
        if ($this->error) break;
      }

      //Coord conversion
      if ($this->parameters["Coords"]) {
//      if (true) {
        include(FileUp2(".admin/map_schema.inc"));
        $coordsys_to = StrToUpper($MAP_PROJECT["coord_sys"]);
        if (!$coordsys_to) {
          $this->error = true;
          $this->errorText = "Main_Interface: Cannot convert coordinates. Missing \"coordSys\" property in \"map_schema.inc\".";
          break;
        }
        $coordsys_from = StrToUpper($this->parameters["CoordSys"]);
        if (($coordsys_from != $coordsys_to || $coordsys_from == "S42") && $coordsys_from != "NONE") {
          include_once ($GLOBALS["TMAPY_LIB"]."/matkart/transformation.inc");
          $coords = Explode(",", $this->parameters["Coords"]);
          reset($coords);
          while (list($key, $val) = each($coords)) {
            list($x, $y) = Explode(":", $val);
            if (!$coordsys_from) {
              $coordsys_from = getcoordsys($x, $y);
              switch ($coordsys_from) {
                case 0: $coordsys_from = "UTM"; break;
                case 1: $coordsys_from = "SJTSK"; break;
                case 2: $coordsys_from = "S42"; break;
                case 3: $coordsys_from = "WGS84"; break;
                case 4: $coordsys_from = "SJTSK"; break;
              }
              if (StrCmp($coordsys_from, $coordsys_to) == 0 && $coordsys_from != "S42") break;
            }
            switch ($coordsys_from) {
              case "WGS84":
                $x1 = degtorad($x);
                $y1 = degtorad($y);
              break;
              default:
                $x1 = $x;
                $y1 = $y;
            }
            $coorditem = Transform($coordsys_from, $coordsys_to, $x1, $y1);
            if (!$coorditem) {
              $this->error = true;
              $this->errorText = "Main_Interface: Cannot convert coordinates from \"$coordsys_from\" to \"$coordsys_to\" (X=$x, Y=$y).";
              break 2;
            }
            switch ($coordsys_to) {
              case "SJTSK":
                $x = $coorditem["x"];
                $coorditem["x"] = -1.0*$coorditem["y"];
                $coorditem["y"] = -1.0*$x;
              break;
              case "S42":
                $x = $coorditem["x"];
                $coorditem["x"] = $coorditem["y"];
                $coorditem["y"] = $x;
              break;
              case "WGS84":
                $x1 = radtodec($x);
                $y1 = radtodec($y);
              break;
              default:
            }
            $coords[$key] = $coorditem["x"].":".$coorditem["y"];
          }
          $this->parameters["Coords"] = Implode(",", $coords);
        }
      }
      //die($this->parameters["Coords"]);


      //Searching map elements (features, extent)

      $ServerType = $this->properties["type"];
      switch ($ServerType) {
        case "": $layer=false;
        break;
        default:
          $file = FileUp2(".admin/connector/dblayer/$ServerType.inc");
          if ($file) include_once($file);
          else ErrorMsg(array("msg"=>"<b>Error:</b> Bad DB connector $ServerType or connector is missing"));
          $DBLayer = $ServerType."_DBLayer";
          $layer = new $DBLayer(&$this, 0, "interface");
        break;
      }
      if ($layer) {
        $layer->TMSInterface();
        $this->objects = $layer->objects;
        $this->alert = $layer->output["alert"];
        $this->alertName = $layer->output["alertName"];
        $this->error = $layer->output["error"];
        $this->errorName = $layer->output["errorName"];
        $this->errorText = $layer->output["errorText"];

        //Show result
        $this->records = $layer->Records;
        $this->extent = $layer->output;
        $this->select = $layer->output["select"];

        if ($this->error) break;
      }
      else {
        if ($this->parameters["Command"] != 'Activate') {
          $this->error = true;
          $this->errorName = "error_bad_layer";
          break;
        }
      }
      break;
    }
    return $this->error;
  }

  function RunMintProcessParameters($width, $height) {
    if ($this->extent['num']) {
      include_once(FileUp2('.admin/main_manager_extent.inc'));
      $em = new ExtentManager($this);
      $bbox = array(
                'minx'=>$this->extent['minx'],
                'miny'=>$this->extent['miny'],
                'maxx'=>$this->extent['maxx'],
                'maxy'=>$this->extent['maxy'],
      );
      $bbox = $em->SetExtentRatioByExtent($bbox, array("minx"=>0,"miny"=>0,"maxx"=>$width,"maxy"=>$height));
      switch ($this->parameters["Zoom"]) {
        case "ToExtent":
          $scale = $em->GetScale($bbox, $width, $height);

          if($this->parameters["Percent"]) {
            $bbox = $em->ScaleExtent($bbox, (double)$this->parameters["Percent"]/100);
          }
          if($this->parameters["MinScale"] && $scale<$this->parameters["MinScale"]) {
            $scale = $em->GetScale($bbox, $width, $height);
            $bbox = $em->ScaleExtent($bbox, (double)$this->parameters["MinScale"]/$scale);
          }
          if($this->parameters["MaxScale"] && $scale>$this->parameters["MaxScale"]) {
            $scale = $em->GetScale($bbox, $width, $height);
            $bbox = $em->ScaleExtent($bbox, (double)$this->parameters["MaxScale"]/$scale);
          }
          if($this->parameters["MinPixel"] && $pixel<$this->parameters["MinPixel"]) {
            $pixel = $em->GetPixelSize($bbox, $width, $height);
            $bbox = $em->ScaleExtent($bbox, (double)$this->parameters["MinPixel"]/$pixel);
          }
          if($this->parameters["MaxPixel"] && $pixel>$this->parameters["MaxPixel"]) {
            $pixel = $em->GetPixelSize($bbox, $width, $height);
            $bbox = $em->ScaleExtent($bbox, (double)$this->parameters["MaxPixel"]/$pixel);
          }
          break;
        case "ToScale":
          if($this->parameters['Scale']) {
            $scale = $em->GetScale($bbox, $width, $height);
            $bbox = $em->ScaleExtent($bbox, (double)$this->parameters['Scale']/$scale);
            if($this->parameters["MinScale"] && $this->parameters['Scale']<$this->parameters["MinScale"])
              $bbox = $em->ScaleExtent($bbox, (double)$this->parameters["MinScale"]/$this->parameters['Scale']);
            if($this->parameters["MaxScale"] && $this->parameters['Scale']>$this->parameters["MaxScale"])
              $bbox = $em->ScaleExtent($bbox, (double)$this->parameters["MaxScale"]/$this->parameters['Scale']);
          }
          break;
        case "ToPixel":
          $pixel = $em->GetPixelSize($bbox, $width, $height);
          $bbox = $em->ScaleExtent($bbox, (double)$this->parameters["Pixel"]/$pixel);
          if($scale>$this->parameters["MaxScale"])
            $bbox = $em->ScaleExtent($bbox, (double)$this->parameters["MaxScale"]/$scale);
          break;
        case "ToMapExtent":
          $this->GetMapProject();
          $bbox = $this->map_project['full_extent'];
          break;
        default: break;
      }
      $this->extent = array_merge($this->extent, $bbox);
      //print($this->extent);
    }
  }

  function WriteResult() {
    $this->RunInterface();

    require_once(FileUp2("html_header.inc"));
    if (!$this->error) {
      $this->WriteScript();
    } else {
      $this->ShowError();
    }
    require_once(FileUp2("html_footer.inc"));
  }

  function WriteQueryResult() {
    $this->RunInterface();

    require_once(FileUp2("html_header.inc"));
    if (!$this->error) {
      $this->WriteQueryTable();
    } else {
      $this->ShowError();
    }
    require_once(FileUp2("html_footer.inc"));
  }

  function WriteQueryTable() {
    echo "<table border=\"1\">\n";
    for($i=0;$i<Count($this->records);$i++) {
      echo "<tr>";
      if ($i==0) {
        reset($this->records[$i]);
        while(list($key,$val) = each($this->records[$i])) {
          if ($key != "ext" && $key != "_ID_" && $key != "_SHAPE_") echo "<td><b>$key</b></td>\n";
        }
      }
      reset($this->records[$i]);
      while(list($key,$val) = each($this->records[$i])) {
        if ($key != "ext" && $key != "_ID_" && $key != "_SHAPE_") echo "<td>$val</td>\n";
      }
      echo "</tr>\n";
    }
    echo "</table>\n";
  }

  function WriteScript() {
    echo "<script>\n";
    echo "function ExecuteCmd() {\n";
    echo "  map_panel = parent.map_panel;\n";
    $this->ObjectHandlerInterface('before');
    echo "\n  if (map_panel) {\n";
    echo "   if (map_panel.panel_loaded) {\n";

    if ($this->parameters["Command"] != "Activate") {
      if ($this->extent["minx"] && $this->extent["miny"] && $this->extent["maxx"] && $this->extent["maxy"]) {
        echo "    map_panel.MapExtent(".$this->extent["minx"].",".$this->extent["miny"].",".$this->extent["maxx"].",".$this->extent["maxy"].");\n";
      }
      if ($this->properties["map_layer"]) {
        if ($this->parameters["DrawPin"] == 1 || $this->parameters["DoSel"] == 1) {
          if ($GLOBALS["request_method"]=="Session" || $GLOBALS["SESSION"]) {
            if ($this->parameters["DrawPin"] == 1) {
              if ($this->parameters["AddToSel"] == 1 && $GLOBALS["TMapServer_Session"]["Map"]["Select"][$this->properties["map_layer"]]) {
                $arr_select = Explode(",",$GLOBALS["TMapServer_Session"]["Map"]["Select"][$this->properties["map_layer"]]);
                $arr_new = Explode(",", $this->select);
                $arr_value = array_unique(array_merge($arr_select, $arr_new));
                $GLOBALS["TMapServer_Session"]["Map"]["Select"][$this->properties["map_layer"]] = Implode(',',$arr_value);
              }
              else {
                $GLOBALS["TMapServer_Session"]["Map"]["Select"][$this->properties["map_layer"]] = $this->select;
              }
            }
            echo "    map_panel.map.session=true;\n";
          }
          else {
            if ($this->parameters["AddToSel"] == 1) echo "    map_panel.AddSelect('".$this->properties["map_layer"]."','".$this->select."');\n";
            else echo "    map_panel.SetSelect('".$this->properties["map_layer"]."','".$this->select."');\n";
            echo "    map_panel.map.session=false;\n";
          }
        } else {
          echo "    map_panel.SetSelect('".$this->properties["map_layer"]."','');\n";
          echo "    map_panel.map.session=false;\n";
        }
      }
    }
    else {
      if ($GLOBALS["SESSION"]) {
        $GLOBALS["TMapServer_Session"]["Map"]["Select"] = "";
      }
    }

    //Groups
    if (Count($this->groups) > 0) {
      echo "    map_panel.map.layer_refresh = false;\n";
      reset($this->groups);
      while (list($layer, $vis) = each($this->groups)) {
        echo "    map_panel.SetLayer('".$layer."',".($vis?1:0).");\n";
      }
      echo "    map_panel.map.layer_refresh = true;\n";
    }

    if ($this->parameters["Command"] != "Activate") {
      echo "    map_panel.ChangeRatio(map_panel.map.cur);\n";
      //echo "    alert('".$this->parameters["MinScale"]."')\n";
      if ($this->parameters["Zoom"] == "ToScale") {
        echo "    map_panel.ChangeScale(".$this->parameters["Scale"].");\n";
      }
      elseif ($this->parameters["Zoom"] == "ToExtent") {
        //Percent - procenta Extentu -> napsat funkci v klientu
        if (!$this->properties["table_extent"])
          echo "    map_panel.ChangeExtentPercent(".$this->parameters["Percent"].",".$this->parameters["MinScale"].",".$this->parameters["MaxScale"].");\n";
      }
      elseif ($this->parameters["Zoom"] == "ToMapExtent") {
        //zobrazi dany mapovy vyrez dle zaslaneho extentu, jinak zobrazi FullExtent
        if($this->parameters["Extent"]) {
          $c = Explode(":",$this->parameters["Extent"]);
          echo "    map_panel.MapExtent($c[0],$c[1],$c[2],$c[3]);\n";
          echo "    map_panel.ChangeRatio(map_panel.map.cur);\n";
        } else echo "    map_panel.FullExtent();\n";
      }
      elseif ($this->parameters["Zoom"] == "ToFullExtent") {
          echo "    map_panel.FullExtent();\n";
      }
    }
    elseif($this->parameters["Extent"]) {
      //support for current extent
      $c = Explode(":",$this->parameters["Extent"]);
      echo "    map_panel.MapExtent($c[0],$c[1],$c[2],$c[3]);\n";
      echo "    map_panel.ChangeRatio(map_panel.map.cur);\n";
    }

    //Layers
    if ($this->parameters["Layers"]) {
      echo "    map_panel.UnsetAllLayersVisible(map_panel.f_layer.document,map_panel.layer,'',-1,true);\n";
      $layer = explode(",",$this->parameters["Layers"]);
      foreach($layer as $key=>$val) {
        if(strstr($val,".")) {
          echo "    map_panel.SetLayer('".$val."',true,true);\n";
        } else {
          echo "    map_panel.SetInterfaceLayers(map_panel.f_layer.document,map_panel.layer,'',-1,'".$val."');\n";
          echo "    map_panel.SetLayer(map_panel.visible_layers.current,true,true);\n";
        }  
      }
    }
    $this->ObjectHandlerInterface('beforerefresh');
    if (!$this->parameters["DoNotRefreshMap"]) {
      echo "    map_panel.Refresh(true);\n";
    }
    if ($this->alert) {
      echo "    alert('".($GLOBALS["RESOURCE_STRING"][$this->alertName]?$GLOBALS["RESOURCE_STRING"][$this->alertName]:"Alert: ".$this->alertName)."');\n";
    }
    echo "   }\n";
    echo "   else {window.setTimeout('ExecuteCmd()', 500);}\n";
    echo "  }\n";
    echo "  else {window.setTimeout('ExecuteCmd()', 700);}\n";
    echo "}\n";
    echo "</script>\n";

    echo "</head>\n";
    echo "<BODY onLoad='ExecuteCmd()'>\n";
    echo "&nbsp;\n";
  }

  function GetGroups (&$layers, $path="") {
    reset($layers);
    while (list($key, $val) = each($layers)) {
//      if ($val["hidden"]) continue;
      $newpath  = ($path?$path.".":"").$key;
      $vis = false;
      if (Is_Array($val["groups"])) {
        if (in_array($this->parameters["Group"], $val["groups"])) {
          $vis = true;
        }
      }
      $this->groups[$newpath] = $vis;
      if (Is_Array($val["layers"])) {
        $this->GetGroups(&$val["layers"], $newpath);
      }
    }
  }

  function GetMapProject() {
    if (!$this->map_project) {
      include(FileUp2(".admin/map_schema.inc"));
      $this->map_project = $MAP_PROJECT;
    }
    return $this->map_project;
  }

  function ObjectHandlerInterface ($type) {
    @include_once(FileUp2(".admin/obj_manager.inc"));
    if (Class_Exists("ObjectsManager")) {
      $this->objects = new ObjectsManager();
      $objects = $this->properties["objects"]?$this->properties["objects"]:array();
      if (Count($objects)) {
        session_start();
        $this->GetMapProject();
        $project = $this->map_project["name"];
        reset($objects);
        while (list($key, $val) = each($objects)) {
          $obj = $this->objects->GetCachedObjectByIdent($val);
          $obj->owner_type = Get_Class($this);
          if (Method_exists($obj, 'TMapServer_OpenSession')) {
            $obj->TMapServer_OpenSession($project,$this->properties["connection"]);
          }
          if ($type == 'before') {
            if (Method_exists($obj, 'TMapServer_WriteInterfaceScriptBefore')) {
              $obj->TMapServer_WriteInterfaceScriptBefore(&$this);
            }
          } else {
            if (Method_exists($obj, 'TMapServer_WriteInterfaceScriptBeforeRefresh')) {
              $obj->TMapServer_WriteInterfaceScriptBeforeRefresh(&$this);
            }
          }
          if (Method_exists($obj, 'TMapServer_SaveSession')) {
            $obj->TMapServer_SaveSession($project,$this->properties["connection"]);
          }
          $this->objects->SetCachedObject($obj);
        }
      }
    }
  }

/*  function GetTM () {
    $this->errorText = "main_interface: Unknown error in GetTM().";
    while (true) {
      //Get Style and SQL
      $items = array(
        "style"=>$this->properties["tm_style"],
        "sql"=>$this->properties["tm_sql"]
      );
      $items["style"]["param"]="Style";
      $items["sql"]["param"]="SQL";

      while (list($key,$val) = each($items)) {
        $errkey = $key;
        switch ($val["tableType"]) {
          case "file":
            include_once(FileUp2($val["table"]));
            $tm = $val["tableField"];
            $tm = $$tm;
            if (!isset($tm[$this->parameters["TM_".$val["param"]]])) {
              $this->errorText = "Main_Inteface: Style ".$this->parameters["TM_".$val["param"]]." does not exists.";
              $this->error = true;
              break;
            }
            $$key = $tm[$this->parameters["TM_".$val["param"]]];
          break;
          default:
            $q = $this->manager->GetActive($val["connection"]);
            $q->Halt_On_Error = "no";
            if (!$q) {
              $this->error = true;
              $this->errorName = "error_cannot_con_tm";
              break;
            }
            switch ($this->parameters["TM_".$val["param"]."Type"]):
              case "DIRECT":
                $Record = $this->parameters["TM_".$val["param"]];
              break;
              case "SELECT":
                $q->Query($this->parameters["TM_".$val["param"]]);
              break;
              default:
                $sql2 = "Select ".$val["tableField"]." from ".$val["table"]." where ".$val["tableID"]."=".$this->parameters["TM_".$val["param"]];
                $q->Query($sql2);
            endswitch;
            if ($q->Next_Record() || $Record) {
              $$key = $Record ? $Record : $q->Record[0] ;
              switch ($key) {
                case "style":
                  //Remove an added code behind the style
                  eval("\$".$key." = ".ERegi_Replace("^([^;]*);(.*)$","\\1;", $$key));
                  if (!Is_Array($$key)) $this->error = true;
                break;
                case "sql":
                  if (!Is_String($$key)) $this->error = true;
                  $style[$style["typeRenderer"]]["table"]["SQL"] = $sql;
                break;
              }
            } else {
              $this->error = true;
              break;
            }
        }
      }
      if ($this->error) {
        break;
      }
      //Get the project
      $project = $this->parameters["Project"]?$this->parameters["Project"]:$this->properties["tm_style"]["project"];
      if (!$project) {
        $this->error = true;
        $this->errorName = "error_missing_project";
        break;
      }

      //Get Layers and styles
      if ($this->manager_layers) {
        reset($this->manager_layers);
        $layers = Current($this->manager_layers);
      } else {
        $layers = Current($this->manager->GetLayer($project));
      }
      $list_layer = Explode(".", $this->properties["tm_style"]["layer"]);
      $layer = $layers;
      $sess_eval = '$GLOBALS["TMapServer"]["'.$project.'"]';
      while(list(, $val) = each($list_layer)) {
        $layer = $layer["layers"][$val];
        $sess_eval .= '["'.$val.'"]';
      }

      //Refresh layer style with the loaded one
      if (!$this->properties["tm_style"]["overwrite"]) {
        $styles = $this->manager->GetStyle($project);
        $layerstyle = $styles[$layer["style"]];

        $this->Array_Update(&$layerstyle, &$style);
        $style = $layerstyle;
      }
/*      include_once(FileUp2(".admin/functions.inc"));
      ShowArray($style);*/

      //Register session variable
/*      $sess_eval .= '["style"] = $style;';
//      echo($sess_eval);
      eval($sess_eval);
      break;
    }
  }*/
}


?>
