<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_index.inc,v 1.12 2007/04/03 08:56:46 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class MapClient {

  var $type;             //typ klienta (default 'all')
  var $version;          //verze
  var $lang;             //jazyk
  var $frames;           //rozlozeni framu
  var $frames_direction; //vertical x horizontal

  function MapClient($params) {
    $this->type = ($params["type"]?$params["type"]:"all");
    $this->version = $params["version"];
    $this->strange_opener = $params["strange_opener"];
    $this->lang = ($params["lang"]?$params["lang"]:"cz_win");
    $this->frames = $params["frames"];
    $this->frames_direction = ($params["frames_direction"]=="cols")?"cols":"rows";
    $this->frames_length = array();

    if ($GLOBALS["request_method"] == 'POST') {
      unset($GLOBALS["HTTP_POST_VARS"]["request_method"]);
      $GLOBALS["TMapServer_Session"]["Interface"] = $GLOBALS["HTTP_POST_VARS"];
    }
  }

  function WriteClient() {
    echo "<html>\n<head>\n";

    $file = FileUp2('.admin/properties.inc');
    if (File_Exists($file)) include($file);
    $TITLE = $PROPERTIES['AGENDA_NAME'];
    if (!$TITLE) {
      $client_prop = $GLOBALS["MAP_WINDOW"][$GLOBALS["client_type"]]["__properties"];
      $TITLE = $client_prop["title"];
      if (!$TITLE) $TITLE = 'T-MapServer';
    }
    echo "<title>".$TITLE."</title>\n";
    
    echo '<meta http-equiv="content-type" content="text/html; charset='.$GLOBALS['RESOURCE_STRING']['content_type_charset'].'">'."\n";

    if ($this->strange_opener) echo "<script>window.opener = null;</script>\n";
    
    if($client_prop["description"]) echo "<meta name=\"Description\" content=\"".$client_prop["description"]."\" />\n";
    if($client_prop["keywords"]) echo "<meta name=\"KeyWords\" content=\"".$client_prop["keywords"]."\" />\n";    

    echo "<script>window.name='".($client_prop["name"]?$client_prop["name"]:"TMapServer")."';window.focus();</script>\n";
    echo "</head>\n";

    //echo "<!--\n";
    $this->WriteFrameSet($this->frames,$this->frames_direction,0,0);
    echo "</html>";
    //echo "-->\n";
  }

  function WriteFrameSet($frames,$direction,$level,$length) {
    for($i=0;$i<$level;$i++) echo " ";
    echo "<frameset $direction=\"";
    $nums = '';
    for($i=0;$i<Count($frames);$i++) {
      $num = '';
      $ar = $frames[$i];
      if (!$ar["type"]) {
        $num = $this->SumFrames($ar,$direction);
        $frames_length[$i] = $num;
      }
      elseif (!$this->CondFrame($ar)) {
        $num = $this->SumFrame($ar,$direction);
        $frames_length[$i] = $num;
      }
      if ($num!='') $nums = (($nums!='')?$nums.','.$num:$num);
    }
    if($GLOBALS["properties"]["map"]["fit"]) echo $nums.'" frameborder="1" border="1" framespacing="3" bordercolor="#EFEFEF">'."\n";
    else echo $nums.'" frameborder="0" border="false" framespacing="0">'."\n";

    for($i=0;$i<Count($frames);$i++) {
      $ar = $frames[$i];
      if (!$ar["type"]) {
        $this->WriteFrameSet($ar, $this->OppositeDirection($direction),$level+1,$frames_length[$i]);
      }
      else {
        if (!$this->CondFrame($ar)) $this->WriteFrame($ar,$level+1,$direction,$length);
      }
    }
    for($i=0;$i<$level;$i++) echo " ";
    echo "</frameset>\n";
  }

  function WriteFrame($frame,$level,$direction,$length) {
    for($i=0;$i<$level;$i++) echo " ";
    if ($frame["type"]=="empty") {
      echo "<frame".($frame["name"]?" name=\"".$frame["name"]."\"":"");
      echo ' src="empty.php?'.($frame["hr"]?"":"nohr=1").'" frameborder="0" marginwidth="'.($frame["marginwidth"]?$frame["marginwidth"]:"0").'" marginheight="0" '.($frame["scrolling"]?'':'scrolling="no"').'>'."\n";
    }
    else {
      if ($frame["type"]=="map") {
        $frame_length = $this->SumFrame($frame,$this->OppositeDirection($direction));
        if ($length == $frame_length || $frame_length == "*") {
          echo "<frame".($frame["name"]?" name=\"".$frame["name"]."\"":"");
          echo " src=\"".$frame["script"]."\"";
          echo ' scrolling="no" marginwidth="0" marginheight="0" frameborder="yes" border="1px">'."\n";
        }
        else {
          echo "<frameset ".$this->OppositeDirection($direction)."=\"";
          if ($frame["align"] == "left") {
            echo "$frame_length,".($length - $frame_length);
          }
          elseif ($frame["align"] == "right") {
            echo ($length - $frame_length).",$frame_length";
          }
          else {
            echo Round(($length - $frame_length)/2).",$frame_length,".(($length - $frame_length)-Round(($length - $frame_length)/2));
          }
          echo '" frameborder="0" border="false" framespacing="0">'."\n";

          for($i=0;$i<$level+1;$i++) echo " ";
          echo '<frame src="empty.php?nohr=1" frameborder="0" marginwidth="0" marginheight="0" scrolling="no">'."\n";
          for($i=0;$i<$level+1;$i++) echo " ";
          echo "<frame".($frame["name"]?" name=\"".$frame["name"]."\"":"");
          echo " src=\"".$frame["script"]."\"";
          echo ' scrolling="no" marginwidth="0" marginheight="0" frameborder="1" border="true">'."\n";
          for($i=0;$i<$level+1;$i++) echo " ";
          echo '<frame src="empty.php?nohr=1" frameborder="0" marginwidth="0" marginheight="0" '.'scrolling="no"'.'>'."\n";

          for($i=0;$i<$level;$i++) echo " ";
          echo "</frameset>\n";
        }
      }

      elseif ($frame["type"]=="interface") {
        if ($GLOBALS["interface"] == 'tmv') {
          if ($GLOBALS["request_method"] == 'POST') echo '<frame src="db_interface.php?request_method=Session" name="map_interface"';
          else echo '<frame src="db_interface.php?'.$GLOBALS["QUERY_STRING"].'" name="map_interface"';
        }
        else if ($frame["script"]) {
          echo "<frame".($frame["name"]?" name=\"".$frame["name"]."\"":"");
          echo ' src="'.$frame["script"].'"';
        } else {
          echo "<frame".($frame["name"]?" name=\"".$frame["name"]."\"":"");
          echo ' src="empty.php?nohr=1"';
        }
        echo ' frameborder="0" marginwidth="'.($frame["marginwindth"]?$frame["marginwindth"]:"0").'" marginheight="0" '.($frame["scrolling"]?'':'scrolling="no"').'>'."\n";
      }
      elseif ($frame["type"]=="toc_tree") {
        echo "<frame".($frame["name"]?" name=\"".$frame["name"]."\"":"");
        echo " src=\"toc.php?firstTime=1&initMap=".(isset($GLOBALS["interface"])?"0":"1")."&client_lang=".$this->lang."&client_version=".$this->version."&client_type=".$this->type.($frame["params"]?$frame["params"]:"")."\"";
        echo ' frameborder="0" marginwidth="0" marginheight="0" '.($frame["scrolling"]?'':'scrolling="no"').'>'."\n";
      }
      elseif ($frame["type"]=="panel") {
        echo "<frame".($frame["name"]?" name=\"".$frame["name"]."\"":"");
        echo " src=\"panel.php?map_refresh=".(isset($GLOBALS["interface"])?"0":"1")."&client_lang=".$this->lang."&client_version=".$this->version."&client_type=".$this->type.($frame["params"]?$frame["params"]:"")."\"";
        echo ' frameborder="0" marginwidth="0" marginheight="0" '.($frame["scrolling"]?'':'scrolling="no"').'>'."\n";
      }
      elseif ($frame["type"]=="arrows") {
        echo "<frame".($frame["name"]?" name=\"".$frame["name"]."\"":"");
        echo " src=\"".$frame["script"]."&client_version=".$this->version."\"";
        if (!$frame["margin"]) {
          echo ' frameborder="0" marginwidth="0" marginheight="0" '.($frame["scrolling"]?'':'scrolling="no"');
        }
        else {
          echo ' marginwidth="'.$frame["margin"].'" marginheight="'.$frame["margin"].'" '.($frame["scrolling"]?'':'scrolling="no"');
        }
        echo ">\n";
      }
      else {
        echo "<frame".($frame["name"]?" name=\"".$frame["name"]."\"":"");
        echo " src=\"".$frame["script"]."?&client_lang=".$this->lang."\"";
        if ($frame["marginwidth"]) echo " marginwidth=\"".$frame["marginwidth"]."\"";
        if ($frame["marginheight"]) echo " marginheight=\"".$frame["marginheight"]."\"";
        if ($frame["frameborder"]) echo " frameborder=\"".$frame["frameborder"]."\"";
        if (!$frame["scrolling"]) echo " scrolling=\"no\"";
        echo '>'."\n";
      }
    }
  }

  //stridani radku a sloupcu
  function OppositeDirection($direction) {
    return ($direction=="cols")?"rows":"cols";
  }

  //kontrola, zda se nema frame zobrazit jen v konkretnim prohlizeci
  function CondFrame($frame) {
    switch ($frame["cond"]) {
      case "nc":
        if (IsN()) return false;
        else return true;
      break;
      case "ie":
        if (IsIE()) return false;
        else return true;
      break;
    }
    return false;
  }

  function SumFrame($frame, $direction) {
    $length = ($direction=="cols")?"width":"height";
    if (!isset($frame[$length]) || $frame[$length]=="*") return "*";
    elseif ($frame["type"]=="map" && isIE()) return $frame[$length]+4;
    elseif ($frame["type"]=="map" && IsN() && BrowserVersion() == 4) return $frame[$length]+4;
    else {
      if (Is_Array($frame[$length])) {
        if (isIE()) return $frame[$length]["IE"];
        elseif (isWin()) return $frame[$length]["NW"];
        else return $frame[$length]["NU"];
      }
      elseif ($frame[$length]) return $frame[$length]==''?"*":$frame[$length];
      else return "*";
    }
  }

  function SumFrames($frames, $direction, $sum=false) {
    $num = 0;
    $type = ($direction=="cols")?"width":"height";
    for($i=0;$i<Count($frames);$i++) {
      if ($frames[$i]["type"]) {
        $frames[$i]["sum_length"] = $this->SumFrame($frames[$i],$direction); //$frames[$i][$type];
      }
      else {
        $frames[$i]["sum_length"] = $this->SumFrames($frames[$i],$direction,true);
      }
    }
    $has_value = false;
    for($i=0;$i<Count($frames);$i++) {
      $aux = $frames[$i]["sum_length"];
      if ($sum) {
        if ($aux == "*") {
          $has_value = false;
          break;
        }
        $has_value = true;
        $num += $aux;
      } else {
        if (Ereg("^[0-9]+$", $aux)) {
          if ($num < $aux) $num = $aux;
          $has_value = true;
        }
      }
    }
    if ($has_value && $num!='') return $num;
    else return "*";
  }

}

?>
