<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_hotlink.inc,v 1.10 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class Hotlink {

  var $layers; //seznam vrstev k prohledavani
  var $layer_properties; //popis dotazu na jednotlivou vrstvu

  var $manager; //spravce spojeni na servery

  var $x;
  var $y;
  var $size; //do jake vzdalenosti hledat od bodu
  var $all; //prohledavat vsechny prichozi vrstvy
  var $count; //celkovy pocet prvku

  function Hotlink($params) {
    $this->layers = ($params["layers"])?Explode(",",$params["layers"]):array();
    $this->layer_properties = ($params["properties"])?$params["properties"]:array();
    if ($params["x"] && $params["y"]) {
      $this->x = $params["x"];
      $this->y = $params["y"];
      $this->img_x = $params["img_x"];
      $this->img_y = $params["img_y"];
      $this->querytype = "point";
    }
    else {
      $this->x1 = $params["x1"];
      $this->y1 = $params["y1"];
      $this->x2 = $params["x2"];
      $this->y2 = $params["y2"];
      $this->querytype = "extent";
    }
    $this->bbox = $params["bbox"];
    $this->width = $params["width"];
    $this->height = $params["height"];
    $this->size = ($params["size"]?$params["size"]:10);
    $this->group = ($params["group"]?$params["group"]:false);
    $this->all = $params["all"];
    $this->manager = &$params["manager"];
    $this->count = 0;
  }

  function WriteHeader() {
//    require_once(FileUp2("html_header_il2.inc"));
    require_once(FileUp2("html_header.inc"));
    echo "<TITLE>T-MapServer</TITLE></HEAD>\n";
//    echo "<BODY class=\"map\">";
//    echo "<b>Info</b><br>\n";
  }

  function WriteFooter() {
    if ($this->map_refresh) {
      echo '
      <script language="JavaScript" type="text/javascript">
        if (parent.map_panel) {
          parent.map_panel.Refresh(true);
        } else { 
          window.opener.parent.map_panel.Refresh(true);
        }
      </script>
      ';
    }
    require_once(FileUp2("html_footer.inc"));
  }

  function GetResultLayers() {
    $result = array(); 
    for($i=0;$i < Count($this->layers); $i++) {
      $ServerType = $this->layer_properties[$this->layers[$i]]["type"];
      switch ($ServerType) {
        default:
          $file = FileUp2(".admin/connector/dblayer/$ServerType.inc");
          if ($file) include_once($file);
          else ErrorMsg(array("msg"=>"<b>Error:</b> Bad DB connector $ServerType or connector is missing"));
          $DBLayer = $ServerType."_DBLayer";
          $$i = new $DBLayer(&$this, $i, "hotlink");
        break;
      }
      if (($$i) && (!$this->group || ($this->group == $this->layer_properties[$this->layers[$i]]["group"]))) {
        $retparams = $$i->GetResultWithExtraInfo();
        if (isset($retparams['map_refresh'])) $this->map_refresh = $retparams['map_refresh'];
        if (($layer_count = $retparams['count']) > 0) {
          $result[$i] = &$$i;
        }
        $this->count += $layer_count;
        //Spatne pro vice vrstev
//        if (($this->count > 0) && !$this->group) break;
      }
    }
    return $result;
  }
  
  function WriteHotlink() {
    $layers = $this->GetResultLayers();
    reset($layers);
    while (list($i, $layer) = each($layers)) {
      if ($layer->output["count"] > 0) {
        $response = $layer->Hotlink();
        if ($this->group) {
          reset($response);
          while(list($key,$val) = each($response)) $group_response[$key] = $val;
          if ($this->layer_properties[$this->layers[$i]]["group_hotlink"]) $group_link = $this->layer_properties[$this->layers[$i]]["group_hotlink"];
        }
        else if ($response) {
          if($GLOBALS["session_parameters"]) { //predani volitelnych parametru agende
            if (EReg("\?",$response)) $response .= '&'; else $response .= '?';
            $response .= "session_parameters=".urlencode($GLOBALS["session_parameters"]);
            foreach(explode(",",$GLOBALS["session_parameters"]) as $key=>$val) {
              $response .= "&".urlencode($val)."=".urlencode($GLOBALS[$val]);
            }
          }
          $this->WriteResponse($response);
          return;
        }  
      }
    }

    if ($this->group && $group_response) {
      $url = $group_link;
      if (EReg("\?",$url)) $url .= '&'; else $url .= '?';
      $prefix = '';
      reset($group_response);
      while(list($key,$val) = each($group_response)) {
        $url .= $prefix;
        $url .= urlencode($key). "=". urlencode($val);
        $prefix = "&";
      }
      $this->WriteResponse($url);
      return;
    }

    //if ($this->count == 0 || $layer->error) {
    reset($this->layers);
    while (list($i, $layer) = each($this->layers)) {
      if ($this->layer_properties[$this->layers[$i]]["hotlink_empty"]) {
        $this->WriteResponse($this->layer_properties[$this->layers[$i]]["hotlink_empty"]);
        return;
      }
    }  
    $this->WriteHeader();
    echo $GLOBALS["RESOURCE_STRING"]["hotlink_no_find"]."<br>\n";
    $this->WriteFooter();
    //}

  }

  function WriteResponse($url) {
    $this->WriteHeader();
    echo "<script>\n";
    echo "function Reload() {\n";
    //echo "  alert('$url');\n";
    echo "  window.location.href = '$url';\n";
    echo "}\n";
    echo "</script>\n";
    echo "<BODY class=\"map\" onLoad=\"Reload()\">".$RESOURCE_STRING["hotlink_loading"]."<br>\n";
    $this->WriteFooter();
  }
}
?>
