<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_edit_vector.inc,v 1.18 2008/03/25 08:20:13 lumo Exp $'.'$Name:  $';exit;}; /* HEADER */
include_once(FileUp2('.admin/map_functions.inc'));

class EditVector {

  function EditVector($params) {
    global $client_lang;
    session_start();
    $this->properties = ($params["properties"])?$params["properties"]:array();
    $this->layer = $params["layer"];
    $this->bbox = $params["bbox"];
    $this->width = $params["width"];
    $this->height = $params["height"];
    $this->shape = $params["shape"];
    $this->edit_id = $params["edit_id"];
    $this->step = isset($params["step"])?$params["step"]:0;
    $this->fields = isset($params["fields"])?$params["fields"]:false;
    
    list($minx, $miny, $maxx, $maxy) = Explode(',',$params["bbox"]);
    $this->bbox = array('minx'=>$minx, 'miny'=>$miny, 'maxx'=>$maxx, 'maxy'=>$maxy);  
    $this->bbox['width'] = $this->bbox['maxx'] - $this->bbox['minx'];
    $this->bbox['height'] = $this->bbox['maxy'] - $this->bbox['miny'];
        
    $this->layer_properties = $this->properties[$this->layer];
    if (!$this->layer_properties) die('No layer "'.$this->layer.'" in edit_schema.inc!');
  
    if ($this->layer_properties['output']['shape_format'])
      $this->layer_properties['output']['shape_format'] = 'GML';
    if ($this->layer_properties['table']['default_lang'])
      $client_lang = $this->layer_properties['table']['default_lang'];
  }

  function WriteHeader() {
    global $client_lang;
    require_once(FileUp2("html_header.inc"));
    if (!$this->header_title) $this->header_title = 'T-MapServer';
    
    if(is_array($this->layer_properties['js']['files'])) {
      foreach($this->layer_properties['js']['files'] as $f) {
        $file = FileUpURL("javascript/$f");
        echo '<script language="JavaScript" src="'.$file.'"></script>'."\n";
      }
    }
    
    echo "<TITLE>".$this->header_title."</TITLE></HEAD>\n";
  }

  function WriteFooter() {
    require_once(FileUp2("html_footer.inc"));
  }

  function WriteEditVector() {
    global $client_lang;
    if(!$this->CheckAccess($this->step)) {
      $this->WriteHeader();
      include(FileUp2('html_error.inc'));
      $this->WriteFooter();
      return false;
    }
        
    if (isset($this->layer_properties['callback']['writeeditvector_start'])) {
      $func = $this->layer_properties['callback']['writeeditvector_start'];
      $func($this);
    }
    
    switch ($this->step) {
      //from map
      case 0:
      //From table
      case 11:
        $this->PrepareShape();

        include_once $GLOBALS["TMAPY_LIB"]."/oohformsex.inc";
        include_once(Fileup2(".admin/functions.inc"));
        include_once(Fileup2(".admin/el/of_text_.inc"));
        include_once(Fileup2(".admin/el/of_date_.inc"));
        include_once(Fileup2(".admin/el/of_select_.inc"));
        $f = new formex;
        $f->classrequired = "required";

        if ($this->layer_properties['form']['schema']) {                
          $f->schema = $this->layer_properties['form']['schema'];
        }

        $this->header_title = $this->layer_properties['form']['caption'];
        $this->WriteHeader();
        
        //Caption
        if (isset($this->layer_properties['form']['caption'])):
          echo "<span class=\"caption\">".$this->layer_properties['form']['caption']."</span>\n";
        endif;
        
        //Metadata 
        $this->PrepareEditLayer();
        if ($this->edit_layer->db) {
          $f->db = $this->edit_layer->db;
        }

        $file = FileUp2(".admin/security_.inc") ;
        if ($file) include($file);
        $GLOBALS['PROPERTIES_ACCESS'] = $this->layer_properties['properties_access'];
        ValidatePropertiesAccess($GLOBALS['PROPERTIES_ACCESS']);


        $met = $this->edit_layer->metadata(); 
        reset($met);
        while (list($key, $val) = each($met)) {
          $f->requiredfields[$val["name"]] = $val["null"] != true;
          $f->lengthoffields[$val["name"]] = $val["len"];
        }

        $GLOBALS['PROPERTIES'] = $this->edit_layer->_GetTableProperties();
        $record = $this->edit_layer->PrepareFormData($this->edit_id);
        if ($this->step == 11) {
          $f->schema[] = array(
            'elements'=>array(
              array('type'=>'hidden','name'=>'EDIT_ID', 'value'=>$this->edit_id),
              array('type'=>'hidden','name'=>'EDIT_STEP', 'value'=>12),
              array('type'=>'hidden','name'=>'EDIT_LAYER', 'value'=>$this->layer),            
              array('type'=>'hidden','name'=>'SHAPE', 'value'=>''),
              array('type'=>'hidden','name'=>'SHAPE_TYPE', 'value'=>''),
              array('type'=>'button','name'=>'SHAPE_BUTTON', 'value'=>$GLOBALS["RESOURCE_STRING"]["edit_vector_shape_edit_button"], 
                    'onclick'=>'opener.edit_vectorPrepareShapeEditing({'.
                      'shp:frm_shp.SHAPE.value'.
                      ',type:frm_shp.SHAPE_TYPE.value'.
                    '});'),
              array('type'=>'button','name'=>'SHAPE_BUTTON_ZOOM', 'value'=>$GLOBALS["RESOURCE_STRING"]["edit_vector_shape_edit_button_zoom"], 
                    'onclick'=>'opener.edit_vectorPrepareShapeEditing({'.
                      'shp:frm_shp.SHAPE.value'.
                      ',type:frm_shp.SHAPE_TYPE.value'.
                    '},true);')
            ),
            'label'=>$GLOBALS["RESOURCE_STRING"]["edit_vector_shape_label"],
            'format'=>"SHAPE_BUTTON...SHAPE_BUTTON_ZOOM...' <span id=\"shape_edited\" style=\"font-weight:bold;display:none\">- ".$GLOBALS['RESOURCE_STRING']["edit_vector_shape_edited"]."</span>'"
          );
        }
        elseif ($this->step == 0) {
          $f->schema[] = array('elements'=>array(
              array('type'=>'hidden','name'=>'EDIT_STEP', 'value'=>1),
              array('type'=>'hidden','name'=>'EDIT_LAYER', 'value'=>$this->layer),
              array('type'=>'hidden','name'=>$this->layer_properties['form']['fields']['shape']?$this->layer_properties['form']['fields']['shape']:'SHAPE', 'value'=>$this->shape['text']),
              array('type'=>'hidden','name'=>$this->layer_properties['form']['fields']['shape_type']?$this->layer_properties['form']['fields']['shape_type']:'SHAPE_TYPE', 'value'=>$this->shape['type'])
          ));
        }

        //Replace block captions
        reset($f->schema);
        foreach ($f->schema as $key=>$val) {
          if (Is_String($val)) {
            $f->schema[$key] = array('label'=>$val, 'class'=>'inputblock');
          }
        }

        //Buttons
        $buttons = array( 
          "elements"=>array(
            array( "type"=>"submit", "name"=>"__", "value"=>$GLOBALS["RESOURCE_STRING"]["button_save"]), 
          ),
          "span"=>true, 
          "class"=>array("right", "right")
        );
        if (!$this->layer_properties['form']['noshowclose']) {
          $buttons['elements'][] = array( "type"=>"button_close", "name"=>"___");
          $buttons['format'] = "__...'&nbsp;&nbsp;'...___";
        }
        $f->schema[] = $buttons; 

        reset($f->schema);

        $f->start(
          "frm_edit",
          isset($this->layer_properties['form']['method'])?$this->layer_properties['form']['method']:'POST',
          isset($this->layer_properties['form']['submit'])?$this->layer_properties['form']['submit']:'',
          isset($this->layer_properties['form']['target'])?$this->layer_properties['form']['target']:'',
          "frm_edit");
        $f->show_in_table();
        $f->finish();
        if ($this->edit_id) {
          echo '<form id="frm_shp" name="frm_shp" method="POST" action="edit_vector.php" target="map_interface">'."\n";
          $shp = array();
          Shape_CreateFromWKT(&$shp, $record['FWKT_']);  
          echo '<input type="hidden" name="SHAPE" value="'.$shp['text'].'">'."\n";
          echo '<input type="hidden" name="SHAPE_TYPE" value="'.$shp['type'].'">'."\n";
          echo '</form>'."\n";
        }
        $this->WriteFooter();

      break;
      //from form
      case 1:
        $this->PrepareShape();
        $this->PrepareEditLayer();
        
        $file = FileUp2(".admin/security_.inc") ;
        if ($file) include($file);
        $GLOBALS['PROPERTIES_ACCESS'] = $this->layer_properties['properties_access'];
        ValidatePropertiesAccess($GLOBALS['PROPERTIES_ACCESS']);
        $this->header_title = $this->layer_properties['form']['caption'];
        $this->WriteHeader();
          $ok = $this->edit_layer->Insert($this->shape, $this->fields);
          $this->RefreshByJS($ok, $GLOBALS['RESOURCE_STRING']['edit_vector_insert_failed'], true);
        $this->WriteFooter();
      break;
      //show table
      case 10:
        if ($this->layer_properties['table']) {
          $this->PrepareShape();
          $this->PrepareEditLayer();
          $this->header_title = $this->layer_properties['table']['caption'];
          $this->WriteHeader();
          echo "<BODY>\n";
          include_once(FileUp2(".admin/brow_.inc"));
          if (!preg_match('/^[a-z_]+$/',$client_lang)) $client_lang = 'cz_win';
          $file_lg = FileUp2(".admin/lg/map_$client_lang.inc");
          if (File_exists($file_lg)) include($file_lg);
          $file_lg_app = FileUp2(".admin/lg/app_map_$client_lang.inc");
          if (File_exists($file_lg_app)) include($file_lg_app);
          

          $file = FileUp2(".admin/security_.inc") ;
          if ($file) include($file);
          $GLOBALS['PROPERTIES_ACCESS'] = $this->layer_properties['properties_access'];
          ValidatePropertiesAccess($GLOBALS['PROPERTIES_ACCESS']);
          
          $table_par = array(
            'caption'=>$this->layer_properties['table']['caption'],
            'table_schema'=>$this->layer_properties['table']['schema'],
            'skip_access'=>true
          );
          $table_par = $this->edit_layer->PrepareTableParams($this->shape,$table_par);
          if (!$table_par) {
            echo '<p><b>'.$RESOURCE_STRING["hotlink_no_find"].'</b></p>';
          } else {
            $table_par['showinfo']=false;
            $table_par['showedittarget']='Edit';
            $table_par['showediturl']="'".$GLOBALS["HTTP_SERVER_VARS"]["PHP_SELF"].'?EDIT_STEP=11&EDIT_LAYER='.$this->layer."&EDIT_ID='+id+'&client_lang=".$GLOBALS['client_lang']."'";
            $table_par['showdeletetarget']='Edit';
            $table_par['showdeleteurl']="'".$GLOBALS["HTTP_SERVER_VARS"]["PHP_SELF"].'?EDIT_STEP=14&EDIT_LAYER='.$this->layer."&EDIT_ID='+id+'&client_lang=".$GLOBALS['client_lang']."'";
            if ($this->layer_properties['table']['params'])
              $table_par = array_merge($table_par, $this->layer_properties['table']['params']);
            $count = Table($table_par);
            if (!$count) {
              echo '<p><b>'.$RESOURCE_STRING["hotlink_no_find"].'</b></p>';
            }
          }
          $this->WriteFooter();
        }
      break;
      //Run from form
      case 12:
        $this->PrepareShape();
        $this->PrepareEditLayer();

        $file = FileUp2(".admin/security_.inc") ;
        if ($file) include($file);
        $GLOBALS['PROPERTIES_ACCESS'] = $this->layer_properties['properties_access'];
        ValidatePropertiesAccess($GLOBALS['PROPERTIES_ACCESS']);
        $this->header_title = $this->layer_properties['form']['caption'];
        $this->WriteHeader();
        $ok = $this->edit_layer->Update($this->edit_id,$this->shape,$this->fields);
        $this->RefreshByJS($ok, $GLOBALS['RESOURCE_STRING']['edit_vector_update_failed']);
        $this->WriteFooter();
      break;
      //show delete
      case 14:
        $this->header_title = $this->layer_properties['form']['caption'];
        $this->WriteHeader();
        echo '<span class="caption">'.$this->header_title.'</span>';
        echo "<form name='frm_edit'  method='GET' action='' target='_self'>";
        echo "<input type='hidden' name='EDIT_ID' value='".$this->edit_id."' >";
        echo "<input type='hidden' name='EDIT_STEP' value='15' >";
        echo "<input type='hidden' name='EDIT_LAYER' value='".$this->layer."' >\n";
        echo '<table><tr><td><b>'.$GLOBALS['RESOURCE_STRING']["edit_vector_delete_confirm"]."</b>\n";
        echo "<input type='hidden' name='EDIT_LAYER' value='".$this->layer."' >";
        echo "</td></tr><tr><td align='right'><p>\n";
        echo "<input name='__' value='".$GLOBALS['RESOURCE_STRING']["button_delete"]."' class='button' type='submit'>&nbsp;&nbsp;\n";
        echo "<input name='___' value='".$GLOBALS['RESOURCE_STRING']["button_close"]."' type='button' class='button' onclick='window.history.go(-1)'>\n";
        echo "</p></td></tr></table>";
        echo "</form>\n";
        $this->WriteFooter();
      break;
      //run delete
      case 15:
        $file = FileUp2(".admin/security_.inc") ;
        if ($file) include($file);
        $GLOBALS['PROPERTIES_ACCESS'] = $this->layer_properties['properties_access'];
        ValidatePropertiesAccess($GLOBALS['PROPERTIES_ACCESS']);
        $this->header_title = $this->layer_properties['form']['caption'];
        $this->WriteHeader();
        $ok = $this->edit_layer->Delete($this->edit_id);
        $this->RefreshByJS($ok, $GLOBALS['RESOURCE_STRING']['edit_vector_delete_failed'], 'delete');
        $this->WriteFooter();
      break;
    }
  }
  
  function RefreshByJS ($ok, $errmsg, $type='close'){
    echo "<BODY class=\"map\">\n";
    if (!$ok) {
      echo '<form><table width="90%"><tr><td class="inputblock">'.$GLOBALS['RESOURCE_STRING']['error'].'</td></tr><tr><td>';
      echo $errmsg;
      echo '</td></tr><tr><td class="inputblock">&nbsp;</td></tr><tr><td align="right">';
      echo '<input type="button" class="button" value="'.$GLOBALS['RESOURCE_STRING']['button_close'].'" onclick="window.close()">';
      echo '</td></tr></table></form>';
    } else {
      echo '<script language="JavaScript" type="text/javascript">';
      if ($this->layer_properties['form']['refreshmap'])
        echo 'if (!window.opener.closed && window.opener.RefreshMap) window.opener.RefreshMap();';
      if ($type == 'close') {
        echo 'window.close();';
      } else if ($type == 'delete') {
        echo 'window.close();';
//        echo "window.opener.top.deletewindow=window;window.opener.top.setTimeout('window.top.deletewindow.location.reload(true)',500);window.history.go(-2);";
      } else {
        echo 'window.history.go(-2);';
      }
      echo '</script>';
    }
  }
  
  function PrepareEditLayer() {
    if (!$this->edit_layer) {
      $elrtype = $this->layer_properties['dataset']['type'];
      $file = FileUp2('.admin/connector/editlayer/'.$elrtype.'.inc');
      if (!File_exists($file)) die("There is no edit connector '$elrtype'.");
      include_once($file);
      $elrtype .= '_Editlayer';
      $this->edit_layer = new $elrtype($this);
      if (!$this->layer_properties['properties_access']) {
        $this->layer_properties['properties_access'] = array(
/*          "all_read"=>true,
          "all_insert"=>true,
          "all_update"=>true,
          "all_delete"=>true*/
        );
      }
    }
  }
  
  function PrepareShape() {
    Shape_PrepareShape($this->shape, $this->layer_properties['edit']['type'], isset($this->layer_properties['edit']['circleasline'])?$this->layer_properties['edit']['circleasline']:true, $this->bbox, $this->width, $this->height);
  }

  function WriteResponse($url) {
    $this->WriteHeader();
    echo "<script>\n";
    echo "function Reload() {\n";
    echo "  window.location.href = '$url';\n";
    echo "}\n";
    echo "</script>\n";
    echo "<BODY class=\"map\" onLoad=\"Reload()\">".$RESOURCE_STRING["hotlink_loading"]."<br>\n";
    $this->WriteFooter();
  }
  
  function CheckAccess($step) {
    include_once(Fileup2(".admin/functions.inc"));
    $this->PrepareEditLayer();
    $GLOBALS['PROPERTIES_ACCESS'] = $this->layer_properties['properties_access'];  
    $GLOBALS['PROPERTIES'] = $this->edit_layer->_GetTableProperties();
    $res = false;
    switch($step) {
      //run INSERT from form
      case 1:
      //show form from map
      case 0:
        if(HasSubRole("insert")) $res = true;
        break;
        
      //run UPDATE from form
      case 12:
      //show form from table
      case 11:
        if(HasSubRole("update") && isSet($this->edit_id) && HasAccessToRecord('update', $this->edit_id)) $res = true;
        break;

      //show table
      case 10:
        if(HasSubRole("read")) $res = true;
        break;
        
      //show DELETE
      case 14:
      //run DELETE
      case 15:
        if(HasSubRole("delete") && isSet($this->edit_id) && HasAccessToRecord('delete', $this->edit_id)) $res = true;
        break;
        
      default: break;
    }
    return $res;
  }
}
?>
