<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_dblayer.inc,v 1.33 2008/06/20 09:35:36 lube Exp $'.'$Name:  $';exit;}; /* HEADER */

class DBLayer {

  var $manager;          //serverovy manager
  var $properties;       //nastaveni vrstvy
  var $x;                //x-ova souradnice pro kliknuti v mape
  var $y;                //y-ova souradnice pro kliknuti v mape
  var $type;             //typ znacky
  var $group;            //skupina vrstev
  var $alt;              //tooltip znacky
  var $x1;               //x-ova souradnice pro levy horni roh vyrezu v mape
  var $y1;               //y-ova souradnice pro levy horni roh vyrezu v mape
  var $x2;               //x-ova souradnice pro pravy dolni roh vyrezu v mape
  var $y2;               //y-ova souradnice pro pravy dolni roh vyrezu v mape
  var $size;             //vzdalenost pro hledani v bodove vrstve
  var $table;            //nastaveni pro prime popisne informace
  var $extra_table;      //nastaveni pro napojene popisne informace

  var $output;           //pomocne pole pro generovani vystupu
  var $error;            //pri chybe je nastavena na true

  var $objects;          //cache pro objekty
  var $map_refresh;      //navratova hodnota metody GetResultWithExtraInfo - muze byt ovlinena objekty TMS (selection)  

  function DBLayer($link, $index, $type) {
    $this->manager = &$link->manager;
    if ($type == "interface") {
      $this->parameters = &$link->parameters;
      $this->properties = &$link->properties;
      $this->table = &$link->properties;
      if ($this->parameters["TypePin"]) $this->type = $this->parameters["TypePin"];
    }
    else {
      $this->bbox = $link->bbox;
      $bbox = Explode(",", $this->bbox);
      $this->parameters["bbox"]["minx"] = $bbox[0];
      $this->parameters["bbox"]["miny"] = $bbox[1];
      $this->parameters["bbox"]["maxx"] = $bbox[2];
      $this->parameters["bbox"]["maxy"] = $bbox[3];
      $this->properties = $link->layer_properties[$link->layers[$index]];
      $this->querytype = $link->querytype?$link->querytype:"point";
      if ($this->querytype=="point") {
        $this->x = $link->x;
        $this->y = $link->y;
        $this->img_x = $link->img_x;
        $this->img_y = $link->img_y;
      }
      else {
        $this->x1 = $link->x1;
        $this->y1 = $link->y1;
        $this->x2 = $link->x2;
        $this->y2 = $link->y2;
      }
      $this->type = $link->type;
      $this->width = $link->width;
      $this->height = $link->height;
      $this->SetSize();
      $this->group = $link->group;
      $this->table = $this->properties["table"];
      $this->extra_table = $this->properties["extra_table"];
      $this->hotlink = false;
      if ($this->table["hotlink"]) {
        reset($this->table["hotlink"]);
        while(list($attribute,$hotlink_key) = each($this->table["hotlink"])) {
          $this->hotlink[$attribute] = $link->hotlink_properties[$hotlink_key];
        }
      }
      $this->left_width = $link->left_width;
      $this->output = array();
      $this->output["data"] = array();
      $this->output["extra_data"] = array();
      $this->output["count"] = 0;
      $this->error = false;
    }
  }

  function SetSize() {
    if (($this->properties["size_type"] == "pixel") && $this->properties["size"]) {
      $this->size = Round(($this->properties["size"]/$this->width)*($this->parameters["bbox"]["maxx"]-$this->parameters["bbox"]["minx"]));
    }
    else $this->size = ($this->properties["size"]?$this->properties["size"]:$link->size);
  }

  function GetQuery() {return "";}

  function GetResult() {
    reset($this->table["schema"]);
    while (list($field, $title) = each($this->table["schema"])) {
      $this->output["fields"][] = $field;
      $this->output["titles"][] = $title;
    }

    //nastaveni spojeni na databazi
    $this->connection = $this->manager->GetActive($this->table["connection"]);
    $connection = &$this->connection;

    $query = $this->GetQuery();
    /* changed by jiva
    switch ($this->querytype) {
      case "point":
        $query = $this->GetQuery();
        break;
      case "extent":
        $bbox = Explode(",", $this->bbox);
        $query = $this->GetQueryRect($bbox);
      break;
    }
    */
    //die($query);

    //echo($query);
    $connection->query($query);
    while ($connection->next_record()):
      $this->output["data"][] = $connection->Record;
      $this->output["count"]++;
    endwhile;

    return $this->output["count"];
  }

  function GetExtraInfo() {
    if ($this->extra_table && $this->output["count"] > 0) {
      reset($this->extra_table["schema"]);
      while (list($field, $title) = each($this->extra_table["schema"])) {
        $this->output["extra_fields"][] = $field;
        $this->output["extra_titles"][] = $title;
      }

      if ($this->extra_table["name"]) {
        if ($this->extra_table["sql_select"]) {
          $sql = "select ".$this->extra_table["sql_select"]." from ".$this->extra_table["name"];
        }
        else {
          $sql = "select ".Implode($this->output["extra_fields"],",")." from ".$this->extra_table["name"];
        }
      }
      else $sql = $this->extra_table["sql_select"];
      if (ERegI(" where ", $this->extra_table["sql_select"])) $sql .= " and ";
      else $sql .= " where ";

      //nastaveni spojeni na databazi
      $connection = $this->manager->GetActive($this->extra_table["connection"]);

      for ($i=0;$i<$this->output["count"];$i++) {
        $value = $this->output["data"][$i][StrToUpper($this->extra_table["field_from"])];
        $item_sql = $sql .$this->extra_table["field_to"]." = '$value'";
        $error = false;
        if (!(($this->extra_table["field_type"] == "number") && (($value=='0') || ((integer)($value)!=0)) )) $this->error = true;
        if (!$this->error) {
          $connection->query($item_sql);
          $connection->next_record();
          $this->output["extra_data"][] = $connection->Record;
        }
        else $this->output["extra_data"][] = "";
        $this->output["extra_count"]++;
      }
    }
  }

  function GetResultWithExtraInfo() {
    $this->GetResult();
    $this->GetExtraInfo();
    $this->ObjectHandlerDBLayerGetResult();
    $ret['count'] = $this->output["count"];
    if (isset($this->map_refresh)) 
      $ret['map_refresh'] = $this->map_refresh;
    return $ret; 
  }


  function GetResultFromSel($l_name) {
    $this->output = array();
    $this->output['count'] = 0;
    session_start();
    $field = $this->properties['table']['hotlink_field'];
    $conn = $this->properties['table']['connection'];
    $selection = $_SESSION['TMapServer'][$conn][$conn][$this->sel_obj_name];
    if(is_array($selection['layers'])) {
      foreach($selection['layers'] as $name=>$params) {
        if($name==$l_name) {
          foreach($params['values'] as $v) {
            $this->output['data'][] = array(
              'layer' => $name,
              $field => $v
            );
            $this->output['count']++;          
          }
          break;
        }
      }
    }
  }

  //konverze z IL2 do WIN-1250
  function TransformIsoLatin2($str) {
    return StrTr($str,"","");
  }

  function GetMapProject() {
    if (!$this->map_project) {
      @include_once(FileUp2(".admin/agenda_func.inc"));
      include(GetAgendaPath($this->parameters["Project"],false)."/.admin/map_schema.inc");
      $this->map_project = $MAP_PROJECT;
    }
    return $this->map_project;
  }

  function CoordSysConvertPoint($coordsys_from,$coordsys_to,$x,$y) {
    include_once ($GLOBALS["TMAPY_LIB"]."/matkart/transformation.inc");
    return Transform_For_TMS($coordsys_from, $coordsys_to, $x, $y);
  }

  function WriteResult() {
    $table_il2 = ($this->table["lang_translate"] == "il2_win")?true:false;
    $extra_table_il2 = ($this->extra_table["lang_translate"] == "il2_win")?true:false;

    $this->left_width=$this->left_width?$this->left_width:"30%";

    for ($i=0;$i<$this->output["count"];$i++) {
      echo "<table width=\"100%\" class=\"info\" border=\"0\" cellspacing=\"0\">\n";
      echo "<tr class=brow>\n";
      echo "<th class=\"info\" colspan=\"2\">".$this->properties["caption"]."</th>\n";
//      echo "<th class=\"info\">&nbsp;</th>\n";
      $data = $this->output["data"][$i];
      for($j=0;$j<Count($this->output["fields"]);$j++) {
        $field = StrToUpper($this->output["fields"][$j]);
        $dataValue = ($data[$field]?$data[$field]:'&nbsp;');
        if ($table_il2) $dataValue = $this->TransformIsoLatin2($dataValue);
        if ($this->hotlink && $this->hotlink[$field]) {
          $this->properties["format"]="TMapViewer";
          $this->properties["hotlink"]=$this->hotlink[$field]["hotlink"];
          $alt = $this->hotlink[$field]["caption"];
          $w_name = $this->hotlink[$field]["output"]["name"]?$this->hotlink[$field]["output"]["name"]:"hotlink";
          $w_features = $this->hotlink[$field]["output"]["features"];
          $url = "javascript:w=window.open('".$this->Hotlink($i)."','$w_name','$w_features');w.focus()";
          $dataValue = "<a href=\"$url\" alt='$alt' title='$alt'>".$dataValue."</a>";
        }
        if($data["HOT_LINK"] && $data["H_LINK"]) {
          $url = $this->table["url"];
          if (strtoupper($dataValue)=="ANO") $path = "<a href='".$url.$data["H_LINK"].".htm'>".$dataValue."</a>";
          else $path = $dataValue;
          echo "<tr class=\"info\"><td width=\"".$this->left_width."\" class=\"infoleft\">".$this->output["titles"][$j]."&nbsp;</td><td class=\"info\">".$path."</td></tr>\n";
        }
        else echo "<tr class=\"info\"><td width=\"".$this->left_width."\" class=\"infoleft\">".$this->output["titles"][$j]."&nbsp;</td><td class=\"info\">".$dataValue."</td></tr>\n";
      }
      $data = $this->output["extra_data"][$i];
      for($j=0;$j<Count($this->output["extra_fields"]);$j++) {
        $field = StrToUpper($this->output["extra_fields"][$j]);
        $dataValue = ($data[$field]?$data[$field]:'&nbsp;');
        if ($extra_table_il2) $dataValue = $this->TransformIsoLatin2($dataValue);
        echo "<tr class=\"info\"><td class=\"infoleft\">".$this->output["extra_titles"][$j]."&nbsp;</td><td class=\"info\">".$dataValue."</td></tr>\n";
      }
      echo "</table><br>\n";
    }
  }

  function Hotlink($id=0) {
   if ($this->group) {
      $table = $this->output["data"];
      $field = StrToUpper($this->table["hotlink_field"]);
      $value = '';
      for ($i=0;$i<$this->output["count"];$i++) {
        if ($value=='') $value = $table[$i][$field];
        else $value = $value.','.$table[$i][$field];
      }
      return array($this->properties["table"]["schema"][$field] => $value);
    }
    
    if ($this->group_ids) {
      $table = $this->output["data"];
      $field = StrToUpper($this->table["hotlink_field"]);
      $grouped_ids = array();
      for ($i=0;$i<$this->output["count"];$i++) {
        $grouped_ids[] = $table[$i][$field];
      }
      $grouped_ids = Implode(',',$grouped_ids);      
    }

    //die($this->properties["format"]);
    switch ($this->properties["format"]) {
      case "TMapViewer":
        $table = $this->output["data"];
        $hotlink = $this->properties["hotlink"];
        $url = '';
        while (EReg("^(.*)<fl>([^<]*)</fl>(.*)$",$hotlink,$res)) {
          $hotlink = $res[1];
          switch ($res[2]) {
            case "x": $url = $this->x.$res[3].$url; break;
            case "y": $url = $this->y.$res[3].$url; break;
            case "x1": $url = $this->x1.$res[3].$url; break;
            case "y1": $url = $this->y1.$res[3].$url; break;
            case "x2": $url = $this->x2.$res[3].$url; break;
            case "y2": $url = $this->y2.$res[3].$url; break;
            case "extent": $url = Implode(",",$table[$id]["ext"]).$res[3].$url; break;
            default:
              if($grouped_ids)
                $url = $grouped_ids.$res[3].$url;
              else
                $url = $table[$id][StrToUpper($res[2])].$res[3].$url;
            break;
          }
        }
        $url = $hotlink.$url;
        //die($url);
      break;
      default:
        if (isset($this->table["hotlink_field"])) {
          $table = $this->output["data"];
          $field = $this->table["hotlink_field"];
        }
        else {
          $table = $this->output["extra_data"];
          $field = $this->extra_table["hotlink_field"];
        }
        $field = StrToUpper($field);
        $value = '';
        $count = 0;
        if ($this->table["select_max_count"]) $max_count = $this->table["select_max_count"];
        else $max_count = $this->output["count"];
        for ($i=0;$i<$this->output["count"]&& $count<$max_count;$i++) {
          if ($table[$i][$field] != '') {
            if ($value=='') $value = $table[$i][$field];
            else $value = $value.','.$table[$i][$field];
            $count++;
          }
        }

        if ($value=='*********') {
          $this->error = true;
          return false;
        }
        $url = $this->properties["hotlink"].urlencode($value).($client_lang!=''?"&client_lang=$client_lang":"");
      break;
    }

    //die($url);
    if ($this->properties["security"]=="anonymous") {
      $fp = FOpen($url, "r");
      if ($fp) FPassThru($fp);
      return false;
    }
    else {
      return $url;
    }
  }

  function TMSInterface() {
    $this->ObjectHandlerInterface('before');
    if ($this->parameters["Command"]) $this->GetInterfaceResult();
    if ($this->output["errorinterface"]) {
      $this->output["error"] = false;
    }
    $this->ObjectHandlerInterface('after');
    if (!$this->output["error"]) {
      $sess = $this->properties["session"];
      if ($sess) {
        if ($this->parameters["ChangeSel"]) {
          $GLOBALS["TMapServer"][$sess["project"]][$sess["style"]]["selectInMap"] = "";
        }
        if ($this->parameters["DoSel"] || $this->parameters["DrawPin"]) {
          if ($this->parameters["DrawPin"])
            $sel = Explode(",", $this->output["select"]);
          else
            $sel = array();
          $GLOBALS["TMapServer"][$sess["project"]][$sess["style"]]["select"] = $sel;
          $GLOBALS["TMapServer"][$sess["project"]][$sess["style"]]["selectInMap"] = $this->output["selectInMap"];
        } else {
          $GLOBALS["TMapServer"][$sess["project"]][$sess["style"]]["select"] = false;
        }
        $this->output["select"] = "!s";
      }
      if ($this->output["num"] == 0 && $this->parameters["Command"] != "Activate") {
        $this->output["error"] = true;
        $this->output["errorName"] = "error_no_data";
      }
    }
  }

  function SetMaxExtent() {
    if ($this->output["num"] == 0) {
      //echo "$this->x1; $this->y1; $this->x2; $this->y2";
      $this->output["minx"] = $this->x1; $this->output["miny"] = $this->y1; $this->output["maxx"] = $this->x2; $this->output["maxy"] = $this->y2;
      //$this->output["select"] = $this->x.":".$this->y.($this->type?":".$this->type:"").($this->alt?":".URLEncode(SubStr($this->alt,0,30)):"");
      $this->output["select"] = $this->x.":".$this->y.":".$this->type.":".URLEncode(SubStr($this->alt,0,30));
    }
    else {
      if ($this->x1 < $this->output["minx"]) $this->output["minx"] = $this->x1;
      if ($this->x2 > $this->output["maxx"]) $this->output["maxx"] = $this->x2;
      if ($this->y1 < $this->output["miny"]) $this->output["miny"] = $this->y1;
      if ($this->y2 > $this->output["maxy"]) $this->output["maxy"] = $this->y2;
      $this->output["select"] .= ",".$this->x.":".$this->y.":".$this->type.":".URLEncode(SubStr($this->alt,0,30));
    }
  }

  function ObjectHandlerInterface ($type) {
    @include_once(FileUp2(".admin/obj_manager.inc"));
    if (Class_Exists("ObjectsManager")) {
      $this->objects = new ObjectsManager();
      $objects = $this->table["objects"]?$this->table["objects"]:array();
      if (Count($objects)) session_start();
      $this->GetMapProject();
      $project = $this->map_project["name"];
      reset($objects);
      while (list($key, $val) = each($objects)) {
        $obj = $this->objects->GetCachedObjectByIdent($val);
        $obj->owner_type = Get_Class($this);
        if (Method_exists($obj, 'TMapServer_OpenSession')) {
          $obj->TMapServer_OpenSession($project,$this->properties["session_id"]?$this->properties["style"]:$this->properties["style"]);
        }
        if ($type == 'before') {
          if (Method_exists($obj, 'TMapServer_InterfaceBefore')) {
            $obj->TMapServer_InterfaceBefore(&$this);
          }
        } else {
          if (Method_exists($obj, 'TMapServer_InterfaceAfter')) {
            $obj->TMapServer_InterfaceAfter(&$this);
          } else if (Method_exists($obj, 'TMapServer_Interface')) {
            $obj->TMapServer_Interface(&$this);
          }
        }
        if (Method_exists($obj, 'TMapServer_SaveSession')) {
          $obj->TMapServer_SaveSession($project,$this->properties["style"]?$this->properties["style"]:$this->properties["connection"]);
        }
        $this->objects->SetCachedObject($obj);
      }
    }
  }

  function ObjectHandlerDBLayerGetResult () {
    @include_once(FileUp2(".admin/obj_manager.inc"));
    if (Class_Exists("ObjectsManager")) {
      $this->objects = new ObjectsManager();
      $objects = $this->properties["objects"]?$this->properties["objects"]:array();
      if (Count($objects)) session_start();
      $this->GetMapProject();
      $project = $this->map_project["name"];
      reset($objects);
      while (list($key, $val) = each($objects)) {
        $obj = $this->objects->GetCachedObjectByIdent($val);
        $obj->owner_type = Get_Class($this);
        $obj->TMapServer_OpenSession($project,$this->properties['table']["style"]?$this->properties['table']["style"]:$this->properties['table']["connection"]);
        if (Method_exists($obj, 'TMapServer_DBLayerGetResult')) {
          $obj->TMapServer_DBLayerGetResult(&$this);
        }
        $obj->TMapServer_SaveSession($project,$this->properties['table']["style"]?$this->properties['table']["style"]:$this->properties['table']["connection"]);
        $this->objects->SetCachedObject($obj);
      }
    }
  }
  
}

?>
