<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: main_client.inc,v 1.16 2006/12/07 08:23:39 lube Exp $'.'$Name:  $';exit;}; /* HEADER */

//require_once(FileUp2(".admin/functions.inc"));
//require_once(FileUp2(".admin/main_map.inc"));
require_once(FileUp2(".admin/agenda_func.inc"));
require_once(FileUp2(".admin/cl_objects_global.inc"));
require_once(FileUp2(".admin/panel_schema.inc"));

class MapClient {

  var $type;             //typ klienta (default 'simple')
  var $version;          //verze
  var $lang;             //jazyk
  var $objects;          //objekty
  var $properties;       //vlastnosti

  var $parameters;       //pole vsech parametru

  var $map;              //mapovy projekt
  var $layers;           //seznam vrstev
  var $windows;          //popisy oken
  var $resource;         //texty v pozadovanem jazyce
  var $link;             //databazova propojeni

  var $tpl;              //FastTemplate
  var $bbox;             //aktualni vyrez mapoveho okna

  function MapClient($params) {
    $this->type = $params["type"];
    $this->version = $params["version"];
    $this->strange_opener = $params["strange_opener"];
    $this->lang = ($params["lang"]?$params["lang"]:"cz_win");
    $this->objects = $params["objects"];
    $this->properties = $params["properties"];

    $this->map = $params["map_project"];
    $this->map_properties = $params["map_properties"];
    $this->layers = $params["layers"];
    $this->windows = $params["windows"];
    $this->resource = $params["resource"];
    $this->link = false;
    $this->bbox = $params["bbox"];
    $this->select = $params["select"];

    $this->parameters = array(
      "bbox"=>$this->bbox,
      "map_properties"=>$this->map_properties,
      "properties"=>$this->properties
    );   

    $this->tpl = new FastTemplate($this->properties["type"][$this->type]["dir"]);
  }

  function WriteClient() {
    $this->SetScriptFiles();         //definovn javascriptovch a stylovch soubor k naten
    $this->SetTemplateObjects();     //nastaven objekt pro ablonu klienta
    $this->SetJS_Variable();         //nastaven promnnch (js) klienta

    $this->WriteHTMLOutput();        //vytvoen HTML strnky klienta
  }


  //---------------------------------------------------------
  // vytvoen HTML strnky klienta
  //---------------------------------------------------------
  function WriteHTMLOutput(){
    $template = $this->properties["type"][$this->type]["template"];
    if (!Is_array($template)) {
      list ($name,$ext) = explode(".",$template);
      $this->tpl->define(array($name =>$template));
      $this->tpl->parse(CLIENT,$name);
    } else {
      $ar = array();
      $name = array();
      foreach ($template as $val) {
        list ($nam,$ext) = explode(".",$val);
        $name[] = (Count($name)?".":"").$nam;
        $ar[$nam] = $val;
      }
      $this->tpl->define($ar);
      foreach ($name as $nam)
        $this->tpl->parse(CLIENT,$nam);
    }
    $this->tpl->FastPrint(CLIENT);
  }

  //---------------------------------------------------------
  // definovn javascriptovch a stylovch soubor k naten
  //---------------------------------------------------------
  function SetScriptFiles() {
    if ($this->properties["js"]["files"][$this->type]) $js_files = $this->properties["js"]["files"][$this->type];
    else $js_files = $this->properties["js"]["files"]["default"];
    for ($i=0;$i < count($js_files);$i++) {
      if (!is_file(FileUp2("javascript/".$js_files[$i]))) {
        die("ERROR in <b>client_schema.inc</b>: Filename <b>".$js_files[$i]."</b> doesn`t exist !!!\n");
      }
      $js_function .= "<script type=\"text/javascript\" src=\"".FileUpURL("javascript/".$js_files[$i])."?client_version=".$this->version."\"></script>\n";
    } 
    if ($this->properties["css"]["files"][$this->type]) $css_files = $this->properties["css"]["files"][$this->type];
    else $css_files = $this->properties["css"]["files"]["default"];
    for ($i=0;$i < count($css_files);$i++) {
      if (!is_file(FileUp2($css_files[$i]))) {
        die("ERROR in <b>client_schema.inc</b>: Filename <b>".$css_files[$i]."</b> doesn`t exist !!!\n");
      }
      $css_style .= "<LINK href=\"".FileUpURL($css_files[$i])."\" rel=\"stylesheet\" type=\"text/css\">\n";
    } 

    $this->tpl->assign(tms_js_function, $js_function);
    $this->tpl->assign(tms_css_style, $css_style); 
  }

  //---------------------------------------------------------
  // nastaven objekt pro ablonu klienta
  //---------------------------------------------------------
  function SetTemplateObjects() {
    if (isset($initMap) && $initMap == 0) $param_refresh = 'false';
    else $param_refresh = 'true';
    if ($initLayer == 1) $param_initLayer = 'true';
    else $param_initLayer = 'false';
    reset($this->objects);
    while (list($key, $object) = each($this->objects)) {
      if ($object["type"]) $this->ShowObject($object);
    }
    reset($this->objects);
  }

  //---------------------------------------------------------
  // nastaven promnnch (js) klienta
  //---------------------------------------------------------
  function SetJS_Variable() {

    list($map_minx,$map_miny,$map_maxx,$map_maxy) = Explode(",",$this->bbox);
    $map_ext = $map_minx."+".$map_miny."+".$map_maxx."+".$map_maxy;

    $map_scripts .= "<script language=\"JavaScript\" type=\"text/javascript\">\n";

    $map_scripts .= "resource=new Object();\n";
    $map_scripts .= "r=resource;\n";
    $map_scripts .= "r.scale_prompt='".$this->resource["panel_scale_prompt"]."';\n";
    $map_scripts .= "r.scale='".$this->resource["panel_scale"]."';\n";

    $map_scripts .= "map=new Object();\n";
    $map_scripts .= "map.version='".$this->version."';\n";
    $map_scripts .= "map.name='".$this->map["name"]."';\n";
    $map_scripts .= "map.units=".(($this->map["units"]=="degree")?"1000":"1").";\n";
    $map_scripts .= "map.minx=".($this->map["full_extent"]["minx"]?$this->map["full_extent"]["minx"]:"''").";\n";
    $map_scripts .= "map.miny=".($this->map["full_extent"]["miny"]?$this->map["full_extent"]["miny"]:"''").";\n";
    $map_scripts .= "map.maxx=".($this->map["full_extent"]["maxx"]?$this->map["full_extent"]["maxx"]:"''").";\n";
    $map_scripts .= "map.maxy=".($this->map["full_extent"]["maxy"]?$this->map["full_extent"]["maxy"]:"''").";\n";
  
    $map_scripts .= "map.minScale=".($this->map["scale"]["min"]?$this->map["scale"]["min"]:"''").";\n";
    $map_scripts .= "map.maxScale=".($this->map["scale"]["max"]?$this->map["scale"]["max"]:"''").";\n";
   
    $map_scripts .= "map.cur=new Object();\n";
    $map_scripts .= "map.cur.minx=".($map_minx?$map_minx:$this->map["first_extent"]["minx"]).";\n";
    $map_scripts .= "map.cur.miny=".($map_miny?$map_miny:$this->map["first_extent"]["miny"]).";\n";
    $map_scripts .= "map.cur.maxx=".($map_maxx?$map_maxx:$this->map["first_extent"]["maxx"]).";\n";
    $map_scripts .= "map.cur.maxy=".($map_maxy?$map_maxy:$this->map["first_extent"]["maxy"]).";\n";
    $map_scripts .= "map.pansize=".($this->map["pan"]["size"]?$this->map["pan"]["size"]:0.3).";\n";    
    
    $map_scripts .= "map.mouseXshift=".($this->objects["MapImage"]["left"]?$this->objects["MapImage"]["left"]:0).";\n";
    $map_scripts .= "map.mouseYshift=".($this->objects["MapImage"]["top"]?$this->objects["MapImage"]["top"]:0).";\n";    

    $map_scripts .= "map.rect=new Object();\n";
    $map_scripts .= "map.rect.size=".($this->map["rectangle"]["size"]?$this->map["rectangle"]["size"]:"''").";\n";
    $map_scripts .= "map.point=new Object();\n";
    $map_scripts .= "map.status=".($this->map["status_bar"]["info"]?"true":"false").";\n";  //vypisovat informace do status baru
    $map_scripts .= "map.lang='".$this->lang."';\n";
    $map_scripts .= "map.cl_type='".$this->type."';\n";
    $map_scripts .= "map.onClick='".(isset($this->map["mapEvent"]["onClick"])?$this->map["mapEvent"]["onClick"]:"default")."';\n";

    $map_scripts .= "map.window=new Object();\n";
    $map_scripts .= "w=map.window;\n";
    $map_scripts .= "w.width=".$this->objects["MapImage"]["width"].";\n";
    $map_scripts .= "w.height=".$this->objects["MapImage"]["height"].";\n";
    $map_scripts .= "w.left=0;\n";
    $map_scripts .= "w.top=0;\n";
    $map_scripts .= "w.bgColor='".($this->map["bg_color"]?$this->map["bg_color"]:"white")."';\n";
    $map_scripts .= "w.ratio=w.height/w.width;\n";
    $map_scripts .= "w.mapscale=".($this->map["scale"]["no_scale_bar"]?"false":"true").";\n";
       
    $map_scripts .= "map.window.info=new Object();\n";
    $map_scripts .= "i=map.window.info;\n";    
    $map_scripts .= "i.width=".$this->objects["MapImage"]["width"].";\n";
    $map_scripts .= "i.height=".$this->objects["MapImage"]["height"].";\n";
    $map_scripts .= "i.left=0;\n";
    $map_scripts .= "i.top=0;\n";

    $map_scripts .= "map.ov=new Object();\n";

    if ($GLOBALS["MAP_PANEL"][($GLOBALS["client_type"]?$GLOBALS["client_type"]:$this->parameters["properties"]["default_type"])]["overview"]) { 
      $map_scripts .= "map.ov.left=".($this->objects["MapOverview"]["left"]?$this->objects["MapOverview"]["left"]:0).";\n";
      $map_scripts .= "map.ov.top=".($this->objects["MapOverview"]["top"]?$this->objects["MapOverview"]["top"]:0).";\n";
      $map_scripts .= "map.ov.width=".($this->objects["MapOverview"]["width"]?$this->objects["MapOverview"]["width"]:0).";\n";
      $map_scripts .= "map.ov.height=".($this->objects["MapOverview"]["height"]?$this->objects["MapOverview"]["height"]:0).";\n";
      $map_scripts .= "map.ov.refresh=true;\n";
      $map_scripts .= "map.ov.rect=new Object();\n";
      $map_scripts .= "map.ov.min_size=".$this->map["overview"]["min_size"].";\n";    
      $map_scripts .= "map.ov.rect.size=".($this->map["overview"]["size"]?$this->map["overview"]["size"]:$this->map["rectangle"]["size"]).";\n";
    } else {
      $map_scripts .= "map.ov.refresh=false;\n";    
    }  

    $map_scripts .= "map.select='".$this->select."';\n";
 
    $map_scripts .= "env=new Object();\n";
    $map_scripts .= "env.leftButton=1;\n";
    $map_scripts .= "env.middleButton=4;\n";
    $map_scripts .= "env.rightButton=2;\n";
    $map_scripts .= "window.zoom=false;\n";
    $map_scripts .= "subproject=false;\n";

    $map_scripts .= "img=new Object();\n";
    
    $map_scripts .= "navi=new Object();\n";
    if($this->map["navi"]) {
      $map_scripts .= "navi.background='".($this->map["navi"]["background"]?$this->map["navi"]["background"]:"#FFFFFF")."';\n";
      $map_scripts .= "navi.select='".($this->map["navi"]["select"]?$this->map["navi"]["select"]:"#000000")."';\n";
      $map_scripts .= "navi.css=".($this->map["navi"]["css"]?"true":"false").";\n";      
    } else {
      $map_scripts .= "navi.background='#FFFFFF';\n";
      $map_scripts .= "navi.select='#000000';\n";      
      $map_scripts .= "navi.css=false;\n";      
    }
    $map_scripts .= "edit=new Object();\n";
    $map_scripts .= "edit.state = 0;\n";

    if ($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["xy2agend"]) {
      $xy2agend = $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["xy2agend"];
      $map_scripts .= "xy2agend=new Object();\n";
      $map_scripts .= "xy2agend.windb_name='".($xy2agend["windb_name"]?$xy2agend["windb_name"]:"")."';\n";
      $map_scripts .= "xy2agend.agend='".($GLOBALS["SERVER_CONFIG"]["AGENDA_PATH"][$xy2agend["AGENDA_IDENT"]]?$GLOBALS["SERVER_CONFIG"]["AGENDA_PATH"][$xy2agend["AGENDA_IDENT"]]:"")."';\n";
      $map_scripts .= "xy2agend.top='".($xy2agend["TOP"]?$xy2agend["TOP"]:"0")."';\n";
      $map_scripts .= "xy2agend.left='".($xy2agend["LEFT"]?$xy2agend["LEFT"]:"0")."';\n";
      $map_scripts .= "xy2agend.height='".($xy2agend["HEIGHT"]?$xy2agend["HEIGHT"]:"100")."';\n";
      $map_scripts .= "xy2agend.width='".($xy2agend["WIDTH"]?$xy2agend["WIDTH"]:"200")."';\n";
      $map_scripts .= "xy2agend.map_close=".($xy2agend["MAP_CLOSE"]?"true":"false").";\n";
      $map_scripts .= "xy2agend.map_refresh=".($xy2agend["MAP_REFRESH"]?"true":"false").";\n";
    }
        
    $map_scripts .= "</script>\n";

    $this->tpl->assign("tms_map_panel",$map_scripts);
  }
  
  function ShowObject($params) {
    $obj_name = "CL_".$params["type"];
    $obj = new $obj_name($params,$this->parameters,&$this);
    $string = $obj->SetHTMLOutput();
    $this->tpl->assign("tms_".$params["name"], $string);
  }
  
}
?>
