<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: hotlink_fromsel.inc,v 1.2 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class HotlinkFromSel {

  var $h_layer; //identifikator hotlinku

  function HotlinkFromSel($params) {
    $this->layers = $params["layers"] ? Explode(',',$params["layers"]) : array();
    $this->layer_properties = $params["properties"] ? $params["properties"] : array();
    $this->interface = $params["interface"] ? $params["interface"] : array();
  }

  function WriteHeader() {
    require_once(FileUp2("html_header.inc"));
  }

  function WriteFooter() {
    require_once(FileUp2("html_footer.inc"));
  }

  function GetResultLayers() {
    $result = array(); 
    for($i=0;$i < Count($this->layers); $i++) {
      $l_name = $this->layer_properties[$this->layers[$i]]["table"]["name"];
      if(is_array($this->interface)) {
        foreach($this->interface as $ident=>$int) {
          if($l_name==$int['query_layer'] || $l_name==$ident) {
            if(is_array($int['objects'])) {
              foreach($int['objects'] as $o) {
                if(preg_match("/^SEL.+/",$o)) {
                  $sel_obj_name = $o;
                  break;
                }
              }
            }
            $objs = $int['objects'];
            break;
          }  
        }
      }
      $ServerType = $this->layer_properties[$this->layers[$i]]["type"];
      switch ($ServerType) {
        default:
          $file = FileUp2(".admin/connector/dblayer/$ServerType.inc");
          if ($file) include_once($file);
          else ErrorMsg(array("msg"=>"<b>Error:</b> Bad DB connector $ServerType or connector is missing"));
          $DBLayer = $ServerType."_DBLayer";
          $$i = new $DBLayer(&$this, $i, "hotlink");
        break;
      }
      if ($$i) {
        $$i->group_ids = true;
        $$i->sel_obj_name = $sel_obj_name;
        $$i->GetResultFromSel($l_name);
        $result[$i] = &$$i;
        $this->count += $layer_count;
      }
    }
    return $result;
  }
  
  function WriteHotlink() {
    $layers = $this->GetResultLayers();
    reset($layers);
    while (list($i, $layer) = each($layers)) {
      if ($layer->output["count"] > 0) {
        $response = $layer->Hotlink();
        if ($response) {
          if($GLOBALS["session_parameters"]) { //predani volitelnych parametru agende
            if (EReg("\?",$response)) $response .= '&'; else $response .= '?';
            $response .= "session_parameters=".urlencode($GLOBALS["session_parameters"]);
            foreach(explode(",",$GLOBALS["session_parameters"]) as $key=>$val) {
              $response .= "&".urlencode($val)."=".urlencode($GLOBALS[$val]);
            }
          }
          $this->WriteResponse($response);
          return;
        }  
      }
    }

    if ($this->group && $group_response) {
      $url = $group_link;
      if (EReg("\?",$url)) $url .= '&'; else $url .= '?';
      $prefix = '';
      reset($group_response);
      while(list($key,$val) = each($group_response)) {
        $url .= $prefix;
        $url .= urlencode($key). "=". urlencode($val);
        $prefix = "&";
      }
      $this->WriteResponse($url);
      return;
    }
    //if ($this->count == 0 || $layer->error) {
    reset($this->layers);
    while (list($i, $layer) = each($this->layers)) {
      if ($this->layer_properties[$this->layers[$i]]["hotlink_empty"]) {
        $this->WriteResponse($this->layer_properties[$this->layers[$i]]["hotlink_empty"]);
        return;
      }
    }  
    $this->WriteHeader();
    echo $GLOBALS["RESOURCE_STRING"]["hotlink_no_find"]."<br>\n";
    $this->WriteFooter();
    //}

  }

  function WriteResponse($url) {
    $this->WriteHeader();
    echo "<script>\n";
    echo "function Reload() {\n";
    //echo "  alert('$url');\n";
    echo "  window.location.href = '$url';\n";
    echo "}\n";
    echo "</script>\n";
    echo "<BODY class=\"map\" onLoad=\"Reload()\">".$RESOURCE_STRING["hotlink_loading"]."<br>\n";
    $this->WriteFooter();
  }
}
?>
