<?php

function _getLayerStyle($tree, $name) {
  foreach($tree as $layer=>$params) {
    if($layer==$name) {$style=$params['style'];break;}
    elseif(is_array($params['layers'])) $style=_getLayerStyle($params['layers'], $name);
  }
  return $style;
}

if($theme && $id) {
  if($client_family=='html') {
    include(FileUp2(".admin/map_schema.inc"));
    $MAP=$MAP?$MAP:$MAP_PROJECT['name']; 
    $BBOX=$BBOX?$BBOX:Implode(',',$MAP_PROJECT['first_extent']);
    $WIDTH=$WIDTH?$WIDTH:$MAP_PROJECT['size']['width'];
    $HEIGHT=$HEIGHT?$HEIGHT:$MAP_PROJECT['size']['height'];
    $TMS_INTERFACE=$TMS_INTERFACE?$TMS_INTERFACE:'TMS12';
    $FORMAT=$FORMAT?$FORMAT:'HTML';
  }
  
  include_once(FileUp2(".admin/map_prepare.inc"));
  $map_obj = $GLOBALS['map'];

  $file = FileUp2(".admin/connector/maplayer/Table.inc");
  if ($file) include_once($file);
  else die('Table connector not found');
  $MapLayer = 'Table_MapLayer';

  $layer = new $MapLayer($map_obj->tree, $theme, $map_obj->request, $map_obj->manager);
  
  if($client_family=='html') {
    include(FileUp2(".admin/layer_schema.inc"));
    $style_key = _getLayerStyle($MAP_LAYER, $theme);
    include(FileUp2(".admin/style_schema.inc"));
    $layer_style = $MAP_STYLE[$style_key];
  }
  else {  
    $layer_style = _getLayerStyle($layer->tree, $theme);
  }

  $ident = $layer_style['table_params']['field_id']?$layer_style['table_params']['field_id']:'ID';
  $field_x = $layer_style["table_params"]["field_x"]?$layer_style["table_params"]["field_x"]:"X";
  $field_y = $layer_style["table_params"]["field_y"]?$layer_style["table_params"]["field_y"]:"Y";  

  if($type=='Session') {
    session_start();
    foreach($_SESSION['TMapServer']['Session_layers'][$theme] as $k=>$point) {
      if($point[$ident]==$id) { $data=$point; break; }
    }
  }
  else { //if($type=='Table')
    $map_style = $map_obj->project;
    $connection = $map_obj->manager->GetActive($layer_style["connection"]);
    if ($layer_style["sql_select"]) {
      $sql = $layer_style["sql_select"];
    } else {
      $sql = "select * from ".$layer_style["table"];
    }
    if(preg_match("/where/i",$sql)) $sql .= " and $ident=$id";
    else $sql .= " where $ident=$id";
    $connection->query($sql);
    $connection->next_record();
    $data = $connection->Record;
  }

  $bubble_params = $layer_style['bubble'];  
  $content = $bubble_params['content_func']($data);

  $bgcolor = $bubble_params['bgcolor']?$bubble_params['bgcolor']:'white';
  $border = $bubble_params['border']?$bubble_params['border']:'1px solid black';
  $font_size = $bubble_params['font_size']?$bubble_params['font_size']:8;
  $div['width'] = $bubble_params['width']?$bubble_params['width']:100;
  $div['height'] = $bubble_params['height']?$bubble_params['height']:100;
  $div['offset_left'] = $bubble_params['left'];
  $div['offset_top'] = $bubble_params['top'];
	$extra_style = $bubble_params['extra_style']?$bubble_params['extra_style']:'';
  $style = 'overflow:auto;display:inline;width:'.$div['width'].'px;height:'.$div['height'].'px;font-size:'.$font_size.'px;position:absolute;'.$extra_style;

  $events=array();

  $div['point_left'] = $left;
  $div['point_top'] = $top;

  $shd_opacity = $bubble_params['shadow_opacity']?$bubble_params['shadow_opacity']:0;
  $position = $layer->GetPosition($div,$GLOBALS['WIDTH'],$GLOBALS['HEIGHT']);
  
  $id = $theme.'_'.$id;
  $output .= '<div id="'.$id.'_shd" style="'.$style.'border:0px;background-color:black;filter:alpha(opacity='.$shd_opacity.');-moz-opacity:.'.$shd_opacity.';opacity:.'.$shd_opacity.';';
  $output .= 'left:'.($position['left']+6).';top:'.($position['top']+6).';"';
	$output .= ' onmouseover="'.$theme.'_fBefore();showElem(\\\''.$id.'\\\');showElem(\\\''.$id.'_shd\\\');" onmouseout="'.$theme.'_fAfter();hTimer(\\\''.$id.'\\\');"></div>';
	$output .= '<div id="'.$id.'" style="'.$style.'background-color:'.$bgcolor.';border:'.$border.';left:'.$position['left'].';top:'.$position['top'].';"';
  $output .= ' onmouseover="'.$theme.'_fBefore();showElem(\\\''.$id.'\\\');showElem(\\\''.$id.'_shd\\\');" onmouseout="'.$theme.'_fAfter();hTimer(\\\''.$id.'\\\');">';
  $output .= $bubble_params['content_func']($data);
  $output .= '</div>';
  
  $output = preg_replace(array("/\n/","/\t/","/\r/"),array("<br>","",""),$output);
  
  //die($output);
  include(FileUp2('html_header.inc'));
?>
      <script language="JavaScript" type="text/javascript">
      <!--
      var buff = window.parent.document.getElementById("_bubbleBuffer_");
      buff.innerHTML = '<?php echo $output;?>';
      //alert(buff.innerHTML);
      //-->
      </script>
<?php
  include(FileUp2('html_footer.inc'));          
}
?>
